/*
 * Decompiled with CFR 0.152.
 */
package play.modules.accesslog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.mvc.Http;

public class AccessLogPlugin
extends PlayPlugin {
    private static final String FORMAT = "%v %h - %u [%t] \"%r\" %s %b \"%ref\" \"%ua\" %rt \"%post\"";
    private static final String CONFIG_PREFIX = "accesslog.";
    private static final String DEFAULT_PATH = "logs/access.log";
    private static boolean _canLog = false;
    private static PrintWriter _writer;
    private static File _logFile;
    private boolean _shouldLog2Play;
    private boolean _shouldLogPost;

    public void onConfigurationRead() {
        this._shouldLog2Play = Boolean.parseBoolean(Play.configuration.getProperty("accesslog.log2play", "false"));
        this._shouldLogPost = Boolean.parseBoolean(Play.configuration.getProperty("accesslog.logpost", "false"));
        _logFile = new File(Play.configuration.getProperty("accesslog.path", DEFAULT_PATH));
        if (!_logFile.isAbsolute()) {
            _logFile = new File(Play.applicationPath, _logFile.getPath());
        }
    }

    public void onApplicationStart() {
        _canLog = this.createWriter();
    }

    public void onApplicationStop() {
        if (_writer != null) {
            _writer.close();
        }
    }

    private synchronized boolean createWriter() {
        try {
            _writer = new PrintWriter(new FileOutputStream(_logFile, true), true);
        }
        catch (FileNotFoundException ex) {
            Logger.warn((String)("AccessLogPlugin: No accesslog will be used (cannot open file handle) (" + ex.getMessage() + ")"), (Object[])new Object[0]);
        }
        return _writer != null;
    }

    public void invocationFinally() {
        this.log();
    }

    private synchronized void log() {
        if (!this._shouldLog2Play && !_canLog) {
            return;
        }
        Http.Request request = Http.Request.current();
        Http.Response response = Http.Response.current();
        long requestProcessingTime = System.currentTimeMillis() - request.date.getTime();
        Http.Header referrer = (Http.Header)request.headers.get("Referer".toLowerCase());
        Http.Header userAgent = (Http.Header)request.headers.get("User-Agent".toLowerCase());
        String bytes = "-";
        String status = "-";
        if (request.action != null && response.out.size() > 0) {
            bytes = String.valueOf(response.out.size());
            status = response.status.toString();
        }
        String line = FORMAT;
        line = StringUtils.replaceOnce((String)line, (String)"%v", (String)request.host);
        line = StringUtils.replaceOnce((String)line, (String)"%h", (String)request.remoteAddress);
        line = StringUtils.replaceOnce((String)line, (String)"%u", (String)(StringUtils.isEmpty((String)request.user) ? "-" : request.user));
        line = StringUtils.replaceOnce((String)line, (String)"%t", (String)request.date.toString());
        line = StringUtils.replaceOnce((String)line, (String)"%r", (String)request.url);
        line = StringUtils.replaceOnce((String)line, (String)"%s", (String)status);
        line = StringUtils.replaceOnce((String)line, (String)"%b", (String)bytes);
        line = StringUtils.replaceOnce((String)line, (String)"%ref", (String)(referrer != null ? referrer.value() : ""));
        line = StringUtils.replaceOnce((String)line, (String)"%ua", (String)(userAgent != null ? userAgent.value() : ""));
        line = StringUtils.replaceOnce((String)line, (String)"%rt", (String)String.valueOf(requestProcessingTime));
        line = this._shouldLogPost ? StringUtils.replaceOnce((String)line, (String)"%post", (String)request.params.get("body")) : StringUtils.remove((String)line, (String)"\"%post\"");
        line = StringUtils.trim((String)line);
        if (_canLog) {
            _writer.println(line);
        }
        if (this._shouldLog2Play) {
            Logger.info((String)line, (Object[])new Object[0]);
        }
    }
}

