/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.actor;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.lag.logging.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import se.scalablesolutions.akka.actor.Actor;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.ActorRegistry$;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActorRegistry$
implements Logging,
ScalaObject {
    public static final ActorRegistry$ MODULE$;
    private final ConcurrentHashMap<String, ActorRef> actorsByUUID;
    private final ConcurrentHashMap<String, List<ActorRef>> actorsById;
    private final ConcurrentHashMap<String, List<ActorRef>> actorsByClassName;
    private final CopyOnWriteArrayList<ActorRef> registrationListeners;
    private final transient Logger log;
    public volatile int bitmap$0;

    static {
        new ActorRegistry$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        ActorRegistry$ actorRegistry$ = this;
        synchronized (actorRegistry$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    private ConcurrentHashMap<String, ActorRef> actorsByUUID() {
        return this.actorsByUUID;
    }

    private ConcurrentHashMap<String, List<ActorRef>> actorsById() {
        return this.actorsById;
    }

    private ConcurrentHashMap<String, List<ActorRef>> actorsByClassName() {
        return this.actorsByClassName;
    }

    private CopyOnWriteArrayList<ActorRef> registrationListeners() {
        return this.registrationListeners;
    }

    public List<ActorRef> actors() {
        ListBuffer all = new ListBuffer();
        Enumeration<ActorRef> elements2 = this.actorsByUUID().elements();
        while (elements2.hasMoreElements()) {
            all.$plus$eq((Object)elements2.nextElement());
        }
        return all.toList();
    }

    public void foreach(Function1<ActorRef, Object> f) {
        Enumeration<ActorRef> elements2 = this.actorsByUUID().elements();
        while (elements2.hasMoreElements()) {
            f.apply((Object)elements2.nextElement());
        }
    }

    public <T extends Actor> List<ActorRef> actorsFor(Manifest<T> manifest) {
        ListBuffer all = new ListBuffer();
        Enumeration<ActorRef> elements2 = this.actorsByUUID().elements();
        while (elements2.hasMoreElements()) {
            ActorRef actorId = elements2.nextElement();
            Object object = manifest.erasure().isAssignableFrom(actorId.actor().getClass()) ? all.$plus$eq((Object)actorId) : BoxedUnit.UNIT;
        }
        return all.toList();
    }

    public <T extends Actor> Option<ActorRef> actorFor(Manifest<T> manifest) {
        return this.actorsFor(manifest).headOption();
    }

    public <T extends Actor> List<ActorRef> actorsFor(Class<T> clazz) {
        return this.actorsByClassName().containsKey(clazz.getName()) ? this.actorsByClassName().get(clazz.getName()) : Nil$.MODULE$;
    }

    public List<ActorRef> actorsFor(String id) {
        return this.actorsById().containsKey(id) ? this.actorsById().get(id) : Nil$.MODULE$;
    }

    public Option<ActorRef> actorFor(String uuid) {
        return this.actorsByUUID().containsKey(uuid) ? new Some((Object)this.actorsByUUID().get(uuid)) : None$.MODULE$;
    }

    public void register(ActorRef actor$3) {
        List<ActorRef> list;
        List<ActorRef> list2;
        this.actorsByUUID().put(actor$3.uuid(), actor$3);
        String id = actor$3.id();
        if (id == null) {
            throw new IllegalStateException(new StringBuilder().append((Object)"Actor.id is null ").append((Object)actor$3).toString());
        }
        if (this.actorsById().containsKey(id)) {
            ActorRef actorRef = actor$3;
            list2 = this.actorsById().put(id, (List<ActorRef>)this.actorsById().get(id).$colon$colon((Object)actorRef));
        } else {
            ActorRef actorRef = actor$3;
            list2 = this.actorsById().put(id, (List<ActorRef>)Nil$.MODULE$.$colon$colon((Object)actorRef));
        }
        String className = actor$3.actor().getClass().getName();
        if (this.actorsByClassName().containsKey(className)) {
            ActorRef actorRef = actor$3;
            list = this.actorsByClassName().put(className, (List<ActorRef>)this.actorsByClassName().get(className).$colon$colon((Object)actorRef));
        } else {
            ActorRef actorRef = actor$3;
            list = this.actorsByClassName().put(className, (List<ActorRef>)Nil$.MODULE$.$colon$colon((Object)actorRef));
        }
        this.foreachListener((Function1<ActorRef, Object>)new anonfun.register.1(actor$3));
    }

    public void unregister(ActorRef actor$4) {
        this.actorsByUUID().remove(actor$4.uuid());
        this.actorsById().remove(actor$4.id());
        this.actorsByClassName().remove(actor$4.getClass().getName());
        this.foreachListener((Function1<ActorRef, Object>)new anonfun.unregister.1(actor$4));
    }

    public void shutdownAll() {
        this.log().info("Shutting down all actors in the system...", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.foreach((Function1<ActorRef, Object>)new anonfun.shutdownAll.1());
        this.actorsByUUID().clear();
        this.actorsById().clear();
        this.actorsByClassName().clear();
        this.log().info("All actors have been shut down and unregistered from ActorRegistry", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public boolean addRegistrationListener(ActorRef listener) {
        listener.start();
        return this.registrationListeners().add(listener);
    }

    public boolean removeRegistrationListener(ActorRef listener) {
        listener.stop();
        return this.registrationListeners().remove(listener);
    }

    private void foreachListener(Function1<ActorRef, Object> f) {
        for (ActorRef listener : this.registrationListeners()) {
            Object object;
            if (listener.isRunning()) {
                object = f.apply((Object)listener);
                continue;
            }
            this.log().warning("Can't send ActorRegistryEvent to [%s] since it is not running.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener}));
            object = BoxedUnit.UNIT;
        }
    }

    private ActorRegistry$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.actorsByUUID = new ConcurrentHashMap();
        this.actorsById = new ConcurrentHashMap();
        this.actorsByClassName = new ConcurrentHashMap();
        this.registrationListeners = new CopyOnWriteArrayList();
    }
}

