/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.dispatch;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.runtime.BoxedUnit;
import se.scalablesolutions.akka.dispatch.ThreadPoolBuilder;

public abstract class ThreadPoolBuilder$class {
    public static final ThreadPoolBuilder.MonitorableThreadFactory se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(ThreadPoolBuilder $this) {
        return new ThreadPoolBuilder.MonitorableThreadFactory($this, $this.name());
    }

    public static boolean isShutdown(ThreadPoolBuilder $this) {
        return $this.executor().isShutdown();
    }

    public static void buildThreadPool(ThreadPoolBuilder $this) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            BoxedUnit boxedUnit;
            $this.ensureNotActive();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(false);
            if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound() > 0) {
                ThreadPoolBuilder.BoundedExecutorDecorator boundedExecutor = new ThreadPoolBuilder.BoundedExecutorDecorator($this, $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound());
                $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(-1);
                $this.executor_$eq(boundedExecutor);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.executor_$eq($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder());
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithCustomBlockingQueue(ThreadPoolBuilder $this, BlockingQueue queue) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(false);
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(queue);
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), queue));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewBoundedThreadPoolWithLinkedBlockingQueueWithUnboundedCapacity(ThreadPoolBuilder $this, int bound) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue());
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), (BlockingQueue<Runnable>)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory()));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(bound);
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithLinkedBlockingQueueWithUnboundedCapacity(ThreadPoolBuilder $this) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue());
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithLinkedBlockingQueueWithCapacity(ThreadPoolBuilder $this, int capacity) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue(capacity));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithSynchronousQueueWithFairness(ThreadPoolBuilder $this, boolean fair) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new SynchronousQueue(fair));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithArrayBlockingQueueWithCapacityAndFairness(ThreadPoolBuilder $this, int capacity, boolean fair) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new ArrayBlockingQueue(capacity, fair));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder setCorePoolSize(ThreadPoolBuilder $this, int size2) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().setCorePoolSize(size2);
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder setMaxPoolSize(ThreadPoolBuilder $this, int size2) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().setMaximumPoolSize(size2);
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder setKeepAliveTimeInMillis(ThreadPoolBuilder $this, long time) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().setKeepAliveTime(time, $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS());
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder setRejectionPolicy(ThreadPoolBuilder $this, RejectedExecutionHandler policy) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().setRejectedExecutionHandler(policy);
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static void verifyNotInConstructionPhase(ThreadPoolBuilder $this) {
        if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding()) {
            throw new IllegalStateException("Is already in the process of building a thread pool");
        }
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(true);
    }

    public static void verifyInConstructionPhase(ThreadPoolBuilder $this) {
        if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding()) {
            return;
        }
        throw new IllegalStateException("Is not in the process of building a thread pool, start building one by invoking one of the 'newThreadPool*' methods");
    }

    public static void $init$(ThreadPoolBuilder $this) {
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS_$eq(16);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS_$eq(128);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME_$eq(60000L);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS_$eq(TimeUnit.MILLISECONDS);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(-1);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(false);
    }
}

