/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import net.lag.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import se.scalablesolutions.akka.actor.Actor;
import se.scalablesolutions.akka.actor.Actor$;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.Supervisor;
import se.scalablesolutions.akka.actor.Supervisor$;
import se.scalablesolutions.akka.config.Config$;
import se.scalablesolutions.akka.config.ScalaConfig;
import se.scalablesolutions.akka.config.ScalaConfig$LifeCycle$;
import se.scalablesolutions.akka.config.ScalaConfig$OneForOne$;
import se.scalablesolutions.akka.config.ScalaConfig$Permanent$;
import se.scalablesolutions.akka.config.ScalaConfig$Supervise$;
import se.scalablesolutions.akka.remote.Cluster;
import se.scalablesolutions.akka.remote.Cluster$;
import se.scalablesolutions.akka.remote.ClusterActor;
import se.scalablesolutions.akka.remote.JGroupsClusterActor;
import se.scalablesolutions.akka.serialization.Serializer$Java$;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cluster$
implements Cluster,
Logging,
ScalaObject {
    public static final Cluster$ MODULE$;
    private String DEFAULT_SERIALIZER_CLASS_NAME;
    private String DEFAULT_CLUSTER_ACTOR_CLASS_NAME;
    private volatile Option<ActorRef> clusterActorRef;
    private volatile Option<ClassLoader> classLoader;
    private final transient Logger log;
    public volatile int bitmap$0;

    static {
        new Cluster$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 0x10) != 0) return this.log;
        Cluster$ cluster$ = this;
        synchronized (cluster$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 0x10;
            }
            return this.log;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String DEFAULT_SERIALIZER_CLASS_NAME() {
        if ((this.bitmap$0 & 1) != 0) return this.DEFAULT_SERIALIZER_CLASS_NAME;
        Cluster$ cluster$ = this;
        synchronized (cluster$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.DEFAULT_SERIALIZER_CLASS_NAME = Serializer$Java$.MODULE$.getClass().getName();
                this.bitmap$0 |= 1;
            }
            return this.DEFAULT_SERIALIZER_CLASS_NAME;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String DEFAULT_CLUSTER_ACTOR_CLASS_NAME() {
        if ((this.bitmap$0 & 4) != 0) return this.DEFAULT_CLUSTER_ACTOR_CLASS_NAME;
        Cluster$ cluster$ = this;
        synchronized (cluster$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.DEFAULT_CLUSTER_ACTOR_CLASS_NAME = JGroupsClusterActor.class.getName();
                this.bitmap$0 |= 4;
            }
            return this.DEFAULT_CLUSTER_ACTOR_CLASS_NAME;
        }
    }

    public Option<ActorRef> clusterActorRef() {
        return this.clusterActorRef;
    }

    public void clusterActorRef_$eq(Option<ActorRef> option) {
        this.clusterActorRef = option;
    }

    public Option<ClassLoader> classLoader() {
        return this.classLoader;
    }

    public void classLoader_$eq(Option<ClassLoader> option) {
        this.classLoader = option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<ActorRef> createClusterActor() {
        void var2_2;
        String name$1 = Config$.MODULE$.config().getString("akka.remote.cluster.actor", this.DEFAULT_CLUSTER_ACTOR_CLASS_NAME());
        if (name$1.isEmpty()) {
            throw new IllegalArgumentException("Can't start cluster since the 'akka.remote.cluster.actor' configuration option is not defined");
        }
        Some exceptionResult1 = null;
        try {
            exceptionResult1 = new Some((Object)Actor$.MODULE$.actorOf((Function0<Actor>)new anonfun.createClusterActor.1(name$1)));
        }
        catch (Throwable throwable) {
            this.log().error(throwable, "Couldn't load Cluster provider: [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1}));
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    public Option<Supervisor> createSupervisor(ActorRef actor2) {
        ScalaConfig.Supervise supervise = ScalaConfig$Supervise$.MODULE$.apply(actor2, ScalaConfig$LifeCycle$.MODULE$.apply(ScalaConfig$Permanent$.MODULE$));
        return new Some((Object)Supervisor$.MODULE$.apply(new ScalaConfig.SupervisorConfig(new ScalaConfig.RestartStrategy(ScalaConfig$OneForOne$.MODULE$, 5, 1000, (List<Class<? extends Throwable>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class}))), (List<ScalaConfig.Server>)Nil$.MODULE$.$colon$colon((Object)supervise))));
    }

    private Option<ClusterActor> clusterActor() {
        return this.clusterActorRef().isEmpty() ? None$.MODULE$ : new Some((Object)((ClusterActor)((ActorRef)this.clusterActorRef().get()).actor()));
    }

    @Override
    public String name() {
        return (String)this.clusterActor().map((Function1)new anonfun.name.1()).getOrElse((Function0)new anonfun.name.2());
    }

    @Override
    public <T> Option<T> lookup(PartialFunction<ScalaConfig.RemoteAddress, T> pf$1) {
        return this.clusterActor().flatMap((Function1)new anonfun.lookup.3(pf$1));
    }

    public void registerLocalNode(String hostname$2, int port$2) {
        this.clusterActorRef().foreach((Function1)new anonfun.registerLocalNode.1(hostname$2, port$2));
    }

    public void deregisterLocalNode(String hostname$1, int port$1) {
        this.clusterActorRef().foreach((Function1)new anonfun.deregisterLocalNode.1(hostname$1, port$1));
    }

    public void relayMessage(Class<? extends Actor> to$1, Object msg$4) {
        this.clusterActorRef().foreach((Function1)new anonfun.relayMessage.1(to$1, msg$4));
    }

    @Override
    public void foreach(Function1<ScalaConfig.RemoteAddress, Object> f$1) {
        this.clusterActor().foreach((Function1)new anonfun.foreach.2(f$1));
    }

    public void start() {
        this.start((Option<ClassLoader>)None$.MODULE$);
    }

    public void start(Option<ClassLoader> serializerClassLoader$1) {
        Cluster$ cluster$ = this;
        synchronized (cluster$) {
            BoxedUnit boxedUnit;
            this.log().info("Starting up Cluster Service...", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            if (this.clusterActorRef().isEmpty()) {
                this.createClusterActor().foreach((Function1)new anonfun.start.1(serializerClassLoader$1));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void shutdown() {
        Cluster$ cluster$ = this;
        synchronized (cluster$) {
            this.log().info("Shutting down Cluster Service...", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.clusterActorRef().foreach((Function1)new anonfun.shutdown.1());
            this.classLoader_$eq((Option<ClassLoader>)new Some((Object)this.getClass().getClassLoader()));
            return;
        }
    }

    private Cluster$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clusterActorRef = None$.MODULE$;
        this.classLoader = new Some((Object)this.getClass().getClassLoader());
    }
}

