/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import java.net.InetSocketAddress;
import net.lag.logging.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.RemoteActorRef;
import se.scalablesolutions.akka.config.Config$;
import se.scalablesolutions.akka.remote.RemoteClient;
import se.scalablesolutions.akka.remote.RemoteClient$;
import se.scalablesolutions.akka.remote.RemoteServer;
import se.scalablesolutions.akka.remote.RemoteServer$Address$;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteClient$
implements Logging,
ScalaObject {
    public static final RemoteClient$ MODULE$;
    private final int READ_TIMEOUT;
    private final int RECONNECT_DELAY;
    private final HashMap<String, RemoteClient> remoteClients;
    private final HashMap<RemoteServer.Address, HashSet<String>> remoteActors;
    private final transient Logger log;
    public volatile int bitmap$0;

    static {
        new RemoteClient$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    public int READ_TIMEOUT() {
        return this.READ_TIMEOUT;
    }

    public int RECONNECT_DELAY() {
        return this.RECONNECT_DELAY;
    }

    private HashMap<String, RemoteClient> remoteClients() {
        return this.remoteClients;
    }

    private HashMap<RemoteServer.Address, HashSet<String>> remoteActors() {
        return this.remoteActors;
    }

    public ActorRef actorFor(String className, String hostname, int port) {
        return this.actorFor(className, className, 5000L, hostname, port, (Option<ClassLoader>)None$.MODULE$);
    }

    public ActorRef actorFor(String className, String hostname, int port, ClassLoader loader) {
        return this.actorFor(className, className, 5000L, hostname, port, (Option<ClassLoader>)new Some((Object)loader));
    }

    public ActorRef actorFor(String uuid, String className, String hostname, int port) {
        return this.actorFor(uuid, className, 5000L, hostname, port, (Option<ClassLoader>)None$.MODULE$);
    }

    public ActorRef actorFor(String uuid, String className, String hostname, int port, ClassLoader loader) {
        return this.actorFor(uuid, className, 5000L, hostname, port, (Option<ClassLoader>)new Some((Object)loader));
    }

    public ActorRef actorFor(String className, long timeout, String hostname, int port) {
        return this.actorFor(className, className, timeout, hostname, port, (Option<ClassLoader>)None$.MODULE$);
    }

    public ActorRef actorFor(String className, long timeout, String hostname, int port, ClassLoader loader) {
        return this.actorFor(className, className, timeout, hostname, port, (Option<ClassLoader>)new Some((Object)loader));
    }

    public ActorRef actorFor(String uuid, String className, long timeout, String hostname, int port) {
        return new RemoteActorRef(uuid, className, hostname, port, timeout, (Option<ClassLoader>)None$.MODULE$);
    }

    public ActorRef actorFor(String uuid, String className, long timeout, String hostname, int port, ClassLoader loader) {
        return new RemoteActorRef(uuid, className, hostname, port, timeout, (Option<ClassLoader>)new Some((Object)loader));
    }

    public ActorRef actorFor(String uuid, String className, long timeout, String hostname, int port, Option<ClassLoader> loader) {
        return new RemoteActorRef(uuid, className, hostname, port, timeout, loader);
    }

    public RemoteClient clientFor(String hostname, int port) {
        return this.clientFor(new InetSocketAddress(hostname, port), (Option<ClassLoader>)None$.MODULE$);
    }

    public RemoteClient clientFor(String hostname, int port, ClassLoader loader) {
        return this.clientFor(new InetSocketAddress(hostname, port), (Option<ClassLoader>)new Some((Object)loader));
    }

    public RemoteClient clientFor(InetSocketAddress address) {
        return this.clientFor(address, (Option<ClassLoader>)None$.MODULE$);
    }

    public RemoteClient clientFor(InetSocketAddress address, ClassLoader loader) {
        return this.clientFor(address, (Option<ClassLoader>)new Some((Object)loader));
    }

    public RemoteClient clientFor(String hostname, int port, Option<ClassLoader> loader) {
        return this.clientFor(new InetSocketAddress(hostname, port), loader);
    }

    public RemoteClient clientFor(InetSocketAddress address, Option<ClassLoader> loader) {
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            Object object;
            String hostname = address.getHostName();
            int port = address.getPort();
            String hash2 = new StringBuilder().append((Object)hostname).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)BoxesRunTime.boxToInteger((int)port)).toString();
            loader.foreach((Function1)new anonfun.clientFor.1());
            if (this.remoteClients().contains((Object)hash2)) {
                object = this.remoteClients().apply((Object)hash2);
            } else {
                RemoteClient client = new RemoteClient(hostname, port, loader);
                client.connect();
                this.remoteClients().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)hash2).$minus$greater((Object)client));
                object = client;
            }
            Object object2 = object;
            return (RemoteClient)object2;
        }
    }

    public Object shutdownClientFor(InetSocketAddress address) {
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            BoxedUnit boxedUnit;
            String hostname = address.getHostName();
            int port = address.getPort();
            String hash2 = new StringBuilder().append((Object)hostname).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)BoxesRunTime.boxToInteger((int)port)).toString();
            if (this.remoteClients().contains((Object)hash2)) {
                RemoteClient client = (RemoteClient)this.remoteClients().apply((Object)hash2);
                client.shutdown();
                boxedUnit = this.remoteClients().$minus$eq((Object)hash2);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        }
    }

    public void shutdownAll() {
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            this.remoteClients().foreach((Function1)new anonfun.shutdownAll.1());
            this.remoteClients().clear();
            return;
        }
    }

    public HashSet<String> register(String hostname, int port, String uuid) {
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            HashSet hashSet = this.actorsFor(RemoteServer$Address$.MODULE$.apply(hostname, port)).$plus$eq((Object)uuid);
            return hashSet;
        }
    }

    public Object unregister(String hostname, int port, String uuid) {
        RemoteClient$ remoteClient$ = this;
        synchronized (remoteClient$) {
            HashSet<String> set = this.actorsFor(RemoteServer$Address$.MODULE$.apply(hostname, port));
            set.$minus$eq((Object)uuid);
            BoxedUnit boxedUnit = set.isEmpty() ? this.shutdownClientFor(new InetSocketAddress(hostname, port)) : BoxedUnit.UNIT;
            return boxedUnit;
        }
    }

    /*
     * WARNING - void declaration
     */
    public HashSet<String> actorsFor(RemoteServer.Address remoteServerAddress) {
        HashSet hashSet;
        Option set = this.remoteActors().get((Object)remoteServerAddress);
        if (set.isDefined() && set.get() != null) {
            hashSet = (HashSet)set.get();
        } else {
            void var3_3;
            HashSet remoteActorSet = new HashSet();
            this.remoteActors().put((Object)remoteServerAddress, (Object)remoteActorSet);
            hashSet = var3_3;
        }
        return hashSet;
    }

    private RemoteClient$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.READ_TIMEOUT = Config$.MODULE$.config().getInt("akka.remote.client.read-timeout", 10000);
        this.RECONNECT_DELAY = Config$.MODULE$.config().getInt("akka.remote.client.reconnect-delay", 5000);
        this.remoteClients = new HashMap();
        this.remoteActors = new HashMap();
    }
}

