/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.lag.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.dispatch.CompletableFuture;
import se.scalablesolutions.akka.dispatch.DefaultCompletableFuture;
import se.scalablesolutions.akka.remote.RemoteClient$;
import se.scalablesolutions.akka.remote.RemoteClientPipelineFactory;
import se.scalablesolutions.akka.remote.RemoteServer;
import se.scalablesolutions.akka.remote.protobuf.RemoteProtocol;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r=t!B\u0001\u0003\u0011\u000bY\u0011\u0001\u0004*f[>$Xm\u00117jK:$(BA\u0002\u0005\u0003\u0019\u0011X-\\8uK*\u0011QAB\u0001\u0005C.\\\u0017M\u0003\u0002\b\u0011\u0005\t2oY1mC\ndWm]8mkRLwN\\:\u000b\u0003%\t!a]3\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019AaB\u0001C\u0001\u0002#\u0015qB\u0001\u0007SK6|G/Z\"mS\u0016tGo\u0005\u0003\u000e!aq\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011\u0001B;uS2L!!\b\u000e\u0003\u000f1{wmZ5oOB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\tY1kY1mC>\u0013'.Z2u\u0011\u0015)S\u0002\"\u0001'\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004)\u001b\t\u0007I\u0011A\u0015\u0002\u0019I+\u0015\tR0U\u00136+u*\u0016+\u0016\u0003)\u0002\"aH\u0016\n\u00051\u0002#aA%oi\"1a&\u0004Q\u0001\n)\nQBU#B\t~#\u0016*T#P+R\u0003\u0003b\u0002\u0019\u000e\u0005\u0004%\t!K\u0001\u0010%\u0016\u001buJ\u0014(F\u0007R{F)\u0012'B3\"1!'\u0004Q\u0001\n)\n\u0001CU#D\u001f:sUi\u0011+`\t\u0016c\u0015)\u0017\u0011\t\u000fQj!\u0019!C\u0005k\u0005i!/Z7pi\u0016\u001cE.[3oiN,\u0012A\u000e\t\u0005oqrT)D\u00019\u0015\tI$(A\u0004nkR\f'\r\\3\u000b\u0005m\u0002\u0013AC2pY2,7\r^5p]&\u0011Q\b\u000f\u0002\b\u0011\u0006\u001c\b.T1q!\ty$I\u0004\u0002 \u0001&\u0011\u0011\tI\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002BAA\u0011AB\u0012\u0004\t\u001d\t!\t\u0011!A\u0001\u000fN!a\t\u0005\r\u001f\u0011!IeI!b\u0001\n\u0003Q\u0015\u0001\u00035pgRt\u0017-\\3\u0016\u0003yB\u0001\u0002\u0014$\u0003\u0002\u0003\u0006IAP\u0001\nQ>\u001cHO\\1nK\u0002B\u0001B\u0014$\u0003\u0006\u0004%\t!K\u0001\u0005a>\u0014H\u000f\u0003\u0005Q\r\n\u0005\t\u0015!\u0003+\u0003\u0015\u0001xN\u001d;!\u0011!\u0011fI!A!\u0002\u0013\u0019\u0016A\u00027pC\u0012,'\u000fE\u0002 )ZK!!\u0016\u0011\u0003\r=\u0003H/[8o!\t\tr+\u0003\u0002Y%\tY1\t\\1tg2{\u0017\rZ3s\u0011\u0019)c\t\"\u0001\u00055R!Qi\u0017/^\u0011\u0015I\u0015\f1\u0001?\u0011\u0015q\u0015\f1\u0001+\u0011\u0015\u0011\u0016\f1\u0001T\u0011\u001dyfI1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002\u0012E&\u00111I\u0005\u0005\u0007I\u001a\u0003\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u0011\u00194\u0005\u0019!C\u0001\u0005\u001d\f\u0011\"[:Sk:t\u0017N\\4\u0016\u0003!\u0004\"aH5\n\u0005)\u0004#a\u0002\"p_2,\u0017M\u001c\u0005\tY\u001a\u0003\r\u0011\"\u0001\u0003[\u0006i\u0011n\u001d*v]:LgnZ0%KF$\"A\\9\u0011\u0005}y\u0017B\u00019!\u0005\u0011)f.\u001b;\t\u000fI\\\u0017\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\t\rQ4\u0005\u0015)\u0003i\u0003)I7OU;o]&tw\r\t\u0015\u0003gZ\u0004\"aH<\n\u0005a\u0004#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fi4%\u0019!C\u0005w\u00069a-\u001e;ve\u0016\u001cX#\u0001?\u0011\u000fu\f\u0019!a\u0002\u0002\u000e5\taPC\u0002\u0000\u0003\u0003\t!bY8oGV\u0014(/\u001a8u\u0015\tYB#C\u0002\u0002\u0006y\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\ry\u0012\u0011B\u0005\u0004\u0003\u0017\u0001#\u0001\u0002'p]\u001e\u0004D!a\u0004\u0002 A1\u0011\u0011CA\f\u00037i!!a\u0005\u000b\u0007\u0005UA!\u0001\u0005eSN\u0004\u0018\r^2i\u0013\u0011\tI\"a\u0005\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002\u001e\u0005}A\u0002\u0001\u0003\f\u0003C\t\u0019\u0003\"A\u0001\u0006\u0003\t9CA\u0002`IEBq!!\nGA\u0003%A0\u0001\u0005gkR,(/Z:!#\u0011\tI#a\f\u0011\u0007}\tY#C\u0002\u0002.\u0001\u0012qAT8uQ&tw\rE\u0002 \u0003cI1!a\r!\u0005\r\te.\u001f\u0005\n\u0003o1%\u0019!C\u0005\u0003s\t1b];qKJ4\u0018n]8sgV\u0011\u00111\b\t\u0007{\u0006\ra(!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011\u0005\u0003\u0015\t7\r^8s\u0013\u0011\t9%!\u0011\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0001\"a\u0013GA\u0003%\u00111H\u0001\rgV\u0004XM\u001d<jg>\u00148\u000f\t\u0005\u000b\u0003\u001f2%\u0019!C\u0001\u0005\u0005E\u0013!\u00037jgR,g.\u001a:t+\t\t\u0019\u0006E\u0003~\u0003+\ni$C\u0002\u0002Xy\u0014QcQ8oGV\u0014(/\u001a8u'.L\u0007\u000fT5tiN+G\u000f\u0003\u0005\u0002\\\u0019\u0003\u000b\u0011BA*\u0003)a\u0017n\u001d;f]\u0016\u00148\u000f\t\u0005\n\u0003?2%\u0019!C\u0005\u0003C\nab\u00195b]:,GNR1di>\u0014\u00180\u0006\u0002\u0002dA!\u0011QMA@\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014a\u00018j_*!\u0011QNA8\u0003\u0019\u0019xnY6fi*!\u0011\u0011OA:\u0003\u001d\u0019\u0007.\u00198oK2TA!!\u001e\u0002x\u0005)a.\u001a;us*!\u0011\u0011PA>\u0003\u0015Q'm\\:t\u0015\t\ti(A\u0002pe\u001eLA!!!\u0002h\tib*[8DY&,g\u000e^*pG.,Go\u00115b]:,GNR1di>\u0014\u0018\u0010\u0003\u0005\u0002\u0006\u001a\u0003\u000b\u0011BA2\u0003=\u0019\u0007.\u00198oK24\u0015m\u0019;pef\u0004\u0003\"CAE\r\n\u0007I\u0011BAF\u0003%\u0011wn\u001c;tiJ\f\u0007/\u0006\u0002\u0002\u000eB!\u0011qRAJ\u001b\t\t\tJ\u0003\u0003\u0002\n\u0006M\u0014\u0002BAK\u0003#\u0013qb\u00117jK:$(i\\8ugR\u0014\u0018\r\u001d\u0005\t\u000333\u0005\u0015!\u0003\u0002\u000e\u0006Q!m\\8ugR\u0014\u0018\r\u001d\u0011\t\u0013\u0005ueI1A\u0005\n\u0005}\u0015!\u0002;j[\u0016\u0014XCAAQ!\u0011\t\u0019+a*\u000e\u0005\u0005\u0015&bA\u000e\u0002t%!\u0011\u0011VAS\u0005AA\u0015m\u001d5fI^CW-\u001a7US6,'\u000f\u0003\u0005\u0002.\u001a\u0003\u000b\u0011BAQ\u0003\u0019!\u0018.\\3sA!I\u0011\u0011\u0017$C\u0002\u0013%\u00111W\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0016\u0005\u0005U\u0006\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005mF#A\u0002oKRLA!a0\u0002:\n\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\t\u0011\u0005\rg\t)A\u0005\u0003k\u000baB]3n_R,\u0017\t\u001a3sKN\u001c\b\u0005\u0003\u0006\u0002H\u001a\u0003\r\u0011\"\u0001\u0003\u0003\u0013\f!bY8o]\u0016\u001cG/[8o+\t\tY\r\u0005\u0003\u0002N\u0006=WBAA8\u0013\u0011\t\t.a\u001c\u0003\u001b\rC\u0017M\u001c8fY\u001a+H/\u001e:f\u0011)\t)N\u0012a\u0001\n\u0003\u0011\u0011q[\u0001\u000fG>tg.Z2uS>tw\fJ3r)\rq\u0017\u0011\u001c\u0005\ne\u0006M\u0017\u0011!a\u0001\u0003\u0017D\u0001\"!8GA\u0003&\u00111Z\u0001\fG>tg.Z2uS>t\u0007\u0005\u0003\u0006\u0002b\u001a\u0013\r\u0011\"\u0001\u0003\u0003G\fAb\u001c9f]\u000eC\u0017M\u001c8fYN,\"!!:\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003STA!a;\u0002p\u0005)qM]8va&!\u0011q^Au\u0005M!UMZ1vYR\u001c\u0005.\u00198oK2<%o\\;q\u0011!\t\u0019P\u0012Q\u0001\n\u0005\u0015\u0018!D8qK:\u001c\u0005.\u00198oK2\u001c\b\u0005C\u0004\u0002x\u001a#\t!!?\u0002\u000f\r|gN\\3diV\ta\u000eC\u0004\u0002~\u001a#\t!!?\u0002\u0011MDW\u000f\u001e3po:DqA!\u0001G\t\u0003\u0011\u0019!\u0001\tsK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feR\u0019\u0001N!\u0002\t\u0011\t\u001d\u0011q a\u0001\u0003{\t\u0001\"Y2u_J\u0014VM\u001a\u0005\b\u0005\u00171E\u0011\u0001B\u0007\u0003I!WM]3hSN$XM\u001d'jgR,g.\u001a:\u0015\u0007!\u0014y\u0001\u0003\u0005\u0003\b\t%\u0001\u0019AA\u001f\u0011\u001d\u0011\u0019B\u0012C\u0001\u0005+\tAa]3oIV!!q\u0003B\u0010)\u0019\u0011IBa\t\u0003TA!q\u0004\u0016B\u000e!\u0019\t\t\"a\u0006\u0003\u001eA!\u0011Q\u0004B\u0010\t-\u0011\tC!\u0005\u0005\u0002\u0003\u0015\r!a\n\u0003\u0003QC\u0001B!\n\u0003\u0012\u0001\u0007!qE\u0001\be\u0016\fX/Z:u!\u0011\u0011IC!\u0014\u000f\t\t-\"q\t\b\u0005\u0005[\u0011\u0019E\u0004\u0003\u00030\t\u0005c\u0002\u0002B\u0019\u0005\u007fqAAa\r\u0003>9!!Q\u0007B\u001e\u001b\t\u00119DC\u0002\u0003:)\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!C\u0002\u0003F\t\t\u0001\u0002\u001d:pi>\u0014WOZ\u0005\u0005\u0005\u0013\u0012Y%\u0001\bSK6|G/\u001a)s_R|7m\u001c7\u000b\u0007\t\u0015#!\u0003\u0003\u0003P\tE#!\u0006*f[>$XMU3rk\u0016\u001cH\u000f\u0015:pi>\u001cw\u000e\u001c\u0006\u0005\u0005\u0013\u0012Y\u0005\u0003\u0005\u0003V\tE\u0001\u0019\u0001B\r\u00031\u0019XM\u001c3fe\u001a+H/\u001e:f\u0011!\u0011IF\u0012C\u0001\t\tm\u0013A\u0007:fO&\u001cH/\u001a:TkB,'O^5t_J4uN]!di>\u0014H\u0003BA\u001f\u0005;B\u0001Ba\u0002\u0003X\u0001\u0007\u0011Q\b\u0005\t\u0005C2E\u0011\u0001\u0003\u0003d\u0005aB-\u001a:fO&\u001cH/\u001a:TkB,'O^5t_J4uN]!di>\u0014H\u0003BA\u001f\u0005KB\u0001Ba\u0002\u0003`\u0001\u0007\u0011Q\b\u0005\b\u0005Sj\u0001\u0015!\u00037\u00039\u0011X-\\8uK\u000ec\u0017.\u001a8ug\u0002B\u0011B!\u001c\u000e\u0005\u0004%IAa\u001c\u0002\u0019I,Wn\u001c;f\u0003\u000e$xN]:\u0016\u0005\tE\u0004CB\u001c=\u0005g\u0012\t\t\u0005\u0003\u0003v\tmdb\u0001\u0007\u0003x%\u0019!\u0011\u0010\u0002\u0002\u0019I+Wn\u001c;f'\u0016\u0014h/\u001a:\n\t\tu$q\u0010\u0002\b\u0003\u0012$'/Z:t\u0015\r\u0011IH\u0001\t\u0005o\t\re(C\u0002\u0003\u0006b\u0012q\u0001S1tQN+G\u000f\u0003\u0005\u0003\n6\u0001\u000b\u0011\u0002B9\u00035\u0011X-\\8uK\u0006\u001bGo\u001c:tA!9!QR\u0007\u0005\u0002\t=\u0015\u0001C1di>\u0014hi\u001c:\u0015\u0011\u0005u\"\u0011\u0013BK\u0005/CqAa%\u0003\f\u0002\u0007a(A\u0005dY\u0006\u001c8OT1nK\"1\u0011Ja#A\u0002yBaA\u0014BF\u0001\u0004Q\u0003b\u0002BG\u001b\u0011\u0005!1\u0014\u000b\u000b\u0003{\u0011iJa(\u0003\"\n\r\u0006b\u0002BJ\u00053\u0003\rA\u0010\u0005\u0007\u0013\ne\u0005\u0019\u0001 \t\r9\u0013I\n1\u0001+\u0011\u0019\u0011&\u0011\u0014a\u0001-\"9!QR\u0007\u0005\u0002\t\u001dFCCA\u001f\u0005S\u0013iKa,\u00032\"9!1\u0016BS\u0001\u0004q\u0014\u0001B;vS\u0012DqAa%\u0003&\u0002\u0007a\b\u0003\u0004J\u0005K\u0003\rA\u0010\u0005\u0007\u001d\n\u0015\u0006\u0019\u0001\u0016\t\u000f\t5U\u0002\"\u0001\u00036Ra\u0011Q\bB\\\u0005s\u0013YL!0\u0003@\"9!1\u0016BZ\u0001\u0004q\u0004b\u0002BJ\u0005g\u0003\rA\u0010\u0005\u0007\u0013\nM\u0006\u0019\u0001 \t\r9\u0013\u0019\f1\u0001+\u0011\u0019\u0011&1\u0017a\u0001-\"9!QR\u0007\u0005\u0002\t\rGCCA\u001f\u0005\u000b\u00149Ma3\u0003N\"9!1\u0013Ba\u0001\u0004q\u0004\u0002\u0003Be\u0005\u0003\u0004\r!a\u0002\u0002\u000fQLW.Z8vi\"1\u0011J!1A\u0002yBaA\u0014Ba\u0001\u0004Q\u0003b\u0002BG\u001b\u0011\u0005!\u0011\u001b\u000b\r\u0003{\u0011\u0019N!6\u0003X\ne'1\u001c\u0005\b\u0005'\u0013y\r1\u0001?\u0011!\u0011IMa4A\u0002\u0005\u001d\u0001BB%\u0003P\u0002\u0007a\b\u0003\u0004O\u0005\u001f\u0004\rA\u000b\u0005\u0007%\n=\u0007\u0019\u0001,\t\u000f\t5U\u0002\"\u0001\u0003`Ra\u0011Q\bBq\u0005G\u0014)Oa:\u0003j\"9!1\u0016Bo\u0001\u0004q\u0004b\u0002BJ\u0005;\u0004\rA\u0010\u0005\t\u0005\u0013\u0014i\u000e1\u0001\u0002\b!1\u0011J!8A\u0002yBaA\u0014Bo\u0001\u0004Q\u0003\u0002\u0003BG\u001b\u0011\u0005AA!<\u0015\u001d\u0005u\"q\u001eBy\u0005g\u0014)Pa>\u0003z\"9!1\u0016Bv\u0001\u0004q\u0004b\u0002BJ\u0005W\u0004\rA\u0010\u0005\t\u0005\u0013\u0014Y\u000f1\u0001\u0002\b!1\u0011Ja;A\u0002yBaA\u0014Bv\u0001\u0004Q\u0003B\u0002*\u0003l\u0002\u0007a\u000b\u0003\u0005\u0003\u000e6!\t\u0001\u0002B\u007f)9\tiDa@\u0004\u0002\r\r1QAB\u0004\u0007\u0013AqAa+\u0003|\u0002\u0007a\bC\u0004\u0003\u0014\nm\b\u0019\u0001 \t\u0011\t%'1 a\u0001\u0003\u000fAa!\u0013B~\u0001\u0004q\u0004B\u0002(\u0003|\u0002\u0007!\u0006\u0003\u0004S\u0005w\u0004\ra\u0015\u0005\b\u0007\u001biA\u0011AB\b\u0003%\u0019G.[3oi\u001a{'\u000fF\u0003F\u0007#\u0019\u0019\u0002\u0003\u0004J\u0007\u0017\u0001\rA\u0010\u0005\u0007\u001d\u000e-\u0001\u0019\u0001\u0016\t\u000f\r5Q\u0002\"\u0001\u0004\u0018Q9Qi!\u0007\u0004\u001c\ru\u0001BB%\u0004\u0016\u0001\u0007a\b\u0003\u0004O\u0007+\u0001\rA\u000b\u0005\u0007%\u000eU\u0001\u0019\u0001,\t\u000f\r5Q\u0002\"\u0001\u0004\"Q\u0019Qia\t\t\u0011\r\u00152q\u0004a\u0001\u0003k\u000bq!\u00193ee\u0016\u001c8\u000fC\u0004\u0004\u000e5!\ta!\u000b\u0015\u000b\u0015\u001bYc!\f\t\u0011\r\u00152q\u0005a\u0001\u0003kCaAUB\u0014\u0001\u00041\u0006\u0002CB\u0007\u001b\u0011\u0005Aa!\r\u0015\u000f\u0015\u001b\u0019d!\u000e\u00048!1\u0011ja\fA\u0002yBaATB\u0018\u0001\u0004Q\u0003B\u0002*\u00040\u0001\u00071\u000b\u0003\u0005\u0004\u000e5!\t\u0001BB\u001e)\u0015)5QHB \u0011!\u0019)c!\u000fA\u0002\u0005U\u0006B\u0002*\u0004:\u0001\u00071\u000bC\u0004\u0004D5!\ta!\u0012\u0002#MDW\u000f\u001e3po:\u001cE.[3oi\u001a{'\u000f\u0006\u0003\u00020\r\u001d\u0003\u0002CB\u0013\u0007\u0003\u0002\r!!.\t\u000f\r-S\u0002\"\u0001\u0002z\u0006Y1\u000f[;uI><h.\u00117m\u0011!\u0019y%\u0004C\u0001\t\rE\u0013\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0011\t\u000551KB+\u0007/Ba!SB'\u0001\u0004q\u0004B\u0002(\u0004N\u0001\u0007!\u0006C\u0004\u0003,\u000e5\u0003\u0019\u0001 \t\u0011\rmS\u0002\"\u0001\u0005\u0007;\n!\"\u001e8sK\u001eL7\u000f^3s)!\tyca\u0018\u0004b\r\r\u0004BB%\u0004Z\u0001\u0007a\b\u0003\u0004O\u00073\u0002\rA\u000b\u0005\b\u0005W\u001bI\u00061\u0001?\u0011!\u00199'\u0004C\u0001\t\r%\u0014!C1di>\u00148OR8s)\u0011\u0011\tia\u001b\t\u0011\r54Q\ra\u0001\u0005g\n1C]3n_R,7+\u001a:wKJ\fE\r\u001a:fgN\u0004")
public class RemoteClient
implements Logging,
ScalaObject {
    private final String hostname;
    private final int port;
    private final String name;
    private volatile boolean isRunning;
    private final ConcurrentHashMap<Long, CompletableFuture<?>> futures;
    private final ConcurrentHashMap<String, ActorRef> supervisors;
    private final ConcurrentSkipListSet<ActorRef> listeners;
    private final NioClientSocketChannelFactory channelFactory;
    private final ClientBootstrap bootstrap;
    private final HashedWheelTimer timer;
    private final InetSocketAddress remoteAddress;
    private ChannelFuture connection;
    private final DefaultChannelGroup openChannels;
    private final transient Logger log;
    public volatile int bitmap$0;

    public static final HashSet<String> actorsFor(RemoteServer.Address address) {
        return RemoteClient$.MODULE$.actorsFor(address);
    }

    public static final Object unregister(String string, int n, String string2) {
        return RemoteClient$.MODULE$.unregister(string, n, string2);
    }

    public static final HashSet<String> register(String string, int n, String string2) {
        return RemoteClient$.MODULE$.register(string, n, string2);
    }

    public static final void shutdownAll() {
        RemoteClient$.MODULE$.shutdownAll();
    }

    public static final Object shutdownClientFor(InetSocketAddress inetSocketAddress) {
        return RemoteClient$.MODULE$.shutdownClientFor(inetSocketAddress);
    }

    public static final RemoteClient clientFor(InetSocketAddress inetSocketAddress, Option<ClassLoader> option) {
        return RemoteClient$.MODULE$.clientFor(inetSocketAddress, option);
    }

    public static final RemoteClient clientFor(String string, int n, Option<ClassLoader> option) {
        return RemoteClient$.MODULE$.clientFor(string, n, option);
    }

    public static final RemoteClient clientFor(InetSocketAddress inetSocketAddress, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.clientFor(inetSocketAddress, classLoader);
    }

    public static final RemoteClient clientFor(InetSocketAddress inetSocketAddress) {
        return RemoteClient$.MODULE$.clientFor(inetSocketAddress);
    }

    public static final RemoteClient clientFor(String string, int n, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.clientFor(string, n, classLoader);
    }

    public static final RemoteClient clientFor(String string, int n) {
        return RemoteClient$.MODULE$.clientFor(string, n);
    }

    public static final ActorRef actorFor(String string, String string2, long l, String string3, int n, Option<ClassLoader> option) {
        return RemoteClient$.MODULE$.actorFor(string, string2, l, string3, n, option);
    }

    public static final ActorRef actorFor(String string, String string2, long l, String string3, int n, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.actorFor(string, string2, l, string3, n, classLoader);
    }

    public static final ActorRef actorFor(String string, String string2, long l, String string3, int n) {
        return RemoteClient$.MODULE$.actorFor(string, string2, l, string3, n);
    }

    public static final ActorRef actorFor(String string, long l, String string2, int n, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.actorFor(string, l, string2, n, classLoader);
    }

    public static final ActorRef actorFor(String string, long l, String string2, int n) {
        return RemoteClient$.MODULE$.actorFor(string, l, string2, n);
    }

    public static final ActorRef actorFor(String string, String string2, String string3, int n, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.actorFor(string, string2, string3, n, classLoader);
    }

    public static final ActorRef actorFor(String string, String string2, String string3, int n) {
        return RemoteClient$.MODULE$.actorFor(string, string2, string3, n);
    }

    public static final ActorRef actorFor(String string, String string2, int n, ClassLoader classLoader) {
        return RemoteClient$.MODULE$.actorFor(string, string2, n, classLoader);
    }

    public static final ActorRef actorFor(String string, String string2, int n) {
        return RemoteClient$.MODULE$.actorFor(string, string2, n);
    }

    public static final int RECONNECT_DELAY() {
        return RemoteClient$.MODULE$.RECONNECT_DELAY();
    }

    public static final int READ_TIMEOUT() {
        return RemoteClient$.MODULE$.READ_TIMEOUT();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        RemoteClient remoteClient = this;
        synchronized (remoteClient) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String name() {
        return this.name;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void isRunning_$eq(boolean bl) {
        this.isRunning = bl;
    }

    private ConcurrentHashMap<Long, CompletableFuture<?>> futures() {
        return this.futures;
    }

    private ConcurrentHashMap<String, ActorRef> supervisors() {
        return this.supervisors;
    }

    public ConcurrentSkipListSet<ActorRef> listeners() {
        return this.listeners;
    }

    private NioClientSocketChannelFactory channelFactory() {
        return this.channelFactory;
    }

    private ClientBootstrap bootstrap() {
        return this.bootstrap;
    }

    private HashedWheelTimer timer() {
        return this.timer;
    }

    private InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public ChannelFuture connection() {
        return this.connection;
    }

    public void connection_$eq(ChannelFuture channelFuture) {
        this.connection = channelFuture;
    }

    public DefaultChannelGroup openChannels() {
        return this.openChannels;
    }

    public void connect() {
        RemoteClient remoteClient = this;
        synchronized (remoteClient) {
            BoxedUnit boxedUnit;
            if (this.isRunning()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.connection_$eq(this.bootstrap().connect((SocketAddress)this.remoteAddress()));
                this.log().info("Starting remote client connection to [%s:%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname(), BoxesRunTime.boxToInteger((int)this.port())}));
                Channel channel = this.connection().awaitUninterruptibly().getChannel();
                this.openChannels().add(channel);
                if (!this.connection().isSuccess()) {
                    Predef$.MODULE$.refArrayOps(this.listeners().toArray()).foreach((Function1)new $anonfun$connect$1(this));
                    this.log().error(this.connection().getCause(), "Remote client connection to [%s:%s] has failed", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname(), BoxesRunTime.boxToInteger((int)this.port())}));
                }
                this.isRunning_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void shutdown() {
        RemoteClient remoteClient = this;
        synchronized (remoteClient) {
            BoxedUnit boxedUnit;
            if (this.isRunning()) {
                this.isRunning_$eq(false);
                this.openChannels().close().awaitUninterruptibly();
                this.bootstrap().releaseExternalResources();
                this.timer().stop();
                this.log().info("%s has been shut down", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean registerListener(ActorRef actorRef) {
        return this.listeners().add(actorRef);
    }

    public boolean deregisterListener(ActorRef actorRef) {
        return this.listeners().remove(actorRef);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Option<CompletableFuture<T>> send(RemoteProtocol.RemoteRequestProtocol request, Option<CompletableFuture<T>> senderFuture2) {
        Some some;
        None$ none$;
        if (!this.isRunning()) {
            IllegalStateException exception$1 = new IllegalStateException("Remote client is not running, make sure you have invoked 'RemoteClient.connect' before using it.");
            Predef$.MODULE$.refArrayOps(this.listeners().toArray()).foreach((Function1)new $anonfun$send$1(this, exception$1));
            throw exception$1;
        }
        if (request.getIsOneWay()) {
            this.connection().getChannel().write((Object)request);
            none$ = None$.MODULE$;
            return none$;
        }
        ConcurrentHashMap<Long, CompletableFuture<?>> concurrentHashMap = this.futures();
        synchronized (concurrentHashMap) {
            CompletableFuture futureResult = senderFuture2.isDefined() ? (CompletableFuture)senderFuture2.get() : new DefaultCompletableFuture(request.getTimeout());
            this.futures().put(BoxesRunTime.boxToLong((long)request.getId()), futureResult);
            this.connection().getChannel().write((Object)request);
            some = new Some(futureResult);
        }
        none$ = (Option)some;
        return none$;
    }

    public ActorRef registerSupervisorForActor(ActorRef actorRef) {
        if (actorRef.supervisor().isDefined()) {
            return this.supervisors().putIfAbsent(((ActorRef)actorRef.supervisor().get()).uuid(), actorRef);
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Can't register supervisor for ").append((Object)actorRef).append((Object)" since it is not under supervision").toString());
    }

    public ActorRef deregisterSupervisorForActor(ActorRef actorRef) {
        if (actorRef.supervisor().isDefined()) {
            return this.supervisors().remove(((ActorRef)actorRef.supervisor().get()).uuid());
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Can't unregister supervisor for ").append((Object)actorRef).append((Object)" since it is not under supervision").toString());
    }

    public RemoteClient(String hostname, int port, Option<ClassLoader> loader) {
        this.hostname = hostname;
        this.port = port;
        Logging$class.$init$(this);
        this.name = new StringBuilder().append((Object)"RemoteClient@").append((Object)hostname).append((Object)"::").append((Object)BoxesRunTime.boxToInteger((int)port)).toString();
        this.isRunning = false;
        this.futures = new ConcurrentHashMap();
        this.supervisors = new ConcurrentHashMap();
        this.listeners = new ConcurrentSkipListSet();
        this.channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory());
        this.timer = new HashedWheelTimer();
        this.remoteAddress = new InetSocketAddress(hostname, port);
        this.openChannels = new DefaultChannelGroup(RemoteClient.class.getName());
        this.bootstrap().setPipelineFactory((ChannelPipelineFactory)new RemoteClientPipelineFactory(this.name(), this.futures(), this.supervisors(), this.bootstrap(), this.remoteAddress(), this.timer(), this));
        this.bootstrap().setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.bootstrap().setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

