/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.lag.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.TimerTask;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.Exit;
import se.scalablesolutions.akka.dispatch.CompletableFuture;
import se.scalablesolutions.akka.remote.RemoteClient;
import se.scalablesolutions.akka.remote.RemoteClient$;
import se.scalablesolutions.akka.remote.RemoteClientHandler$;
import se.scalablesolutions.akka.remote.RemoteProtocolBuilder$;
import se.scalablesolutions.akka.remote.protobuf.RemoteProtocol;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003'I+Wn\u001c;f\u00072LWM\u001c;IC:$G.\u001a:\u000b\u0005\r!\u0011A\u0002:f[>$XM\u0003\u0002\u0006\r\u0005!\u0011m[6b\u0015\t9\u0001\"A\ttG\u0006d\u0017M\u00197fg>dW\u000f^5p]NT\u0011!C\u0001\u0003g\u0016\u001c\u0001a\u0005\u0003\u0001\u0019aq\u0002CA\u0007\u0017\u001b\u0005q!BA\b\u0011\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0005\n\u0002\u000b9,G\u000f^=\u000b\u0005M!\u0012!\u00026c_N\u001c(\"A\u000b\u0002\u0007=\u0014x-\u0003\u0002\u0018\u001d\ta2+[7qY\u0016\u001c\u0005.\u00198oK2,\u0006o\u001d;sK\u0006l\u0007*\u00198eY\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005uQ\"a\u0002'pO\u001eLgn\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0011q\u0017-\\3\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000f\u0005}I\u0013B\u0001\u0016!\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\u0002\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000b9\fW.\u001a\u0011\t\u0011E\u0002!Q1A\u0005\u0002I\nqAZ;ukJ,7/F\u00014!\u0011!$\bP \u000e\u0003UR!AN\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001cq)\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e6\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011q$P\u0005\u0003}\u0001\u0012A\u0001T8oOB\u0012\u0001\t\u0013\t\u0004\u0003\u00123U\"\u0001\"\u000b\u0005\r#\u0011\u0001\u00033jgB\fGo\u00195\n\u0005\u0015\u0013%!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0011q\t\u0013\u0007\u0001\t!I\u0005\u0001\"A\u0001\u0006\u0003Q%aA0%gE\u00111J\u0014\t\u0003?1K!!\u0014\u0011\u0003\u000f9{G\u000f[5oOB\u0011qdT\u0005\u0003!\u0002\u00121!\u00118z\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0016\u0001\u00034viV\u0014Xm\u001d\u0011\u0011\tQRD\b\u0016\u0019\u0003+^\u00032!\u0011#W!\t9u\u000b\u0002\u0005J\u0001\u0011\u0005\tQ!\u0001K\u0011!I\u0006A!b\u0001\n\u0003Q\u0016aC:va\u0016\u0014h/[:peN,\u0012a\u0017\t\u0005ii:C\f\u0005\u0002^A6\taL\u0003\u0002`\t\u0005)\u0011m\u0019;pe&\u0011\u0011M\u0018\u0002\t\u0003\u000e$xN\u001d*fM\"A1\r\u0001B\u0001B\u0003%1,\u0001\u0007tkB,'O^5t_J\u001c\b\u0005\u0003\u0005f\u0001\t\u0015\r\u0011\"\u0001g\u0003%\u0011wn\u001c;tiJ\f\u0007/F\u0001h!\tA'.D\u0001j\u0015\t)\u0007#\u0003\u0002lS\ny1\t\\5f]R\u0014un\u001c;tiJ\f\u0007\u000f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003h\u0003)\u0011wn\u001c;tiJ\f\u0007\u000f\t\u0005\t_\u0002\u0011)\u0019!C\u0001a\u0006i!/Z7pi\u0016\fE\r\u001a:fgN,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003ib\n1A\\3u\u0013\t18OA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\tq\u0002\u0011\t\u0011)A\u0005c\u0006q!/Z7pi\u0016\fE\r\u001a:fgN\u0004\u0003\u0002\u0003>\u0001\u0005\u000b\u0007I\u0011A>\u0002\u000bQLW.\u001a:\u0016\u0003q\u0004\"!`@\u000e\u0003yT!a\u0007\t\n\u0007\u0005\u0005aP\u0001\tICNDW\rZ,iK\u0016dG+[7fe\"I\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I\u0001`\u0001\u0007i&lWM\u001d\u0011\t\u0015\u0005%\u0001A!b\u0001\n\u0003\tY!\u0001\u0004dY&,g\u000e^\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00125\t!!C\u0002\u0002\u0014\t\u0011ABU3n_R,7\t\\5f]RD!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0003\u001d\u0019G.[3oi\u0002Bq!a\u0007\u0001\t\u0003\ti\"\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003?\t\t#a\t\u00020\u0005E\u00121GA\u001b\u0003o\u00012!a\u0004\u0001\u0011\u0019)\u0013\u0011\u0004a\u0001O!9\u0011'!\u0007A\u0002\u0005\u0015\u0002#\u0002\u001b;y\u0005\u001d\u0002\u0007BA\u0015\u0003[\u0001B!\u0011#\u0002,A\u0019q)!\f\u0005\u0013%\u000bI\u0002\"A\u0001\u0006\u0003Q\u0005BB-\u0002\u001a\u0001\u00071\f\u0003\u0004f\u00033\u0001\ra\u001a\u0005\u0007_\u0006e\u0001\u0019A9\t\ri\fI\u00021\u0001}\u0011!\tI!!\u0007A\u0002\u00055\u0001bBA\u001e\u0001\u0011\u0005\u0013QH\u0001\u000fQ\u0006tG\r\\3VaN$(/Z1n)\u0019\ty$!\u0012\u0002PA\u0019q$!\u0011\n\u0007\u0005\r\u0003E\u0001\u0003V]&$\b\u0002CA$\u0003s\u0001\r!!\u0013\u0002\u0007\r$\b\u0010E\u0002\u000e\u0003\u0017J1!!\u0014\u000f\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRD\u0001\"!\u0015\u0002:\u0001\u0007\u00111K\u0001\u0006KZ,g\u000e\u001e\t\u0004\u001b\u0005U\u0013bAA,\u001d\ta1\t[1o]\u0016dWI^3oi\"9\u00111\f\u0001\u0005B\u0005u\u0013aD7fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\r\u0005}\u0012qLA1\u0011!\t9%!\u0017A\u0002\u0005%\u0003\u0002CA)\u00033\u0002\r!a\u0019\u0011\u00075\t)'C\u0002\u0002h9\u0011A\"T3tg\u0006<W-\u0012<f]RDq!a\u001b\u0001\t\u0003\ni'A\u0007dQ\u0006tg.\u001a7DY>\u001cX\r\u001a\u000b\u0007\u0003\u007f\ty'!\u001d\t\u0011\u0005\u001d\u0013\u0011\u000ea\u0001\u0003\u0013B\u0001\"!\u0015\u0002j\u0001\u0007\u00111\u000f\t\u0004\u001b\u0005U\u0014bAA<\u001d\t\t2\t[1o]\u0016d7\u000b^1uK\u00163XM\u001c;\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u0005\u00012\r[1o]\u0016d7i\u001c8oK\u000e$X\r\u001a\u000b\u0007\u0003\u007f\ty(!!\t\u0011\u0005\u001d\u0013\u0011\u0010a\u0001\u0003\u0013B\u0001\"!\u0015\u0002z\u0001\u0007\u00111\u000f\u0005\b\u0003\u000b\u0003A\u0011IAD\u0003M\u0019\u0007.\u00198oK2$\u0015n]2p]:,7\r^3e)\u0019\ty$!#\u0002\f\"A\u0011qIAB\u0001\u0004\tI\u0005\u0003\u0005\u0002R\u0005\r\u0005\u0019AA:\u0011\u001d\ty\t\u0001C!\u0003#\u000bq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0007\u0003\u007f\t\u0019*!&\t\u0011\u0005\u001d\u0013Q\u0012a\u0001\u0003\u0013B\u0001\"!\u0015\u0002\u000e\u0002\u0007\u0011q\u0013\t\u0004\u001b\u0005e\u0015bAAN\u001d\tqQ\t_2faRLwN\\#wK:$\bbBAP\u0001\u0011%\u0011\u0011U\u0001\u000fa\u0006\u00148/Z#yG\u0016\u0004H/[8o)\u0011\t\u0019+a/\u0011\t\u0005\u0015\u0016Q\u0017\b\u0005\u0003O\u000b\tL\u0004\u0003\u0002*\u0006=VBAAV\u0015\r\tiKC\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J1!a-!\u0003\u001d\u0001\u0018mY6bO\u0016LA!a.\u0002:\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003g\u0003\u0003\u0002CA_\u0003;\u0003\r!a0\u0002\u000bI,\u0007\u000f\\=\u0011\t\u0005\u0005\u0017q\u001c\b\u0005\u0003\u0007\fIN\u0004\u0003\u0002F\u0006Ug\u0002BAd\u0003'tA!!3\u0002R:!\u00111ZAh\u001d\u0011\tI+!4\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\t9NA\u0001\taJ|Go\u001c2vM&!\u00111\\Ao\u00039\u0011V-\\8uKB\u0013x\u000e^8d_2T1!a6\u0003\u0013\u0011\t\t/a9\u0003'I+Wn\u001c;f%\u0016\u0004H.\u001f)s_R|7m\u001c7\u000b\t\u0005m\u0017Q\u001c\u0015\u0004\u0001\u0005\u001d\b\u0003BAu\u0003_t1!DAv\u0013\r\tiOD\u0001\u000f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0013\u0011\t\t0a=\u0003\u0011MC\u0017M]1cY\u0016T1!!<\u000f\u0001")
public class RemoteClientHandler
extends SimpleChannelUpstreamHandler
implements Logging,
ScalaObject {
    private final String name;
    private final ConcurrentMap<Long, CompletableFuture<?>> futures;
    private final ConcurrentMap<String, ActorRef> supervisors;
    private final ClientBootstrap bootstrap;
    private final SocketAddress remoteAddress;
    private final HashedWheelTimer timer;
    private final RemoteClient client;
    private final transient Logger log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        RemoteClientHandler remoteClientHandler = this;
        synchronized (remoteClientHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    public String name() {
        return this.name;
    }

    public ConcurrentMap<Long, CompletableFuture<?>> futures() {
        return this.futures;
    }

    public ConcurrentMap<String, ActorRef> supervisors() {
        return this.supervisors;
    }

    public ClientBootstrap bootstrap() {
        return this.bootstrap;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public HashedWheelTimer timer() {
        return this.timer;
    }

    public RemoteClient client() {
        return this.client;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) {
        if (event instanceof ChannelStateEvent) {
            ChannelState channelState = ((ChannelStateEvent)event).getState();
            ChannelState channelState2 = ChannelState.INTEREST_OPS;
            if (channelState == null ? channelState2 != null : !channelState.equals(channelState2)) {
                this.log().debug(event.toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        super.handleUpstream(ctx, event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        try {
            Object result = event.getMessage();
            if (result instanceof RemoteProtocol.RemoteReplyProtocol) {
                RemoteProtocol.RemoteReplyProtocol reply = (RemoteProtocol.RemoteReplyProtocol)((Object)result);
                this.log().debug("Remote client received RemoteReplyProtocol[\n%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reply.toString()}));
                CompletableFuture future = (CompletableFuture)this.futures().get(BoxesRunTime.boxToLong((long)reply.getId()));
                if (reply.getIsSuccessful()) {
                    Object message = RemoteProtocolBuilder$.MODULE$.getMessage(reply);
                    future.completeWithResult(message);
                } else {
                    if (reply.hasSupervisorUuid()) {
                        String supervisorUuid = reply.getSupervisorUuid();
                        if (!this.supervisors().containsKey(supervisorUuid)) throw new IllegalStateException(new StringBuilder().append((Object)"Expected a registered supervisor for UUID [").append((Object)supervisorUuid).append((Object)"] but none was found").toString());
                        ActorRef supervisedActor = (ActorRef)this.supervisors().get(supervisorUuid);
                        if (!supervisedActor.supervisor().isDefined()) throw new IllegalStateException(new StringBuilder().append((Object)"Can't handle restart for remote actor ").append((Object)supervisedActor).append((Object)" since its supervisor has been removed").toString());
                        ActorRef qual$3 = (ActorRef)supervisedActor.supervisor().get();
                        Exit x$6 = new Exit(supervisedActor, this.parseException(reply));
                        Option x$7 = qual$3.$bang$default$2(x$6);
                        qual$3.$bang(x$6, (Option<ActorRef>)x$7);
                    }
                    future.completeWithException(null, this.parseException(reply));
                }
                this.futures().remove(BoxesRunTime.boxToLong((long)reply.getId()));
                return;
            }
            IllegalArgumentException exception$2 = new IllegalArgumentException(new StringBuilder().append((Object)"Unknown message received in remote client handler: ").append(result).toString());
            Predef$.MODULE$.refArrayOps(this.client().listeners().toArray()).foreach((Function1)new $anonfun$messageReceived$1(this, exception$2));
            throw exception$2;
        }
        catch (Exception exception) {
            Predef$.MODULE$.refArrayOps(this.client().listeners().toArray()).foreach((Function1)new $anonfun$messageReceived$2(this, exception));
            this.log().error("Unexpected exception in remote client handler: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception}));
            throw exception;
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event$1) {
        if (this.client().isRunning()) {
            this.timer().newTimeout((TimerTask)new $anon$1(this, event$1), (long)RemoteClient$.MODULE$.RECONNECT_DELAY(), TimeUnit.MILLISECONDS);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Predef$.MODULE$.refArrayOps(this.client().listeners().toArray()).foreach((Function1)new $anonfun$channelConnected$1(this));
        this.log().debug("Remote client connected to [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.getChannel().getRemoteAddress()}));
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Predef$.MODULE$.refArrayOps(this.client().listeners().toArray()).foreach((Function1)new $anonfun$channelDisconnected$1(this));
        this.log().debug("Remote client disconnected from [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.getChannel().getRemoteAddress()}));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event$2) {
        Predef$.MODULE$.refArrayOps(this.client().listeners().toArray()).foreach((Function1)new $anonfun$exceptionCaught$1(this, event$2));
        this.log().error(event$2.getCause(), "Unexpected exception from downstream in remote client", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        event$2.getChannel().close();
    }

    private Throwable parseException(RemoteProtocol.RemoteReplyProtocol reply) {
        String exception = reply.getException();
        Class<?> exceptionType = Class.forName(exception.substring(0, exception.indexOf(36)));
        String exceptionMessage = exception.substring(exception.indexOf(36) + 1, exception.length());
        return (Throwable)exceptionType.getConstructor((Class[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String.class}), ClassManifest$.MODULE$.classType(Class.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])))).newInstance(exceptionMessage);
    }

    public RemoteClientHandler(String name2, ConcurrentMap<Long, CompletableFuture<?>> futures, ConcurrentMap<String, ActorRef> supervisors, ClientBootstrap bootstrap, SocketAddress remoteAddress2, HashedWheelTimer timer, RemoteClient client) {
        this.name = name2;
        this.futures = futures;
        this.supervisors = supervisors;
        this.bootstrap = bootstrap;
        this.remoteAddress = remoteAddress2;
        this.timer = timer;
        this.client = client;
        Logging$class.$init$(this);
    }
}

