/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import java.net.InetSocketAddress;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.config.Config$;
import se.scalablesolutions.akka.remote.RemoteServer;
import se.scalablesolutions.akka.remote.RemoteServer$;
import se.scalablesolutions.akka.remote.RemoteServer$$anonfun$se$scalablesolutions$akka$remote$RemoteServer$;
import se.scalablesolutions.akka.util.ReadWriteGuard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteServer$
implements ScalaObject {
    public static final RemoteServer$ MODULE$;
    private final String HOSTNAME;
    private final int PORT;
    private final int CONNECTION_TIMEOUT_MILLIS;
    private final String COMPRESSION_SCHEME;
    private final int ZLIB_COMPRESSION_LEVEL;
    private final ReadWriteGuard guard;
    private final Map<RemoteServer.Address, RemoteServer.RemoteActorSet> remoteActorSets;
    private final Map se$scalablesolutions$akka$remote$RemoteServer$$remoteServers;

    static {
        new RemoteServer$();
    }

    public String HOSTNAME() {
        return this.HOSTNAME;
    }

    public int PORT() {
        return this.PORT;
    }

    public int CONNECTION_TIMEOUT_MILLIS() {
        return this.CONNECTION_TIMEOUT_MILLIS;
    }

    public String COMPRESSION_SCHEME() {
        return this.COMPRESSION_SCHEME;
    }

    public int ZLIB_COMPRESSION_LEVEL() {
        return this.ZLIB_COMPRESSION_LEVEL;
    }

    private ReadWriteGuard guard() {
        return this.guard;
    }

    private Map<RemoteServer.Address, RemoteServer.RemoteActorSet> remoteActorSets() {
        return this.remoteActorSets;
    }

    public final Map se$scalablesolutions$akka$remote$RemoteServer$$remoteServers() {
        return this.se$scalablesolutions$akka$remote$RemoteServer$$remoteServers;
    }

    public ActorRef registerActor(InetSocketAddress address$2, String uuid$1, ActorRef actor$1) {
        return (ActorRef)this.guard().withWriteGuard(new anonfun.registerActor.1(address$2, uuid$1, actor$1));
    }

    public Object registerActiveObject(InetSocketAddress address$3, String name$1, Object activeObject$1) {
        return this.guard().withWriteGuard(new anonfun.registerActiveObject.1(address$3, name$1, activeObject$1));
    }

    public RemoteServer getOrCreateServer(InetSocketAddress address$1) {
        return (RemoteServer)this.guard().withWriteGuard(new anonfun.getOrCreateServer.1(address$1));
    }

    public Option<RemoteServer> serverFor(InetSocketAddress address) {
        return this.serverFor(address.getHostName(), address.getPort());
    }

    public Option<RemoteServer> serverFor(String hostname$2, int port$2) {
        return (Option)this.guard().withReadGuard(new anonfun.serverFor.1(hostname$2, port$2));
    }

    public Option<RemoteServer> register(String hostname$3, int port$3, RemoteServer server$1) {
        return (Option)this.guard().withWriteGuard(new anonfun.register.1(hostname$3, port$3, server$1));
    }

    public Option<RemoteServer> unregister(String hostname$1, int port$1) {
        return (Option)this.guard().withWriteGuard(new anonfun.unregister.1(hostname$1, port$1));
    }

    public final RemoteServer.RemoteActorSet se$scalablesolutions$akka$remote$RemoteServer$$actorsFor(RemoteServer.Address remoteServerAddress) {
        return (RemoteServer.RemoteActorSet)this.remoteActorSets().getOrElseUpdate((Object)remoteServerAddress, (Function0)new anonfun$se$scalablesolutions$akka$remote$RemoteServer$$actorsFor$1());
    }

    /*
     * WARNING - void declaration
     */
    private RemoteServer$() {
        void var1_1;
        MODULE$ = this;
        this.HOSTNAME = Config$.MODULE$.config().getString("akka.remote.server.hostname", "localhost");
        this.PORT = Config$.MODULE$.config().getInt("akka.remote.server.port", 9999);
        this.CONNECTION_TIMEOUT_MILLIS = Config$.MODULE$.config().getInt("akka.remote.server.connection-timeout", 1000);
        this.COMPRESSION_SCHEME = Config$.MODULE$.config().getString("akka.remote.compression-scheme", "zlib");
        int level = Config$.MODULE$.config().getInt("akka.remote.zlib-compression-level", 6);
        if (level < 1 && level > 9) {
            throw new IllegalArgumentException("zlib compression level has to be within 1-9, with 1 being fastest and 9 being the most compressed");
        }
        this.ZLIB_COMPRESSION_LEVEL = var1_1;
        this.guard = new ReadWriteGuard();
        this.remoteActorSets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.se$scalablesolutions$akka$remote$RemoteServer$$remoteServers = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

