/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import net.lag.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import se.scalablesolutions.akka.actor.ActiveObject$;
import se.scalablesolutions.akka.actor.Actor;
import se.scalablesolutions.akka.actor.Actor$;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.ActorRef$;
import se.scalablesolutions.akka.remote.RemoteProtocolBuilder$;
import se.scalablesolutions.akka.remote.RemoteServerHandler$;
import se.scalablesolutions.akka.remote.protobuf.RemoteProtocol;
import se.scalablesolutions.akka.util.Logging;
import se.scalablesolutions.akka.util.Logging$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003'I+Wn\u001c;f'\u0016\u0014h/\u001a:IC:$G.\u001a:\u000b\u0005\r!\u0011A\u0002:f[>$XM\u0003\u0002\u0006\r\u0005!\u0011m[6b\u0015\t9\u0001\"A\ttG\u0006d\u0017M\u00197fg>dW\u000f^5p]NT\u0011!C\u0001\u0003g\u0016\u001c\u0001a\u0005\u0003\u0001\u0019aq\u0002CA\u0007\u0017\u001b\u0005q!BA\b\u0011\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0005\n\u0002\u000b9,G\u000f^=\u000b\u0005M!\u0012!\u00026c_N\u001c(\"A\u000b\u0002\u0007=\u0014x-\u0003\u0002\u0018\u001d\ta2+[7qY\u0016\u001c\u0005.\u00198oK2,\u0006o\u001d;sK\u0006l\u0007*\u00198eY\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005uQ\"a\u0002'pO\u001eLgn\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0011q\u0017-\\3\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000f\u0005}I\u0013B\u0001\u0016!\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\u0002\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000b9\fW.\u001a\u0011\t\u0011E\u0002!Q1A\u0005\u0002I\nAb\u001c9f]\u000eC\u0017M\u001c8fYN,\u0012a\r\t\u0003i]j\u0011!\u000e\u0006\u0003m9\tQa\u001a:pkBL!\u0001O\u001b\u0003\u0019\rC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\u0011i\u0002!\u0011!Q\u0001\nM\nQb\u001c9f]\u000eC\u0017M\u001c8fYN\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\u0002#\u0005\u0004\b\u000f\\5dCRLwN\u001c'pC\u0012,'/F\u0001?!\ryr(Q\u0005\u0003\u0001\u0002\u0012aa\u00149uS>t\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\f\u00072\f7o\u001d'pC\u0012,'\u000f\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003?\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8M_\u0006$WM\u001d\u0011\t\u00111\u0003!Q1A\u0005\u00025\u000ba!Y2u_J\u001cX#\u0001(\u0011\t=\u000bveU\u0007\u0002!*\u00111$R\u0005\u0003%B\u00131!T1q!\t!v+D\u0001V\u0015\t1F!A\u0003bGR|'/\u0003\u0002Y+\nA\u0011i\u0019;peJ+g\r\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003O\u0003\u001d\t7\r^8sg\u0002B\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!X\u0001\u000eC\u000e$\u0018N^3PE*,7\r^:\u0016\u0003y\u0003BaT)(?B\u0011q\u0004Y\u0005\u0003C\u0002\u0012a!\u00118z%\u00164\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\u0002\u001d\u0005\u001cG/\u001b<f\u001f\nTWm\u0019;tA!)Q\r\u0001C\u0001M\u00061A(\u001b8jiz\"baZ5kW2l\u0007C\u00015\u0001\u001b\u0005\u0011\u0001\"B\u0013e\u0001\u00049\u0003\"B\u0019e\u0001\u0004\u0019\u0004\"\u0002\u001fe\u0001\u0004q\u0004\"\u0002'e\u0001\u0004q\u0005\"\u0002/e\u0001\u0004q\u0006bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0010\u0003^{\u0006KU(Y3~\u0003&+\u0012$J1V\t\u0011\u000f\u0005\u0002Ce&\u0011Af\u0011\u0005\u0007i\u0002\u0001\u000b\u0011B9\u0002!\u0005;v\f\u0015*P1f{\u0006KU#G\u0013b\u0003\u0003\"\u0002<\u0001\t\u0003:\u0018aC2iC:tW\r\\(qK:$B\u0001_>\u0002\u0002A\u0011q$_\u0005\u0003u\u0002\u0012A!\u00168ji\")A0\u001ea\u0001{\u0006\u00191\r\u001e=\u0011\u00055q\u0018BA@\u000f\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDq!a\u0001v\u0001\u0004\t)!A\u0003fm\u0016tG\u000fE\u0002\u000e\u0003\u000fI1!!\u0003\u000f\u0005E\u0019\u0005.\u00198oK2\u001cF/\u0019;f\u000bZ,g\u000e\u001e\u0005\b\u0003\u001b\u0001A\u0011IA\b\u00039A\u0017M\u001c3mKV\u00038\u000f\u001e:fC6$R\u0001_A\t\u0003'Aa\u0001`A\u0006\u0001\u0004i\b\u0002CA\u0002\u0003\u0017\u0001\r!!\u0006\u0011\u00075\t9\"C\u0002\u0002\u001a9\u0011Ab\u00115b]:,G.\u0012<f]RDq!!\b\u0001\t\u0003\ny\"A\bnKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\u0015A\u0018\u0011EA\u0012\u0011\u0019a\u00181\u0004a\u0001{\"A\u00111AA\u000e\u0001\u0004\t)\u0003E\u0002\u000e\u0003OI1!!\u000b\u000f\u00051iUm]:bO\u0016,e/\u001a8u\u0011\u001d\ti\u0003\u0001C!\u0003_\tq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0006q\u0006E\u00121\u0007\u0005\u0007y\u0006-\u0002\u0019A?\t\u0011\u0005\r\u00111\u0006a\u0001\u0003k\u00012!DA\u001c\u0013\r\tID\u0004\u0002\u000f\u000bb\u001cW\r\u001d;j_:,e/\u001a8u\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007f\t1\u0004[1oI2,'+Z7pi\u0016\u0014V-];fgR\u0004&o\u001c;pG>dGCBA!\u0003\u000f\n9\bE\u0002 \u0003\u0007J1!!\u0012!\u0005\r\te.\u001f\u0005\t\u0003\u0013\nY\u00041\u0001\u0002L\u00059!/Z9vKN$\b\u0003BA'\u0003crA!a\u0014\u0002l9!\u0011\u0011KA4\u001d\u0011\t\u0019&!\u001a\u000f\t\u0005U\u00131\r\b\u0005\u0003/\n\tG\u0004\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\tIGA\u0001\taJ|Go\u001c2vM&!\u0011QNA8\u00039\u0011V-\\8uKB\u0013x\u000e^8d_2T1!!\u001b\u0003\u0013\u0011\t\u0019(!\u001e\u0003+I+Wn\u001c;f%\u0016\fX/Z:u!J|Go\\2pY*!\u0011QNA8\u0011\u001dy\u00111\ba\u0001\u0003s\u00022!DA>\u0013\r\tiH\u0004\u0002\b\u0007\"\fgN\\3m\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000bq\u0002Z5ta\u0006$8\r\u001b+p\u0003\u000e$xN\u001d\u000b\u0007\u0003\u0003\n))a\"\t\u0011\u0005%\u0013q\u0010a\u0001\u0003\u0017BqaDA@\u0001\u0004\tI\bC\u0004\u0002\f\u0002!I!!$\u0002-\u0011L7\u000f]1uG\"$v.Q2uSZ,wJ\u00196fGR$b!a$\u0002\u0016\u0006]\u0005c\u0001\"\u0002\u0012&\u0019\u00111S\"\u0003\r=\u0013'.Z2u\u0011!\tI%!#A\u0002\u0005-\u0003bB\b\u0002\n\u0002\u0007\u0011\u0011\u0010\u0005\b\u00037\u0003A\u0011BAO\u00031)h.Z:dCB,\u0017I]4t)!\ty*!3\u0002`\u0006E\bcB\u0010\u0002\"\u0006\u0015\u00161V\u0005\u0004\u0003G\u0003#A\u0002+va2,'\u0007\u0005\u0003 \u0003O{\u0016bAAUA\t)\u0011I\u001d:bsB)q$a*\u0002.B\"\u0011qVA]!\u0015\u0011\u0015\u0011WA[\u0013\r\t\u0019l\u0011\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003o\u000bI\f\u0004\u0001\u0005\u0017\u0005m\u0016Q\u0018C\u0001\u0002\u000b\u0005\u0011\u0011\u0019\u0002\u0004?\u0012\u0012\u0004bBA`\u00033\u0003\u00111V\u0001\u0014k:,7oY1qK\u0012\f%oZ\"mCN\u001cXm]\t\u0005\u0003\u0007\f\t\u0005E\u0002 \u0003\u000bL1!a2!\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001\"a3\u0002\u001a\u0002\u0007\u0011QZ\u0001\u0005CJ<7\u000fE\u0003\u0002P\u0006ewL\u0004\u0003\u0002R\u0006Ug\u0002BA-\u0003'L\u0011!I\u0005\u0004\u0003/\u0004\u0013a\u00029bG.\fw-Z\u0005\u0005\u00037\fiN\u0001\u0003MSN$(bAAlA!A\u0011\u0011]AM\u0001\u0004\t\u0019/\u0001\u0006be\u001e\u001cE.Y:tKN\u0004b!a4\u0002Z\u0006\u0015\b\u0007BAt\u0003[\u0004R\u0001KAu\u0003WL1!a-.!\u0011\t9,!<\u0005\u0017\u0005=\u0018\u0011\u0014C\u0001\u0002\u000b\u0005\u0011\u0011\u0019\u0002\u0004?\u0012\n\u0004\u0002CAz\u00033\u0003\r!!>\u0002\u000fQLW.Z8viB\u0019q$a>\n\u0007\u0005e\bE\u0001\u0003M_:<\u0007bBA\u007f\u0001\u0011%\u0011q`\u0001\u0013GJ,\u0017\r^3BGRLg/Z(cU\u0016\u001cG\u000fF\u0003`\u0005\u0003\u0011\u0019\u0001\u0003\u0004&\u0003w\u0004\ra\n\u0005\t\u0003g\fY\u00101\u0001\u0002v\"9!q\u0001\u0001\u0005\n\t%\u0011aC2sK\u0006$X-Q2u_J$ra\u0015B\u0006\u0005\u001b\u0011\t\u0002\u0003\u0004&\u0005\u000b\u0001\ra\n\u0005\b\u0005\u001f\u0011)\u00011\u0001(\u0003\u0011)X/\u001b3\t\u0011\u0005M(Q\u0001a\u0001\u0003kD3\u0001\u0001B\u000b!\u0011\u00119B!\b\u000f\u00075\u0011I\"C\u0002\u0003\u001c9\tab\u00115b]:,G\u000eS1oI2,'/\u0003\u0003\u0003 \t\u0005\"\u0001C*iCJ\f'\r\\3\u000b\u0007\tma\u0002")
public class RemoteServerHandler
extends SimpleChannelUpstreamHandler
implements Logging,
ScalaObject {
    private final String name;
    private final ChannelGroup openChannels;
    private final Option<ClassLoader> applicationLoader;
    private final Map<String, ActorRef> actors;
    private final Map<String, Object> activeObjects;
    private final String AW_PROXY_PREFIX;
    private final transient Logger log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        RemoteServerHandler remoteServerHandler = this;
        synchronized (remoteServerHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    public String name() {
        return this.name;
    }

    public ChannelGroup openChannels() {
        return this.openChannels;
    }

    public Option<ClassLoader> applicationLoader() {
        return this.applicationLoader;
    }

    public Map<String, ActorRef> actors() {
        return this.actors;
    }

    public Map<String, Object> activeObjects() {
        return this.activeObjects;
    }

    public String AW_PROXY_PREFIX() {
        return this.AW_PROXY_PREFIX;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) {
        this.openChannels().add(ctx.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) {
        if (event instanceof ChannelStateEvent) {
            ChannelState channelState = ((ChannelStateEvent)event).getState();
            ChannelState channelState2 = ChannelState.INTEREST_OPS;
            if (channelState == null ? channelState2 != null : !channelState.equals(channelState2)) {
                this.log().debug(event.toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object message = event.getMessage();
        if (message == null) {
            throw new IllegalStateException(new StringBuilder().append((Object)"Message in remote MessageEvent is null: ").append((Object)event).toString());
        }
        if (message instanceof RemoteProtocol.RemoteRequestProtocol) {
            this.handleRemoteRequestProtocol((RemoteProtocol.RemoteRequestProtocol)((Object)message), event.getChannel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        event.getCause().printStackTrace();
        this.log().error(event.getCause(), "Unexpected exception from remote downstream", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        event.getChannel().close();
    }

    private Object handleRemoteRequestProtocol(RemoteProtocol.RemoteRequestProtocol request, Channel channel) {
        this.log().debug("Received RemoteRequestProtocol[\n%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.toString()}));
        return request.getIsActor() ? this.dispatchToActor(request, channel) : this.dispatchToActiveObject(request, channel);
    }

    private Object dispatchToActor(RemoteProtocol.RemoteRequestProtocol request, Channel channel) {
        BoxedUnit boxedUnit;
        None$ sender2;
        this.log().debug("Dispatching to remote actor [%s:%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getTarget(), request.getUuid()}));
        ActorRef actorRef = this.createActor(request.getTarget(), request.getUuid(), request.getTimeout());
        actorRef.start();
        Object message = RemoteProtocolBuilder$.MODULE$.getMessage(request);
        Object object = sender2 = request.hasSender() ? new Some((Object)ActorRef$.MODULE$.fromProtobuf(request.getSender(), this.applicationLoader())) : None$.MODULE$;
        if (request.getIsOneWay()) {
            actorRef.$bang(message, (Option<ActorRef>)sender2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelFuture exceptionResult1 = null;
            try {
                Option resultOrNone = actorRef.$bang$bang(message, actorRef.$bang$bang$default$2(), (Option<ActorRef>)sender2);
                Object result = resultOrNone.isDefined() ? resultOrNone.get() : null;
                this.log().debug("Returning result from actor invocation [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result}));
                RemoteProtocol.RemoteReplyProtocol.Builder replyBuilder = RemoteProtocol.RemoteReplyProtocol.newBuilder().setId(request.getId()).setIsSuccessful(true).setIsActor(true);
                RemoteProtocolBuilder$.MODULE$.setMessage(result, replyBuilder);
                Object object2 = request.hasSupervisorUuid() ? replyBuilder.setSupervisorUuid(request.getSupervisorUuid()) : BoxedUnit.UNIT;
                RemoteProtocol.RemoteReplyProtocol replyMessage = replyBuilder.build();
                exceptionResult1 = channel.write((Object)replyMessage);
            }
            catch (Throwable throwable) {
                this.log().error(throwable, "Could not invoke remote actor [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getTarget()}));
                RemoteProtocol.RemoteReplyProtocol.Builder replyBuilder = RemoteProtocol.RemoteReplyProtocol.newBuilder().setId(request.getId()).setException(new StringBuilder().append((Object)throwable.getClass().getName()).append((Object)"$").append((Object)throwable.getMessage()).toString()).setIsSuccessful(false).setIsActor(true);
                Object object3 = request.hasSupervisorUuid() ? replyBuilder.setSupervisorUuid(request.getSupervisorUuid()) : BoxedUnit.UNIT;
                RemoteProtocol.RemoteReplyProtocol replyMessage = replyBuilder.build();
                exceptionResult1 = channel.write((Object)replyMessage);
            }
            boxedUnit = exceptionResult1;
        }
        return boxedUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object dispatchToActiveObject(RemoteProtocol.RemoteRequestProtocol request, Channel channel) {
        this.log().debug("Dispatching to remote active object [%s :: %s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getMethod(), request.getTarget()}));
        Object activeObject = this.se$scalablesolutions$akka$remote$RemoteServerHandler$$createActiveObject(request.getTarget(), request.getTimeout());
        List args = Predef$.MODULE$.refArrayOps((Object[])RemoteProtocolBuilder$.MODULE$.getMessage(request)).toList();
        List argClasses = (List)args.map((Function1)new $anonfun$5(this), List$.MODULE$.canBuildFrom());
        Tuple2<Object[], Class<?>[]> tuple2 = this.unescapeArgs((List<Object>)args, argClasses, request.getTimeout());
        if (tuple2 == null) throw new MatchError(tuple2);
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        Object[] unescapedArgs = (Object[])tuple22._1();
        Class[] unescapedArgClasses = (Class[])tuple22._2();
        Object exceptionResult2 = null;
        try {
            Object object;
            Method messageReceiver = activeObject.getClass().getDeclaredMethod(request.getMethod(), unescapedArgClasses);
            if (request.getIsOneWay()) {
                object = messageReceiver.invoke(activeObject, unescapedArgs);
                return object;
            } else {
                Object result = messageReceiver.invoke(activeObject, unescapedArgs);
                this.log().debug("Returning result from remote active object invocation [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result}));
                RemoteProtocol.RemoteReplyProtocol.Builder replyBuilder = RemoteProtocol.RemoteReplyProtocol.newBuilder().setId(request.getId()).setIsSuccessful(true).setIsActor(false);
                RemoteProtocolBuilder$.MODULE$.setMessage(result, replyBuilder);
                Object object2 = request.hasSupervisorUuid() ? replyBuilder.setSupervisorUuid(request.getSupervisorUuid()) : BoxedUnit.UNIT;
                RemoteProtocol.RemoteReplyProtocol replyMessage = replyBuilder.build();
                object = channel.write((Object)replyMessage);
            }
            return object;
        }
        catch (Throwable throwable) {
            this.log().error(throwable.getCause(), "Could not invoke remote active object [%s :: %s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getMethod(), request.getTarget()}));
            RemoteProtocol.RemoteReplyProtocol.Builder replyBuilder = RemoteProtocol.RemoteReplyProtocol.newBuilder().setId(request.getId()).setException(new StringBuilder().append((Object)throwable.getClass().getName()).append((Object)"$").append((Object)throwable.getMessage()).toString()).setIsSuccessful(false).setIsActor(false);
            Object object = request.hasSupervisorUuid() ? replyBuilder.setSupervisorUuid(request.getSupervisorUuid()) : BoxedUnit.UNIT;
            RemoteProtocol.RemoteReplyProtocol replyMessage = replyBuilder.build();
            return channel.write((Object)replyMessage);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.log().error(invocationTargetException.getCause(), "Could not invoke remote active object [%s :: %s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.getMethod(), request.getTarget()}));
            RemoteProtocol.RemoteReplyProtocol.Builder replyBuilder = RemoteProtocol.RemoteReplyProtocol.newBuilder().setId(request.getId()).setException(new StringBuilder().append((Object)invocationTargetException.getCause().getClass().getName()).append((Object)"$").append((Object)invocationTargetException.getCause().getMessage()).toString()).setIsSuccessful(false).setIsActor(false);
            Object object = request.hasSupervisorUuid() ? replyBuilder.setSupervisorUuid(request.getSupervisorUuid()) : BoxedUnit.UNIT;
            RemoteProtocol.RemoteReplyProtocol replyMessage = replyBuilder.build();
            return channel.write((Object)replyMessage);
        }
    }

    private Tuple2<Object[], Class<?>[]> unescapeArgs(List<Object> args$1, List<Class<?>> argClasses$1, long timeout$1) {
        Object[] unescapedArgs$1 = new Object[args$1.size()];
        Class[] unescapedArgClasses$1 = new Class[args$1.size()];
        Predef$.MODULE$.intWrapper(0).until(args$1.size()).foreach$mVc$sp((Function1)new $anonfun$1(this, args$1, argClasses$1, timeout$1, unescapedArgs$1, unescapedArgClasses$1));
        BoxedUnit escapedArgs = BoxedUnit.UNIT;
        return new Tuple2((Object)unescapedArgs$1, (Object)unescapedArgClasses$1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object se$scalablesolutions$akka$remote$RemoteServerHandler$$createActiveObject(String name2, long timeout) {
        Object object;
        Object activeObjectOrNull = this.activeObjects().get(name2);
        if (activeObjectOrNull != null) {
            object = activeObjectOrNull;
            return object;
        }
        Object exceptionResult3 = null;
        try {
            this.log().info("Creating a new remote active object [%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}));
            Class<?> clazz = this.applicationLoader().isDefined() ? ((ClassLoader)this.applicationLoader().get()).loadClass(name2) : Class.forName(name2);
            Object newInstance2 = ActiveObject$.MODULE$.newInstance(clazz, timeout);
            this.activeObjects().put(name2, newInstance2);
            exceptionResult3 = newInstance2;
            object = exceptionResult3;
            return object;
        }
        catch (Throwable throwable) {
            this.log().error(throwable, "Could not create remote active object instance", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActorRef createActor(String name2, String uuid, long timeout) {
        ActorRef actorRef;
        ActorRef actorRefOrNull = this.actors().get(uuid);
        if (actorRefOrNull != null) {
            actorRef = actorRefOrNull;
            return actorRef;
        }
        ActorRef exceptionResult4 = null;
        try {
            this.log().info("Creating a new remote actor [%s:%s]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2, uuid}));
            Class<?> clazz$1 = this.applicationLoader().isDefined() ? ((ClassLoader)this.applicationLoader().get()).loadClass(name2) : Class.forName(name2);
            ActorRef actorRef2 = Actor$.MODULE$.actorOf((Function0<Actor>)new $anonfun$6(this, clazz$1));
            actorRef2.uuid_$eq(uuid);
            actorRef2.timeout_$eq(timeout);
            actorRef2.remoteAddress_$eq((Option<InetSocketAddress>)None$.MODULE$);
            this.actors().put(uuid, actorRef2);
            actorRef = exceptionResult4 = actorRef2;
            return actorRef;
        }
        catch (Throwable throwable) {
            this.log().error(throwable, "Could not create remote actor instance", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            throw throwable;
        }
    }

    public RemoteServerHandler(String name2, ChannelGroup openChannels, Option<ClassLoader> applicationLoader, Map<String, ActorRef> actors, Map<String, Object> activeObjects) {
        this.name = name2;
        this.openChannels = openChannels;
        this.applicationLoader = applicationLoader;
        this.actors = actors;
        this.activeObjects = activeObjects;
        Logging$class.$init$(this);
        this.AW_PROXY_PREFIX = "$$ProxiedByAW".intern();
        applicationLoader.foreach((Function1)new $anonfun$4(this));
    }
}

