/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class RelaxedPrimitiveClock
implements PrimitiveClock {
    private final AtomicLong clock = new AtomicLong(0L);

    @Override
    public long tick() {
        long oldTime = this.clock.get();
        this.clock.compareAndSet(oldTime, oldTime + 1L);
        return this.clock.get();
    }

    @Override
    public long strictTick() {
        return this.clock.incrementAndGet();
    }

    @Override
    public long getVersion() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("RelaxedPrimitiveClock(time=%s)", this.clock.get());
    }
}

