/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.commitlock;

import java.util.Collection;
import org.multiverse.api.Transaction;
import org.multiverse.api.commitlock.CommitLock;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.api.commitlock.CommitLockPolicy;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class GenericCommitLockPolicy
implements CommitLockPolicy {
    public static final CommitLockPolicy FAIL_FAST = new GenericCommitLockPolicy(0, 0);
    public static final CommitLockPolicy FAIL_FAST_BUT_RETRY = new GenericCommitLockPolicy(0, 10);
    public static final CommitLockPolicy SPIN_AND_RETRY = new GenericCommitLockPolicy(10, 10);
    private final int spinAttemptsPerLockCount;
    private final int retryCount;

    public GenericCommitLockPolicy(int spinAttemptsPerLockCount, int retryCount) {
        if (spinAttemptsPerLockCount < 0) {
            throw new IllegalArgumentException();
        }
        if (retryCount < 0) {
            throw new IllegalArgumentException();
        }
        this.spinAttemptsPerLockCount = spinAttemptsPerLockCount;
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getSpinAttemptsPerLockCount() {
        return this.spinAttemptsPerLockCount;
    }

    @Override
    public boolean tryAcquire(CommitLock lock, CommitLockFilter filter, Transaction lockOwner) {
        if (lockOwner == null) {
            throw new NullPointerException();
        }
        for (int k = 0; k < this.retryCount; ++k) {
            if (GenericCommitLockPolicy.singleLock(lock, filter, lockOwner, this.spinAttemptsPerLockCount) < 0) continue;
            return true;
        }
        return false;
    }

    private static int singleLock(CommitLock lock, CommitLockFilter filter, Transaction lockOwner, int availableAttempts) {
        if (lock == null) {
            return availableAttempts;
        }
        if (!filter.needsLocking(lock)) {
            return availableAttempts;
        }
        for (int k = 0; k <= availableAttempts; ++k) {
            if (!lock.___tryLock(lockOwner)) continue;
            return availableAttempts - k;
        }
        return -1;
    }

    @Override
    public boolean tryAcquireAll(CommitLock[] locks, CommitLockFilter filter, Transaction lockOwner) {
        if (lockOwner == null) {
            throw new NullPointerException();
        }
        int maxAttempts = 1 + this.retryCount;
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            if (!this.attempt(locks, filter, lockOwner)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquireAll(Collection<CommitLock> locks, CommitLockFilter filter, Transaction lockOwner) {
        if (lockOwner == null) {
            throw new NullPointerException();
        }
        int maxAttempts = 1 + this.retryCount;
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            if (!this.attempt(locks, filter, lockOwner)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attempt(CommitLock[] locks, CommitLockFilter commitLockFilter, Transaction lockOwner) {
        int money = 0;
        boolean locksNeedToBeReleased = true;
        int lockIndex = 0;
        try {
            for (lockIndex = 0; lockIndex < locks.length; ++lockIndex) {
                boolean lockAcquired;
                CommitLock lock = locks[lockIndex];
                if (lock == null) {
                    locksNeedToBeReleased = false;
                    boolean bl = true;
                    return bl;
                }
                if (!commitLockFilter.needsLocking(lock)) continue;
                do {
                    if (lock.___tryLock(lockOwner)) {
                        lockAcquired = true;
                        continue;
                    }
                    lockAcquired = false;
                    if (--money >= 0) continue;
                    --lockIndex;
                    boolean bl = false;
                    return bl;
                } while (!lockAcquired);
                money += this.spinAttemptsPerLockCount;
            }
            locksNeedToBeReleased = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (locksNeedToBeReleased) {
                GenericCommitLockPolicy.releaseLocks(locks, lockOwner, lockIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attempt(Collection<CommitLock> locks, CommitLockFilter commitLockFilter, Transaction lockOwner) {
        int money = 0;
        boolean locksNeedToBeReleased = true;
        try {
            for (CommitLock lock : locks) {
                boolean lockAcquired;
                if (!commitLockFilter.needsLocking(lock)) continue;
                do {
                    if (lock.___tryLock(lockOwner)) {
                        lockAcquired = true;
                        continue;
                    }
                    lockAcquired = false;
                    if (--money >= 0) continue;
                    boolean bl = false;
                    return bl;
                } while (!lockAcquired);
                money += this.spinAttemptsPerLockCount;
            }
            locksNeedToBeReleased = false;
            boolean bl = true;
            return bl;
        }
        finally {
            if (locksNeedToBeReleased) {
                GenericCommitLockPolicy.releaseLocks(locks, lockOwner);
            }
        }
    }

    private static void releaseLocks(CommitLock[] locks, Transaction owner, int lastIndexOfLockToRelease) {
        for (int k = 0; k <= lastIndexOfLockToRelease; ++k) {
            CommitLock lock = locks[k];
            lock.___releaseLock(owner);
        }
    }

    private static void releaseLocks(Collection<CommitLock> locks, Transaction owner) {
        for (CommitLock lock : locks) {
            lock.___releaseLock(owner);
        }
    }

    public String toString() {
        return String.format("GenericCommitLockPolicy(retryCount=%s, spinAttemptsPerLockCount=%s)", this.retryCount, this.spinAttemptsPerLockCount);
    }
}

