/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.utils.StandardThreadFactory;
import org.multiverse.utils.TodoException;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public abstract class CommitBarrier {
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(5, new StandardThreadFactory(5, true));
    private volatile ScheduledExecutorService executorService = EXECUTOR;
    protected final Lock lock;
    protected final Condition statusCondition;
    private volatile Status status;
    private volatile int numberWaiting = 0;
    private List<Runnable> onAbortTasks;
    private List<Runnable> onCommitTasks;

    public CommitBarrier(Status status, boolean fair) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.status = status;
        this.lock = new ReentrantLock(fair);
        this.statusCondition = this.lock.newCondition();
    }

    protected final Status getStatus() {
        return this.status;
    }

    public final int getNumberWaiting() {
        return this.numberWaiting;
    }

    public final boolean isClosed() {
        return this.status == Status.closed;
    }

    public final boolean isCommitted() {
        return this.status == Status.committed;
    }

    public final boolean isAborted() {
        return this.status == Status.aborted;
    }

    protected final List<Runnable> signalCommit() {
        this.numberWaiting = 0;
        this.status = Status.committed;
        this.statusCondition.signalAll();
        this.onAbortTasks = null;
        List<Runnable> result = this.onCommitTasks;
        this.onCommitTasks = null;
        return result;
    }

    protected final List<Runnable> signalAborted() {
        this.numberWaiting = 0;
        this.status = Status.aborted;
        this.statusCondition.signalAll();
        this.onCommitTasks = null;
        List<Runnable> result = this.onAbortTasks;
        this.onAbortTasks = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void abort() {
        postAbortTasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.status.ordinal()]) {
                case 1: {
                    postAbortTasks = this.signalAborted();
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    commitMsg = "Can't abort already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        CommitBarrier.executeTasks(postAbortTasks);
    }

    protected static void executeTasks(List<Runnable> tasks) {
        if (tasks == null) {
            return;
        }
        for (Runnable task : tasks) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitOpen() throws InterruptedException {
        if (this.status != Status.closed) {
            return;
        }
        this.lock.lockInterruptibly();
        try {
            while (this.status == Status.closed) {
                this.statusCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitOpenUninterruptibly() {
        if (this.status == Status.closed) {
            this.lock.lock();
            try {
                while (this.status == Status.closed) {
                    this.statusCondition.awaitUninterruptibly();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAwaitOpen(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.status == Status.closed) {
            long timeoutNs = unit.toNanos(timeout);
            this.lock.lockInterruptibly();
            try {
                while (this.status == Status.closed) {
                    if ((timeoutNs = this.statusCondition.awaitNanos(timeoutNs)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAwaitOpenUninterruptibly(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.status == Status.closed) {
            long timeoutNs = unit.toNanos(timeout);
            this.lock.lock();
            try {
                while (this.status == Status.closed) {
                    if ((timeoutNs = this.awaitNanosUninterruptible(timeoutNs)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    private long awaitNanosUninterruptible(long timeoutNs) {
        boolean restoreInterrupt = Thread.interrupted();
        while (true) {
            long startNs = System.nanoTime();
            try {
                long l = this.statusCondition.awaitNanos(timeoutNs);
                return l;
            }
            catch (InterruptedException ex) {
                timeoutNs -= System.nanoTime() - startNs;
                restoreInterrupt = true;
            }
        }
        finally {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setTimeout(long timeout, TimeUnit unit) {
        this.lock.lock();
        try {
            switch (this.status) {
                case closed: {
                    Runnable command = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommitBarrier.this.abort();
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                        }
                    };
                    this.executorService.schedule(command, timeout, unit);
                    return;
                }
                case committed: {
                    String commitMsg = "Can't set a timeout on an already commit CommitBarrier.";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case aborted: {
                    String abortMsg = "Can't set a timeout on an already aborted CommitBarrier.";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void registerOnAbortTask(Runnable task) {
        this.lock.lock();
        try {
            switch (this.status) {
                case closed: {
                    if (task == null) {
                        throw new NullPointerException();
                    }
                    if (this.onAbortTasks == null) {
                        this.onAbortTasks = new LinkedList<Runnable>();
                    }
                    this.onAbortTasks.add(task);
                    return;
                }
                case committed: {
                    String commitMsg = "Can't register on abort task on already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case aborted: {
                    String abortMsg = "Can't register on abort task on already aborted CommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void registerOnCommitTask(Runnable task) {
        this.lock.lock();
        try {
            switch (this.status) {
                case closed: {
                    if (task == null) {
                        throw new NullPointerException();
                    }
                    if (this.onCommitTasks == null) {
                        this.onCommitTasks = new LinkedList<Runnable>();
                    }
                    this.onCommitTasks.add(task);
                    return;
                }
                case committed: {
                    String commitMsg = "Can't register on commit task on already committed CommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case aborted: {
                    String abortMsg = "Can't register on commit task on already aborted CommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void addJoiner() {
        if (this.status != Status.closed) {
            throw new IllegalStateException();
        }
        ++this.numberWaiting;
    }

    protected final void finish(Transaction tx) {
        if (tx == null) {
            return;
        }
        if (this.isCommitted()) {
            tx.commit();
        } else if (this.isAborted()) {
            tx.abort();
            throw new IllegalStateException();
        }
    }

    protected final void ensureNotDead(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        TransactionStatus status = tx.getStatus();
        if (status.isDead()) {
            throw new DeadTransactionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void joinCommit(Transaction tx) throws InterruptedException {
        this.ensureNotDead(tx);
        tasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.getStatus().ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        tasks = this.signalCommit();
                        ** break;
lbl12:
                        // 1 sources

                    } else {
                        while (this.getStatus() == Status.closed) {
                            try {
                                this.statusCondition.await();
                            }
                            catch (InterruptedException ex) {
                                this.signalAborted();
                                tx.abort();
                                throw ex;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    committedMsg = String.format("Can't await commit on already committed VetoCommitBarrier with transaction %s", new Object[]{tx.getConfiguration().getFamilyName()});
                    throw new CommitBarrierOpenException(committedMsg);
                }
                case 2: {
                    abortMsg = String.format("Can't await commit on already aborted VetoCommitBarrier with transaction %s", new Object[]{tx.getConfiguration().getFamilyName()});
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        CommitBarrier.executeTasks(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void joinCommitUninterruptibly(Transaction tx) {
        this.ensureNotDead(tx);
        postCommitTasks = null;
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.getStatus().ordinal()]) {
                case 1: {
                    tx.prepare();
                    this.addJoiner();
                    if (this.isLastParty()) {
                        postCommitTasks = this.signalCommit();
                        ** break;
lbl12:
                        // 1 sources

                    } else {
                        while (this.getStatus() == Status.closed) {
                            this.statusCondition.awaitUninterruptibly();
                        }
                    }
                    break;
                }
                case 2: {
                    tx.abort();
                    abortedMsg = String.format("Can't call joinCommitUninterruptible on already aborted CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfiguration().getFamilyName()});
                    throw new CommitBarrierOpenException(abortedMsg);
                }
                case 3: {
                    tx.abort();
                    commitMsg = String.format("Can't call joinCommitUninterruptible on already committed CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfiguration().getFamilyName()});
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        CommitBarrier.executeTasks(postCommitTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean tryJoinCommit(Transaction tx) {
        this.ensureNotDead(tx);
        postCommitTasks = null;
        abort = true;
        this.lock.lock();
        try {
            try {
                switch (2.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.getStatus().ordinal()]) {
                    case 1: {
                        tx.prepare();
                        this.addJoiner();
                        if (this.isLastParty()) {
                            postCommitTasks = this.signalCommit();
                            abort = false;
                            ** break;
lbl15:
                            // 1 sources

                        } else {
                            postCommitTasks = this.signalAborted();
                            ** break;
                        }
lbl18:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        abortMsg = String.format("Can't call tryJoinCommit on already aborted CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfiguration().getFamilyName()});
                        throw new CommitBarrierOpenException(abortMsg);
                    }
                    case 3: {
                        commitMsg = String.format("Can't call tryJoinCommit on already committed CountDownCommitBarrier with transaction %s ", new Object[]{tx.getConfiguration().getFamilyName()});
                        throw new CommitBarrierOpenException(commitMsg);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        finally {
            if (abort) {
                tx.abort();
            } else {
                tx.commit();
            }
        }
        CommitBarrier.executeTasks(postCommitTasks);
        return this.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryJoinCommit(Transaction tx, long timeout, TimeUnit unit) throws InterruptedException {
        this.ensureNotDead(tx);
        long timeoutNs = unit.toNanos(timeout);
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case closed: {
                    tx.prepare();
                    this.addJoiner();
                    while (this.getStatus() == Status.closed) {
                        try {
                            timeoutNs = this.statusCondition.awaitNanos(timeoutNs);
                            if (timeoutNs > 0L) continue;
                            this.signalAborted();
                            tx.abort();
                            boolean bl = false;
                            return bl;
                        }
                        catch (InterruptedException ex) {
                            this.signalAborted();
                            tx.abort();
                            throw ex;
                        }
                    }
                    break;
                }
                case committed: {
                    String commitMsg = "Can't await commit on an already committed VetoCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case aborted: {
                    String abortMsg = "Can't await commit on an already aborted VetoCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new NullPointerException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryJoinCommitUninterruptibly(Transaction tx, long timeout, TimeUnit unit) {
        this.ensureNotDead(tx);
        long timeoutNs = unit.toNanos(timeout);
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case closed: {
                    tx.prepare();
                    this.addJoiner();
                    while (this.getStatus() == Status.closed) {
                        try {
                            timeoutNs = this.statusCondition.awaitNanos(timeoutNs);
                            if (timeoutNs > 0L) continue;
                            this.signalAborted();
                            tx.abort();
                            boolean bl = false;
                            return bl;
                        }
                        catch (InterruptedException ex) {
                            this.signalAborted();
                            tx.abort();
                            throw new RuntimeException(ex);
                        }
                    }
                    break;
                }
                case committed: {
                    String commitMsg = "Can't await commit on an already committed VetoCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                case aborted: {
                    String abortMsg = "Can't await commit on an already aborted VetoCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                default: {
                    throw new NullPointerException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.finish(tx);
        throw new TodoException();
    }

    protected abstract boolean isLastParty();

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
    static enum Status {
        closed,
        committed,
        aborted;

    }
}

