/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.multiverse.instrumentation.DebugInfo;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.CloneMap;
import org.multiverse.repackaged.org.objectweb.asm.ClassReader;
import org.multiverse.repackaged.org.objectweb.asm.ClassWriter;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.repackaged.org.objectweb.asm.commons.Remapper;
import org.multiverse.repackaged.org.objectweb.asm.commons.RemappingMethodAdapter;
import org.multiverse.repackaged.org.objectweb.asm.tree.AbstractInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.AnnotationNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.InsnList;
import org.multiverse.repackaged.org.objectweb.asm.tree.LineNumberNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.LocalVariableNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MemberNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.TryCatchBlockNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.TypeInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.util.TraceMethodVisitor;
import org.multiverse.utils.IOUtils;
import org.multiverse.utils.SystemOut;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class AsmUtils
implements Opcodes {
    public static MethodNode cloneMethodWithoutInstructions(MethodNode originalMethod, CloneMap cloneMap) {
        if (originalMethod == null || cloneMap == null) {
            throw new NullPointerException();
        }
        MethodNode result = new MethodNode();
        result.name = originalMethod.name;
        result.access = originalMethod.access;
        result.desc = originalMethod.desc;
        result.signature = originalMethod.signature;
        result.exceptions = originalMethod.exceptions;
        result.annotationDefault = originalMethod.annotationDefault;
        result.invisibleParameterAnnotations = originalMethod.invisibleParameterAnnotations;
        result.visibleParameterAnnotations = originalMethod.visibleParameterAnnotations;
        result.localVariables = AsmUtils.cloneLocalVariableTable(originalMethod, cloneMap);
        result.tryCatchBlocks = AsmUtils.cloneTryCatchBlocks(originalMethod, cloneMap);
        return result;
    }

    public static List<LocalVariableNode> cloneLocalVariableTable(MethodNode originalMethod, CloneMap cloneMap) {
        if (originalMethod.localVariables == null) {
            return null;
        }
        LinkedList<LocalVariableNode> localVariableTable = new LinkedList<LocalVariableNode>();
        for (LocalVariableNode localVariableNode : originalMethod.localVariables) {
            LocalVariableNode cloned = new LocalVariableNode(localVariableNode.name, localVariableNode.desc, localVariableNode.signature, cloneMap.get(localVariableNode.start), cloneMap.get(localVariableNode.end), localVariableNode.index);
            localVariableTable.add(cloned);
        }
        return localVariableTable;
    }

    public static List<TryCatchBlockNode> cloneTryCatchBlocks(MethodNode originalMethod, CloneMap cloneMap) {
        if (originalMethod.tryCatchBlocks == null) {
            return null;
        }
        LinkedList<TryCatchBlockNode> tryCatchBlocks = new LinkedList<TryCatchBlockNode>();
        for (TryCatchBlockNode tryCatchBlockNode : originalMethod.tryCatchBlocks) {
            TryCatchBlockNode cloned = new TryCatchBlockNode(cloneMap.get(tryCatchBlockNode.start), cloneMap.get(tryCatchBlockNode.end), cloneMap.get(tryCatchBlockNode.handler), tryCatchBlockNode.type);
            tryCatchBlocks.add(cloned);
        }
        return tryCatchBlocks;
    }

    public static void printClassOfTopItem(InsnList instructions) {
        instructions.add(new MethodInsnNode(182, Type.getInternalName(Object.class), "getClass", "()Ljava/lang/Class;"));
        instructions.add(new MethodInsnNode(184, Type.getInternalName(AsmUtils.class), "printClazz", "(Ljava/lang/Class;)V"));
    }

    public static void printClass(Class clazz) {
        SystemOut.println("  class on top: " + clazz.getName(), new Object[0]);
    }

    public static DebugInfo findDebugInfo(MethodNode method) {
        DebugInfo info = new DebugInfo();
        ListIterator iterator = method.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!(node instanceof LineNumberNode)) continue;
            LineNumberNode lineNumberNode = (LineNumberNode)node;
            if (lineNumberNode.line > info.endLine) {
                info.endLine = lineNumberNode.line;
            }
            if (info.beginLine == -1) {
                info.beginLine = lineNumberNode.line;
                continue;
            }
            if (lineNumberNode.line >= info.beginLine) continue;
            info.beginLine = lineNumberNode.line;
        }
        return info;
    }

    public static int getInvokeOpcode(MethodNode methodNode) {
        if (AsmUtils.isStatic(methodNode.access)) {
            return 184;
        }
        if (methodNode.name.equals("<init>")) {
            return 183;
        }
        return 182;
    }

    public static List<TryCatchBlockNode> cloneTryCatchBlockNodes(List<TryCatchBlockNode> originalBlocks, CloneMap cloneMap) {
        LinkedList<TryCatchBlockNode> result = new LinkedList<TryCatchBlockNode>();
        for (TryCatchBlockNode originalBlock : originalBlocks) {
            TryCatchBlockNode clonedBlock = new TryCatchBlockNode(cloneMap.get(originalBlock.start), cloneMap.get(originalBlock.end), cloneMap.get(originalBlock.handler), originalBlock.type);
            result.add(clonedBlock);
        }
        return result;
    }

    public static List cloneVariableTable(MethodNode methodNode, CloneMap cloneMap) {
        LinkedList<LocalVariableNode> result = new LinkedList<LocalVariableNode>();
        for (LocalVariableNode originalLocalVar : methodNode.localVariables) {
            LocalVariableNode clonedLocalVar = new LocalVariableNode(originalLocalVar.name, originalLocalVar.desc, originalLocalVar.signature, cloneMap.get(originalLocalVar.start), cloneMap.get(originalLocalVar.end), originalLocalVar.index);
            result.add(clonedLocalVar);
        }
        return result;
    }

    public static int firstIndexAfterSuper(String methodName, InsnList instructions, String superClass) {
        if (!methodName.equals("<init>")) {
            throw new RuntimeException();
        }
        if (instructions == null) {
            return -1;
        }
        int depth = 0;
        for (int k = 0; k < instructions.size(); ++k) {
            AbstractInsnNode insn = instructions.get(k);
            if (insn.getOpcode() == 183) {
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (!methodInsn.name.equals("<init>") || !methodInsn.owner.endsWith(superClass)) continue;
                if (depth == 0) {
                    return k + 1;
                }
                --depth;
                continue;
            }
            if (insn.getOpcode() != 187) continue;
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            if (!typeInsn.desc.equals(superClass)) continue;
            ++depth;
        }
        return -1;
    }

    public static int firstIndexAfterSuper(MethodNode methodNode, String superClass) {
        return AsmUtils.firstIndexAfterSuper(methodNode.name, methodNode.instructions, superClass);
    }

    public static String toString(AbstractInsnNode insnNode) {
        TraceMethodVisitor asmifier = new TraceMethodVisitor();
        insnNode.accept(asmifier);
        StringBuffer sb = new StringBuffer();
        for (String line : asmifier.getText()) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static int sizeOfFormalParameters(String desc) {
        int size = 0;
        for (Type argType : Type.getArgumentTypes(desc)) {
            size += argType.getSize();
        }
        return size;
    }

    public static boolean isCategory2(String valueDesc) {
        return valueDesc.equals("J") || valueDesc.equals("D");
    }

    public static int upgradeToPublic(int access) {
        if (AsmUtils.isPublic(access)) {
            return access;
        }
        if (AsmUtils.isPrivate(access)) {
            access -= 2;
        } else if (AsmUtils.isProtected(access)) {
            access -= 4;
        }
        return access + 1;
    }

    public static int upgradeToProtected(int access) {
        if (AsmUtils.isProtected(access)) {
            return access;
        }
        if (AsmUtils.isPublic(access)) {
            return access;
        }
        if (AsmUtils.isPrivate(access)) {
            access -= 2;
        }
        return access + 4;
    }

    public static String createMethodDescriptorWithRightIntroducedVariable(String methodDesc, String extraArgType) {
        Type returnType = Type.getReturnType(methodDesc);
        Type[] argTypes = Type.getArgumentTypes(methodDesc);
        Type[] newArgTypes = new Type[argTypes.length + 1];
        System.arraycopy(argTypes, 0, newArgTypes, 0, argTypes.length);
        newArgTypes[argTypes.length] = Type.getObjectType(extraArgType);
        return Type.getMethodDescriptor(returnType, newArgTypes);
    }

    public static MethodNode remap(MethodNode originalMethod, Remapper remapper) {
        String[] exceptions = AsmUtils.getExceptions(originalMethod);
        MethodNode mappedMethod = new MethodNode(originalMethod.access, originalMethod.name, remapper.mapMethodDesc(originalMethod.desc), remapper.mapSignature(originalMethod.signature, false), remapper.mapTypes(exceptions));
        RemappingMethodAdapter remapVisitor = new RemappingMethodAdapter(mappedMethod.access, mappedMethod.desc, mappedMethod, remapper);
        originalMethod.accept(remapVisitor);
        return mappedMethod;
    }

    public static String[] getExceptions(MethodNode originalMethod) {
        if (originalMethod.exceptions == null) {
            return new String[0];
        }
        String[] exceptions = new String[originalMethod.exceptions.size()];
        originalMethod.exceptions.toArray(exceptions);
        return exceptions;
    }

    public static ClassNode loadAsClassNode(Class clazz) {
        return AsmUtils.loadAsClassNode(clazz.getClassLoader(), Type.getInternalName(clazz));
    }

    public static ClassNode loadAsClassNode(ClassLoader loader, String classInternalName) {
        if (loader == null || classInternalName == null) {
            throw new NullPointerException();
        }
        String fileName = classInternalName + ".class";
        InputStream is = loader.getResourceAsStream(fileName);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader reader = new ClassReader(is);
            reader.accept(classNode, 8);
            ClassNode classNode2 = classNode;
            return classNode2;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(String.format("Could not find file '%s' for class '%s': ", fileName, classInternalName));
        }
        catch (IOException e) {
            throw new RuntimeException("A problem ocurred while loading class: " + fileName, e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static ClassNode loadAsClassNode(File file) {
        ClassNode classNode;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ClassNode classNode2 = new ClassNode();
            ClassReader reader = new ClassReader(is);
            reader.accept(classNode2, 8);
            classNode = classNode2;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("A problem ocurred while loading class: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return classNode;
    }

    public static byte[] loadAsBytecode(File file) {
        byte[] byArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ClassNode classNode = new ClassNode();
            ClassReader reader = new ClassReader(is);
            reader.accept(classNode, 8);
            byArray = AsmUtils.toBytecode(classNode);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("A problem ocurred while loading class: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return byArray;
    }

    public static boolean hasVisibleAnnotation(MemberNode memberNode, Class annotationClass) {
        return AsmUtils.getVisibleAnnotation(memberNode, annotationClass) != null;
    }

    public static AnnotationNode getVisibleAnnotation(MemberNode memberNode, Class annotationClass) {
        if (memberNode == null || annotationClass == null) {
            throw new NullPointerException();
        }
        if (memberNode.visibleAnnotations == null) {
            return null;
        }
        String annotationClassDescriptor = Type.getDescriptor(annotationClass);
        for (AnnotationNode node : memberNode.visibleAnnotations) {
            if (!annotationClassDescriptor.equals(node.desc)) continue;
            return node;
        }
        return null;
    }

    public static Object getAnnotationValue(AnnotationNode annotationNode, String valueName) {
        List values = annotationNode.values;
        if (values == null) {
            return null;
        }
        for (int k = 0; k < values.size(); k += 2) {
            if (!values.get(k).equals(valueName)) continue;
            return values.get(k + 1);
        }
        return null;
    }

    public static String internalToDesc(String internalForm) {
        return String.format("L%s;", internalForm);
    }

    public static Field getField(Class clazz, String fieldName) {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAbstract(MethodNode methodNode) {
        return AsmUtils.isAbstract(methodNode.access);
    }

    public static boolean isInterface(ClassNode classNode) {
        return (classNode.access & 0x200) != 0;
    }

    public static boolean isNative(MethodNode methodNode) {
        return AsmUtils.isNative(methodNode.access);
    }

    public static boolean isFinal(FieldNode fieldNode) {
        return AsmUtils.isFinal(fieldNode.access);
    }

    public static boolean isStatic(FieldNode fieldNode) {
        return AsmUtils.isStatic(fieldNode.access);
    }

    public static boolean isStatic(MethodNode methodNode) {
        return AsmUtils.isStatic(methodNode.access);
    }

    public static boolean isPrivate(MethodNode methodNode) {
        return AsmUtils.isPrivate(methodNode.access);
    }

    public static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    public static boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    public static boolean isProtected(int access) {
        return (access & 4) != 0;
    }

    public static boolean isFinal(int access) {
        return (access & 0x10) != 0;
    }

    public static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    public static boolean isNative(int access) {
        return (access & 0x100) != 0;
    }

    public static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static boolean isAbstract(int access) {
        return (access & 0x400) != 0;
    }

    public static ClassNode loadAsClassNode(byte[] bytecode) {
        if (bytecode == null) {
            throw new NullPointerException();
        }
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(bytecode);
        cr.accept(classNode, 8);
        return classNode;
    }

    public static byte[] toBytecode(ClassNode classNode) {
        if (classNode == null) {
            throw new NullPointerException();
        }
        ClassWriter cw = new ClassWriter(2);
        classNode.accept(cw);
        return cw.toByteArray();
    }

    public static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] bytecode) {
        if (file == null || bytecode == null) {
            throw new NullPointerException();
        }
        try {
            AsmUtils.ensureExistingParent(file);
            FileOutputStream writer = new FileOutputStream(file);
            try {
                ((OutputStream)writer).write(bytecode);
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void ensureExistingParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent.isDirectory()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Failed to make parent directories for file " + file);
        }
    }

    private AsmUtils() {
    }
}

