/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MethodType;
import org.multiverse.instrumentation.metadata.TransactionMetadata;
import org.multiverse.repackaged.org.objectweb.asm.Type;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class MethodMetadata {
    private final ClassMetadata classMetadata;
    private TransactionMetadata transactionMetadata;
    private final String name;
    private final String desc;
    private int access;
    private final List<String> exceptions = new LinkedList<String>();
    private MethodType getterSetter = MethodType.unknown;
    private FieldMetadata getterSetterField;

    public MethodMetadata(ClassMetadata classMetadata, String name, String desc) {
        this.classMetadata = classMetadata;
        this.name = name;
        this.desc = desc;
    }

    public FieldMetadata getGetterSetterField() {
        return this.getterSetterField;
    }

    public MethodType getMethodType() {
        return this.getterSetter;
    }

    public void setGetterSetter(MethodType getterSetter, FieldMetadata getterSetterField) {
        this.getterSetterField = getterSetterField;
        this.getterSetter = getterSetter;
    }

    public TransactionMetadata getTransactionMetadata() {
        return this.transactionMetadata;
    }

    public void setTransactionMetadata(TransactionMetadata transactionMetadata) {
        this.transactionMetadata = transactionMetadata;
    }

    public void addException(String exception) {
        if (exception == null) {
            throw new NullPointerException();
        }
        if (!this.exceptions.contains(exception)) {
            this.exceptions.add(exception);
        }
    }

    public boolean checkIfSpecificTransactionIsThrown(Class exception) {
        String type = Type.getInternalName(exception);
        for (String e : this.exceptions) {
            if (!type.equals(e)) continue;
            return true;
        }
        return false;
    }

    public List<String> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public boolean isAbstract() {
        return AsmUtils.isAbstract(this.access);
    }

    public boolean isNative() {
        return AsmUtils.isNative(this.access);
    }

    public boolean isStatic() {
        return AsmUtils.isStatic(this.access);
    }

    public boolean isFinal() {
        return this.classMetadata.isFinal() || AsmUtils.isFinal(this.access);
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTransactional() {
        return this.transactionMetadata != null;
    }

    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    public TransactionMetadata getTransactionalMetadata() {
        return this.transactionMetadata;
    }

    public void setTransactionalMetadata(TransactionMetadata transactionMetadata) {
        this.transactionMetadata = transactionMetadata;
    }

    public String toFullName() {
        return this.classMetadata.getName() + "." + this.name + this.desc;
    }
}

