/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.multiverse.api.commitlock.CommitLock;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaTranlocal;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class UncommittedFilter
implements CommitLockFilter {
    public static final UncommittedFilter NO_DIRTY_CHECK = new UncommittedFilter(false);
    public static final UncommittedFilter DIRTY_CHECK = new UncommittedFilter(true);
    private final boolean dirtyCheck;

    public UncommittedFilter(boolean dirtyCheck) {
        this.dirtyCheck = dirtyCheck;
    }

    @Override
    public boolean needsLocking(CommitLock commitLock) {
        AlphaTranlocal tranlocal = (AlphaTranlocal)commitLock;
        if (tranlocal.isCommitted()) {
            return false;
        }
        if (tranlocal.isCommuting()) {
            return true;
        }
        if (tranlocal.getOrigin() == null) {
            return false;
        }
        if (this.dirtyCheck) {
            return tranlocal.getPrecalculatedIsDirty();
        }
        return true;
    }
}

