/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldgranularity;

import java.util.LinkedList;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.asm.CloneMap;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.repackaged.org.objectweb.asm.tree.AbstractInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.InsnList;
import org.multiverse.repackaged.org.objectweb.asm.tree.InsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.TypeInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.VarInsnNode;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class FieldGranularityTransformer
implements Opcodes {
    private final ClassNode classNode;
    private final ClassMetadata classMetadata;
    private final MetadataRepository metadataRepository;
    private final ClassLoader classLoader;

    public FieldGranularityTransformer(ClassLoader classLoader, ClassNode classNode, MetadataRepository metadataRepository) {
        if (classNode == null) {
            throw new RuntimeException();
        }
        this.metadataRepository = metadataRepository;
        this.classLoader = classLoader;
        this.classNode = classNode;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, classNode.name);
    }

    public ClassNode transform() {
        this.fixFields();
        this.fixFieldAccessInMethods();
        this.addInitializationLogicToConstructors();
        return this.classNode;
    }

    private void fixFields() {
        LinkedList<FieldNode> fields = new LinkedList<FieldNode>();
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (fieldMetadata.hasFieldGranularity()) {
                String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldNode.desc);
                FieldNode fixedFieldNode = new FieldNode(4113, fieldNode.name, referenceDesc, null, null);
                fields.add(fixedFieldNode);
                continue;
            }
            fields.add(fieldNode);
        }
        this.classNode.fields = fields;
    }

    private void fixFieldAccessInMethods() {
        LinkedList<MethodNode> methods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (methodMetadata.isTransactional()) {
                methodNode = this.fixMethod(methodNode);
            }
            methods.add(methodNode);
        }
        this.classNode.methods = methods;
    }

    private MethodNode fixMethod(MethodNode originalMethod) {
        CloneMap cloneMap = new CloneMap();
        MethodNode result = AsmUtils.cloneMethodWithoutInstructions(originalMethod, cloneMap);
        result.instructions = this.fixInstructions(originalMethod, cloneMap);
        return result;
    }

    private InsnList fixInstructions(MethodNode originalMethod, CloneMap cloneMap) {
        InsnList instructions = new InsnList();
        block4: for (int k = 0; k < originalMethod.instructions.size(); ++k) {
            AbstractInsnNode originalInsn = originalMethod.instructions.get(k);
            switch (originalInsn.getOpcode()) {
                case 181: {
                    FieldInsnNode fieldInsn = (FieldInsnNode)originalInsn;
                    ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, fieldInsn.owner);
                    FieldMetadata fieldMetadata = ownerMetadata.getFieldMetadata(fieldInsn.name);
                    Type originalFieldType = Type.getType(fieldMetadata.getDesc());
                    if (fieldMetadata.hasFieldGranularity()) {
                        boolean fieldIsCategory2 = AsmUtils.isCategory2(fieldMetadata.getDesc());
                        if (fieldIsCategory2) {
                            instructions.add(new InsnNode(93));
                            instructions.add(new InsnNode(88));
                        } else {
                            instructions.add(new InsnNode(95));
                        }
                        String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                        String referenceName = Type.getType(referenceDesc).getInternalName();
                        instructions.add(new FieldInsnNode(180, fieldInsn.owner, fieldInsn.name, referenceDesc));
                        if (fieldIsCategory2) {
                            instructions.add(new InsnNode(91));
                            instructions.add(new InsnNode(87));
                        } else {
                            instructions.add(new InsnNode(95));
                        }
                        if (originalFieldType.getSort() == 9 || originalFieldType.getSort() == 10) {
                            String objectDesc = Type.getDescriptor(Object.class);
                            MethodInsnNode methodInsn = new MethodInsnNode(182, referenceName, "set", String.format("(%s)%s", objectDesc, objectDesc));
                            instructions.add(methodInsn);
                        } else {
                            MethodInsnNode methodInsn = new MethodInsnNode(182, referenceName, "set", String.format("(%s)%s", fieldMetadata.getDesc(), fieldMetadata.getDesc()));
                            instructions.add(methodInsn);
                        }
                        if (fieldIsCategory2) {
                            instructions.add(new InsnNode(88));
                            continue block4;
                        }
                        instructions.add(new InsnNode(87));
                        continue block4;
                    }
                    instructions.add(originalInsn.clone(cloneMap));
                    continue block4;
                }
                case 180: {
                    FieldInsnNode fieldInsn = (FieldInsnNode)originalInsn;
                    FieldMetadata fieldMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, fieldInsn.owner).getFieldMetadata(fieldInsn.name);
                    if (!fieldMetadata.hasFieldGranularity()) {
                        instructions.add(originalInsn.clone(cloneMap));
                        continue block4;
                    }
                    String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                    String referenceName = Type.getType(referenceDesc).getInternalName();
                    instructions.add(new FieldInsnNode(180, fieldInsn.owner, fieldInsn.name, referenceDesc));
                    Type originalFieldType = Type.getType(fieldMetadata.getDesc());
                    if (originalFieldType.getSort() == 9 || originalFieldType.getSort() == 10) {
                        instructions.add(new MethodInsnNode(182, referenceName, "get", String.format("()%s", Type.getDescriptor(Object.class))));
                        if (originalFieldType.equals(Type.getType(Object.class))) continue block4;
                        instructions.add(new TypeInsnNode(192, originalFieldType.getInternalName()));
                        continue block4;
                    }
                    instructions.add(new MethodInsnNode(182, referenceName, "get", String.format("()%s", fieldMetadata.getDesc())));
                    continue block4;
                }
                default: {
                    instructions.add(originalInsn.clone(cloneMap));
                }
            }
        }
        return instructions;
    }

    private void addInitializationLogicToConstructors() {
        if (!this.classMetadata.hasManagedFieldsWithFieldGranularity()) {
            return;
        }
        for (MethodNode methodNode : this.classNode.methods) {
            int firstAfterSuper;
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (!methodMetadata.isTransactional() || !methodMetadata.isConstructor() || (firstAfterSuper = AsmUtils.firstIndexAfterSuper(methodNode, this.classNode.superName)) < 0) continue;
            InsnList extraInstructions = new InsnList();
            for (FieldNode fieldNode : this.classNode.fields) {
                FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
                if (fieldMetadata.hasFieldGranularity()) {
                    extraInstructions.add(new VarInsnNode(25, 0));
                    String referenceDesc = FieldGranularityTransformer.findReferenceDesc(fieldMetadata.getDesc());
                    String referenceName = Type.getType(referenceDesc).getInternalName();
                    extraInstructions.add(new TypeInsnNode(187, referenceName));
                    extraInstructions.add(new InsnNode(89));
                    extraInstructions.add(new MethodInsnNode(183, referenceName, "<init>", "()V"));
                    extraInstructions.add(new FieldInsnNode(181, this.classNode.name, fieldNode.name, referenceDesc));
                }
                AbstractInsnNode first = methodNode.instructions.get(firstAfterSuper);
                methodNode.instructions.insert(first, extraInstructions);
            }
        }
    }

    private static String findReferenceDesc(String desc) {
        Type type = Type.getType(desc);
        switch (type.getSort()) {
            case 9: {
                return "Lorg/multiverse/transactional/DefaultTransactionalReference;";
            }
            case 1: {
                return "Lorg/multiverse/transactional/primitives/TransactionalBoolean;";
            }
            case 3: {
                return "Lorg/multiverse/transactional/primitives/TransactionalByte;";
            }
            case 2: {
                return "Lorg/multiverse/transactional/primitives/TransactionalCharacter;";
            }
            case 8: {
                return "Lorg/multiverse/transactional/primitives/TransactionalDouble;";
            }
            case 6: {
                return "Lorg/multiverse/transactional/primitives/TransactionalFloat;";
            }
            case 5: {
                return "Lorg/multiverse/transactional/primitives/TransactionalInteger;";
            }
            case 7: {
                return "Lorg/multiverse/transactional/primitives/TransactionalLong;";
            }
            case 4: {
                return "Lorg/multiverse/transactional/primitives/TransactionalShort;";
            }
            case 10: {
                return "Lorg/multiverse/transactional/DefaultTransactionalReference;";
            }
        }
        throw new IllegalStateException("Unhandeled sort: " + type.getSort());
    }
}

