/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.tranlocal;

import java.util.LinkedList;
import java.util.List;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.repackaged.org.objectweb.asm.Label;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTranlocalSnapshot;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class TranlocalFactory
implements Opcodes {
    private final ClassNode clazz;
    private final ClassMetadata clazzMetadata;
    private final String tranlocalName;
    private final String tranlocalSnapshotName;
    private final MetadataRepository metadataRepository;
    private final ClassLoader classLoader;
    private final String alphaTranlocalName;
    private final String alphaTransactionalObjectDesc;
    private final String originDesc;

    public TranlocalFactory(ClassLoader classLoader, ClassNode clazz, MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
        this.clazz = clazz;
        this.classLoader = classLoader;
        this.clazzMetadata = metadataRepository.loadClassMetadata(classLoader, clazz.name);
        this.tranlocalName = this.clazzMetadata.getTranlocalName();
        this.tranlocalSnapshotName = this.clazzMetadata.getTranlocalSnapshotName();
        this.alphaTranlocalName = Type.getInternalName(AlphaTranlocal.class);
        this.alphaTransactionalObjectDesc = Type.getDescriptor(AlphaTransactionalObject.class);
        this.originDesc = Type.getDescriptor(AlphaTranlocal.class);
    }

    public ClassNode create() {
        ClassNode result = new ClassNode();
        result.version = this.clazz.version;
        result.name = this.clazzMetadata.getTranlocalName();
        result.access = 4097;
        result.sourceFile = this.clazz.sourceFile;
        result.sourceDebug = this.clazz.sourceDebug;
        result.signature = this.clazz.signature;
        result.fields.addAll(this.remapManagedFields());
        result.superName = Type.getInternalName(AlphaTranlocal.class);
        result.methods.add(this.createOpenForWriteConstructor());
        result.methods.add(this.createIsDirtyMethod());
        result.methods.add(this.createTakeSnapshotMethod());
        result.methods.add(this.createFreshConstructor());
        result.methods.add(this.createOpenForWriteMethod());
        return result;
    }

    private Object createOpenForWriteMethod() {
        String desc = "()" + Type.getDescriptor(AlphaTranlocal.class);
        MethodNode m = new MethodNode(4097, "openForWrite", desc, null, new String[0]);
        m.visitTypeInsn(187, this.tranlocalName);
        m.visitInsn(89);
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, this.tranlocalName, "<init>", String.format("(%s)V", AsmUtils.internalToDesc(this.tranlocalName)));
        m.visitInsn(176);
        return m;
    }

    private List<FieldNode> remapManagedFields() {
        LinkedList<FieldNode> result = new LinkedList<FieldNode>();
        for (FieldNode fieldNode : this.clazz.fields) {
            FieldMetadata fieldMetadata = this.clazzMetadata.getFieldMetadata(fieldNode.name);
            if (!fieldMetadata.isManagedField()) continue;
            FieldNode fixedFieldNode = new FieldNode(AsmUtils.upgradeToPublic(fieldNode.access), fieldNode.name, fieldNode.desc, fieldNode.signature, fieldNode.value);
            result.add(fixedFieldNode);
        }
        return result;
    }

    private MethodNode createFreshConstructor() {
        MethodNode m = new MethodNode(4097, "<init>", String.format("(%s)V", AsmUtils.internalToDesc(this.clazz.name)), null, new String[0]);
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, this.alphaTranlocalName, "<init>", "()V");
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        m.visitFieldInsn(181, this.alphaTranlocalName, "___transactionalObject", this.alphaTransactionalObjectDesc);
        m.visitInsn(177);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }

    private MethodNode createOpenForWriteConstructor() {
        MethodNode m = new MethodNode(4097, "<init>", String.format("(%s)V", AsmUtils.internalToDesc(this.tranlocalName)), null, new String[0]);
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, Type.getInternalName(AlphaTranlocal.class), "<init>", "()V");
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        m.visitFieldInsn(180, this.tranlocalName, "___transactionalObject", this.alphaTransactionalObjectDesc);
        m.visitFieldInsn(181, this.tranlocalName, "___transactionalObject", this.alphaTransactionalObjectDesc);
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        m.visitFieldInsn(181, this.tranlocalName, "___origin", this.originDesc);
        for (FieldNode field : this.clazz.fields) {
            FieldMetadata fieldMetadata = this.clazzMetadata.getFieldMetadata(field.name);
            if (!fieldMetadata.isManagedField()) continue;
            m.visitVarInsn(25, 0);
            m.visitVarInsn(25, 1);
            m.visitFieldInsn(180, this.tranlocalName, field.name, field.desc);
            m.visitFieldInsn(181, this.tranlocalName, field.name, field.desc);
        }
        m.visitInsn(177);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }

    private MethodNode createIsDirtyMethod() {
        MethodNode m = new MethodNode(4097, "isDirty", "()Z", null, new String[0]);
        Label next = new Label();
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, this.tranlocalName, "___writeVersion", "J");
        m.visitLdcInsn(new Long(0L));
        m.visitInsn(148);
        m.visitJumpInsn(153, next);
        m.visitInsn(3);
        m.visitInsn(172);
        m.visitLabel(next);
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, this.tranlocalName, "___origin", this.originDesc);
        next = new Label();
        m.visitJumpInsn(199, next);
        m.visitInsn(4);
        m.visitInsn(172);
        m.visitLabel(next);
        if (this.clazzMetadata.hasManagedFieldsWithObjectGranularity()) {
            m.visitVarInsn(25, 0);
            m.visitFieldInsn(180, this.tranlocalName, "___origin", this.originDesc);
            m.visitTypeInsn(192, this.tranlocalName);
            for (FieldNode fieldNode : this.clazz.fields) {
                FieldMetadata fieldMetadata = this.clazzMetadata.getFieldMetadata(fieldNode.name);
                if (!fieldMetadata.isManagedField()) continue;
                m.visitInsn(89);
                m.visitFieldInsn(180, this.tranlocalName, fieldNode.name, fieldNode.desc);
                m.visitVarInsn(25, 0);
                m.visitFieldInsn(180, this.tranlocalName, fieldNode.name, fieldNode.desc);
                next = new Label();
                switch (Type.getType(fieldNode.desc).getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        m.visitJumpInsn(159, next);
                        break;
                    }
                    case 6: {
                        m.visitInsn(149);
                        m.visitJumpInsn(153, next);
                        break;
                    }
                    case 7: {
                        m.visitInsn(148);
                        m.visitJumpInsn(153, next);
                        break;
                    }
                    case 8: {
                        m.visitInsn(151);
                        m.visitJumpInsn(153, next);
                        break;
                    }
                    case 9: 
                    case 10: {
                        m.visitJumpInsn(165, next);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled type: " + fieldNode.desc);
                    }
                }
                m.visitInsn(4);
                m.visitInsn(172);
                m.visitLabel(next);
            }
            m.visitLabel(next);
        }
        m.visitInsn(3);
        m.visitInsn(172);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }

    private MethodNode createTakeSnapshotMethod() {
        MethodNode m = new MethodNode(4097, "takeSnapshot", String.format("()%s", Type.getDescriptor(AlphaTranlocalSnapshot.class)), null, new String[0]);
        m.visitTypeInsn(187, this.tranlocalSnapshotName);
        m.visitInsn(89);
        m.visitVarInsn(25, 0);
        String constructorDesc = String.format("(%s)V", AsmUtils.internalToDesc(this.tranlocalName));
        m.visitMethodInsn(183, this.tranlocalSnapshotName, "<init>", constructorDesc);
        m.visitInsn(176);
        m.visitMaxs(0, 0);
        m.visitEnd();
        return m;
    }
}

