/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.tranlocal;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.stms.alpha.instrumentation.tranlocal.TranlocalSnapshotFactory;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class TranlocalSnapshotInstrumentationPhase
extends AbstractInstrumentationPhase {
    public TranlocalSnapshotInstrumentationPhase() {
        super("TranlocalSnapshotInstrumentationPhase");
    }

    @Override
    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassMetadata classMetadata = environment.getMetadataRepository().loadClassMetadata(originalClazz.getClassLoader(), originalClazz.getName());
        if (!classMetadata.isTransactionalObjectWithObjectGranularFields()) {
            return originalClazz;
        }
        ClassNode originalClassNode = AsmUtils.loadAsClassNode(originalClazz.getBytecode());
        TranlocalSnapshotFactory factory = new TranlocalSnapshotFactory(originalClazz.getClassLoader(), originalClassNode, environment.getMetadataRepository());
        ClassNode result = factory.create();
        Clazz snapshotClazz = new Clazz(classMetadata.getTranlocalSnapshotName());
        snapshotClazz.setBytecode(AsmUtils.toBytecode(result));
        snapshotClazz.setClassLoader(originalClazz.getClassLoader());
        environment.getFiler().createClassFile(snapshotClazz);
        return originalClazz;
    }
}

