/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import java.util.LinkedList;
import java.util.List;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.TransactionalMethodUtils;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class InterfaceTransactionalMethodTransformer {
    private final ClassNode classNode;
    private final MetadataRepository metadataRepository;
    private final ClassMetadata classMetadata;
    private final ClassLoader classLoader;

    public InterfaceTransactionalMethodTransformer(ClassLoader classLoader, ClassNode classNode, MetadataRepository metadataRepository) {
        if (classLoader == null || classNode == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        this.metadataRepository = metadataRepository;
        this.classNode = classNode;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, classNode.name);
    }

    public ClassNode transform() {
        this.classNode.methods = this.createInterfaceMethods();
        return this.classNode;
    }

    private List<MethodNode> createInterfaceMethods() {
        LinkedList<MethodNode> methods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (methodMetadata.isTransactional()) {
                methods.add(InterfaceTransactionalMethodTransformer.createInterfaceTransactionMethod(methodNode, true));
                methods.add(InterfaceTransactionalMethodTransformer.createInterfaceTransactionMethod(methodNode, false));
            }
            methods.add(methodNode);
        }
        return methods;
    }

    private static MethodNode createInterfaceTransactionMethod(MethodNode methodNode, boolean readonly) {
        MethodNode transactionMethod = new MethodNode();
        transactionMethod.access = methodNode.access;
        transactionMethod.name = TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly);
        transactionMethod.exceptions = methodNode.exceptions;
        transactionMethod.desc = AsmUtils.createMethodDescriptorWithRightIntroducedVariable(methodNode.desc, Type.getInternalName(AlphaTransaction.class));
        return transactionMethod;
    }
}

