/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions;

import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionSnapshot;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AbstractAlphaTransactionConfiguration;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public abstract class AbstractAlphaTransaction<C extends AbstractAlphaTransactionConfiguration, S extends AbstractTransactionSnapshot>
extends AbstractTransaction<C, S>
implements AlphaTransaction {
    public AbstractAlphaTransaction(C config) {
        super(config);
    }

    protected final AlphaTranlocal load(AlphaTransactionalObject txObject) {
        int spin = 0;
        while (true) {
            try {
                return txObject.___load(this.getReadVersion());
            }
            catch (LockNotFreeReadConflict lockNotFreeReadConflict) {
                if (spin >= ((AbstractAlphaTransactionConfiguration)this.config).maxReadSpinCount) {
                    throw lockNotFreeReadConflict;
                }
                ++spin;
                continue;
            }
            break;
        }
    }

    @Override
    public final AlphaTranlocal openForCommutingWrite(AlphaTransactionalObject transactionalObject) {
        switch (this.getStatus()) {
            case active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for write a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForCommutingWrite(transactionalObject);
            }
            case prepared: {
                String preparedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case committed: {
                String committedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = String.format("Can't open for commuting write transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException();
    }

    protected AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject txObject) {
        String msg = String.format("Can't can't open for write transactional object '%s' because transaction '%s' and class '%s' doesn't support this operation.", AlphaStmUtils.toTxObjectString(txObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName(), this.getClass());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public final AlphaTranlocal openForRead(AlphaTransactionalObject transactionalObject) {
        switch (this.getStatus()) {
            case active: {
                if (transactionalObject == null) {
                    return null;
                }
                return this.doOpenForRead(transactionalObject);
            }
            case prepared: {
                String preparedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case committed: {
                String committedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = String.format("Can't open for read transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException();
    }

    protected AlphaTranlocal doOpenForRead(AlphaTransactionalObject txObject) {
        String msg = String.format("Can't open for read transactional object '%s' because transaction '%s' and class '%s' doesn't support this operation.", AlphaStmUtils.toTxObjectString(txObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName(), this.getClass());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public final AlphaTranlocal openForWrite(AlphaTransactionalObject transactionalObject) {
        switch (this.getStatus()) {
            case active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for write a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForWrite(transactionalObject);
            }
            case prepared: {
                String preparedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case committed: {
                String committedMsg = String.format("Can't open for write transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = String.format("Can't open for commuting write transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException();
    }

    protected AlphaTranlocal doOpenForWrite(AlphaTransactionalObject txObject) {
        String msg = String.format("Can't can't open for write transactional object '%s' because transaction '%s' and class '%s' doesn't support this operation.", AlphaStmUtils.toTxObjectString(txObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName(), this.getClass());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public final AlphaTranlocal openForConstruction(AlphaTransactionalObject transactionalObject) {
        switch (this.getStatus()) {
            case active: {
                if (transactionalObject == null) {
                    String msg = String.format("Can't open for construction a null transactional object on transaction '%s' ", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                    throw new NullPointerException(msg);
                }
                return this.doOpenForConstruction(transactionalObject);
            }
            case prepared: {
                String preparedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is prepared to commit.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new PreparedTransactionException(preparedMsg);
            }
            case committed: {
                String committedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is committed.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case aborted: {
                String abortedMsg = String.format("Can't open for construction transactional object '%s' because transaction '%s' already is aborted.", AlphaStmUtils.toTxObjectString(transactionalObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
        }
        throw new IllegalStateException();
    }

    protected AlphaTranlocal doOpenForConstruction(AlphaTransactionalObject txObject) {
        String msg = String.format("Can't can't open for construction transactional object '%s' because transaction '%s' and class '%s' doesn't support this operation.", AlphaStmUtils.toTxObjectString(txObject), ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName(), this.getClass());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    protected final boolean doRegisterRetryLatch(Latch latch, long wakeupVersion) {
        if (!((AbstractAlphaTransactionConfiguration)this.config).explicitRetryAllowed) {
            String msg = String.format("Transaction %s explicitly doesn't allow for a retry (needed for blocking operations)", ((AbstractAlphaTransactionConfiguration)this.config).getFamilyName());
            throw new NoRetryPossibleException(msg);
        }
        SpeculativeConfiguration speculativeConfig = ((AbstractAlphaTransactionConfiguration)this.config).speculativeConfiguration;
        if (!((AbstractAlphaTransactionConfiguration)this.config).readTrackingEnabled) {
            if (speculativeConfig.isSpeculativeNoReadTrackingEnabled()) {
                speculativeConfig.signalSpeculativeReadTrackingDisabledFailure();
                throw SpeculativeConfigurationFailure.create();
            }
            return false;
        }
        return this.dodoRegisterRetryLatch(latch, wakeupVersion);
    }

    protected abstract boolean dodoRegisterRetryLatch(Latch var1, long var2);
}

