/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.readonly.AbstractReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class ArrayReadonlyAlphaTransaction
extends AbstractReadonlyAlphaTransaction {
    private AlphaTranlocal[] attachedArray;
    private int firstFreeIndex;

    public ArrayReadonlyAlphaTransaction(ReadonlyConfiguration config, int size) {
        super(config);
        this.attachedArray = new AlphaTranlocal[size];
        this.init();
    }

    @Override
    protected void doClear() {
        this.firstFreeIndex = 0;
        for (int k = 0; k < this.attachedArray.length; ++k) {
            this.attachedArray[k] = null;
        }
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject txObject) {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            if (attached.getTransactionalObject() != txObject) continue;
            return attached;
        }
        return null;
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        if (this.firstFreeIndex == this.attachedArray.length) {
            int newOptimalSize = this.attachedArray.length + 2;
            ((ReadonlyConfiguration)this.config).speculativeConfiguration.signalSpeculativeSizeFailure(this.attachedArray.length);
            if (this.attachedArray.length >= ((ReadonlyConfiguration)this.config).speculativeConfiguration.getMaximumArraySize()) {
                throw SpeculativeConfigurationFailure.create();
            }
            AlphaTranlocal[] newAttachedArray = new AlphaTranlocal[newOptimalSize];
            System.arraycopy(this.attachedArray, 0, newAttachedArray, 0, this.attachedArray.length);
            this.attachedArray = newAttachedArray;
        }
        this.attachedArray[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        boolean trackedReads = false;
        block5: for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTransactionalObject txObject = this.attachedArray[k].getTransactionalObject();
            switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
                case opened: {
                    return true;
                }
                case registered: {
                    trackedReads = true;
                    continue block5;
                }
                case noregistration: {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return trackedReads;
    }
}

