/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import java.util.IdentityHashMap;
import java.util.Map;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.AbstractReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class MapReadonlyAlphaTransaction
extends AbstractReadonlyAlphaTransaction {
    private final Map<AlphaTransactionalObject, AlphaTranlocal> attachedMap = new IdentityHashMap<AlphaTransactionalObject, AlphaTranlocal>();

    public MapReadonlyAlphaTransaction(ReadonlyConfiguration config) {
        super(config);
        this.init();
    }

    @Override
    protected void doClear() {
        this.attachedMap.clear();
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject txObject) {
        return this.attachedMap.get(txObject);
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        this.attachedMap.put(tranlocal.getTransactionalObject(), tranlocal);
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        boolean trackedReads = false;
        block5: for (AlphaTransactionalObject txObject : this.attachedMap.keySet()) {
            switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
                case opened: {
                    return true;
                }
                case registered: {
                    trackedReads = true;
                    continue block5;
                }
                case noregistration: {
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return trackedReads;
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
    public static class Factory
    implements TransactionFactory<AlphaTransaction> {
        public final ReadonlyConfiguration config;
        private final TransactionFactoryBuilder builder;

        public Factory(ReadonlyConfiguration config, TransactionFactoryBuilder builder) {
            this.config = config;
            this.builder = builder;
        }

        @Override
        public AlphaTransaction start() {
            return new MapReadonlyAlphaTransaction(this.config);
        }

        @Override
        public TransactionFactoryBuilder getBuilder() {
            return this.builder;
        }
    }
}

