/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.5.2")
public final class StandardThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;
    private volatile int priority;

    private static String createThreadGroupName() {
        return Integer.toString(poolNumber.getAndIncrement());
    }

    public StandardThreadFactory() {
        this(5, StandardThreadFactory.createThreadGroupName());
    }

    public StandardThreadFactory(String groupName) {
        this(5, groupName);
    }

    public StandardThreadFactory(int priority) {
        this(priority, StandardThreadFactory.createThreadGroupName());
    }

    public StandardThreadFactory(int priority, String groupName) {
        this(priority, new ThreadGroup(Thread.currentThread().getThreadGroup(), groupName), false);
    }

    public StandardThreadFactory(int priority, ThreadGroup threadGroup) {
        this(priority, threadGroup, false);
    }

    public StandardThreadFactory(int priority, boolean daemon) {
        this(priority, new ThreadGroup(Thread.currentThread().getThreadGroup(), StandardThreadFactory.createThreadGroupName()), daemon);
    }

    public StandardThreadFactory(int priority, ThreadGroup threadGroup, boolean daemon) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        this.threadGroup = threadGroup;
        this.ensureValidPriority(priority);
        this.priority = priority;
        this.daemon = daemon;
        this.namePrefix = threadGroup.getName() + "-thread#";
    }

    private void ensureValidPriority(int priority) {
        if (priority < 1) {
            throw new IllegalArgumentException("priority can`t be smaller than: 1, priority was: " + priority);
        }
        if (priority > 10) {
            throw new IllegalArgumentException("priority can`t be greater than: 10, priority was: " + priority);
        }
        if (priority > this.threadGroup.getMaxPriority()) {
            throw new IllegalArgumentException("priority can`t be greater than threadGroup.maxPriority: " + this.threadGroup.getMaxPriority() + ", priority was: " + priority);
        }
    }

    public boolean isProducingDaemons() {
        return this.daemon;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.ensureValidPriority(priority);
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        String threadName = this.namePrefix + this.threadNumber.getAndIncrement();
        Thread thread = new Thread(this.threadGroup, runnable, threadName);
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }
}

