/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.internal.Function;
import com.google.inject.internal.MapMaker;
import com.google.inject.internal.Nullable;
import com.google.inject.internal.cglib.core.DefaultNamingPolicy;
import com.google.inject.internal.cglib.core.NamingPolicy;
import com.google.inject.internal.cglib.proxy.Enhancer;
import com.google.inject.internal.cglib.reflect.FastClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytecodeGen {
    private static final Logger logger = Logger.getLogger(BytecodeGen.class.getName());
    static final ClassLoader GUICE_CLASS_LOADER = BytecodeGen.canonicalize(BytecodeGen.class.getClassLoader());
    static final Object NULL_CLASS_LOADER_KEY = new Object();
    private static final String GUICE_INTERNAL_PACKAGE = BytecodeGen.class.getName().replaceFirst("\\.internal\\..*$", ".internal");
    private static final String CGLIB_PACKAGE = Enhancer.class.getName().replaceFirst("\\.cglib\\..*$", ".cglib");
    static final NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "ByGuice";
        }
    };
    static final String CUSTOM_LOADER_SETTING = System.getProperty("guice.custom.loader", "true");
    private static final Map<Object, ClassLoader> CLASS_LOADER_CACHE = new MapMaker().weakKeys().weakValues().makeComputingMap(new Function<Object, ClassLoader>(){

        @Override
        public ClassLoader apply(@Nullable Object classLoaderKey) {
            final ClassLoader typeClassLoader = BytecodeGen.getClassLoaderFromKey(classLoaderKey);
            logger.fine("Creating a bridge ClassLoader for " + typeClassLoader);
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new BridgeClassLoader(typeClassLoader);
                }
            });
        }
    });

    private static ClassLoader canonicalize(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static Object getKeyFromClassLoader(ClassLoader classLoader) {
        return classLoader != null ? classLoader : NULL_CLASS_LOADER_KEY;
    }

    private static ClassLoader getClassLoaderFromKey(Object key) {
        return key != NULL_CLASS_LOADER_KEY ? (ClassLoader)key : null;
    }

    public static ClassLoader getClassLoader(Class<?> type) {
        return BytecodeGen.getClassLoader(type, type.getClassLoader());
    }

    private static ClassLoader getClassLoader(Class<?> type, ClassLoader delegate) {
        if ("FALSE".equalsIgnoreCase(CUSTOM_LOADER_SETTING)) {
            return delegate;
        }
        if (GUICE_CLASS_LOADER == (delegate = BytecodeGen.canonicalize(delegate)) && !"EAGER".equalsIgnoreCase(CUSTOM_LOADER_SETTING)) {
            return delegate;
        }
        if (delegate instanceof BridgeClassLoader) {
            return delegate;
        }
        if (Visibility.forType(type) == Visibility.PUBLIC) {
            return CLASS_LOADER_CACHE.get(BytecodeGen.getKeyFromClassLoader(delegate));
        }
        return delegate;
    }

    public static FastClass newFastClass(Class<?> type, Visibility visibility) {
        FastClass.Generator generator = new FastClass.Generator();
        generator.setType(type);
        if (visibility == Visibility.PUBLIC) {
            generator.setClassLoader(BytecodeGen.getClassLoader(type));
        }
        generator.setNamingPolicy(NAMING_POLICY);
        logger.fine("Loading " + type + " FastClass with " + generator.getClassLoader());
        return generator.create();
    }

    public static Enhancer newEnhancer(Class<?> type, Visibility visibility) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setUseFactory(false);
        if (visibility == Visibility.PUBLIC) {
            enhancer.setClassLoader(BytecodeGen.getClassLoader(type));
        }
        enhancer.setNamingPolicy(NAMING_POLICY);
        logger.fine("Loading " + type + " Enhancer with " + enhancer.getClassLoader());
        return enhancer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BridgeClassLoader
    extends ClassLoader {
        public BridgeClassLoader(ClassLoader usersClassLoader) {
            super(usersClassLoader);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith(GUICE_INTERNAL_PACKAGE) || name.startsWith(CGLIB_PACKAGE)) {
                try {
                    Class<?> clazz = GUICE_CLASS_LOADER.loadClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        PUBLIC{

            public Visibility and(Visibility that) {
                return that;
            }
        }
        ,
        SAME_PACKAGE{

            public Visibility and(Visibility that) {
                return this;
            }
        };


        public static Visibility forMember(Member member) {
            Class<?>[] parameterTypes;
            if ((member.getModifiers() & 5) == 0) {
                return SAME_PACKAGE;
            }
            for (Class<?> type : parameterTypes = member instanceof Constructor ? ((Constructor)member).getParameterTypes() : ((Method)member).getParameterTypes()) {
                if (Visibility.forType(type) != SAME_PACKAGE) continue;
                return SAME_PACKAGE;
            }
            return PUBLIC;
        }

        public static Visibility forType(Class<?> type) {
            return (type.getModifiers() & 5) != 0 ? PUBLIC : SAME_PACKAGE;
        }

        public abstract Visibility and(Visibility var1);
    }
}

