/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import java.util.LinkedList;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.stms.alpha.instrumentation.fieldaccess.NonTransactionalMethodFieldAccessMethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class NonTransactionalMethodFieldAccessTransformer
implements Opcodes {
    private final ClassNode classNode;
    private final MetadataRepository metadataRepository;
    private final ClassMetadata classMetadata;
    private final ClassLoader classLoader;

    public NonTransactionalMethodFieldAccessTransformer(ClassLoader classLoader, ClassNode classNode, MetadataRepository metadataRepository) {
        if (classLoader == null || classNode == null) {
            throw new NullPointerException();
        }
        this.metadataRepository = metadataRepository;
        this.classNode = classNode;
        this.classLoader = classLoader;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, classNode.name);
    }

    public ClassNode transform() {
        this.fixMethods();
        return this.classNode;
    }

    private void fixMethods() {
        LinkedList<MethodNode> fixedMethods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodNode fixedMethod = this.fixMethod(methodNode);
            fixedMethods.add(fixedMethod);
        }
        this.classNode.methods = fixedMethods;
    }

    private MethodNode fixMethod(MethodNode methodNode) {
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
        if (methodMetadata == null || methodMetadata.isAbstract() || methodMetadata.isNative() || methodMetadata.isTransactional()) {
            return methodNode;
        }
        MethodNode fixedMethod = new MethodNode();
        fixedMethod.signature = methodNode.signature;
        fixedMethod.access = methodNode.access;
        fixedMethod.localVariables = new LinkedList();
        fixedMethod.name = methodNode.name;
        fixedMethod.desc = methodNode.desc;
        fixedMethod.exceptions = methodNode.exceptions;
        fixedMethod.tryCatchBlocks = new LinkedList();
        methodNode.accept((MethodVisitor)new NonTransactionalMethodFieldAccessMethodAdapter(this.classLoader, (MethodVisitor)fixedMethod, this.metadataRepository));
        return fixedMethod;
    }
}

