/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.instrumentation.CompileException;
import org.multiverse.instrumentation.DebugInfo;
import org.multiverse.instrumentation.InstrumenterLogger;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.asm.CloneMap;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.TransactionMetadata;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.TransactionLogicDonor;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.TransactionalMethodUtils;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public final class ClassTransactionalMethodTransformer
implements Opcodes {
    private static final String ALPHA_TRANSACTION_INTERNAL_NAME = Type.getInternalName(AlphaTransaction.class);
    private final ClassNode classNode;
    private final MetadataRepository metadataRepository;
    private final ClassNode donorClassNode;
    private final MethodNode donorMethodNode;
    private final MethodNode donorConstructorNode;
    private final String tranlocalName;
    private final ClassMetadata classMetadata;
    private final ClassLoader classLoader;
    private final Map<MethodNode, FieldNode> transactionFactoryFields = new HashMap<MethodNode, FieldNode>();
    private final boolean optimize;
    private final InstrumenterLogger logger;

    public ClassTransactionalMethodTransformer(ClassLoader classLoader, ClassNode classNode, ClassNode donorClassNode, MetadataRepository metadataRepository, boolean optimize, InstrumenterLogger logger) {
        this.classLoader = classLoader;
        this.metadataRepository = metadataRepository;
        this.classNode = classNode;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, classNode.name);
        this.tranlocalName = this.classMetadata.getTranlocalName();
        this.donorClassNode = donorClassNode;
        this.donorMethodNode = this.getDonorMethod("donorMethod");
        this.donorConstructorNode = this.getDonorMethod("donorConstructor");
        this.optimize = optimize;
        this.logger = logger;
    }

    public ClassNode transform() {
        this.addTransactionFactoryInitializationToStaticInitializer();
        this.classNode.methods = this.fixMethods();
        return this.classNode;
    }

    private void addTransactionFactoryInitializationToStaticInitializer() {
        MethodNode staticInitializerNode = null;
        LinkedList<MethodNode> extraMethods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (methodMetadata == null || !methodMetadata.isTransactional() || methodMetadata.isAbstract()) continue;
            FieldNode txFactoryField = this.createTransactionFactoryField();
            this.classNode.fields.add(txFactoryField);
            this.transactionFactoryFields.put(methodNode, txFactoryField);
            if (staticInitializerNode == null) {
                MethodNode existingStaticInitializerNode = this.findStaticInitializerMethodNode();
                if (existingStaticInitializerNode == null) {
                    staticInitializerNode = new MethodNode(8, "<clinit>", "()V", null, new String[0]);
                    staticInitializerNode.instructions.add((AbstractInsnNode)new InsnNode(177));
                    extraMethods.add(staticInitializerNode);
                } else {
                    staticInitializerNode = existingStaticInitializerNode;
                }
            }
            TransactionMetadata transactionMetadata = methodMetadata.getTransactionalMetadata();
            InsnList insnList = this.transactionFactoryInitialization(transactionMetadata, txFactoryField);
            staticInitializerNode.instructions.insert(insnList);
        }
        this.classNode.methods.addAll(extraMethods);
    }

    private InsnList transactionFactoryInitialization(TransactionMetadata transactionMetadata, FieldNode txFactoryField) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(GlobalStmInstance.class), "getGlobalStmInstance", "()" + Type.getDescriptor(Stm.class)));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(Stm.class), "getTransactionFactoryBuilder", "()" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        boolean speculative = transactionMetadata.speculativeConfigurationEnabled;
        insnList.add((AbstractInsnNode)new InsnNode(speculative ? 4 : 3));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setSpeculativeConfigurationEnabled", "(Z)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        if (transactionMetadata.readOnly != null) {
            insnList.add((AbstractInsnNode)new InsnNode(transactionMetadata.readOnly != false ? 4 : 3));
            insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setReadonly", "(Z)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        }
        if (transactionMetadata.trackReads != null) {
            insnList.add((AbstractInsnNode)new InsnNode(transactionMetadata.trackReads != false ? 4 : 3));
            insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setReadTrackingEnabled", "(Z)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        }
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)transactionMetadata.familyName));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setFamilyName", "(Ljava/lang/String;)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        insnList.add((AbstractInsnNode)new InsnNode(transactionMetadata.interruptible != false ? 4 : 3));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setInterruptible", "(Z)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        insnList.add((AbstractInsnNode)new InsnNode(transactionMetadata.writeSkew ? 4 : 3));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setWriteSkewAllowed", "(Z)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)transactionMetadata.maxRetries));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setMaxRetries", "(I)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)transactionMetadata.timeoutNs));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "setTimeoutNs", "(J)" + Type.getDescriptor(TransactionFactoryBuilder.class)));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(TransactionFactoryBuilder.class), "build", "()" + Type.getDescriptor(TransactionFactory.class)));
        insnList.add((AbstractInsnNode)new FieldInsnNode(179, this.classNode.name, txFactoryField.name, Type.getDescriptor(TransactionFactory.class)));
        return insnList;
    }

    private List<MethodNode> fixMethods() {
        LinkedList<MethodNode> fixedMethods = new LinkedList<MethodNode>();
        for (MethodNode methodNode : this.classNode.methods) {
            MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
            if (methodMetadata == null || !methodMetadata.isTransactional()) {
                fixedMethods.add(methodNode);
                continue;
            }
            if (methodMetadata.isAbstract()) {
                fixedMethods.add(methodNode);
                fixedMethods.add(this.createAbstractTransactedMethod(methodNode, true));
                fixedMethods.add(this.createAbstractTransactedMethod(methodNode, false));
                continue;
            }
            if (methodMetadata.isStatic()) {
                fixedMethods.add(this.createTransactionalMethod(methodNode));
                fixedMethods.add(this.createTransactedMethod(methodNode, true));
                fixedMethods.add(this.createTransactedMethod(methodNode, false));
                continue;
            }
            if (methodMetadata.isConstructor()) {
                fixedMethods.add(this.createTransactionalMethod(methodNode));
                fixedMethods.add(this.createTransactedConstructor(methodNode));
                continue;
            }
            fixedMethods.add(this.createTransactionalMethod(methodNode));
            if (this.classMetadata.isTransactionalObjectWithObjectGranularFields()) {
                fixedMethods.add(this.createTranlocalLoadMethod(methodNode, true));
                fixedMethods.add(this.createTranlocalLoadMethod(methodNode, false));
                fixedMethods.add(this.createTransactionalWithTranlocalMethod(methodNode, true));
                fixedMethods.add(this.createTransactionalWithTranlocalMethod(methodNode, false));
                continue;
            }
            fixedMethods.add(this.createTransactedMethod(methodNode, true));
            fixedMethods.add(this.createTransactedMethod(methodNode, false));
        }
        return fixedMethods;
    }

    private MethodNode createTransactedConstructor(MethodNode methodNode) {
        int indexOfFirst;
        CloneMap cloneMap = new CloneMap();
        DebugInfo debugInfo = AsmUtils.findDebugInfo((MethodNode)methodNode);
        LabelNode startLabelNode = new LabelNode();
        LabelNode endLabelNode = new LabelNode();
        MethodNode result = new MethodNode();
        result.name = "<init>";
        result.access = methodNode.access;
        result.desc = this.createTransactedMethodDesc(methodNode.desc);
        result.exceptions = methodNode.exceptions;
        result.localVariables = this.createNewVariableTableForMethodWithLogic(methodNode, cloneMap, startLabelNode, endLabelNode);
        result.tryCatchBlocks = AsmUtils.cloneTryCatchBlocks((MethodNode)methodNode, (CloneMap)cloneMap);
        result.instructions = this.transformOriginalLogic(methodNode, cloneMap, debugInfo, startLabelNode, endLabelNode, false);
        int transactionVar = this.indexOfTransactionVariable(methodNode.name, methodNode.desc);
        if (this.classMetadata.isFirstGenerationTransactionalObjectWithObjectGranularFields() && (indexOfFirst = AsmUtils.firstIndexAfterSuper((String)methodNode.name, (InsnList)result.instructions, (String)this.classNode.superName)) >= 0) {
            InsnList initTranlocal = new InsnList();
            initTranlocal.add((AbstractInsnNode)new VarInsnNode(25, transactionVar));
            initTranlocal.add((AbstractInsnNode)new VarInsnNode(25, 0));
            String openForConstructionDesc = String.format("(%s)%s", Type.getDescriptor(AlphaTransactionalObject.class), Type.getDescriptor(AlphaTranlocal.class));
            initTranlocal.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(AlphaTransaction.class), "openForConstruction", openForConstructionDesc));
            initTranlocal.add((AbstractInsnNode)new InsnNode(87));
            result.instructions.insertBefore(result.instructions.get(indexOfFirst), initTranlocal);
        }
        return result;
    }

    private MethodNode createAbstractTransactedMethod(MethodNode methodNode, boolean readonly) {
        MethodNode transactionMethod = new MethodNode();
        transactionMethod.access = methodNode.access;
        transactionMethod.name = TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly);
        transactionMethod.exceptions = methodNode.exceptions;
        transactionMethod.desc = this.createTransactedMethodDesc(methodNode.desc);
        transactionMethod.signature = methodNode.signature;
        return transactionMethod;
    }

    private MethodNode createTranlocalLoadMethod(MethodNode methodNode, boolean readonly) {
        CloneMap cloneMap = new CloneMap();
        LabelNode startLabelNode = new LabelNode();
        LabelNode endLabelNode = new LabelNode();
        MethodNode result = new MethodNode();
        result.name = TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly);
        result.access = methodNode.access;
        result.desc = this.createTransactedMethodDesc(methodNode.desc);
        result.exceptions = methodNode.exceptions;
        result.tryCatchBlocks = AsmUtils.cloneTryCatchBlocks((MethodNode)methodNode, (CloneMap)cloneMap);
        result.instructions = new InsnList();
        result.instructions.add((AbstractInsnNode)startLabelNode);
        result.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int loadIndex = 1;
        for (Type argType : Type.getArgumentTypes((String)methodNode.desc)) {
            VarInsnNode loadInsn = new VarInsnNode(argType.getOpcode(21), loadIndex);
            result.instructions.add((AbstractInsnNode)loadInsn);
            loadIndex += argType.getSize();
        }
        int transactionVarIndex = this.indexOfTransactionVariable(methodNode.name, methodNode.desc);
        result.instructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVarIndex));
        result.instructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVarIndex));
        result.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        String openForReadDesc = String.format("(%s)%s", Type.getDescriptor(AlphaTransactionalObject.class), Type.getDescriptor(AlphaTranlocal.class));
        result.instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(AlphaTransaction.class), "openForRead", openForReadDesc));
        result.instructions.add((AbstractInsnNode)new TypeInsnNode(192, this.tranlocalName));
        MethodInsnNode invokeInsn = new MethodInsnNode(AsmUtils.getInvokeOpcode((MethodNode)methodNode), this.classNode.name, TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly), this.createTranlocalMethodDesc(methodNode.name, methodNode.desc));
        result.instructions.add((AbstractInsnNode)invokeInsn);
        int returnOpCode = Type.getReturnType((String)methodNode.desc).getOpcode(172);
        result.instructions.add((AbstractInsnNode)new InsnNode(returnOpCode));
        result.instructions.add((AbstractInsnNode)endLabelNode);
        return result;
    }

    private MethodNode createTransactedMethod(MethodNode methodNode, boolean readonly) {
        CloneMap cloneMap = new CloneMap();
        DebugInfo debugInfo = AsmUtils.findDebugInfo((MethodNode)methodNode);
        LabelNode startLabelNode = new LabelNode();
        LabelNode endLabelNode = new LabelNode();
        MethodNode result = new MethodNode();
        result.name = TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly);
        result.access = methodNode.access;
        result.desc = this.createTransactedMethodDesc(methodNode.desc);
        result.signature = methodNode.signature;
        result.exceptions = methodNode.exceptions;
        result.localVariables = AsmUtils.cloneVariableTable((MethodNode)methodNode, (CloneMap)cloneMap);
        LocalVariableNode transactionVar = new LocalVariableNode("transaction", Type.getDescriptor(AlphaTransaction.class), null, startLabelNode, endLabelNode, this.indexOfTransactionVariable(methodNode.name, methodNode.desc));
        result.localVariables.add(transactionVar);
        result.tryCatchBlocks = AsmUtils.cloneTryCatchBlocks((MethodNode)methodNode, (CloneMap)cloneMap);
        result.instructions = this.transformOriginalLogic(methodNode, cloneMap, debugInfo, startLabelNode, endLabelNode, readonly);
        return result;
    }

    private MethodNode getDonorMethod(String methodName) {
        for (MethodNode m : this.donorClassNode.methods) {
            if (!m.name.equals(methodName)) continue;
            return m;
        }
        throw new RuntimeException(String.format("method '%s' not found in class '%s'", methodName, this.donorClassNode.name));
    }

    private MethodNode findStaticInitializerMethodNode() {
        for (MethodNode method : this.classNode.methods) {
            if (!method.name.equals("<clinit>")) continue;
            return method;
        }
        return null;
    }

    private MethodNode getDonorMethodNode(MethodNode originalTxMethod) {
        if (originalTxMethod.name.equals("<init>")) {
            return this.donorConstructorNode;
        }
        return this.donorMethodNode;
    }

    private FieldNode createTransactionFactoryField() {
        int access = 4121;
        String name = "___transactionFactory_" + System.nanoTime();
        String desc = Type.getDescriptor(TransactionFactory.class);
        String sig = null;
        Object value = null;
        return new FieldNode(access, name, desc, sig, value);
    }

    public MethodNode createTransactionalWithTranlocalMethod(MethodNode methodNode, boolean readonly) {
        CloneMap cloneMap = new CloneMap();
        DebugInfo debugInfo = AsmUtils.findDebugInfo((MethodNode)methodNode);
        LabelNode startLabelNode = new LabelNode();
        LabelNode endLabelNode = new LabelNode();
        MethodNode result = new MethodNode();
        result.name = TransactionalMethodUtils.toTransactedMethodName(methodNode.name, readonly);
        result.access = methodNode.access;
        result.desc = this.createTranlocalMethodDesc(methodNode.name, methodNode.desc);
        result.exceptions = methodNode.exceptions;
        result.localVariables = this.createNewVariableTableForMethodWithLogic(methodNode, cloneMap, startLabelNode, endLabelNode);
        result.tryCatchBlocks = AsmUtils.cloneTryCatchBlocks((MethodNode)methodNode, (CloneMap)cloneMap);
        result.instructions = this.transformOriginalLogic(methodNode, cloneMap, debugInfo, startLabelNode, endLabelNode, readonly);
        return result;
    }

    private InsnList transformOriginalLogic(MethodNode methodNode, CloneMap cloneMap, DebugInfo debugInfo, LabelNode startLabelNode, LabelNode endLabelNode, boolean readonly) {
        Frame[] frames;
        this.logger.lessImportant("transactify %s.%s", new Object[]{this.classMetadata.getName(), methodNode.name});
        Analyzer a = new Analyzer((Interpreter)new SourceInterpreter());
        try {
            frames = a.analyze(this.classNode.name, methodNode);
        }
        catch (AnalyzerException e) {
            throw new CompileException("failed to create frames for " + this.classMetadata.getName() + "." + methodNode.name);
        }
        int transactionVar = this.indexOfTransactionVariable(methodNode.name, methodNode.desc);
        int tranlocalVar = this.indexOfTranlocalVariable(methodNode.name, methodNode.desc);
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)startLabelNode);
        newInstructions.add((AbstractInsnNode)new LineNumberNode(debugInfo.beginLine, startLabelNode));
        for (int k = 0; k < methodNode.instructions.size(); ++k) {
            AbstractInsnNode originalInsn = methodNode.instructions.get(k);
            AbstractInsnNode newInsn = null;
            switch (originalInsn.getOpcode()) {
                case -1: {
                    if (originalInsn instanceof FrameNode) break;
                    newInsn = originalInsn.clone((Map)cloneMap);
                    break;
                }
                case 181: {
                    boolean fullMonty;
                    FieldInsnNode originalFieldInsnNode = (FieldInsnNode)originalInsn;
                    ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, originalFieldInsnNode.owner);
                    FieldMetadata fieldMetadata = ownerMetadata.getFieldMetadata(originalFieldInsnNode.name);
                    if (!fieldMetadata.isManagedFieldWithObjectGranularity()) {
                        newInsn = originalInsn.clone((Map)cloneMap);
                        break;
                    }
                    Frame methodFrame = frames[methodNode.instructions.indexOf((AbstractInsnNode)originalFieldInsnNode)];
                    int size = 1 + (AsmUtils.isCategory2((String)originalFieldInsnNode.desc) ? 2 : 1);
                    int stackSlot = methodFrame.getStackSize() - size;
                    SourceValue stackValue = (SourceValue)methodFrame.getStack(stackSlot);
                    boolean aload0 = false;
                    if (stackValue.insns.size() > 0) {
                        if (stackValue.insns.size() > 1) {
                            throw new RuntimeException();
                        }
                        AbstractInsnNode node = (AbstractInsnNode)stackValue.insns.iterator().next();
                        if (node.getOpcode() == 25) {
                            VarInsnNode varNode = (VarInsnNode)node;
                            if (varNode.var == 0) {
                                aload0 = true;
                                this.logger.lessImportant("   aload 0 found for candidate put optimization %s.%s", new Object[]{originalFieldInsnNode.owner, originalFieldInsnNode.name});
                            }
                        }
                    }
                    if (AsmUtils.isCategory2((String)originalFieldInsnNode.desc)) {
                        newInstructions.add((AbstractInsnNode)new InsnNode(93));
                        newInstructions.add((AbstractInsnNode)new InsnNode(88));
                    } else {
                        newInstructions.add((AbstractInsnNode)new InsnNode(95));
                    }
                    LabelNode finishedLoadingLabel = new LabelNode();
                    LabelNode startFullLoadLabel = new LabelNode();
                    boolean bl = fullMonty = aload0 && tranlocalVar > -1 && !methodNode.name.equals("<init>");
                    if (fullMonty) {
                        this.logger.lessImportant("   candidate for put optimization %s.%s", new Object[]{originalFieldInsnNode.owner, originalFieldInsnNode.name});
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                        newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getType(AlphaTranlocal.class).getInternalName(), "isCommitted", "()Z"));
                        newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, startFullLoadLabel));
                        newInstructions.add((AbstractInsnNode)new InsnNode(87));
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                        newInstructions.add((AbstractInsnNode)new JumpInsnNode(167, finishedLoadingLabel));
                    }
                    newInstructions.add((AbstractInsnNode)startFullLoadLabel);
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVar));
                    newInstructions.add((AbstractInsnNode)new InsnNode(95));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(AlphaTransaction.class), "openForWrite", String.format("(%s)%s", Type.getDescriptor(AlphaTransactionalObject.class), Type.getDescriptor(AlphaTranlocal.class))));
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, ownerMetadata.getTranlocalName()));
                    if (fullMonty) {
                        newInstructions.add((AbstractInsnNode)new InsnNode(89));
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(58, tranlocalVar));
                    }
                    newInstructions.add((AbstractInsnNode)finishedLoadingLabel);
                    if (AsmUtils.isCategory2((String)originalFieldInsnNode.desc)) {
                        newInstructions.add((AbstractInsnNode)new InsnNode(91));
                        newInstructions.add((AbstractInsnNode)new InsnNode(87));
                    } else {
                        newInstructions.add((AbstractInsnNode)new InsnNode(95));
                    }
                    newInsn = new FieldInsnNode(181, ownerMetadata.getTranlocalName(), originalFieldInsnNode.name, originalFieldInsnNode.desc);
                    break;
                }
                case 180: {
                    boolean fullMonty;
                    FieldInsnNode originalFieldInsnNode = (FieldInsnNode)originalInsn;
                    ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, originalFieldInsnNode.owner);
                    FieldMetadata fieldMetadata = ownerMetadata.getFieldMetadata(originalFieldInsnNode.name);
                    if (!fieldMetadata.isManagedFieldWithObjectGranularity()) {
                        newInsn = originalInsn.clone((Map)cloneMap);
                        break;
                    }
                    Frame methodFrame = frames[methodNode.instructions.indexOf((AbstractInsnNode)originalFieldInsnNode)];
                    int stackSlot = methodFrame.getStackSize() - 1;
                    SourceValue stackValue = (SourceValue)methodFrame.getStack(stackSlot);
                    boolean aload0 = false;
                    if (stackValue.insns.size() > 0) {
                        if (stackValue.insns.size() > 1) {
                            throw new RuntimeException();
                        }
                        AbstractInsnNode node = (AbstractInsnNode)stackValue.insns.iterator().next();
                        if (node.getOpcode() == 25) {
                            VarInsnNode varNode = (VarInsnNode)node;
                            if (varNode.var == 0) {
                                aload0 = true;
                                this.logger.lessImportant("   aload 0 found for candidate get optimization %s.%s", new Object[]{originalFieldInsnNode.owner, originalFieldInsnNode.name});
                            }
                        }
                    }
                    LabelNode startFullLoadLabel = new LabelNode();
                    LabelNode continueGetFieldLabel = new LabelNode();
                    boolean bl = fullMonty = aload0 && tranlocalVar > -1 && !methodNode.name.equals("<init>");
                    if (fullMonty) {
                        if (readonly) {
                            newInstructions.add((AbstractInsnNode)new InsnNode(87));
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                            newInstructions.add((AbstractInsnNode)new JumpInsnNode(167, continueGetFieldLabel));
                        } else {
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(AlphaTranlocal.class), "isCommitted", "()Z"));
                            newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, startFullLoadLabel));
                            newInstructions.add((AbstractInsnNode)new InsnNode(87));
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                            newInstructions.add((AbstractInsnNode)new JumpInsnNode(167, continueGetFieldLabel));
                            newInstructions.add((AbstractInsnNode)new JumpInsnNode(167, startFullLoadLabel));
                        }
                    }
                    newInstructions.add((AbstractInsnNode)startFullLoadLabel);
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVar));
                    newInstructions.add((AbstractInsnNode)new InsnNode(95));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(AlphaTransaction.class), "openForRead", String.format("(%s)%s", Type.getDescriptor(AlphaTransactionalObject.class), Type.getDescriptor(AlphaTranlocal.class))));
                    newInstructions.add((AbstractInsnNode)new TypeInsnNode(192, ownerMetadata.getTranlocalName()));
                    if (fullMonty) {
                        newInstructions.add((AbstractInsnNode)new InsnNode(89));
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(58, tranlocalVar));
                    }
                    newInstructions.add((AbstractInsnNode)continueGetFieldLabel);
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, ownerMetadata.getTranlocalName(), originalFieldInsnNode.name, originalFieldInsnNode.desc));
                    break;
                }
                case 132: {
                    IincInsnNode originalIncInsn = (IincInsnNode)originalInsn;
                    int newPos = this.newIndexOfLocalVariable(methodNode.name, methodNode.desc, originalIncInsn.var);
                    newInsn = new IincInsnNode(newPos, originalIncInsn.incr);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    VarInsnNode originalVarNode = (VarInsnNode)originalInsn;
                    int newPos = this.newIndexOfLocalVariable(methodNode.name, methodNode.desc, originalVarNode.var);
                    newInsn = new VarInsnNode(originalInsn.getOpcode(), newPos);
                    break;
                }
                case 182: 
                case 183: 
                case 185: {
                    SourceValue stackValue;
                    int stackSlot;
                    MethodInsnNode originalMethodInsnNode = (MethodInsnNode)originalInsn;
                    ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, originalMethodInsnNode.owner);
                    MethodMetadata ownerMethodMetadata = ownerMetadata.getMethodMetadata(originalMethodInsnNode.name, originalMethodInsnNode.desc);
                    boolean optimizeTransactionalMethodCall = this.optimize && ownerMethodMetadata != null && ownerMethodMetadata.isTransactional();
                    this.logger.lessImportant("  executing call %s transactional %s   optimize allowed: %s", new Object[]{originalMethodInsnNode.owner + "." + originalMethodInsnNode.name, ownerMethodMetadata != null && ownerMethodMetadata.isTransactional(), this.optimize});
                    if (optimizeTransactionalMethodCall) {
                        boolean fullMonty;
                        Frame methodFrame = frames[methodNode.instructions.indexOf((AbstractInsnNode)originalMethodInsnNode)];
                        stackSlot = methodFrame.getStackSize();
                        for (Type type : Type.getArgumentTypes((String)originalMethodInsnNode.desc)) {
                            stackSlot -= type.getSize();
                        }
                        stackValue = (SourceValue)methodFrame.getStack(--stackSlot);
                        boolean aload0 = false;
                        if (stackValue.insns.size() > 0) {
                            if (stackValue.insns.size() > 1) {
                                throw new RuntimeException();
                            }
                            AbstractInsnNode node = (AbstractInsnNode)stackValue.insns.iterator().next();
                            if (node.getOpcode() == 25) {
                                VarInsnNode v = (VarInsnNode)node;
                                VarInsnNode varNode = (VarInsnNode)node;
                                if (varNode.var == 0) {
                                    aload0 = true;
                                }
                            }
                        }
                        boolean bl = fullMonty = this.classMetadata.isTransactionalObjectWithObjectGranularFields() && aload0 && !methodNode.name.equals("<init>");
                        if (fullMonty) {
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVar));
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, tranlocalVar));
                            newInstructions.add((AbstractInsnNode)new MethodInsnNode(originalMethodInsnNode.getOpcode(), originalMethodInsnNode.owner, TransactionalMethodUtils.toTransactedMethodName(originalMethodInsnNode.name, readonly), this.createTransactedWithTranlocalMethodDesc(ownerMetadata, originalMethodInsnNode.name, originalMethodInsnNode.desc)));
                            this.logger.lessImportant("   ---full monty tranlocal method optimization %s.%s", new Object[]{originalMethodInsnNode.owner, originalMethodInsnNode.name});
                            break;
                        }
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVar));
                        newInstructions.add((AbstractInsnNode)new MethodInsnNode(originalMethodInsnNode.getOpcode(), originalMethodInsnNode.owner, TransactionalMethodUtils.toTransactedMethodName(originalMethodInsnNode.name, readonly), this.createTransactedMethodDesc(originalMethodInsnNode.desc)));
                        this.logger.lessImportant("   ---transactional method optimization %s.%s", new Object[]{originalMethodInsnNode.owner, originalMethodInsnNode.name});
                        break;
                    }
                    newInsn = originalInsn.clone((Map)cloneMap);
                    break;
                }
                default: {
                    newInsn = originalInsn.clone((Map)cloneMap);
                }
            }
            if (newInsn == null) continue;
            newInstructions.add(newInsn);
        }
        newInstructions.add((AbstractInsnNode)endLabelNode);
        return newInstructions;
    }

    private List createNewVariableTableForMethodWithLogic(MethodNode methodNode, CloneMap cloneMap, LabelNode startLabelNode, LabelNode endLabelNode) {
        LinkedList<LocalVariableNode> result = new LinkedList<LocalVariableNode>();
        LocalVariableNode transactionVar = new LocalVariableNode("transaction", Type.getDescriptor(AlphaTransaction.class), null, startLabelNode, endLabelNode, this.indexOfTransactionVariable(methodNode.name, methodNode.desc));
        result.add(transactionVar);
        int tranlocalVarIndex = this.indexOfTranlocalVariable(methodNode.name, methodNode.desc);
        if (tranlocalVarIndex >= 0) {
            LocalVariableNode tranlocalVar = new LocalVariableNode("tranlocalThis", AsmUtils.internalToDesc((String)this.tranlocalName), null, startLabelNode, endLabelNode, tranlocalVarIndex);
            result.add(tranlocalVar);
        }
        HashSet<Integer> encountered = new HashSet<Integer>();
        for (LocalVariableNode originalLocalVar : methodNode.localVariables) {
            int originalVarIndex = originalLocalVar.index;
            int clonedVarIndex = this.newIndexOfLocalVariable(methodNode.name, methodNode.desc, originalVarIndex);
            if (encountered.contains(originalVarIndex)) continue;
            encountered.add(originalVarIndex);
            LocalVariableNode clonedLocalVar = new LocalVariableNode(originalLocalVar.name, originalLocalVar.desc, originalLocalVar.signature, cloneMap.get(originalLocalVar.start), cloneMap.get(originalLocalVar.end), clonedVarIndex);
            result.add(clonedLocalVar);
        }
        return result;
    }

    public MethodNode createTransactionalMethod(MethodNode originalMethod) {
        MethodNode donorMethodNode = this.getDonorMethodNode(originalMethod);
        FieldNode txFactoryFieldNode = this.transactionFactoryFields.get(originalMethod);
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(originalMethod.name, originalMethod.desc);
        TransactionMetadata transactionMetadata = methodMetadata.getTransactionalMetadata();
        if (transactionMetadata.interruptible.booleanValue()) {
            this.ensureInterruptibleExceptionCanBeThrown(originalMethod);
        }
        MethodNode result = new MethodNode(originalMethod.access, originalMethod.name, originalMethod.desc, originalMethod.signature, AsmUtils.getExceptions((MethodNode)originalMethod));
        result.visibleAnnotations = originalMethod.visibleAnnotations;
        result.invisibleAnnotations = originalMethod.invisibleAnnotations;
        result.invisibleParameterAnnotations = originalMethod.invisibleParameterAnnotations;
        result.annotationDefault = originalMethod.annotationDefault;
        boolean isConstructor = "<init>".equals(originalMethod.name);
        CloneMap cloneMap = new CloneMap();
        LocalVariableNode transactionVar = null;
        HashMap<Integer, Integer> varMapping = new HashMap<Integer, Integer>();
        LabelNode startScope = new LabelNode();
        LabelNode endScope = new LabelNode();
        int var = 0;
        if (!AsmUtils.isStatic((MethodNode)originalMethod)) {
            LocalVariableNode clonedThis = new LocalVariableNode("this", AsmUtils.internalToDesc((String)this.classNode.name), null, startScope, endScope, 0);
            result.localVariables.add(clonedThis);
            ++var;
        }
        for (Type argType : Type.getArgumentTypes((String)originalMethod.desc)) {
            LocalVariableNode clonedVar = new LocalVariableNode("arg" + result.localVariables.size(), argType.getDescriptor(), null, startScope, endScope, var);
            var += argType.getSize();
            result.localVariables.add(clonedVar);
        }
        for (LocalVariableNode donorVar : donorMethodNode.localVariables) {
            LocalVariableNode clonedVar = new LocalVariableNode(donorVar.name, donorVar.desc, donorVar.signature, cloneMap.get(donorVar.start), cloneMap.get(donorVar.end), var);
            varMapping.put(donorVar.index, clonedVar.index);
            if (donorVar.name.equals("tx")) {
                transactionVar = clonedVar;
            }
            result.localVariables.add(clonedVar);
            var += Type.getType((String)clonedVar.desc).getSize();
        }
        LocalVariableNode resultVariable = null;
        Type returnType = Type.getReturnType((String)originalMethod.desc);
        if (!returnType.equals((Object)Type.VOID_TYPE)) {
            resultVariable = new LocalVariableNode("result", returnType.getDescriptor(), null, startScope, endScope, var);
            result.localVariables.add(resultVariable);
            var += returnType.getSize();
        }
        if (transactionVar == null) {
            throw new RuntimeException(String.format("No transaction variable with name 'tx' is found in donor method '%s.%s'", this.donorClassNode.name, donorMethodNode.name));
        }
        result.tryCatchBlocks = new LinkedList();
        result.tryCatchBlocks.addAll(AsmUtils.cloneTryCatchBlockNodes((List)donorMethodNode.tryCatchBlocks, (CloneMap)cloneMap));
        result.instructions.add((AbstractInsnNode)startScope);
        block10: for (AbstractInsnNode donorInsn : donorMethodNode.instructions) {
            switch (donorInsn.getOpcode()) {
                case -1: {
                    if (donorInsn instanceof LineNumberNode || donorInsn instanceof FrameNode) continue block10;
                    AbstractInsnNode cloned = donorInsn.clone((Map)cloneMap);
                    result.instructions.add(cloned);
                    break;
                }
                case 184: {
                    MethodInsnNode donorMethodInsn = (MethodInsnNode)donorInsn;
                    if (ClassTransactionalMethodTransformer.isReplacementMethod(donorMethodInsn)) {
                        if (!AsmUtils.isStatic((MethodNode)originalMethod)) {
                            result.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        }
                        int loadIndex = AsmUtils.isStatic((MethodNode)originalMethod) ? 0 : 1;
                        for (Type argType : Type.getArgumentTypes((String)originalMethod.desc)) {
                            VarInsnNode loadInsn = new VarInsnNode(argType.getOpcode(21), loadIndex);
                            result.instructions.add((AbstractInsnNode)loadInsn);
                            loadIndex += argType.getSize();
                        }
                        result.instructions.add((AbstractInsnNode)new VarInsnNode(25, transactionVar.index));
                        if (isConstructor) {
                            result.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.classNode.name, "<init>", this.createTransactedMethodDesc(originalMethod.desc)));
                            break;
                        }
                        String transactedMethodName = TransactionalMethodUtils.toTransactedMethodName(originalMethod.name, donorMethodInsn.name.endsWith("___ro"));
                        result.instructions.add((AbstractInsnNode)new MethodInsnNode(AsmUtils.getInvokeOpcode((MethodNode)originalMethod), this.classNode.name, transactedMethodName, this.createTransactedMethodDesc(originalMethod.desc)));
                        if (returnType.equals((Object)Type.VOID_TYPE)) continue block10;
                        result.instructions.add((AbstractInsnNode)new VarInsnNode(returnType.getOpcode(54), resultVariable.index));
                        break;
                    }
                    AbstractInsnNode cloned = donorInsn.clone((Map)cloneMap);
                    result.instructions.add(cloned);
                    break;
                }
                case 178: {
                    FieldInsnNode donorFieldInsnNode = (FieldInsnNode)donorInsn;
                    boolean donorIsOwner = donorFieldInsnNode.owner.equals(this.donorClassNode.name);
                    if (donorIsOwner && donorFieldInsnNode.name.equals("transactionFactory")) {
                        result.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.classNode.name, txFactoryFieldNode.name, donorFieldInsnNode.desc));
                        break;
                    }
                    result.instructions.add(donorInsn.clone((Map)cloneMap));
                    break;
                }
                case 132: {
                    IincInsnNode donorIncInsn = (IincInsnNode)donorInsn;
                    int clonedIndex = (Integer)varMapping.get(donorIncInsn.var);
                    result.instructions.add((AbstractInsnNode)new IincInsnNode(clonedIndex, donorIncInsn.incr));
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    int index;
                    VarInsnNode donorVarInsn = (VarInsnNode)donorInsn;
                    Integer foundVar = (Integer)varMapping.get(donorVarInsn.var);
                    if (foundVar == null) {
                        index = var;
                        varMapping.put(donorVarInsn.var, var);
                        ++var;
                    } else {
                        index = foundVar;
                    }
                    VarInsnNode cloned = new VarInsnNode(donorVarInsn.getOpcode(), index);
                    result.instructions.add((AbstractInsnNode)cloned);
                    break;
                }
                case 177: {
                    if (returnType.equals((Object)Type.VOID_TYPE)) {
                        result.instructions.add((AbstractInsnNode)new InsnNode(177));
                        break;
                    }
                    result.instructions.add((AbstractInsnNode)new VarInsnNode(returnType.getOpcode(21), resultVariable.index));
                    result.instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
                    break;
                }
                default: {
                    AbstractInsnNode cloned = donorInsn.clone((Map)cloneMap);
                    result.instructions.add(cloned);
                }
            }
        }
        result.instructions.add((AbstractInsnNode)endScope);
        return result;
    }

    private void ensureInterruptibleExceptionCanBeThrown(MethodNode originalMethod) {
        for (String exception : originalMethod.exceptions) {
            if (!exception.equals(Type.getInternalName(InterruptedException.class)) && !exception.equals(Type.getInternalName(Throwable.class)) && !exception.equals(Type.getInternalName(Exception.class))) continue;
            return;
        }
        String msg = String.format("Transaction on Method '%s.%s' can't be made interruptible since it doesn't throw InterruptedException or Exception ", this.classNode.name.replace("/", "."), originalMethod.name);
        throw new RuntimeException(msg);
    }

    public static boolean isReplacementMethod(MethodInsnNode donorMethodInsnNode) {
        if (!donorMethodInsnNode.name.equals("execute___ro") && !donorMethodInsnNode.name.equals("execute___up")) {
            return false;
        }
        return donorMethodInsnNode.owner.equals(Type.getInternalName(TransactionLogicDonor.class));
    }

    public int newIndexOfLocalVariable(String methodName, String methodDesc, int originalVar) {
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodName, methodDesc);
        int firstPrivateLocalVar = AsmUtils.sizeOfFormalParameters((String)methodDesc);
        if (!methodMetadata.isStatic()) {
            ++firstPrivateLocalVar;
        }
        if (originalVar < firstPrivateLocalVar) {
            return originalVar;
        }
        if (this.indexOfTranlocalVariable(methodName, methodDesc) >= 0) {
            return originalVar + 2;
        }
        return originalVar + 1;
    }

    public int indexOfTranlocalVariable(String methodName, String methodDesc) {
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodName, methodDesc);
        if (methodMetadata.isStatic() || !methodMetadata.getClassMetadata().isTransactionalObjectWithObjectGranularFields()) {
            return -1;
        }
        return AsmUtils.sizeOfFormalParameters((String)methodDesc) + 2;
    }

    public int indexOfTransactionVariable(String methodName, String methodDesc) {
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(methodName, methodDesc);
        if (!methodMetadata.isTransactional()) {
            return -1;
        }
        int sizeOfFormalParameters = AsmUtils.sizeOfFormalParameters((String)methodDesc);
        return methodMetadata.isStatic() ? sizeOfFormalParameters : sizeOfFormalParameters + 1;
    }

    private String createTransactedMethodDesc(String methodDesc) {
        return AsmUtils.createMethodDescriptorWithRightIntroducedVariable((String)methodDesc, (String)ALPHA_TRANSACTION_INTERNAL_NAME);
    }

    private String createTranlocalMethodDesc(String methodName, String methodDesc) {
        return this.createTransactedWithTranlocalMethodDesc(this.classMetadata, methodName, methodDesc);
    }

    private String createTransactedWithTranlocalMethodDesc(ClassMetadata classMetadata, String methodName, String methodDesc) {
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata(methodName, methodDesc);
        if (methodMetadata.isStatic() || !methodMetadata.isTransactional()) {
            throw new IllegalStateException();
        }
        String result = AsmUtils.createMethodDescriptorWithRightIntroducedVariable((String)methodDesc, (String)ALPHA_TRANSACTION_INTERNAL_NAME);
        result = AsmUtils.createMethodDescriptorWithRightIntroducedVariable((String)result, (String)methodMetadata.getClassMetadata().getTranlocalName());
        return result;
    }
}

