/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.ClassTransactionalMethodTransformer;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.InterfaceTransactionalMethodTransformer;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.TransactionLogicDonor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;

public final class TransactionalMethodInstrumentationPhase
extends AbstractInstrumentationPhase {
    public TransactionalMethodInstrumentationPhase() {
        super("TransactionalMethodInstrumentationPhase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassMetadata classMetadata = environment.getMetadataRepository().loadClassMetadata(originalClazz.getClassLoader(), originalClazz.getName());
        if (!classMetadata.hasTransactionalMethods()) {
            return originalClazz;
        }
        ClassNode original = AsmUtils.loadAsClassNode((byte[])originalClazz.getBytecode());
        boolean restore = InsnList.check;
        InsnList.check = true;
        try {
            ClassNode result;
            Object transformer;
            ClassNode donor = AsmUtils.loadAsClassNode(TransactionLogicDonor.class);
            if (classMetadata.isInterface()) {
                transformer = new InterfaceTransactionalMethodTransformer(originalClazz.getClassLoader(), original, environment.getMetadataRepository());
                result = ((InterfaceTransactionalMethodTransformer)transformer).transform();
            } else {
                transformer = new ClassTransactionalMethodTransformer(originalClazz.getClassLoader(), original, donor, environment.getMetadataRepository(), environment.optimize(), environment.getLog());
                result = ((ClassTransactionalMethodTransformer)transformer).transform();
            }
            if (result == null) {
                transformer = originalClazz;
                return transformer;
            }
            byte[] newBytecode = AsmUtils.toBytecode((ClassNode)result);
            Clazz clazz = new Clazz(originalClazz, newBytecode);
            return clazz;
        }
        finally {
            InsnList.check = restore;
        }
    }
}

