/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalobject;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.stms.alpha.instrumentation.transactionalobject.TransactionalObjectTransformer;
import org.multiverse.stms.alpha.mixins.DefaultTxObjectMixin;
import org.objectweb.asm.tree.ClassNode;

public final class TransactionalObjectInstrumentationPhase
extends AbstractInstrumentationPhase {
    public TransactionalObjectInstrumentationPhase() {
        super("TransactionalObjectInstrumentationPhase");
    }

    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassMetadata classMetadata = environment.getMetadataRepository().loadClassMetadata(originalClazz.getClassLoader(), originalClazz.getName());
        if (!classMetadata.isTransactionalObjectWithObjectGranularFields()) {
            environment.getLog().lessImportant("%s is not a real transactional object", new Object[]{originalClazz.getName()});
            return originalClazz;
        }
        environment.getLog().lessImportant("%s is a real transactional object", new Object[]{originalClazz.getName()});
        ClassNode mixinClassNode = AsmUtils.loadAsClassNode(DefaultTxObjectMixin.class);
        ClassNode originalClassNode = AsmUtils.loadAsClassNode((byte[])originalClazz.getBytecode());
        TransactionalObjectTransformer transformer = new TransactionalObjectTransformer(originalClazz.getClassLoader(), originalClassNode, mixinClassNode, environment.getMetadataRepository());
        ClassNode result = transformer.transform();
        return new Clazz(originalClazz, AsmUtils.toBytecode((ClassNode)result));
    }
}

