/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalobject;

import java.util.HashSet;
import java.util.LinkedList;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransactionalObjectTransformer
implements Opcodes {
    private final ClassNode classNode;
    private final ClassNode mixinClassNode;
    private final ClassMetadata classMetadata;

    public TransactionalObjectTransformer(ClassLoader classLoader, ClassNode originalClass, ClassNode mixinClassNode, MetadataRepository metadataRepository) {
        this.classNode = originalClass;
        this.classMetadata = metadataRepository.loadClassMetadata(classLoader, originalClass.name);
        this.mixinClassNode = mixinClassNode;
    }

    public ClassNode transform() {
        this.ensureNoProblems();
        this.removeManagedFieldsWithObjectGranularity();
        this.fixUnmanagedFields();
        this.mergeMixin();
        this.classNode.methods.add(this.createOpenUnconstructedMethod());
        return this.classNode;
    }

    private void ensureNoProblems() {
        for (FieldNode fieldNode : this.classNode.fields) {
            if (!fieldNode.name.startsWith("___")) continue;
            String msg = String.format("Field '%s.%s' begins with illegal pattern '___'", this.classNode.name, fieldNode.name);
            throw new IllegalStateException(msg);
        }
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.startsWith("___")) continue;
            String msg = String.format("Method '%s.%s%s' begins with illegal patterns '___'", this.classNode.name, methodNode.name, methodNode.desc);
            throw new IllegalStateException(msg);
        }
    }

    private void fixUnmanagedFields() {
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (fieldMetadata.isManagedField()) continue;
            fieldNode.access = AsmUtils.upgradeToPublic((int)fieldNode.access);
            if (!AsmUtils.isFinal((int)fieldNode.access)) continue;
            fieldNode.access -= 16;
        }
    }

    private void removeManagedFieldsWithObjectGranularity() {
        LinkedList<FieldNode> fixedFields = new LinkedList<FieldNode>();
        for (FieldNode fieldNode : this.classNode.fields) {
            FieldMetadata fieldMetadata = this.classMetadata.getFieldMetadata(fieldNode.name);
            if (fieldMetadata.isManagedFieldWithObjectGranularity()) continue;
            fixedFields.add(fieldNode);
        }
        this.classNode.fields = fixedFields;
    }

    private void mergeMixin() {
        this.mergeStaticInitializers();
        this.mergeMixinInterfaces();
        this.mergeMixinFields();
        this.mergeMixinMethods();
    }

    private void mergeStaticInitializers() {
        SimpleRemapper remapper = new SimpleRemapper(this.mixinClassNode.name, this.classNode.name);
        MethodNode mixinStaticInit = this.findStaticInitializer(this.mixinClassNode);
        if (mixinStaticInit != null) {
            MethodNode txObjectStaticInit = this.findStaticInitializer(this.classNode);
            if (txObjectStaticInit == null) {
                MethodNode remappedInit = AsmUtils.remap((MethodNode)mixinStaticInit, (Remapper)remapper);
                this.classNode.methods.add(remappedInit);
            } else {
                MethodNode originalStaticInit = AsmUtils.remap((MethodNode)mixinStaticInit, (Remapper)remapper);
                originalStaticInit.name = "___clinit_mixin";
                txObjectStaticInit.name = "___clinit_txobject";
                MethodNode replacementStaticInit = new MethodNode();
                replacementStaticInit.name = "<clinit>";
                replacementStaticInit.desc = txObjectStaticInit.desc;
                replacementStaticInit.access = mixinStaticInit.access;
                replacementStaticInit.tryCatchBlocks = new LinkedList();
                replacementStaticInit.exceptions = new LinkedList();
                replacementStaticInit.localVariables = new LinkedList();
                replacementStaticInit.visitMethodInsn(184, this.classNode.name, originalStaticInit.name, "()V");
                replacementStaticInit.visitMethodInsn(184, this.classNode.name, txObjectStaticInit.name, "()V");
                replacementStaticInit.visitInsn(177);
                this.classNode.methods.add(replacementStaticInit);
                this.classNode.methods.add(originalStaticInit);
            }
        }
    }

    private void mergeMixinInterfaces() {
        HashSet interfaces = new HashSet();
        interfaces.addAll(this.classNode.interfaces);
        interfaces.addAll(this.mixinClassNode.interfaces);
        this.classNode.interfaces = new LinkedList(interfaces);
    }

    private void mergeMixinFields() {
        for (FieldNode mixinField : this.mixinClassNode.fields) {
            this.classNode.fields.add(mixinField);
        }
    }

    private void mergeMixinMethods() {
        SimpleRemapper remapper = new SimpleRemapper(this.mixinClassNode.name, this.classNode.name);
        for (MethodNode mixinMethodNode : this.mixinClassNode.methods) {
            if (mixinMethodNode.name.equals("<init>") || mixinMethodNode.name.equals("<clinit>")) continue;
            MethodNode remappedMethod = AsmUtils.remap((MethodNode)mixinMethodNode, (Remapper)remapper);
            this.classNode.methods.add(remappedMethod);
        }
    }

    private MethodNode findStaticInitializer(ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("<clinit>")) continue;
            return methodNode;
        }
        return null;
    }

    private MethodNode createOpenUnconstructedMethod() {
        String desc = "()" + Type.getDescriptor(AlphaTranlocal.class);
        MethodNode m = new MethodNode(4097, "___openUnconstructed", desc, null, new String[0]);
        m.visitTypeInsn(187, this.classMetadata.getTranlocalName());
        m.visitInsn(89);
        m.visitVarInsn(25, 0);
        String constructorDesc = String.format("(%s)V", AsmUtils.internalToDesc((String)this.classNode.name));
        m.visitMethodInsn(183, this.classMetadata.getTranlocalName(), "<init>", constructorDesc);
        m.visitInsn(176);
        return m;
    }
}

