/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.io.File;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Listeners;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.programmatic.ProgrammaticReference;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.mixins.DefaultTxObjectMixin;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReferenceTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public final class AlphaProgrammaticReference<E>
extends DefaultTxObjectMixin
implements ProgrammaticReference<E> {
    private static final TransactionFactory getOrAwaitTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setFamilyName(AlphaProgrammaticReference.class.getName() + ".getOrAwait()").setReadTrackingEnabled(true).build();
    private final AlphaStm stm;

    public static AlphaProgrammaticReference createUncommitted() {
        return new AlphaProgrammaticReference((File)null);
    }

    public AlphaProgrammaticReference() {
        this(ThreadLocalTransaction.getThreadLocalTransaction(), null);
    }

    private AlphaProgrammaticReference(File file) {
        this.stm = null;
    }

    public AlphaProgrammaticReference(E value) {
        this(ThreadLocalTransaction.getThreadLocalTransaction(), value);
    }

    public AlphaProgrammaticReference(Transaction tx) {
        this(tx, null);
    }

    public AlphaProgrammaticReference(AlphaStm stm, E value) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        long writeVersion = this.stm.getVersion();
        AlphaProgrammaticReferenceTranlocal tranlocal = new AlphaProgrammaticReferenceTranlocal(this);
        tranlocal.value = value;
        this.___storeInitial(tranlocal, writeVersion);
    }

    public AlphaProgrammaticReference(Transaction tx, E value) {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        if (tx == null || tx.getStatus().isDead()) {
            long writeVersion = this.stm.getVersion();
            AlphaProgrammaticReferenceTranlocal tranlocal = new AlphaProgrammaticReferenceTranlocal(this);
            tranlocal.value = value;
            this.___storeInitial(tranlocal, writeVersion);
            return;
        }
        AlphaProgrammaticReferenceTranlocal tranlocal = (AlphaProgrammaticReferenceTranlocal)alphaTx.openForConstruction(this);
        tranlocal.value = value;
    }

    private AlphaProgrammaticReferenceTranlocal<E> openForRead(Transaction tx) {
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        return (AlphaProgrammaticReferenceTranlocal)alphaTx.openForRead(this);
    }

    private AlphaProgrammaticReferenceTranlocal<E> openForWrite(Transaction tx) {
        AlphaTransaction alphaTx = (AlphaTransaction)tx;
        return (AlphaProgrammaticReferenceTranlocal)alphaTx.openForWrite(this);
    }

    public E get() {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicGet();
        }
        return this.get(tx);
    }

    public E get(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticReferenceTranlocal<E> tranlocal = this.openForRead(tx);
        return tranlocal.value;
    }

    public E atomicGet() {
        AlphaProgrammaticReferenceTranlocal tranlocal = (AlphaProgrammaticReferenceTranlocal)this.___load();
        if (tranlocal == null) {
            throw new UncommittedReadConflict();
        }
        return tranlocal.value;
    }

    public boolean isNull() {
        return this.get() == null;
    }

    public boolean isNull(Transaction tx) {
        return this.get(tx) == null;
    }

    public boolean atomicIsNull() {
        return this.atomicGet() == null;
    }

    public E getOrAwait() {
        return this.getOrAwait(getOrAwaitTxFactory);
    }

    public E getOrAwait(TransactionFactory txFactory) {
        return (E)new TransactionTemplate<E>(txFactory){

            public E execute(Transaction t) {
                return AlphaProgrammaticReference.this.getOrAwait(t);
            }
        }.execute();
    }

    public E getOrAwait(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticReferenceTranlocal<E> tranlocal = this.openForRead(tx);
        if (tranlocal.value == null) {
            StmUtils.retry();
        }
        return tranlocal.value;
    }

    public E set(E newValue) {
        Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
        if (tx == null || tx.getStatus().isDead()) {
            return this.atomicSet(newValue);
        }
        return this.set(tx, newValue);
    }

    public E set(Transaction tx, E newValue) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticReferenceTranlocal<E> readonly = this.openForRead(tx);
        if (readonly.value == newValue) {
            return newValue;
        }
        AlphaProgrammaticReferenceTranlocal<E> tranlocal = this.openForWrite(tx);
        if (newValue == tranlocal.value) {
            return newValue;
        }
        Object oldValue = tranlocal.value;
        tranlocal.value = newValue;
        return oldValue;
    }

    public E atomicSet(E newValue) {
        AlphaProgrammaticReferenceTranlocal committed = (AlphaProgrammaticReferenceTranlocal)this.___load();
        if (committed == null) {
            throw UncommittedReadConflict.createUncommittedReadConflict();
        }
        if (committed.value == newValue) {
            return newValue;
        }
        AlphaProgrammaticReferenceTranlocal newTranlocal = new AlphaProgrammaticReferenceTranlocal(this);
        newTranlocal.value = newValue;
        AlphaProgrammaticReferenceTranlocal lockOwner = newTranlocal;
        this.lock(lockOwner);
        AlphaProgrammaticReferenceTranlocal oldTranlocal = (AlphaProgrammaticReferenceTranlocal)this.___load();
        long writeVersion = this.stm.getClock().tick();
        Listeners listeners = this.___storeUpdate(newTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return oldTranlocal.value;
    }

    private void lock(Transaction lockOwner) {
        for (int attempt = 0; attempt <= this.stm.getMaxRetries(); ++attempt) {
            lockOwner.setAttempt(attempt);
            if (attempt == this.stm.getMaxRetries()) {
                throw new TooManyRetriesException();
            }
            if (this.___tryLock(lockOwner)) {
                return;
            }
            this.stm.getBackoffPolicy().delayedUninterruptible(lockOwner);
        }
    }

    public boolean atomicCompareAndSet(E expected, E update) {
        AlphaProgrammaticReferenceTranlocal committed = (AlphaProgrammaticReferenceTranlocal)this.___load();
        if (committed == null) {
            throw new UncommittedReadConflict();
        }
        if (committed.value != expected) {
            return false;
        }
        if (committed.value == update) {
            return true;
        }
        AlphaProgrammaticReferenceTranlocal updateTranlocal = new AlphaProgrammaticReferenceTranlocal(this);
        updateTranlocal.value = update;
        AlphaProgrammaticReferenceTranlocal lockOwner = updateTranlocal;
        if (!this.___tryLock(lockOwner)) {
            return false;
        }
        AlphaProgrammaticReferenceTranlocal oldTranlocal = (AlphaProgrammaticReferenceTranlocal)this.___load();
        if (oldTranlocal.value != expected) {
            this.___releaseLock(lockOwner);
            return false;
        }
        long writeVersion = this.stm.getClock().tick();
        Listeners listeners = this.___storeUpdate(updateTranlocal, writeVersion, true);
        if (listeners != null) {
            listeners.openAll();
        }
        return true;
    }

    public String toString() {
        E value = this.get();
        return this.toString(value);
    }

    public String toString(Transaction tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        AlphaProgrammaticReferenceTranlocal<E> tranlocal = this.openForRead(tx);
        return this.toString(tranlocal.value);
    }

    private String toString(E value) {
        if (value == null) {
            return "AlphaProgrammaticReference(reference=null)";
        }
        return String.format("AlphaProgrammaticReference(reference=%s)", value);
    }

    @Override
    public AlphaProgrammaticReferenceTranlocal<E> ___openUnconstructed() {
        return new AlphaProgrammaticReferenceTranlocal(this);
    }
}

