/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.commitlock.CommitLock;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.AbstractUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public final class ArrayUpdateAlphaTransaction
extends AbstractUpdateAlphaTransaction {
    private AlphaTranlocal[] attachedArray;
    private int firstFreeIndex;

    public ArrayUpdateAlphaTransaction(UpdateConfiguration config, int size) {
        super(config);
        this.attachedArray = new AlphaTranlocal[size];
        this.init();
    }

    @Override
    protected void dodoClear() {
        this.firstFreeIndex = 0;
        for (int k = 0; k < this.attachedArray.length; ++k) {
            this.attachedArray[k] = null;
        }
    }

    @Override
    protected boolean isDirty() {
        boolean isDirty = false;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            if (!this.isDirty(attached)) continue;
            isDirty = true;
        }
        return isDirty;
    }

    @Override
    public AlphaTranlocal doOpenForCommutingWrite(AlphaTransactionalObject txObject) {
        AlphaTranlocal opened;
        this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        int indexOf = this.indexOf(txObject);
        if (indexOf == -1) {
            opened = txObject.___openForCommutingOperation();
            this.attach(opened);
        } else {
            opened = this.attachedArray[indexOf];
            if (opened.isCommitted()) {
                this.attachedArray[indexOf] = opened = opened.openForWrite();
            }
        }
        return opened;
    }

    @Override
    protected AlphaTranlocal doOpenForWrite(AlphaTransactionalObject txObject) {
        this.updateTransactionStatus = this.updateTransactionStatus.upgradeToOpenForWrite();
        int indexOf = this.indexOf(txObject);
        if (indexOf == -1) {
            AlphaTranlocal committed = txObject.___load(this.getReadVersion());
            if (committed == null) {
                throw new UncommittedReadConflict();
            }
            AlphaTranlocal opened = committed.openForWrite();
            this.attach(opened);
            return opened;
        }
        AlphaTranlocal attached = this.attachedArray[indexOf];
        if (attached.isCommitted()) {
            this.attachedArray[indexOf] = attached = attached.openForWrite();
        } else if (attached.isCommuting()) {
            AlphaTranlocal origin = txObject.___load(this.getReadVersion());
            if (origin == null) {
                throw new UncommittedReadConflict();
            }
            attached.prematureFixation(this, origin);
        }
        return attached;
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        if (___SANITY_CHECKS_ENABLED && tranlocal.isUncommitted()) {
            throw new PanicError();
        }
        if (this.firstFreeIndex == this.attachedArray.length) {
            SpeculativeConfiguration speculativeConfig = ((UpdateConfiguration)this.config).speculativeConfiguration;
            speculativeConfig.signalSpeculativeSizeFailure(this.attachedArray.length);
            int newOptimalSize = speculativeConfig.getOptimalSize();
            if (newOptimalSize > speculativeConfig.getMaximumArraySize()) {
                throw SpeculativeConfigurationFailure.create();
            }
            AlphaTranlocal[] newAttachedArray = new AlphaTranlocal[newOptimalSize];
            System.arraycopy(this.attachedArray, 0, newAttachedArray, 0, this.attachedArray.length);
            this.attachedArray = newAttachedArray;
        }
        this.attachedArray[this.firstFreeIndex] = tranlocal;
        ++this.firstFreeIndex;
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject txObject) {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            if (attached.getTransactionalObject() != txObject) continue;
            if (k != 0) {
                AlphaTranlocal old = this.attachedArray[0];
                this.attachedArray[0] = attached;
                this.attachedArray[k] = old;
            }
            return attached;
        }
        return null;
    }

    private int indexOf(AlphaTransactionalObject txObject) {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            if (this.attachedArray[k].getTransactionalObject() != txObject) continue;
            return k;
        }
        return -1;
    }

    @Override
    protected boolean hasWriteConflict() {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            if (!this.hasWriteConflict(attached)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasReadConflict() {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            if (!this.hasReadConflict(attached)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        boolean trackedReads = false;
        block5: for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTransactionalObject txObject = this.attachedArray[k].getTransactionalObject();
            switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
                case noregistration: {
                    continue block5;
                }
                case registered: {
                    trackedReads = true;
                    continue block5;
                }
                case opened: {
                    return true;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return trackedReads;
    }

    @Override
    protected boolean tryWriteLocks(CommitLockFilter commitLockFilter) {
        return ((UpdateConfiguration)this.config).commitLockPolicy.tryAcquireAll((CommitLock[])this.attachedArray, commitLockFilter, (Transaction)this);
    }

    @Override
    protected void doReleaseWriteLocksForFailure() {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            this.doReleaseWriteSetLocksForFailure(this.attachedArray[k]);
        }
    }

    @Override
    protected void doReleaseWriteLocksForSuccess(long writeVersion) {
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            this.doReleaseWriteLockForSuccess(this.attachedArray[k], writeVersion);
        }
    }

    @Override
    protected Listeners[] makeChangesPermanent(long writeVersion) {
        Listeners[] listenersArray = null;
        int listenersIndex = 0;
        for (int k = 0; k < this.firstFreeIndex; ++k) {
            AlphaTranlocal attached = this.attachedArray[k];
            Listeners listeners = this.makePermanent(attached, writeVersion);
            if (listeners == null) continue;
            if (listenersArray == null) {
                listenersArray = new Listeners[this.firstFreeIndex - k];
            }
            listenersArray[listenersIndex] = listeners;
            ++listenersIndex;
        }
        return listenersArray;
    }
}

