/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Experimental
public class TUNNEL
extends TP {
    @Deprecated
    @Property(name="router_host", deprecatedMessage="router_host is deprecated. Specify target GRs using gossip_router_hosts", description="Router host address")
    private String router_host = null;
    @Deprecated
    @Property(name="router_port", deprecatedMessage="router_port is deprecated. Specify target GRs using gossip_router_hosts", description="Router port")
    private int router_port = 0;
    @Property(description="Interval in msec to attempt connecting back to router in case of torn connection. Default is 5000 msec")
    private long reconnect_interval = 5000L;
    private final List<InetSocketAddress> gossip_router_hosts = new ArrayList<InetSocketAddress>();
    private final List<RouterStub> stubs = new ArrayList<RouterStub>();
    private TUNNELPolicy tunnel_policy = new DefaultTUNNELPolicy();
    private DatagramSocket sock;
    private final Map<InetSocketAddress, Future<?>> reconnectFutures = new HashMap();
    private final Lock reconnectorLock = new ReentrantLock();

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    @Property
    public void setGossipRouterHosts(String hosts) throws UnknownHostException {
        this.gossip_router_hosts.clear();
        if (hosts.startsWith("[") && hosts.endsWith("]")) {
            hosts = hosts.substring(1, hosts.length() - 1);
        }
        this.gossip_router_hosts.addAll(Util.parseCommaDelimitedHosts2(hosts, 1));
    }

    @Override
    public String toString() {
        return "TUNNEL";
    }

    @Deprecated
    public String getRouterHost() {
        return this.router_host;
    }

    @Deprecated
    public void setRouterHost(String router_host) {
        this.router_host = router_host;
    }

    @Deprecated
    public int getRouterPort() {
        return this.router_port;
    }

    @Deprecated
    public void setRouterPort(int router_port) {
        this.router_port = router_port;
    }

    public long getReconnectInterval() {
        return this.reconnect_interval;
    }

    public void setReconnectInterval(long reconnect_interval) {
        this.reconnect_interval = reconnect_interval;
    }

    public synchronized void setTUNNELPolicy(TUNNELPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Tunnel policy has to be non null");
        }
        this.tunnel_policy = policy;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.enable_bundling) {
            this.log.warn("bundling is currently not supported by TUNNEL; bundling is disabled");
            this.enable_bundling = false;
        }
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if ((this.router_host == null || this.router_port == 0) && this.gossip_router_hosts.isEmpty()) {
            throw new Exception("either router_host and router_port have to be set or a list of gossip routers");
        }
        if (this.router_host != null && this.router_port != 0 && !this.gossip_router_hosts.isEmpty()) {
            throw new Exception("cannot specify both router host and port along with gossip_router_hosts");
        }
        if (this.router_host != null && this.router_port != 0 && this.gossip_router_hosts.isEmpty()) {
            this.gossip_router_hosts.add(new InetSocketAddress(this.router_host, this.router_port));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("GossipRouters are:" + this.gossip_router_hosts.toString());
        }
    }

    @Override
    public void start() throws Exception {
        this.loopback = true;
        this.sock = new DatagramSocket(0, this.bind_addr);
        super.start();
        for (InetSocketAddress gr : this.gossip_router_hosts) {
            RouterStub stub = new RouterStub(gr.getHostName(), gr.getPort(), this.bind_addr);
            stub.setConnectionListener(new StubConnectionListener(stub));
            this.stubs.add(stub);
        }
    }

    @Override
    public void destroy() {
        for (RouterStub stub : this.stubs) {
            this.stopReconnecting(stub);
            stub.destroy();
        }
        super.destroy();
    }

    private void disconnectStub(String group, Address addr) {
        for (RouterStub stub : this.stubs) {
            stub.disconnect(group, addr);
        }
    }

    @Override
    public Object handleDownEvent(Event evt) {
        Object retEvent = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                String group = (String)evt.getArg();
                Address local = null;
                if (!this.isSingleton()) {
                    local = this.local_addr;
                } else {
                    TP.ProtocolAdapter adapter = TP.ProtocolAdapter.thread_local.get();
                    local = adapter.local_addr;
                }
                PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, local));
                List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                String logical_name = UUID.get(local);
                this.tunnel_policy.connect(this.stubs, group, local, logical_name, physical_addrs);
                break;
            }
            case 4: {
                String group;
                Address local;
                if (!this.isSingleton()) {
                    local = this.local_addr;
                    group = this.channel_name;
                } else {
                    TP.ProtocolAdapter adapter = TP.ProtocolAdapter.thread_local.get();
                    local = adapter.local_addr;
                    group = adapter.cluster_name;
                }
                this.disconnectStub(group, local);
            }
        }
        return retEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReconnecting(final RouterStub stub) {
        this.reconnectorLock.lock();
        try {
            Future<?> reconnectorFuture = this.reconnectFutures.get(stub.getGossipRouterAddress());
            if (reconnectorFuture == null || reconnectorFuture.isDone()) {
                Runnable reconnector = new Runnable(){

                    @Override
                    public void run() {
                        block7: {
                            try {
                                if (TUNNEL.this.log.isInfoEnabled()) {
                                    TUNNEL.this.log.info("Reconnecting " + stub);
                                }
                                if (!TUNNEL.this.isSingleton()) {
                                    PhysicalAddress physical_addr = (PhysicalAddress)TUNNEL.this.down(new Event(87, TUNNEL.this.local_addr));
                                    List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                                    stub.connect(TUNNEL.this.channel_name, TUNNEL.this.local_addr, UUID.get(TUNNEL.this.local_addr), physical_addrs);
                                    if (TUNNEL.this.log.isInfoEnabled()) {
                                        TUNNEL.this.log.info("Reconnected " + stub);
                                    }
                                } else {
                                    for (Protocol p : TUNNEL.this.up_prots.values()) {
                                        if (!(p instanceof TP.ProtocolAdapter)) continue;
                                        Address local = ((TP.ProtocolAdapter)p).local_addr;
                                        String cluster_name = ((TP.ProtocolAdapter)p).cluster_name;
                                        PhysicalAddress physical_addr = (PhysicalAddress)TUNNEL.this.down(new Event(87, local));
                                        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                                        stub.connect(cluster_name, local, UUID.get(local), physical_addrs);
                                        if (!TUNNEL.this.log.isInfoEnabled()) continue;
                                        TUNNEL.this.log.info("Reconnected " + stub);
                                    }
                                }
                            }
                            catch (Throwable ex) {
                                if (!TUNNEL.this.log.isWarnEnabled()) break block7;
                                TUNNEL.this.log.warn("failed reconnecting stub to GR at " + stub.getGossipRouterAddress() + ": " + ex);
                            }
                        }
                    }
                };
                reconnectorFuture = this.timer.scheduleWithFixedDelay(reconnector, 0L, this.reconnect_interval, TimeUnit.MILLISECONDS);
                this.reconnectFutures.put(stub.getGossipRouterAddress(), reconnectorFuture);
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnecting(RouterStub stub) {
        this.reconnectorLock.lock();
        InetSocketAddress address = stub.getGossipRouterAddress();
        try {
            Future<?> reconnectorFuture = this.reconnectFutures.get(address);
            if (reconnectorFuture != null) {
                reconnectorFuture.cancel(true);
                this.reconnectFutures.remove(address);
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    @Override
    protected void send(Message msg, Address dest, boolean multicast) throws Exception {
        TpHeader hdr = (TpHeader)msg.getHeader(this.getName());
        if (hdr == null) {
            throw new Exception("message " + msg + " doesn't have a transport header, cannot route it");
        }
        String group = hdr.channel_name;
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream((int)(msg.size() + 50L));
        ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
        TUNNEL.writeMessage(msg, dos, multicast);
        Buffer buf = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.tunnel_policy.sendToAllMembers(this.stubs, group, buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.tunnel_policy.sendToSingleMember(this.stubs, group, dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendMulticast() should not get called on TUNNEL");
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendUnicast() should not get called on TUNNEL");
    }

    @Override
    public String getInfo() {
        if (this.stubs.isEmpty()) {
            return this.stubs.toString();
        }
        return "RouterStubs not yet initialized";
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.sock != null ? new IpAddress(this.bind_addr, this.sock.getLocalPort()) : null;
    }

    private class DefaultTUNNELPolicy
    implements TUNNELPolicy {
        private DefaultTUNNELPolicy() {
        }

        @Override
        public void sendToAllMembers(List<RouterStub> stubs, String group, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            if (stubs.size() > 1) {
                Collections.shuffle(stubs);
            }
            for (RouterStub stub : stubs) {
                try {
                    stub.sendToAllMembers(group, data, offset, length);
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("sent a message to all members, GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) continue;
                    TUNNEL.this.log.warn("failed sending a message to all members, GR used " + stub.getGossipRouterAddress());
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a multicast message");
            }
        }

        @Override
        public void sendToSingleMember(List<RouterStub> stubs, String group, Address dest, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            if (stubs.size() > 1) {
                Collections.shuffle(stubs);
            }
            for (RouterStub stub : stubs) {
                try {
                    stub.sendToMember(group, dest, data, offset, length);
                    if (TUNNEL.this.log.isDebugEnabled()) {
                        TUNNEL.this.log.debug("sent a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) continue;
                    TUNNEL.this.log.warn("failed sending a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a message for dest " + dest);
            }
        }

        @Override
        public void connect(List<RouterStub> stubs, String group, Address addr, String logical_name, List<PhysicalAddress> phys_addrs) {
            for (RouterStub stub : stubs) {
                try {
                    stub.connect(group, addr, logical_name, phys_addrs);
                }
                catch (Exception e) {
                    if (TUNNEL.this.log.isWarnEnabled()) {
                        TUNNEL.this.log.warn("Failed connecting to GossipRouter at " + stub.getGossipRouterAddress());
                    }
                    TUNNEL.this.startReconnecting(stub);
                }
            }
        }
    }

    public static interface TUNNELPolicy {
        public void connect(List<RouterStub> var1, String var2, Address var3, String var4, List<PhysicalAddress> var5);

        public void sendToAllMembers(List<RouterStub> var1, String var2, byte[] var3, int var4, int var5) throws Exception;

        public void sendToSingleMember(List<RouterStub> var1, String var2, Address var3, byte[] var4, int var5, int var6) throws Exception;
    }

    public class StubReceiver
    implements Runnable {
        private Thread runner;
        private final DataInputStream input;

        public StubReceiver(DataInputStream input) {
            this.input = input;
        }

        public synchronized void setThread(Thread t) {
            this.runner = t;
        }

        public synchronized Thread getThread() {
            return this.runner;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    GossipData msg = new GossipData();
                    msg.readFrom(this.input);
                    switch (msg.getType()) {
                        case 10: {
                            byte[] data = msg.getBuffer();
                            TUNNEL.this.receive(null, data, 0, data.length);
                            break;
                        }
                        case 11: {
                            final Address suspect = Util.readAddress(this.input);
                            TUNNEL.this.log.debug("Firing suspect event " + suspect + " at " + TUNNEL.this.local_addr);
                            if (suspect == null) break;
                            Thread thread = TUNNEL.this.getThreadFactory().newThread(new Runnable(){

                                @Override
                                public void run() {
                                    StubReceiver.this.fireSuspectEvent(suspect);
                                }
                            }, "StubReceiver-suspect");
                            thread.start();
                        }
                    }
                }
                catch (SocketTimeoutException ste) {
                }
                catch (SocketException se) {
                    break;
                }
                catch (IOException ioe) {
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) break;
                    TUNNEL.this.log.warn("failure in TUNNEL receiver thread", e);
                    break;
                }
            }
        }

        private void fireSuspectEvent(Address suspect) {
            TUNNEL.this.up(new Event(9, suspect));
        }
    }

    private class StubConnectionListener
    implements RouterStub.ConnectionListener {
        private volatile RouterStub.ConnectionStatus currentState = RouterStub.ConnectionStatus.INITIAL;
        private final RouterStub stub;

        public StubConnectionListener(RouterStub stub) {
            this.stub = stub;
        }

        @Override
        public void connectionStatusChange(RouterStub.ConnectionStatus newState) {
            if (newState == RouterStub.ConnectionStatus.DISCONNECTED) {
                this.stub.interrupt();
                TUNNEL.this.startReconnecting(this.stub);
            } else if (this.currentState != RouterStub.ConnectionStatus.CONNECTED && newState == RouterStub.ConnectionStatus.CONNECTED) {
                TUNNEL.this.stopReconnecting(this.stub);
                StubReceiver stubReceiver = new StubReceiver(this.stub.getInputStream());
                this.stub.setReceiver(stubReceiver);
                Thread t = TUNNEL.this.global_thread_factory.newThread(stubReceiver, "TUNNEL receiver for " + this.stub.toString());
                stubReceiver.setThread(t);
                t.setDaemon(true);
                t.start();
            }
            this.currentState = newState;
        }
    }
}

