/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NakReceiverWindowTest {
    private Address sender;
    private MyRetransmitCommand cmd = new MyRetransmitCommand();
    private TimeScheduler timer;

    @BeforeMethod
    void initTimer() {
        this.timer = new TimeScheduler();
    }

    @AfterMethod
    void destroyTimer() throws InterruptedException {
        this.timer.stop();
    }

    @BeforeClass
    protected void setUp() throws Exception {
        this.sender = Util.createRandomAddress();
    }

    public void test1() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 1L, this.timer);
        NakReceiverWindowTest.check(win, 0L, 1L, 1L);
        assert (win.get(23L) == null);
    }

    public void test2() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, this.timer);
        NakReceiverWindowTest.check(win, 0L, 100L, 100L);
    }

    public void test3() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        assert (win.get(1L) != null);
        NakReceiverWindowTest.check(win, 0L, 1L, 0L);
        win.add(2L, new Message());
        NakReceiverWindowTest.check(win, 0L, 2L, 0L);
        assert (win.get(2L) != null);
        win.remove();
        NakReceiverWindowTest.check(win, 0L, 2L, 1L);
        win.remove();
        NakReceiverWindowTest.check(win, 0L, 2L, 2L);
    }

    public void test4() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 1L, this.timer);
        win.add(2L, new Message());
        NakReceiverWindowTest.check(win, 0L, 2L, 1L);
    }

    public void test5() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, this.timer);
        win.add(101L, new Message());
        win.add(100L, new Message());
        NakReceiverWindowTest.check(win, 0L, 101L, 100L);
    }

    public void test6() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, this.timer);
        win.add(101L, new Message());
        System.out.println("win: " + win);
        win.add(100L, new Message());
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 0L, 101L, 100L);
        win.remove();
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 0L, 101L, 101L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 101L, 101L);
    }

    public void testLowerBounds() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, 50L, this.timer);
        win.add(101L, new Message());
        System.out.println("win: " + win);
        win.add(100L, new Message());
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 50L, 101L, 100L);
        win.remove();
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 50L, 101L, 101L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 50L, 101L, 101L);
    }

    public void test7() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.check(win, 0L, 4L, 0L);
        System.out.println("Note that the subsequent warning is expected:");
        win.stable(4L);
        NakReceiverWindowTest.check(win, 0L, 4L, 0L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 4L, 4L);
        win.stable(4L);
        NakReceiverWindowTest.check(win, 4L, 4L, 4L);
    }

    public void testLowerBounds2() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, 50L, this.timer);
        win.add(100L, new Message());
        win.add(101L, new Message());
        win.add(102L, new Message());
        win.add(103L, new Message());
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 50L, 103L, 100L);
        System.out.println("Note that the subsequent warning is expected:");
        win.stable(103L);
        NakReceiverWindowTest.check(win, 50L, 103L, 100L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 50L, 103L, 103L);
        win.stable(103L);
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 103L, 103L, 103L);
    }

    public void test8() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        win.add(6L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 0L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 6L, 4L);
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 4L);
        win.remove();
        NakReceiverWindowTest.check(win, 0L, 6L, 5L);
        win.remove();
        NakReceiverWindowTest.check(win, 0L, 6L, 6L);
        win.stable(4L);
        NakReceiverWindowTest.check(win, 4L, 6L, 6L);
        win.stable(6L);
        NakReceiverWindowTest.check(win, 6L, 6L, 6L);
    }

    public void testAdd() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        NakReceiverWindowTest.check(win, 0L, 0L, 0L);
        win.add(0L, new Message());
        NakReceiverWindowTest.check(win, 0L, 0L, 0L);
        win.add(1L, new Message());
        NakReceiverWindowTest.check(win, 0L, 1L, 0L);
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.check(win, 0L, 4L, 0L);
        win.add(6L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 0L);
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 0L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 6L, 6L);
        win.stable(4L);
        NakReceiverWindowTest.check(win, 4L, 6L, 6L);
        win.stable(6L);
        NakReceiverWindowTest.check(win, 6L, 6L, 6L);
    }

    public void test9() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        win.add(6L, new Message());
        System.out.println("win: " + win);
        while (win.remove() != null) {
        }
        win.stable(6L);
        System.out.println("win: " + win);
        assert (win.get(2L) != null);
        NakReceiverWindowTest.check(win, 0L, 6L, 4L);
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 4L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 6L, 6L);
        win.stable(6L);
        NakReceiverWindowTest.check(win, 6L, 6L, 6L);
    }

    public void testHighestDelivered() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.check(win, 0L, 4L, 0L);
        win.add(10L, new Message());
        NakReceiverWindowTest.check(win, 0L, 10L, 0L);
        System.out.println("win: " + win);
        win.add(9L, new Message());
        win.add(7L, new Message());
        win.add(8L, new Message());
        win.add(6L, new Message());
        win.add(5L, new Message());
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 0L, 10L, 0L);
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 10L, 10L);
        win.stable(5L);
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 5L, 10L, 10L);
        win.stable(10L);
        System.out.println("win: " + win);
        NakReceiverWindowTest.check(win, 10L, 10L, 10L);
    }

    public void testMissingMessages() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 5L, 0L);
        win.add(6L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 0L);
        System.out.println("win: " + win);
    }

    public void testMissingMessages2() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 5L, 0L);
        win.add(8L, new Message());
        NakReceiverWindowTest.check(win, 0L, 8L, 0L);
        win.add(9L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        System.out.println("win: " + win);
    }

    public void testMissingMessages3() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(5L, new Message());
        NakReceiverWindowTest.check(win, 0L, 5L, 0L);
        win.add(8L, new Message());
        NakReceiverWindowTest.check(win, 0L, 8L, 0L);
        win.add(9L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        System.out.println("win: " + win);
        win.add(2L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        win.add(7L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        win.add(6L, new Message());
        NakReceiverWindowTest.check(win, 0L, 9L, 0L);
        win.add(10L, new Message());
        NakReceiverWindowTest.check(win, 0L, 10L, 0L);
        win.add(11L, new Message());
        NakReceiverWindowTest.check(win, 0L, 11L, 0L);
        System.out.println("win: " + win);
    }

    public void testMissingMessages4() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, this.timer);
        win.add(101L, new Message());
        win.add(105L, new Message());
        NakReceiverWindowTest.check(win, 0L, 105L, 100L);
        win.add(108L, new Message());
        NakReceiverWindowTest.check(win, 0L, 108L, 100L);
        win.add(109L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 100L);
        System.out.println("win: " + win);
        win.add(102L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 100L);
        win.add(103L, new Message());
        win.add(104L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 100L);
        win.add(107L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 100L);
        win.add(106L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 100L);
        win.add(110L, new Message());
        NakReceiverWindowTest.check(win, 0L, 110L, 100L);
        win.add(110L, new Message());
        NakReceiverWindowTest.check(win, 0L, 110L, 100L);
        System.out.println("win: " + win);
    }

    public void testMissingMessages5() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 100L, this.timer);
        win.add(101L, new Message());
        NakReceiverWindowTest.check(win, 0L, 101L, 100L);
        win.add(108L, new Message());
        NakReceiverWindowTest.check(win, 0L, 108L, 100L);
        win.remove();
        win.add(109L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 101L);
        System.out.println("win: " + win);
        win.add(102L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 101L);
        win.add(103L, new Message());
        win.add(104L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 101L);
        win.add(107L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 101L);
        win.add(106L, new Message());
        win.add(105L, new Message());
        NakReceiverWindowTest.check(win, 0L, 109L, 101L);
        win.add(110L, new Message());
        NakReceiverWindowTest.check(win, 0L, 110L, 101L);
        win.add(110L, new Message());
        NakReceiverWindowTest.check(win, 0L, 110L, 101L);
        System.out.println("win: " + win);
    }

    public void test10() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        NakReceiverWindowTest.check(win, 0L, 4L, 4L);
    }

    public void test10a() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        win.stable(4L);
        NakReceiverWindowTest.check(win, 4L, 4L, 4L);
    }

    public void test11() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        while (win.remove() != null) {
        }
        win.reset();
        NakReceiverWindowTest.check(win, 0L, 0L, 0L);
    }

    public void test12() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message(null, null, new Integer(1)));
        win.add(2L, new Message(null, null, new Integer(2)));
        win.add(3L, new Message(null, null, new Integer(3)));
        Assert.assertEquals((int)1, (int)((Integer)win.remove().getObject()));
        Assert.assertEquals((int)2, (int)((Integer)win.remove().getObject()));
        Assert.assertEquals((int)3, (int)((Integer)win.remove().getObject()));
    }

    public void test13() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, new Message());
        win.add(2L, new Message());
        win.add(3L, new Message());
        win.add(4L, new Message());
        NakReceiverWindowTest.check(win, 0L, 4L, 0L);
        win.remove();
        win.remove();
        win.add(5L, new Message());
        win.add(6L, new Message());
        NakReceiverWindowTest.check(win, 0L, 6L, 2L);
        win.stable(2L);
        NakReceiverWindowTest.check(win, 2L, 6L, 2L);
    }

    public void testAddOOBAtHead() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        boolean rc = win.add(0L, NakReceiverWindowTest.oob());
        assert (!rc);
        rc = win.add(1L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(1L, NakReceiverWindowTest.oob());
        assert (!rc);
    }

    public void testAddOOBAtTail() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        boolean rc = win.add(1L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(2L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(2L, NakReceiverWindowTest.oob());
        assert (!rc);
    }

    public void testAddOOBInTheMiddle() throws Exception {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        boolean rc = win.add(3L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(3L, NakReceiverWindowTest.oob());
        assert (!rc);
        rc = win.add(1L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(1L, NakReceiverWindowTest.oob());
        assert (!rc);
        rc = win.add(2L, NakReceiverWindowTest.oob());
        assert (rc);
        rc = win.add(2L, NakReceiverWindowTest.oob());
        assert (!rc);
    }

    public void testUpdateHighestSeen() {
        this.add(1000);
        this.add(2000);
        this.add(3000);
        this.add(4000);
        this.add(5000);
        this.add(10000);
        this.add(15000);
        this.add(20000);
        this.add(30000);
    }

    public void test1000() {
        this.add(1000);
    }

    public void test10000() {
        this.add(10000);
    }

    public void testHasMessagesToRemove() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        assert (!win.hasMessagesToRemove());
        win.add(2L, new Message());
        assert (!win.hasMessagesToRemove());
        win.add(1L, NakReceiverWindowTest.oob());
        assert (win.hasMessagesToRemove());
        win.remove();
        assert (win.hasMessagesToRemove());
        win.remove();
        assert (!win.hasMessagesToRemove());
    }

    public void testRemoveOOBMessage() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        System.out.println("win = " + win);
        win.add(2L, NakReceiverWindowTest.msg());
        System.out.println("win = " + win);
        assert (win.removeOOBMessage() == null);
        assert (win.remove() == null);
        win.add(1L, NakReceiverWindowTest.oob());
        System.out.println("win = " + win);
        assert (win.removeOOBMessage() != null);
        System.out.println("win = " + win);
        assert (win.removeOOBMessage() == null);
        assert (win.remove() != null);
        assert (win.remove() == null);
        assert (win.removeOOBMessage() == null);
    }

    public void testRemoveOOBMessages() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(0L, NakReceiverWindowTest.msg());
        List<Message> list = win.removeOOBMessages();
        assert (list.isEmpty());
        win.add(1L, NakReceiverWindowTest.oob());
        win.add(2L, NakReceiverWindowTest.oob());
        win.add(3L, NakReceiverWindowTest.msg());
        win.add(4L, NakReceiverWindowTest.oob());
        list = win.removeOOBMessages();
        assert (list.size() == 2);
        list = win.removeOOBMessages();
        assert (list.isEmpty());
        win.remove();
        list = win.removeOOBMessages();
        assert (list.size() == 1);
    }

    public void testRemoveRegularAndOOBMessages() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, NakReceiverWindowTest.msg());
        System.out.println("win = " + win);
        win.remove();
        System.out.println("win = " + win);
        assert (win.getHighestDelivered() == 1L);
        win.add(3L, NakReceiverWindowTest.msg());
        win.remove();
        System.out.println("win = " + win);
        assert (win.getHighestDelivered() == 1L);
        win.add(2L, NakReceiverWindowTest.oob());
        win.removeOOBMessage();
        System.out.println("win = " + win);
        assert (win.getHighestDelivered() == 2L);
    }

    public void testRemoveMany() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, NakReceiverWindowTest.msg());
        win.add(2L, NakReceiverWindowTest.msg());
        win.add(3L, NakReceiverWindowTest.msg());
        win.add(5L, NakReceiverWindowTest.msg());
        win.add(6L, NakReceiverWindowTest.msg());
        System.out.println("win = " + win);
        List<Message> msgs = win.removeMany(null);
        System.out.println("msgs = " + msgs);
        assert (msgs.size() == 3);
        win.add(4L, NakReceiverWindowTest.msg());
        msgs = win.removeMany(null);
        System.out.println("msgs = " + msgs);
        assert (msgs.size() == 3);
    }

    public void testRetransmitter() {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 0L, this.timer);
        win.add(1L, NakReceiverWindowTest.msg());
        win.add(2L, NakReceiverWindowTest.msg());
        win.add(3L, NakReceiverWindowTest.msg());
        win.add(5L, NakReceiverWindowTest.msg());
        win.add(6L, NakReceiverWindowTest.msg());
        System.out.println("win = " + win);
        int num_pending_xmits = win.getPendingXmits();
        assert (num_pending_xmits == 1);
        win.add(4L, NakReceiverWindowTest.msg());
        num_pending_xmits = win.getPendingXmits();
        assert (num_pending_xmits == 0);
    }

    private void add(int num_msgs) {
        NakReceiverWindow win = new NakReceiverWindow(this.sender, this.cmd, 1L, this.timer);
        long start = System.currentTimeMillis();
        for (int i = 1; i < 1 + num_msgs; ++i) {
            win.add(i, new Message());
        }
        long stop = System.currentTimeMillis();
        double time_per_msg = (double)(stop - start) / (double)num_msgs;
        System.out.println("-- time for " + num_msgs + " msgs: " + (stop - start) + ", " + time_per_msg + " ms/msg");
    }

    private static Message oob() {
        Message retval = new Message();
        retval.setFlag((byte)1);
        return retval;
    }

    private static Message msg() {
        return new Message();
    }

    private static void check(NakReceiverWindow win, long lowest, long highest_received, long highest_delivered) {
        Assert.assertEquals((long)win.getLowestSeen(), (long)lowest, (String)("lowest=" + lowest + ", win.lowest=" + win.getLowestSeen()));
        Assert.assertEquals((long)win.getHighestReceived(), (long)highest_received, (String)("highest_received=" + highest_received + ", win.highest_received=" + win.getHighestReceived()));
        Assert.assertEquals((long)win.getHighestDelivered(), (long)highest_delivered, (String)("highest_delivered=" + highest_delivered + ", win.highest_delivered=" + win.getHighestDelivered()));
    }

    private static class MyRetransmitCommand
    implements Retransmitter.RetransmitCommand {
        private MyRetransmitCommand() {
        }

        @Override
        public void retransmit(long first_seqno, long last_seqno, Address sender) {
        }
    }
}

