/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;

public class ResponseCollector<T> {
    private final Map<Address, T> responses;
    private final Lock lock = new ReentrantLock(false);
    private final Condition cond = this.lock.newCondition();

    public ResponseCollector(Collection<Address> members) {
        this.responses = members != null ? new HashMap(members.size()) : new HashMap();
        this.reset(members);
    }

    public ResponseCollector(Address ... members) {
        this.responses = members != null ? new HashMap(members.length) : new HashMap();
        this.reset(members);
    }

    public ResponseCollector() {
        this.responses = new HashMap<Address, T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Address member, T data) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.containsKey(member)) {
                this.responses.put(member, data);
                this.cond.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address member) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            this.responses.remove(member);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Address member) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.remove(member) != null) {
                this.cond.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAllResponses() {
        this.lock.lock();
        try {
            for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
                if (entry.getValue() != null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<Address, T> getResults() {
        return Collections.unmodifiableMap(this.responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.responses.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAllResponses(long timeout) {
        if (timeout <= 0L) {
            timeout = 2000L;
        }
        long end_time = System.currentTimeMillis() + timeout;
        this.lock.lock();
        try {
            while (!this.hasAllResponses()) {
                long wait_time = end_time - System.currentTimeMillis();
                if (wait_time <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.cond.await(wait_time, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    boolean bl = false;
                    this.lock.unlock();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.reset((Collection<Address>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<Address> members) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members != null) {
                for (Address mbr : members) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Address ... members) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members != null) {
                for (Address mbr : members) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.responses).append(", complete=").append(this.hasAllResponses());
        return sb.toString();
    }
}

