/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.auth.AuthToken;
import org.jgroups.blocks.Connection;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Queue;
import org.jgroups.util.Range;
import org.jgroups.util.StackType;
import org.jgroups.util.Streamable;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.UnmodifiableVector;

public class Util {
    private static NumberFormat f;
    private static Map<Class, Byte> PRIMITIVE_TYPES;
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_STREAMABLE = 1;
    private static final byte TYPE_SERIALIZABLE = 2;
    private static final byte TYPE_BOOLEAN = 10;
    private static final byte TYPE_BYTE = 11;
    private static final byte TYPE_CHAR = 12;
    private static final byte TYPE_DOUBLE = 13;
    private static final byte TYPE_FLOAT = 14;
    private static final byte TYPE_INT = 15;
    private static final byte TYPE_LONG = 16;
    private static final byte TYPE_SHORT = 17;
    private static final byte TYPE_STRING = 18;
    private static final byte TYPE_BYTEARRAY = 19;
    public static final int MAX_PORT = 65535;
    static boolean resolve_dns;
    static boolean JGROUPS_COMPAT;
    private static short COUNTER;
    private static Pattern METHOD_NAME_TO_ATTR_NAME_PATTERN;
    private static Pattern ATTR_NAME_TO_METHOD_NAME_PATTERN;
    private static ThreadGroup GLOBAL_GROUP;
    private static Method NETWORK_INTERFACE_IS_UP;
    private static Method NETWORK_INTERFACE_IS_LOOPBACK;

    public static ThreadGroup getGlobalThreadGroup() {
        return GLOBAL_GROUP;
    }

    public static void assertTrue(boolean condition) {
        assert (condition);
    }

    public static void assertTrue(String message, boolean condition) {
        if (message != null) {
            assert (condition) : message;
        } else assert (condition);
    }

    public static void assertFalse(boolean condition) {
        Util.assertFalse(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        if (message != null) {
            assert (!condition) : message;
        } else assert (!condition);
    }

    public static void assertEquals(String message, Object val1, Object val2) {
        if (message != null) {
            assert (val1.equals(val2)) : message;
        } else assert (val1.equals(val2));
    }

    public static void assertEquals(Object val1, Object val2) {
        Util.assertEquals(null, val1, val2);
    }

    public static void assertNotNull(String message, Object val) {
        if (message != null) {
            assert (val != null) : message;
        } else assert (val != null);
    }

    public static void assertNotNull(Object val) {
        Util.assertNotNull(null, val);
    }

    public static void assertNull(String message, Object val) {
        if (message != null) {
            assert (val == null) : message;
        } else assert (val == null);
    }

    public static void blockUntilViewsReceived(long timeout, long interval, Channel ... channels) throws TimeoutException {
        int expected_size = channels.length;
        if (interval > timeout) {
            throw new IllegalArgumentException("interval needs to be smaller than timeout");
        }
        long end_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end_time) {
            boolean all_ok = true;
            for (Channel ch : channels) {
                View view = ch.getView();
                if (view != null && view.size() == expected_size) continue;
                all_ok = false;
                break;
            }
            if (all_ok) {
                return;
            }
            Util.sleep(interval);
        }
        throw new TimeoutException();
    }

    public static void addFlush(Channel ch, FLUSH flush) {
        if (ch == null || flush == null) {
            throw new IllegalArgumentException("ch and flush have to be non-null");
        }
        ProtocolStack stack = ch.getProtocolStack();
        stack.insertProtocolAtTop(flush);
    }

    public static void connect(Socket sock, SocketAddress dest, int sock_conn_timeout) throws IOException {
        Inet6Address tmp;
        InetAddress addr;
        if (dest instanceof InetSocketAddress && (addr = ((InetSocketAddress)dest).getAddress()) instanceof Inet6Address && (tmp = (Inet6Address)addr).getScopeId() != 0) {
            dest = new InetSocketAddress(InetAddress.getByAddress(tmp.getAddress()), ((InetSocketAddress)dest).getPort());
        }
        sock.connect(dest, sock_conn_timeout);
    }

    public static void close(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(DatagramSocket my_sock) {
        if (my_sock != null) {
            try {
                my_sock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Channel ch) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Channel ... channels) {
        if (channels != null) {
            for (Channel ch : channels) {
                Util.close(ch);
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void shutdown(Channel ch) throws Exception {
        View view;
        DISCARD discard = new DISCARD();
        discard.setLocalAddress(ch.getAddress());
        discard.setDiscardAll(true);
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        stack.insertProtocol((Protocol)discard, 1, transport.getClass());
        FD_SOCK fd = (FD_SOCK)ch.getProtocolStack().findProtocol("FD_SOCK");
        if (fd != null) {
            fd.stopServerSocket(false);
        }
        if ((view = ch.getView()) != null) {
            ViewId vid = view.getViewId();
            List<Address> members = Arrays.asList(ch.getAddress());
            ViewId new_vid = new ViewId(ch.getAddress(), vid.getId() + 1L);
            View new_view = new View(new_vid, members);
            GMS gms = (GMS)stack.findProtocol(GMS.class);
            gms.installView(new_view);
        }
        Util.close(ch);
    }

    public static byte setFlag(byte bits, byte flag) {
        bits = (byte)(bits | flag);
        return bits;
    }

    public static boolean isFlagSet(byte bits, byte flag) {
        return (bits & flag) == flag;
    }

    public static byte clearFlags(byte bits, byte flag) {
        bits = (byte)(bits & ~flag);
        return bits;
    }

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        if (JGROUPS_COMPAT) {
            return Util.oldObjectFromByteBuffer(buffer);
        }
        return Util.objectFromByteBuffer(buffer, 0, buffer.length);
    }

    /*
     * Exception decompiling
     */
    public static Object objectFromByteBuffer(byte[] buffer, int offset, int length) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        OutputStream out;
        ByteArrayOutputStream out_stream;
        block22: {
            if (JGROUPS_COMPAT) {
                return Util.oldObjectToByteBuffer(obj);
            }
            out_stream = new ByteArrayOutputStream(512);
            if (obj == null) {
                out_stream.write(0);
                out_stream.flush();
                return out_stream.toByteArray();
            }
            out = null;
            try {
                if (obj instanceof Streamable) {
                    out_stream.write(1);
                    out = new DataOutputStream(out_stream);
                    Util.writeGenericStreamable((Streamable)obj, (DataOutputStream)out);
                    break block22;
                }
                Byte type = PRIMITIVE_TYPES.get(obj.getClass());
                if (type != null) {
                    out_stream.write(type.byteValue());
                    out = new DataOutputStream(out_stream);
                    switch (type) {
                        case 10: {
                            ((DataOutputStream)out).writeBoolean((Boolean)obj);
                            break;
                        }
                        case 11: {
                            ((DataOutputStream)out).writeByte(((Byte)obj).byteValue());
                            break;
                        }
                        case 12: {
                            ((DataOutputStream)out).writeChar(((Character)obj).charValue());
                            break;
                        }
                        case 13: {
                            ((DataOutputStream)out).writeDouble((Double)obj);
                            break;
                        }
                        case 14: {
                            ((DataOutputStream)out).writeFloat(((Float)obj).floatValue());
                            break;
                        }
                        case 15: {
                            ((DataOutputStream)out).writeInt((Integer)obj);
                            break;
                        }
                        case 16: {
                            ((DataOutputStream)out).writeLong((Long)obj);
                            break;
                        }
                        case 17: {
                            ((DataOutputStream)out).writeShort(((Short)obj).shortValue());
                            break;
                        }
                        case 18: {
                            String str = (String)obj;
                            if (str.length() > Short.MAX_VALUE) {
                                ((DataOutputStream)out).writeBoolean(true);
                                ObjectOutputStream oos = new ObjectOutputStream(out);
                                try {
                                    oos.writeObject(str);
                                    break block22;
                                }
                                finally {
                                    oos.close();
                                }
                            }
                            ((DataOutputStream)out).writeBoolean(false);
                            ((DataOutputStream)out).writeUTF(str);
                            break;
                        }
                        case 19: {
                            byte[] buf = (byte[])obj;
                            ((DataOutputStream)out).writeInt(buf.length);
                            out.write(buf, 0, buf.length);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("type " + type + " is invalid");
                        }
                    }
                    break block22;
                }
                out_stream.write(2);
                out = new ObjectOutputStream(out_stream);
                ((ObjectOutputStream)out).writeObject(obj);
            }
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
        }
        Util.close(out);
        byte[] result = out_stream.toByteArray();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectToStream(Object obj, DataOutputStream out) throws Exception {
        block22: {
            if (obj == null) {
                out.write(0);
                return;
            }
            try {
                if (obj instanceof Streamable) {
                    out.write(1);
                    Util.writeGenericStreamable((Streamable)obj, out);
                    break block22;
                }
                Byte type = PRIMITIVE_TYPES.get(obj.getClass());
                if (type != null) {
                    out.write(type.byteValue());
                    switch (type) {
                        case 10: {
                            out.writeBoolean((Boolean)obj);
                            break;
                        }
                        case 11: {
                            out.writeByte(((Byte)obj).byteValue());
                            break;
                        }
                        case 12: {
                            out.writeChar(((Character)obj).charValue());
                            break;
                        }
                        case 13: {
                            out.writeDouble((Double)obj);
                            break;
                        }
                        case 14: {
                            out.writeFloat(((Float)obj).floatValue());
                            break;
                        }
                        case 15: {
                            out.writeInt((Integer)obj);
                            break;
                        }
                        case 16: {
                            out.writeLong((Long)obj);
                            break;
                        }
                        case 17: {
                            out.writeShort(((Short)obj).shortValue());
                            break;
                        }
                        case 18: {
                            String str = (String)obj;
                            if (str.length() > Short.MAX_VALUE) {
                                out.writeBoolean(true);
                                ObjectOutputStream oos = new ObjectOutputStream(out);
                                try {
                                    oos.writeObject(str);
                                    break block22;
                                }
                                finally {
                                    oos.close();
                                }
                            }
                            out.writeBoolean(false);
                            out.writeUTF(str);
                            break;
                        }
                        case 19: {
                            byte[] buf = (byte[])obj;
                            out.writeInt(buf.length);
                            out.write(buf, 0, buf.length);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("type " + type + " is invalid");
                        }
                    }
                    break block22;
                }
                out.write(2);
                ObjectOutputStream tmp = new ObjectOutputStream(out);
                tmp.writeObject(obj);
            }
            finally {
                Util.close(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectFromStream(DataInputStream in) throws Exception {
        if (in == null) {
            return null;
        }
        Object retval = null;
        byte b = (byte)in.read();
        switch (b) {
            case 0: {
                return null;
            }
            case 1: {
                retval = Util.readGenericStreamable(in);
                break;
            }
            case 2: {
                ObjectInputStream tmp = new ObjectInputStream(in);
                retval = tmp.readObject();
                break;
            }
            case 10: {
                retval = in.readBoolean();
                break;
            }
            case 11: {
                retval = in.readByte();
                break;
            }
            case 12: {
                retval = Character.valueOf(in.readChar());
                break;
            }
            case 13: {
                retval = in.readDouble();
                break;
            }
            case 14: {
                retval = Float.valueOf(in.readFloat());
                break;
            }
            case 15: {
                retval = in.readInt();
                break;
            }
            case 16: {
                retval = in.readLong();
                break;
            }
            case 17: {
                retval = in.readShort();
                break;
            }
            case 18: {
                if (in.readBoolean()) {
                    ObjectInputStream ois = new ObjectInputStream(in);
                    try {
                        retval = ois.readObject();
                        break;
                    }
                    finally {
                        ois.close();
                    }
                }
                retval = in.readUTF();
                break;
            }
            case 19: {
                int len = in.readInt();
                byte[] tmpbuf = new byte[len];
                in.readFully(tmpbuf, 0, tmpbuf.length);
                retval = tmpbuf;
                break;
            }
            default: {
                throw new IllegalArgumentException("type " + b + " is invalid");
            }
        }
        return retval;
    }

    public static Object oldObjectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        return Util.oldObjectFromByteBuffer(buffer, 0, buffer.length);
    }

    public static Object oldObjectFromByteBuffer(byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        Object retval = null;
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
            ObjectInputStream in = new ObjectInputStream(in_stream);
            retval = in.readObject();
            in.close();
        }
        catch (StreamCorruptedException sce) {
            try {
                ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
                DataInputStream in = new DataInputStream(in_stream);
                retval = Util.readGenericStreamable(in);
                in.close();
            }
            catch (Exception ee) {
                IOException tmp = new IOException("unmarshalling failed");
                tmp.initCause(ee);
                throw tmp;
            }
        }
        if (retval == null) {
            return null;
        }
        return retval;
    }

    public static byte[] oldObjectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        if (obj instanceof Streamable) {
            DataOutputStream out = new DataOutputStream(out_stream);
            Util.writeGenericStreamable((Streamable)obj, out);
            out.close();
        } else {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            out.close();
        }
        result = out_stream.toByteArray();
        return result;
    }

    public static Streamable streamableFromByteBuffer(Class cl, byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        Streamable retval = null;
        ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
        DataInputStream in = new DataInputStream(in_stream);
        retval = (Streamable)cl.newInstance();
        retval.readFrom(in);
        in.close();
        return retval;
    }

    public static Streamable streamableFromByteBuffer(Class cl, byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        Streamable retval = null;
        ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(in_stream);
        retval = (Streamable)cl.newInstance();
        retval.readFrom(in);
        in.close();
        return retval;
    }

    public static byte[] streamableToByteBuffer(Streamable obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(out_stream);
        obj.writeTo(out);
        result = out_stream.toByteArray();
        out.close();
        return result;
    }

    public static byte[] collectionToByteBuffer(Collection<Address> c) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(out_stream);
        Util.writeAddresses(c, out);
        result = out_stream.toByteArray();
        out.close();
        return result;
    }

    public static void writeAuthToken(AuthToken token, DataOutputStream out) throws IOException {
        Util.writeString(token.getName(), out);
        token.writeTo(out);
    }

    public static AuthToken readAuthToken(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        try {
            String type = Util.readString(in);
            Object obj = Class.forName(type).newInstance();
            AuthToken token = (AuthToken)obj;
            token.readFrom(in);
            return token;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static void writeView(View view, DataOutputStream out) throws IOException {
        if (view == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeBoolean(view instanceof MergeView);
        view.writeTo(out);
    }

    public static View readView(DataInputStream in) throws IOException, InstantiationException, IllegalAccessException {
        if (!in.readBoolean()) {
            return null;
        }
        boolean isMergeView = in.readBoolean();
        View view = isMergeView ? new MergeView() : new View();
        view.readFrom(in);
        return view;
    }

    public static void writeAddress(Address addr, DataOutputStream out) throws IOException {
        byte flags = 0;
        boolean streamable_addr = true;
        if (addr == null) {
            flags = Util.setFlag(flags, (byte)1);
            out.writeByte(flags);
            return;
        }
        if (addr instanceof UUID) {
            flags = Util.setFlag(flags, (byte)2);
        } else if (addr instanceof IpAddress) {
            flags = Util.setFlag(flags, (byte)4);
        } else {
            streamable_addr = false;
        }
        out.writeByte(flags);
        if (streamable_addr) {
            addr.writeTo(out);
        } else {
            Util.writeOtherAddress(addr, out);
        }
    }

    public static Address readAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Address addr;
        byte flags = in.readByte();
        if (Util.isFlagSet(flags, (byte)1)) {
            return null;
        }
        if (Util.isFlagSet(flags, (byte)2)) {
            addr = new UUID();
            addr.readFrom(in);
        } else if (Util.isFlagSet(flags, (byte)4)) {
            addr = new IpAddress();
            addr.readFrom(in);
        } else {
            addr = Util.readOtherAddress(in);
        }
        return addr;
    }

    public static int size(Address addr) {
        int retval = 1;
        if (addr != null) {
            if (addr instanceof UUID || addr instanceof IpAddress) {
                retval += addr.size();
            } else {
                retval += 2;
                retval += addr.size();
            }
        }
        return retval;
    }

    public static int size(View view) {
        int retval = 1;
        if (view != null) {
            retval += view.serializedSize() + 1;
        }
        return retval;
    }

    private static Address readOtherAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        short magic_number = in.readShort();
        Class cl = ClassConfigurator.get(magic_number);
        if (cl == null) {
            throw new RuntimeException("class for magic number " + magic_number + " not found");
        }
        Address addr = (Address)cl.newInstance();
        addr.readFrom(in);
        return addr;
    }

    private static void writeOtherAddress(Address addr, DataOutputStream out) throws IOException {
        short magic_number = ClassConfigurator.getMagicNumber(addr.getClass());
        if (magic_number == -1) {
            throw new RuntimeException("magic number " + magic_number + " not found");
        }
        out.writeShort(magic_number);
        addr.writeTo(out);
    }

    public static void writeAddresses(Collection<? extends Address> v, DataOutputStream out) throws IOException {
        if (v == null) {
            out.writeShort(-1);
            return;
        }
        out.writeShort(v.size());
        for (Address address : v) {
            Util.writeAddress(address, out);
        }
    }

    public static Collection<? extends Address> readAddresses(DataInputStream in, Class cl) throws IOException, IllegalAccessException, InstantiationException {
        int length = in.readShort();
        if (length < 0) {
            return null;
        }
        Collection retval = (Collection)cl.newInstance();
        for (int i = 0; i < length; ++i) {
            Address addr = Util.readAddress(in);
            retval.add(addr);
        }
        return retval;
    }

    public static long size(Collection<? extends Address> addrs) {
        int retval = 2;
        if (addrs != null && !addrs.isEmpty()) {
            Address addr = addrs.iterator().next();
            retval += Util.size(addr) * addrs.size();
        }
        return retval;
    }

    public static void writeStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        obj.writeTo(out);
    }

    public static Streamable readStreamable(Class clazz, DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Streamable retval = null;
        if (!in.readBoolean()) {
            return null;
        }
        retval = (Streamable)clazz.newInstance();
        retval.readFrom(in);
        return retval;
    }

    public static void writeGenericStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.write(0);
            return;
        }
        out.write(1);
        short magic_number = ClassConfigurator.getMagicNumber(obj.getClass());
        if (magic_number == -1) {
            out.writeBoolean(false);
            String classname = obj.getClass().getName();
            out.writeUTF(classname);
        } else {
            out.writeBoolean(true);
            out.writeShort(magic_number);
        }
        obj.writeTo(out);
    }

    public static Streamable readGenericStreamable(DataInputStream in) throws IOException {
        Streamable retval = null;
        int b = in.read();
        if (b == 0) {
            return null;
        }
        boolean use_magic_number = in.readBoolean();
        try {
            Class clazz;
            if (use_magic_number) {
                short magic_number = in.readShort();
                clazz = ClassConfigurator.get(magic_number);
                if (clazz == null) {
                    throw new ClassNotFoundException("Class for magic number " + magic_number + " cannot be found.");
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.get(classname);
                if (clazz == null) {
                    throw new ClassNotFoundException(classname);
                }
            }
            retval = (Streamable)clazz.newInstance();
            retval.readFrom(in);
            return retval;
        }
        catch (Exception ex) {
            throw new IOException("failed reading object: " + ex.toString());
        }
    }

    public static void writeObject(Object obj, DataOutputStream out) throws Exception {
        if (obj == null || !(obj instanceof Streamable)) {
            byte[] buf = Util.objectToByteBuffer(obj);
            out.writeShort(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.writeShort(-1);
            Util.writeGenericStreamable((Streamable)obj, out);
        }
    }

    public static Object readObject(DataInputStream in) throws Exception {
        short len = in.readShort();
        Object retval = null;
        if (len == -1) {
            retval = Util.readGenericStreamable(in);
        } else {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            retval = Util.objectFromByteBuffer(buf);
        }
        return retval;
    }

    public static void writeString(String s, DataOutputStream out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeAsciiString(String str, DataOutputStream out) throws IOException {
        if (str == null) {
            out.write(-1);
            return;
        }
        int length = str.length();
        if (length > 127) {
            throw new IllegalArgumentException("string is > 127");
        }
        out.write(length);
        out.writeBytes(str);
    }

    public static String readAsciiString(DataInputStream in) throws IOException {
        byte length = (byte)in.read();
        if (length == -1) {
            return null;
        }
        byte[] tmp = new byte[length];
        in.readFully(tmp, 0, tmp.length);
        return new String(tmp, 0, tmp.length);
    }

    public static String parseString(DataInputStream in) {
        return Util.parseString(in, false);
    }

    public static String parseString(DataInputStream in, boolean break_on_newline) {
        int ch;
        StringBuilder sb = new StringBuilder();
        try {
            block7: {
                do {
                    if ((ch = in.read()) == -1) {
                        return null;
                    }
                    if (!Character.isWhitespace(ch)) break block7;
                } while (!break_on_newline || ch != 10);
                return null;
            }
            sb.append((char)ch);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            while ((ch = in.read()) != -1 && !Character.isWhitespace(ch)) {
                sb.append((char)ch);
            }
        }
        catch (IOException e) {
        }
        return sb.toString();
    }

    public static String readStringFromStdin(String message) throws Exception {
        System.out.print(message);
        System.out.flush();
        System.in.skip(System.in.available());
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine().trim();
    }

    public static long readLongFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Long.parseLong(tmp);
    }

    public static double readDoubleFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Double.parseDouble(tmp);
    }

    public static int readIntFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Integer.parseInt(tmp);
    }

    public static void writeByteBuffer(byte[] buf, DataOutputStream out) throws IOException {
        Util.writeByteBuffer(buf, 0, buf.length, out);
    }

    public static void writeByteBuffer(byte[] buf, int offset, int length, DataOutputStream out) throws IOException {
        if (buf != null) {
            out.write(1);
            out.writeInt(length);
            out.write(buf, offset, length);
        } else {
            out.write(0);
        }
    }

    public static byte[] readByteBuffer(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            b = in.readInt();
            byte[] buf = new byte[b];
            in.readFully(buf, 0, buf.length);
            return buf;
        }
        return null;
    }

    public static Buffer messageToByteBuffer(Message msg) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        out.writeBoolean(msg != null);
        if (msg != null) {
            msg.writeTo(out);
        }
        out.flush();
        Buffer retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static Message byteBufferToMessage(byte[] buffer, int offset, int length) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        if (!in.readBoolean()) {
            return null;
        }
        Message msg = new Message(false);
        msg.readFrom(in);
        return msg;
    }

    public static Buffer msgListToByteBuffer(List<Message> xmit_list) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        Buffer retval = null;
        out.writeInt(xmit_list.size());
        for (Message msg : xmit_list) {
            msg.writeTo(out);
        }
        out.flush();
        retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static List<Message> byteBufferToMessageList(byte[] buffer, int offset, int length) throws Exception {
        LinkedList<Message> retval = null;
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        int size = in.readInt();
        if (size == 0) {
            return null;
        }
        retval = new LinkedList<Message>();
        for (int i = 0; i < size; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            retval.add(msg);
        }
        return retval;
    }

    public static boolean match(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }

    public static boolean sameViewId(ViewId one, ViewId two) {
        return one.getId() == two.getId() && one.getCoordAddress().equals(two.getCoordAddress());
    }

    public static boolean match(long[] a1, long[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1 == a2) {
            return true;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long timeout, int nanos) {
        try {
            Thread.sleep(timeout, nanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long msecs, boolean busy_sleep) {
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static int keyPress(String msg) {
        System.out.println(msg);
        try {
            int ret = System.in.read();
            System.in.skip(System.in.available());
            return ret;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * (double)range % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) {
        if (timeout <= 0L) {
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        Util.sleep(r);
    }

    public static void sleepRandom(long floor, long ceiling) {
        if (ceiling - floor <= 0L) {
            return;
        }
        long diff = ceiling - floor;
        long r = (long)((int)(Math.random() * 100000.0 % (double)diff)) + floor;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exit) {
                System.exit(0);
            }
            return;
        }
    }

    public static String dumpThreads() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] ids = bean.getAllThreadIds();
        ThreadInfo[] threads = bean.getThreadInfo(ids, 20);
        for (int i = 0; i < threads.length; ++i) {
            ThreadInfo info = threads[i];
            if (info == null) continue;
            sb.append(info.getThreadName()).append(":\n");
            StackTraceElement[] stack_trace = info.getStackTrace();
            for (int j = 0; j < stack_trace.length; ++j) {
                StackTraceElement el = stack_trace[j];
                sb.append("    at ").append(el.getClassName()).append(".").append(el.getMethodName());
                sb.append("(").append(el.getFileName()).append(":").append(el.getLineNumber()).append(")");
                sb.append("\n");
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static boolean interruptAndWaitToDie(Thread t) {
        return Util.interruptAndWaitToDie(t, 300L);
    }

    public static boolean interruptAndWaitToDie(Thread t, long timeout) {
        if (t == null) {
            throw new IllegalArgumentException("Thread can not be null");
        }
        t.interrupt();
        try {
            t.join(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return t.isAlive();
    }

    public static String dumpQueue(Queue q) {
        StringBuilder sb = new StringBuilder();
        LinkedList values = q.values();
        if (values.isEmpty()) {
            sb.append("empty");
        } else {
            for (Object o : values) {
                String s = null;
                if (o instanceof Event) {
                    Event event = (Event)o;
                    int type = event.getType();
                    s = Event.type2String(type);
                    if (type == 6) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + "[";
                        Message m = (Message)event.getArg();
                        HashMap<String, Header> headers = new HashMap<String, Header>(m.getHeaders());
                        for (Map.Entry entry : headers.entrySet()) {
                            String headerKey = (String)entry.getKey();
                            Header value = (Header)entry.getValue();
                            String headerToString = null;
                            if (value instanceof FD.FdHeader) {
                                headerToString = value.toString();
                            } else if (value instanceof PingHeader) {
                                headerToString = headerKey + "-";
                                headerToString = ((PingHeader)value).type == 1 ? headerToString + "GMREQ" : (((PingHeader)value).type == 2 ? headerToString + "GMRSP" : headerToString + "UNKNOWN");
                            } else {
                                headerToString = headerKey + "-" + (value == null ? "null" : value.toString());
                            }
                            s = s + headerToString;
                            s = s + " ";
                        }
                        s = s + "]";
                    }
                } else {
                    s = o.toString();
                }
                sb.append(s).append("\n");
            }
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
        System.exit(-1);
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getLength() > 0) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return null;
        }
        try {
            return msg.getObject().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String mapToString(Map<? extends Object, ? extends Object> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append("=");
            if (val == null) {
                sb.append("null");
            } else {
                sb.append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return "";
        }
        try {
            Object obj = msg.getObject();
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println("#" + i + ": " + threads[i]);
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuilder sb = new StringBuilder();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        for (int i = 0; i < threads.length; ++i) {
            sb.append("#").append(i).append(": ").append(threads[i]).append('\n');
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static String printBytes(long bytes) {
        if (bytes < 1000L) {
            return bytes + "b";
        }
        if (bytes < 1000000L) {
            double tmp = (double)bytes / 1000.0;
            return f.format(tmp) + "KB";
        }
        if (bytes < 1000000000L) {
            double tmp = (double)bytes / 1000000.0;
            return f.format(tmp) + "MB";
        }
        double tmp = (double)bytes / 1.0E9;
        return f.format(tmp) + "GB";
    }

    public static String format(double value) {
        return f.format(value);
    }

    public static long readBytesLong(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return (long)(num * (double)tuple.getVal2().longValue());
    }

    public static int readBytesInteger(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return (int)(num * (double)tuple.getVal2().longValue());
    }

    public static double readBytesDouble(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return num * (double)tuple.getVal2().longValue();
    }

    private static Tuple<String, Long> readBytes(String input) {
        input = input.trim().toLowerCase();
        int index = -1;
        long factor = 1L;
        index = input.indexOf("k");
        if (index != -1) {
            factor = 1000L;
        } else {
            index = input.indexOf("kb");
            if (index != -1) {
                factor = 1000L;
            } else {
                index = input.indexOf("m");
                if (index != -1) {
                    factor = 1000000L;
                } else {
                    index = input.indexOf("mb");
                    if (index != -1) {
                        factor = 1000000L;
                    } else {
                        index = input.indexOf("g");
                        if (index != -1) {
                            factor = 1000000000L;
                        } else {
                            index = input.indexOf("gb");
                            if (index != -1) {
                                factor = 1000000000L;
                            }
                        }
                    }
                }
            }
        }
        String str = index != -1 ? input.substring(0, index) : input;
        return new Tuple<String, Long>(str, factor);
    }

    public static String printBytes(double bytes) {
        if (bytes < 1000.0) {
            return bytes + "b";
        }
        if (bytes < 1000000.0) {
            double tmp = bytes / 1000.0;
            return f.format(tmp) + "KB";
        }
        if (bytes < 1.0E9) {
            double tmp = bytes / 1000000.0;
            return f.format(tmp) + "MB";
        }
        double tmp = bytes / 1.0E9;
        return f.format(tmp) + "GB";
    }

    public static List<String> split(String input, int separator) {
        ArrayList<String> retval = new ArrayList<String>();
        if (input == null) {
            return retval;
        }
        int index = 0;
        while ((index = input.indexOf(separator, index)) != -1) {
            int end;
            if ((end = input.indexOf(separator, ++index)) == -1) {
                retval.add(input.substring(index));
                continue;
            }
            retval.add(input.substring(index, end));
        }
        return retval;
    }

    public static String[] components(String path, String separator) {
        if (path == null || path.length() == 0) {
            return null;
        }
        String[] tmp = path.split(separator + "+");
        if (tmp == null) {
            return null;
        }
        if (tmp.length == 0) {
            return null;
        }
        if (tmp[0].length() == 0) {
            tmp[0] = separator;
        }
        return tmp;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size, int length) {
        int tmp_size = 0;
        int index = 0;
        int num_frags = length % frag_size == 0 ? length / frag_size : length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        for (int accumulated_size = 0; accumulated_size < length; accumulated_size += tmp_size) {
            tmp_size = accumulated_size + frag_size <= length ? frag_size : length - accumulated_size;
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
        }
        return retval;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        return Util.fragmentBuffer(buf, frag_size, buf.length);
    }

    public static List<Range> computeFragOffsets(int offset, int length, int frag_size) {
        ArrayList<Range> retval = new ArrayList<Range>();
        long total_size = length + offset;
        int index = offset;
        int tmp_size = 0;
        while ((long)index < total_size) {
            tmp_size = (long)(index + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index);
            Range r = new Range(index, tmp_size);
            retval.add(r);
            index += tmp_size;
        }
        return retval;
    }

    public static List<Range> computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
            index += fragments[i].length;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        for (int i = 0; i < frags.length; ++i) {
            System.out.println('\'' + new String(frags[i]) + '\'');
        }
    }

    public static <T> String printListWithDelimiter(Collection<T> list, String delimiter) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (T el : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(el);
        }
        return sb.toString();
    }

    public static <T> String printMapWithDelimiter(Map<T, T> map, String delimiter) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, T> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static String array2String(long[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(short[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuilder ret = new StringBuilder("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(Object[] array) {
        return Arrays.toString(array);
    }

    public static boolean all(Collection c, Object obj) {
        for (Object o : c) {
            if (o.equals(obj)) continue;
            return false;
        }
        return true;
    }

    public static List<Address> leftMembers(View one, View two) {
        if (one == null || two == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(one.getMembers());
        retval.removeAll(two.getMembers());
        return retval;
    }

    public static List<Address> leftMembers(Collection<Address> old_list, Collection<Address> new_list) {
        if (old_list == null || new_list == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(old_list);
        retval.removeAll(new_list);
        return retval;
    }

    public static List<Address> newMembers(List<Address> old_list, List<Address> new_list) {
        if (old_list == null || new_list == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(new_list);
        retval.removeAll(old_list);
        return retval;
    }

    public static Vector<Address> pickSubset(Vector<Address> members, double subset_percentage) {
        Vector<Address> ret = new Vector<Address>();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        for (int i = subset_size; i > 0 && !tmp_mbrs.isEmpty(); --i) {
            int index = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement((Address)tmp_mbrs.elementAt(index));
            tmp_mbrs.removeElementAt(index);
        }
        return ret;
    }

    public static boolean containsViewId(Collection<View> views, ViewId vid) {
        for (View view : views) {
            ViewId tmp = view.getVid();
            if (!Util.sameViewId(vid, tmp)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Address> determineMergeParticipants(Map<Address, View> map) {
        HashSet<Address> coords = new HashSet<Address>();
        HashSet<Address> all_addrs = new HashSet<Address>();
        if (map == null) {
            return Collections.emptyList();
        }
        for (View view : map.values()) {
            all_addrs.addAll(view.getMembers());
        }
        for (View view : map.values()) {
            Address coord = view.getCreator();
            if (coord == null) continue;
            coords.add(coord);
        }
        for (Address coord : coords) {
            View view = map.get(coord);
            Vector<Address> mbrs = view != null ? view.getMembers() : null;
            if (mbrs == null) continue;
            all_addrs.removeAll(mbrs);
        }
        coords.addAll(all_addrs);
        return coords;
    }

    public static Collection<Address> determineMergeCoords(Map<Address, View> map) {
        HashSet<Address> retval = new HashSet<Address>();
        if (map != null) {
            for (View view : map.values()) {
                Address coord = view.getCreator();
                if (coord == null) continue;
                retval.add(coord);
            }
        }
        return retval;
    }

    public static Object pickRandomElement(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        int index = (int)(Math.random() * (double)size * 10.0 % (double)size);
        return list.get(index);
    }

    public static Object pickRandomElement(Object[] array) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        int index = (int)(Math.random() * (double)size * 10.0 % (double)size);
        return array[index];
    }

    public static View createView(Address coord, long id, Address ... members) {
        Vector<Address> mbrs = new Vector<Address>();
        mbrs.addAll(Arrays.asList(members));
        return new View(coord, id, mbrs);
    }

    public static Address createRandomAddress() {
        UUID retval = UUID.randomUUID();
        String name = Util.generateLocalName();
        UUID.add(retval, name);
        return retval;
    }

    public static Vector<Address> determineLeftMembers(Vector<Address> old_mbrs, Vector<Address> new_mbrs) {
        Vector<Address> retval = new Vector<Address>();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Address mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.addElement(mbr);
        }
        return retval;
    }

    public static String printViews(Collection<View> views) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (View view : views) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(view.getVid());
        }
        return sb.toString();
    }

    public static <T> String print(Collection<T> objs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T obj : objs) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static <T> String print(Map<T, T> map) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<T, T> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static String printPingData(List<PingData> rsps) {
        StringBuilder sb = new StringBuilder();
        if (rsps != null) {
            int total = rsps.size();
            int servers = 0;
            int clients = 0;
            int coords = 0;
            for (PingData rsp : rsps) {
                if (rsp.isCoord()) {
                    ++coords;
                }
                if (rsp.isServer()) {
                    ++servers;
                    continue;
                }
                ++clients;
            }
            sb.append(total + " total (" + servers + " servers (" + coords + " coord), " + clients + " clients)");
        }
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static void doubleWrite(byte[] buf, int offset, int length, OutputStream out) throws Exception {
        if (length > 1) {
            out.write(buf, offset, 1);
            out.write(buf, offset + 1, length - 1);
        } else {
            out.write(buf, offset, 0);
            out.write(buf, offset, length);
        }
    }

    public static void writeFully(ByteBuffer buf, WritableByteChannel out) throws IOException {
        int toWrite = buf.limit();
        for (int written = 0; written < toWrite; written += out.write(buf)) {
        }
    }

    public static long sizeOf(String classname) {
        try {
            Object inst = Util.loadClass(classname, null).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static int sizeOf(Streamable inst) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            inst.writeTo(out);
            out.flush();
            byte[] data = output.toByteArray();
            return data.length;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static Class loadClass(String classname, Class clazz) throws ClassNotFoundException {
        ClassLoader loader;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                return loader.loadClass(classname);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                loader = clazz.getClassLoader();
                if (loader != null) {
                    return loader.loadClass(classname);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            loader = ClassLoader.getSystemClassLoader();
            if (loader != null) {
                return loader.loadClass(classname);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new ClassNotFoundException(classname);
    }

    public static Field[] getAllDeclaredFields(Class clazz) {
        return Util.getAllDeclaredFieldsWithAnnotations(clazz, new Class[0]);
    }

    public static Field[] getAllDeclaredFieldsWithAnnotations(Class clazz, Class<? extends Annotation> ... annotations) {
        ArrayList<Field> list = new ArrayList<Field>(30);
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            Field[] fields = curr.getDeclaredFields();
            if (fields == null) continue;
            for (Field field : fields) {
                if (annotations != null && annotations.length > 0) {
                    for (Class<? extends Annotation> annotation : annotations) {
                        if (!field.isAnnotationPresent(annotation)) continue;
                        list.add(field);
                    }
                    continue;
                }
                list.add(field);
            }
        }
        Field[] retval = new Field[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retval[i] = (Field)list.get(i);
        }
        return retval;
    }

    public static Method[] getAllDeclaredMethods(Class clazz) {
        return Util.getAllDeclaredMethodsWithAnnotations(clazz, new Class[0]);
    }

    public static Method[] getAllDeclaredMethodsWithAnnotations(Class clazz, Class<? extends Annotation> ... annotations) {
        ArrayList<Method> list = new ArrayList<Method>(30);
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            Method[] methods = curr.getDeclaredMethods();
            if (methods == null) continue;
            for (Method method : methods) {
                if (annotations != null && annotations.length > 0) {
                    for (Class<? extends Annotation> annotation : annotations) {
                        if (!method.isAnnotationPresent(annotation)) continue;
                        list.add(method);
                    }
                    continue;
                }
                list.add(method);
            }
        }
        Method[] retval = new Method[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retval[i] = (Method)list.get(i);
        }
        return retval;
    }

    public static Field getField(Class clazz, String field_name) {
        if (clazz == null || field_name == null) {
            return null;
        }
        Field field = null;
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            try {
                return curr.getDeclaredField(field_name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return field;
    }

    public static InputStream getResourceAsStream(String name, Class clazz) {
        ClassLoader loader;
        InputStream retval = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                return retval;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                loader = clazz.getClassLoader();
                if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                    return retval;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            loader = ClassLoader.getSystemClassLoader();
            if (loader != null) {
                return loader.getResourceAsStream(name);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return retval;
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = new Long(tok.nextToken());
            v.addElement(l);
        }
        if (v.isEmpty()) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.elementAt(i);
        }
        return retval;
    }

    public static List<String> parseCommaDelimitedStrings(String l) {
        return Util.parseStringList(l, ",");
    }

    public static List<IpAddress> parseCommaDelimitedHosts(String hosts, int port_range) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(hosts, ",");
        HashSet<IpAddress> retval = new HashSet<IpAddress>();
        while (tok.hasMoreTokens()) {
            int port;
            String t = tok.nextToken().trim();
            String host = t.substring(0, t.indexOf(91));
            host = host.trim();
            for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + port_range; ++i) {
                IpAddress addr = new IpAddress(host, i);
                retval.add(addr);
            }
        }
        return Collections.unmodifiableList(new LinkedList(retval));
    }

    public static List<InetSocketAddress> parseCommaDelimitedHosts2(String hosts, int port_range) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(hosts, ",");
        HashSet<InetSocketAddress> retval = new HashSet<InetSocketAddress>();
        while (tok.hasMoreTokens()) {
            int port;
            String t = tok.nextToken().trim();
            String host = t.substring(0, t.indexOf(91));
            host = host.trim();
            for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + port_range; ++i) {
                InetSocketAddress addr = new InetSocketAddress(host, i);
                retval.add(addr);
            }
        }
        return Collections.unmodifiableList(new LinkedList(retval));
    }

    public static List<String> parseStringList(String l, String separator) {
        LinkedList<String> tmp = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(l, separator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t.trim());
        }
        return tmp;
    }

    public static String parseString(ByteBuffer buf) {
        return Util.parseString(buf, true);
    }

    public static String parseString(ByteBuffer buf, boolean discard_whitespace) {
        char ch;
        StringBuilder sb = new StringBuilder();
        while (buf.remaining() > 0) {
            ch = (char)buf.get();
            if (Character.isWhitespace(ch)) continue;
            buf.position(buf.position() - 1);
            break;
        }
        if (buf.remaining() == 0) {
            return null;
        }
        while (buf.remaining() > 0 && !Character.isWhitespace(ch = (char)buf.get())) {
            sb.append(ch);
        }
        if (discard_whitespace) {
            while (buf.remaining() > 0) {
                ch = (char)buf.get();
                if (Character.isWhitespace(ch)) continue;
                buf.position(buf.position() - 1);
                break;
            }
        }
        return sb.toString();
    }

    public static int readNewLine(ByteBuffer buf) {
        int num = 0;
        while (buf.remaining() > 0) {
            char ch = (char)buf.get();
            ++num;
            if (ch != '\n') continue;
            break;
        }
        return num;
    }

    public static int discardUntilNewLine(InputStream in) {
        int num = 0;
        try {
            int ch;
            while ((ch = in.read()) != -1) {
                ++num;
                if (ch != 10) continue;
            }
        }
        catch (IOException e) {}
        return num;
    }

    public static String readLine(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(35);
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static void writeString(ByteBuffer buf, String s) {
        for (int i = 0; i < s.length(); ++i) {
            buf.put((byte)s.charAt(i));
        }
    }

    public static List<NetworkInterface> parseInterfaceList(String s) throws Exception {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(10);
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String interface_name = tok.nextToken();
            NetworkInterface intf = NetworkInterface.getByName(interface_name);
            if (intf == null) {
                intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interface_name));
            }
            if (intf == null) {
                throw new Exception("interface " + interface_name + " not found");
            }
            if (interfaces.contains(intf)) continue;
            interfaces.add(intf);
        }
        return interfaces;
    }

    public static String print(List<NetworkInterface> interfaces) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (NetworkInterface intf : interfaces) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    public static String shortName(String hostname) {
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    public static boolean startFlush(Channel c, List<Address> flushParticipants, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        boolean successfulFlush = false;
        for (int attemptCount = 0; attemptCount < numberOfAttempts && !(successfulFlush = c.startFlush(flushParticipants, false)); ++attemptCount) {
            Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
        }
        return successfulFlush;
    }

    public static boolean startFlush(Channel c, List<Address> flushParticipants) {
        return Util.startFlush(c, flushParticipants, 4, 1000L, 5000L);
    }

    public static boolean startFlush(Channel c, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        boolean successfulFlush = false;
        for (int attemptCount = 0; attemptCount < numberOfAttempts && !(successfulFlush = c.startFlush(false)); ++attemptCount) {
            Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
        }
        return successfulFlush;
    }

    public static boolean startFlush(Channel c) {
        return Util.startFlush(c, 4, 1000L, 5000L);
    }

    public static String shortName(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (resolve_dns) {
            sb.append(hostname.getHostName());
        } else {
            sb.append(hostname.getHostAddress());
        }
        return sb.toString();
    }

    public static String generateLocalName() {
        String retval = null;
        try {
            retval = Util.shortName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            retval = "localhost";
        }
        long counter = Util.random(65534L);
        return retval + "-" + counter;
    }

    public static synchronized short incrCounter() {
        short s = COUNTER;
        COUNTER = (short)(s + 1);
        short retval = s;
        if (COUNTER >= Short.MAX_VALUE) {
            COUNTER = 1;
        }
        return retval;
    }

    public static ServerSocket createServerSocket(int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException iOException) {
            }
            break;
        }
        return ret;
    }

    public static ServerSocket createServerSocket(InetAddress bind_addr, int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port, 50, bind_addr);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException iOException) {
            }
            break;
        }
        return ret;
    }

    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return new DatagramSocket();
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
            }
        }
        return sock;
    }

    public static MulticastSocket createMulticastSocket(int port) throws IOException {
        return Util.createMulticastSocket(null, port, null);
    }

    public static MulticastSocket createMulticastSocket(InetAddress mcast_addr, int port, Log log) throws IOException {
        MulticastSocket retval;
        block4: {
            if (mcast_addr != null && !mcast_addr.isMulticastAddress()) {
                throw new IllegalArgumentException("mcast_addr (" + mcast_addr + ") is not a valid multicast address");
            }
            InetSocketAddress saddr = new InetSocketAddress(mcast_addr, port);
            retval = null;
            try {
                retval = new MulticastSocket(saddr);
            }
            catch (IOException ex) {
                if (log == null || !log.isWarnEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                String type = mcast_addr != null ? (mcast_addr instanceof Inet4Address ? "IPv4" : "IPv6") : "n/a";
                sb.append("could not bind to " + mcast_addr + " (" + type + " address)");
                sb.append("; make sure your mcast_addr is of the same type as the preferred IP stack (IPv4 or IPv6)");
                sb.append(" by checking the value of the system properties java.net.preferIPv4Stack and java.net.preferIPv6Addresses.");
                sb.append("\nWill ignore mcast_addr, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details). ");
                sb.append("\nException was: " + ex);
                log.warn(sb.toString());
            }
        }
        if (retval == null) {
            retval = new MulticastSocket(port);
        }
        return retval;
    }

    public static InetAddress getBindAddress(Properties props) throws UnknownHostException, SocketException {
        return Util.getBindAddress(props, StackType.IPv4);
    }

    public static InetAddress getBindAddress(Properties props, StackType ip_version) throws UnknownHostException, SocketException {
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String bind_addr_str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        String bind_interface_str = Util.getProperty(new String[]{"jgroups.bind_interface", null}, props, "bind_interface", ignore_systemprops, null);
        InetAddress bind_addr = null;
        NetworkInterface bind_intf = null;
        if (bind_addr_str != null) {
            boolean hasCorrectVersion;
            bind_addr = InetAddress.getByName(bind_addr_str);
            boolean bl = hasCorrectVersion = bind_addr instanceof Inet4Address && ip_version == StackType.IPv4 || bind_addr instanceof Inet6Address && ip_version == StackType.IPv6;
            if (!hasCorrectVersion) {
                throw new IllegalArgumentException("bind_addr " + bind_addr_str + " has incorrect IP version");
            }
        }
        if (bind_interface_str != null) {
            bind_intf = NetworkInterface.getByName(bind_interface_str);
            if (bind_intf != null) {
                boolean supportsVersion = Util.interfaceHasIPAddresses(bind_intf, ip_version);
                if (!supportsVersion) {
                    throw new IllegalArgumentException("bind_interface " + bind_interface_str + " has incorrect IP version");
                }
            } else {
                throw new UnknownHostException("network interface " + bind_interface_str + " not found");
            }
        }
        if (bind_intf != null && bind_addr != null) {
            boolean hasAddress = false;
            Enumeration<InetAddress> addresses = bind_intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!bind_addr.equals(address)) continue;
                hasAddress = true;
                break;
            }
            if (!hasAddress) {
                throw new IllegalArgumentException("network interface " + bind_interface_str + " does not contain address " + bind_addr_str);
            }
        } else if (bind_intf != null) {
            bind_addr = Util.getFirstNonLoopbackAddress(bind_intf, ip_version);
        } else if (bind_addr == null) {
            bind_addr = Util.getFirstNonLoopbackAddress(ip_version);
        }
        boolean localhost = false;
        if (bind_addr == null) {
            bind_addr = Util.getLocalhost(ip_version);
            localhost = true;
        }
        if (!localhost && NetworkInterface.getByInetAddress(bind_addr) == null) {
            throw new UnknownHostException("Invalid bind address " + bind_addr);
        }
        if (props != null) {
            props.remove("bind_addr");
            props.remove("bind_interface");
        }
        return bind_addr;
    }

    public static InetAddress validateBindAddressFromInterface(InetAddress bind_addr, String bind_interface_str) throws UnknownHostException, SocketException {
        NetworkInterface bind_intf = null;
        if (bind_interface_str == null || bind_interface_str.trim().length() == 0) {
            return bind_addr;
        }
        StackType ip_version = Util.getIpStackType();
        bind_intf = NetworkInterface.getByName(bind_interface_str);
        if (bind_intf != null) {
            boolean supportsVersion = Util.interfaceHasIPAddresses(bind_intf, ip_version);
            if (!supportsVersion) {
                throw new IllegalArgumentException("bind_interface " + bind_interface_str + " has incorrect IP version");
            }
        } else {
            throw new UnknownHostException("network interface " + bind_interface_str + " not found");
        }
        if (bind_addr != null) {
            boolean hasAddress = false;
            Enumeration<InetAddress> addresses = bind_intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!bind_addr.equals(address)) continue;
                hasAddress = true;
                break;
            }
            if (!hasAddress) {
                String bind_addr_str = bind_addr.getHostAddress();
                throw new IllegalArgumentException("network interface " + bind_interface_str + " does not contain address " + bind_addr_str);
            }
        } else {
            bind_addr = Util.getFirstNonLoopbackAddress(bind_intf, ip_version);
        }
        if (bind_addr != null && NetworkInterface.getByInetAddress(bind_addr) == null) {
            throw new UnknownHostException("Invalid bind address " + bind_addr);
        }
        return bind_addr;
    }

    public static boolean checkForLinux() {
        return Util.checkForPresence("os.name", "linux");
    }

    public static boolean checkForHp() {
        return Util.checkForPresence("os.name", "hp");
    }

    public static boolean checkForSolaris() {
        return Util.checkForPresence("os.name", "sun");
    }

    public static boolean checkForWindows() {
        return Util.checkForPresence("os.name", "win");
    }

    public static boolean checkForMac() {
        return Util.checkForPresence("os.name", "mac");
    }

    private static boolean checkForPresence(String key, String value) {
        try {
            String tmp = System.getProperty(key);
            return tmp != null && tmp.trim().toLowerCase().startsWith(value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void prompt(String s) {
        System.out.println(s);
        System.out.flush();
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        int retval = 0;
        if (version != null) {
            if (version.startsWith("1.2")) {
                return 12;
            }
            if (version.startsWith("1.3")) {
                return 13;
            }
            if (version.startsWith("1.4")) {
                return 14;
            }
            if (version.startsWith("1.5")) {
                return 15;
            }
            if (version.startsWith("5")) {
                return 15;
            }
            if (version.startsWith("1.6")) {
                return 16;
            }
            if (version.startsWith("6")) {
                return 16;
            }
        }
        return retval;
    }

    public static <T> Vector<T> unmodifiableVector(Vector<? extends T> v) {
        if (v == null) {
            return null;
        }
        return new UnmodifiableVector(v);
    }

    public static String memStats(boolean gc) {
        StringBuilder sb = new StringBuilder();
        Runtime rt = Runtime.getRuntime();
        if (gc) {
            rt.gc();
        }
        long free_mem = rt.freeMemory();
        long total_mem = rt.totalMemory();
        long used_mem = total_mem - free_mem;
        sb.append("Free mem: ").append(free_mem).append("\nUsed mem: ").append(used_mem);
        sb.append("\nTotal mem: ").append(total_mem);
        return sb.toString();
    }

    public static InetAddress getIPv4Localhost() throws UnknownHostException {
        return Util.getLocalhost(StackType.IPv4);
    }

    public static InetAddress getIPv6Localhost() throws UnknownHostException {
        return Util.getLocalhost(StackType.IPv6);
    }

    public static InetAddress getLocalhost(StackType ip_version) throws UnknownHostException {
        if (ip_version == StackType.IPv4) {
            return InetAddress.getByName("127.0.0.1");
        }
        return InetAddress.getByName("::1");
    }

    public static InetAddress getFirstNonLoopbackAddress(StackType ip_version) throws SocketException {
        InetAddress address = null;
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        while (intfs.hasMoreElements()) {
            NetworkInterface intf = intfs.nextElement();
            if (Util.isDownOrLoopback(intf) || (address = Util.getFirstNonLoopbackAddress(intf, ip_version)) == null) continue;
            return address;
        }
        return null;
    }

    public static boolean isDownOrLoopback(NetworkInterface intf) {
        Boolean retval;
        boolean is_up = true;
        boolean is_loopback = false;
        if (NETWORK_INTERFACE_IS_UP != null) {
            try {
                retval = (Boolean)NETWORK_INTERFACE_IS_UP.invoke((Object)intf, new Object[0]);
                if (retval != null) {
                    is_up = retval;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (NETWORK_INTERFACE_IS_LOOPBACK != null) {
            try {
                retval = (Boolean)NETWORK_INTERFACE_IS_LOOPBACK.invoke((Object)intf, new Object[0]);
                if (retval != null) {
                    is_loopback = retval;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return !is_up || is_loopback;
    }

    public static InetAddress getFirstNonLoopbackAddress(NetworkInterface intf, StackType ip_version) throws SocketException {
        if (intf == null) {
            throw new IllegalArgumentException("Network interface pointer is null");
        }
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || (!(address instanceof Inet4Address) || ip_version != StackType.IPv4) && (!(address instanceof Inet6Address) || ip_version != StackType.IPv6)) continue;
            return address;
        }
        return null;
    }

    public static boolean interfaceHasIPAddresses(NetworkInterface intf, StackType ip_version) throws SocketException, UnknownHostException {
        boolean supportsVersion = false;
        if (intf != null) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if ((!(address instanceof Inet4Address) || ip_version != StackType.IPv4) && (!(address instanceof Inet6Address) || ip_version != StackType.IPv6)) continue;
                supportsVersion = true;
                break;
            }
        } else {
            throw new UnknownHostException("network interface " + intf + " not found");
        }
        return supportsVersion;
    }

    public static StackType getIpStackType() {
        boolean isIPv4StackAvailable = Util.isStackAvailable(true);
        boolean isIPv6StackAvailable = Util.isStackAvailable(false);
        if (isIPv4StackAvailable && !isIPv6StackAvailable) {
            return StackType.IPv4;
        }
        if (isIPv6StackAvailable && !isIPv4StackAvailable) {
            return StackType.IPv6;
        }
        if (isIPv4StackAvailable && isIPv6StackAvailable) {
            if (Boolean.getBoolean("java.net.preferIPv4Stack")) {
                return StackType.IPv4;
            }
            if (Boolean.getBoolean("java.net.preferIPv6Addresses")) {
                return StackType.IPv6;
            }
            return StackType.IPv6;
        }
        return StackType.Unknown;
    }

    public static boolean isStackAvailable(boolean ipv4) {
        Collection<InetAddress> all_addrs = Util.getAllAvailableAddresses();
        for (InetAddress addr : all_addrs) {
            if ((!ipv4 || !(addr instanceof Inet4Address)) && (ipv4 || !(addr instanceof Inet6Address))) continue;
            return true;
        }
        return false;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> retval = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            retval.add(intf);
        }
        return retval;
    }

    public static Collection<InetAddress> getAllAvailableAddresses() {
        HashSet<InetAddress> retval = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en == null) {
                return retval;
            }
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    retval.add(addrs.nextElement());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public static String getProperty(String[] system_props, Properties props, String prop_name, boolean ignore_sysprops, String default_value) {
        String retval = null;
        if (props != null && prop_name != null) {
            retval = props.getProperty(prop_name);
            props.remove(prop_name);
        }
        if (!ignore_sysprops && system_props != null) {
            for (int i = 0; i < system_props.length; ++i) {
                String prop = system_props[i];
                if (prop == null) continue;
                try {
                    String tmp = System.getProperty(prop);
                    if (tmp != null) {
                        return tmp;
                    }
                    continue;
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
            }
        }
        if (retval == null) {
            return default_value;
        }
        return retval;
    }

    public static boolean isBindAddressPropertyIgnored() {
        try {
            String tmp = System.getProperty("jgroups.ignore.bind_addr");
            if (tmp == null && (tmp = System.getProperty("ignore.bind.address")) == null) {
                return false;
            }
            return !(tmp = tmp.trim().toLowerCase()).equals("false") && !tmp.equals("no") && !tmp.equals("off") && (tmp.equals("true") || tmp.equals("yes") || tmp.equals("on"));
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isCoordinator(JChannel ch) {
        if (ch == null) {
            return false;
        }
        View view = ch.getView();
        if (view == null) {
            return false;
        }
        Address local_addr = ch.getAddress();
        if (local_addr == null) {
            return false;
        }
        Vector<Address> mbrs = view.getMembers();
        return mbrs != null && !mbrs.isEmpty() && local_addr.equals(mbrs.firstElement());
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && !servers.isEmpty()) {
            for (int i = 0; i < servers.size(); ++i) {
                MBeanServer srv = servers.get(i);
                if (!"jboss".equalsIgnoreCase(srv.getDefaultDomain())) continue;
                return srv;
            }
            return servers.get(0);
        }
        return MBeanServerFactory.createMBeanServer();
    }

    public static void registerChannel(JChannel channel, String name) {
        MBeanServer server = Util.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.registerChannel(channel, server, name != null ? name : "jgroups", channel.getClusterName(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String generateList(Collection c, String separator) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String replaceProperties(String string, Properties props) {
        String FILE_SEPARATOR = File.separator;
        String PATH_SEPARATOR = File.pathSeparator;
        String FILE_SEPARATOR_ALIAS = "/";
        String PATH_SEPARATOR_ALIAS = ":";
        boolean NORMAL = false;
        boolean SEEN_DOLLAR = true;
        int IN_BRACKET = 2;
        char[] chars = string.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = string.substring(start + 2, i);
                if ("/".equals(key)) {
                    value = FILE_SEPARATOR;
                } else if (":".equals(key)) {
                    value = PATH_SEPARATOR;
                } else {
                    value = props != null ? props.getProperty(key) : System.getProperty(key);
                    if (value == null) {
                        int colon = key.indexOf(58);
                        if (colon > 0) {
                            String realKey = key.substring(0, colon);
                            value = props != null ? props.getProperty(realKey) : System.getProperty(realKey);
                            if (value == null && (value = Util.resolveCompositeKey(realKey, props)) == null) {
                                value = key.substring(colon + 1);
                            }
                        } else {
                            value = Util.resolveCompositeKey(key, props);
                        }
                    }
                }
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string;
        }
        if (start != chars.length) {
            buffer.append(string.substring(start, chars.length));
        }
        return buffer.toString();
    }

    private static String resolveCompositeKey(String key, Properties props) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key.substring(0, comma);
                value = props != null ? props.getProperty(key1) : System.getProperty(key1);
            }
            if (value == null && comma < key.length() - 1) {
                String key2 = key.substring(comma + 1);
                value = props != null ? props.getProperty(key2) : System.getProperty(key2);
            }
        }
        return value;
    }

    public static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = Util._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = Util.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, start_index));
        sb.append(tmp);
        sb.append(val.substring(end_index + 1));
        return sb.toString();
    }

    public static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(":");
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            if (default_val != null && default_val.length() > 0) {
                default_val = default_val.trim();
            }
            retval = Util._getProperty(var, default_val);
        } else {
            String var = s;
            retval = Util._getProperty(var, null);
        }
        return retval;
    }

    private static String _getProperty(String var, String default_value) {
        if (var == null) {
            return null;
        }
        List<String> list = Util.parseCommaDelimitedStrings(var);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>(1);
            list.add(var);
        }
        String retval = null;
        for (String prop : list) {
            try {
                retval = System.getProperty(prop);
                if (retval == null) continue;
                return retval;
            }
            catch (Throwable e) {
            }
        }
        return default_value;
    }

    private static String getString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static String md5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String methodNameToAttributeName(String methodName) {
        methodName = methodName.startsWith("get") || methodName.startsWith("set") ? methodName.substring(3) : methodName;
        methodName = methodName.startsWith("is") ? methodName.substring(2) : methodName;
        Matcher m = METHOD_NAME_TO_ATTR_NAME_PATTERN.matcher(methodName);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int end;
            int start = m.start();
            String str = methodName.substring(start, end = m.end()).toLowerCase();
            if (str.length() > 1) {
                String tmp1 = str.substring(0, str.length() - 1);
                String tmp2 = str.substring(str.length() - 1);
                str = tmp1 + "_" + tmp2;
            }
            if (start == 0) {
                m.appendReplacement(sb, str);
                continue;
            }
            m.appendReplacement(sb, "_" + str);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String attributeNameToMethodName(String attr_name) {
        if (attr_name.contains("_")) {
            Matcher m = ATTR_NAME_TO_METHOD_NAME_PATTERN.matcher(attr_name);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, attr_name.substring(m.end() - 1, m.end()).toUpperCase());
            }
            m.appendTail(sb);
            char first = sb.charAt(0);
            if (Character.isLowerCase(first)) {
                sb.setCharAt(0, Character.toUpperCase(first));
            }
            return sb.toString();
        }
        if (Character.isLowerCase(attr_name.charAt(0))) {
            return attr_name.substring(0, 1).toUpperCase() + attr_name.substring(1);
        }
        return attr_name;
    }

    public static void runAsync(Runnable task, ThreadFactory factory, ThreadGroup group, String thread_name) {
        Thread thread = factory.newThread(group, task, thread_name);
        thread.start();
    }

    static {
        PRIMITIVE_TYPES = new HashMap<Class, Byte>(10);
        resolve_dns = false;
        JGROUPS_COMPAT = false;
        COUNTER = 1;
        METHOD_NAME_TO_ATTR_NAME_PATTERN = Pattern.compile("[A-Z]+");
        ATTR_NAME_TO_METHOD_NAME_PATTERN = Pattern.compile("_.");
        GLOBAL_GROUP = new ThreadGroup("JGroups"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LogFactory.getLog("org.jgroups").error("uncaught exception in " + t + " (thread group=" + GLOBAL_GROUP + " )", e);
            }
        };
        NETWORK_INTERFACE_IS_UP = null;
        NETWORK_INTERFACE_IS_LOOPBACK = null;
        try {
            resolve_dns = Boolean.valueOf(System.getProperty("resolve.dns", "false"));
        }
        catch (SecurityException ex) {
            resolve_dns = false;
        }
        f = NumberFormat.getNumberInstance();
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
        try {
            String tmp = Util.getProperty(new String[]{"jgroups.marshalling.compatible"}, null, null, false, "false");
            JGROUPS_COMPAT = Boolean.valueOf(tmp);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        PRIMITIVE_TYPES.put(Boolean.class, new Byte(10));
        PRIMITIVE_TYPES.put(Byte.class, new Byte(11));
        PRIMITIVE_TYPES.put(Character.class, new Byte(12));
        PRIMITIVE_TYPES.put(Double.class, new Byte(13));
        PRIMITIVE_TYPES.put(Float.class, new Byte(14));
        PRIMITIVE_TYPES.put(Integer.class, new Byte(15));
        PRIMITIVE_TYPES.put(Long.class, new Byte(16));
        PRIMITIVE_TYPES.put(Short.class, new Byte(17));
        PRIMITIVE_TYPES.put(String.class, new Byte(18));
        PRIMITIVE_TYPES.put(byte[].class, new Byte(19));
        try {
            NETWORK_INTERFACE_IS_UP = NetworkInterface.class.getMethod("isUp", new Class[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            NETWORK_INTERFACE_IS_LOOPBACK = NetworkInterface.class.getMethod("isLoopback", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

