/*
 * Decompiled with CFR 0.152.
 */
package net.lag.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.LogRecord;
import net.lag.logging.Daily$;
import net.lag.logging.Formatter;
import net.lag.logging.Formatter$;
import net.lag.logging.Handler;
import net.lag.logging.Hourly$;
import net.lag.logging.Never$;
import net.lag.logging.Policy;
import net.lag.logging.Weekly;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u0017\u0019KG.\u001a%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tq\u0001\\8hO&twM\u0003\u0002\u0006\r\u0005\u0019A.Y4\u000b\u0003\u001d\t1A\\3u\u0007\u0001\u00192\u0001\u0001\u0006\u000f!\tYA\"D\u0001\u0003\u0013\ti!AA\u0004IC:$G.\u001a:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005Aa-\u001b7f]\u0006lW-F\u0001\u0018!\tA2D\u0004\u0002\u00103%\u0011!\u0004E\u0001\u0007!J,G-\u001a4\n\u0005qi\"AB*ue&twM\u0003\u0002\u001b!!Aq\u0004\u0001B\u0001B\u0003%q#A\u0005gS2,g.Y7fA!A\u0011\u0005\u0001BC\u0002\u0013\u0005!%\u0001\u0004q_2L7-_\u000b\u0002GA\u00111\u0002J\u0005\u0003K\t\u0011a\u0001U8mS\u000eL\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000fA|G.[2zA!A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0005g_Jl\u0017\r\u001e;feB\u00111bK\u0005\u0003Y\t\u0011\u0011BR8s[\u0006$H/\u001a:\t\u00119\u0002!Q1A\u0005\u0002=\na!\u00199qK:$W#\u0001\u0019\u0011\u0005=\t\u0014B\u0001\u001a\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\bCB\u0004XM\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q)\u0001(\u000f\u001e<yA\u00111\u0002\u0001\u0005\u0006+U\u0002\ra\u0006\u0005\u0006CU\u0002\ra\t\u0005\u0006SU\u0002\rA\u000b\u0005\u0006]U\u0002\r\u0001\r\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0003\u0019\u0019HO]3b[V\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006\u0011\u0011n\u001c\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9%I\u0001\u0004Xe&$XM\u001d\u0005\b\u0013\u0002\u0001\r\u0011\"\u0003K\u0003)\u0019HO]3b[~#S-\u001d\u000b\u0003\u0017:\u0003\"a\u0004'\n\u00055\u0003\"\u0001B+oSRDqa\u0014%\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBa!\u0015\u0001!B\u0013\u0001\u0015aB:ue\u0016\fW\u000e\t\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0003!y\u0007/\u001a8US6,W#A+\u0011\u0005=1\u0016BA,\u0011\u0005\u0011auN\\4\t\u000fe\u0003\u0001\u0019!C\u00055\u0006aq\u000e]3o)&lWm\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006Iq\u000e]3o)&lW\r\t\u0005\b?\u0002\u0001\r\u0011\"\u0003U\u00031qW\r\u001f;S_2dG+[7f\u0011\u001d\t\u0007\u00011A\u0005\n\t\f\u0001C\\3yiJ{G\u000e\u001c+j[\u0016|F%Z9\u0015\u0005-\u001b\u0007bB(a\u0003\u0003\u0005\r!\u0016\u0005\u0007K\u0002\u0001\u000b\u0015B+\u0002\u001b9,\u0007\u0010\u001e*pY2$\u0016.\\3!\u0011\u00159\u0007\u0001\"\u0001i\u0003\u00151G.^:i)\u0005Y\u0005\"\u00026\u0001\t\u0003A\u0017!B2m_N,\u0007\"\u00027\u0001\t\u0013A\u0017aB8qK:dun\u001a\u0005\u0006]\u0002!\ta\\\u0001\u000bi&lWmU;gM&DHC\u00019v!\t\tH/D\u0001s\u0015\t\u0019H)\u0001\u0003mC:<\u0017B\u0001\u000fs\u0011\u00151X\u000e1\u0001x\u0003\u0011!\u0017\r^3\u0011\u0005a\\X\"A=\u000b\u0005i$\u0015\u0001B;uS2L!\u0001`=\u0003\t\u0011\u000bG/\u001a\u0005\u0006}\u0002!\ta`\u0001\u0014G>l\u0007/\u001e;f\u001d\u0016DHOU8mYRKW.\u001a\u000b\u0004+\u0006\u0005\u0001BBA\u0002{\u0002\u0007Q+A\u0002o_^DaA \u0001\u0005\u0002\u0005\u001dA#A+\t\r\u0005-\u0001\u0001\"\u0003i\u0003\u0011\u0011x\u000e\u001c7\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u00059\u0001/\u001e2mSNDGcA&\u0002\u0014!A\u0011QCA\u0007\u0001\u0004\t9\"\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u00033\ti\"\u0004\u0002\u0002\u001c)\u00111!_\u0005\u0005\u0003?\tYBA\u0005M_\u001e\u0014VmY8sI\u0002")
public class FileHandler
extends Handler
implements ScalaObject {
    private final String filename;
    private final Policy policy;
    private final Formatter formatter;
    private final boolean append;
    private Writer stream;
    private long openTime;
    private long nextRollTime;

    public String filename() {
        return this.filename;
    }

    public Policy policy() {
        return this.policy;
    }

    public boolean append() {
        return this.append;
    }

    private Writer stream() {
        return this.stream;
    }

    private void stream_$eq(Writer writer) {
        this.stream = writer;
    }

    private long openTime() {
        return this.openTime;
    }

    private void openTime_$eq(long l) {
        this.openTime = l;
    }

    private long nextRollTime() {
        return this.nextRollTime;
    }

    private void nextRollTime_$eq(long l) {
        this.nextRollTime = l;
    }

    public void flush() {
        this.stream().flush();
    }

    public void close() {
        this.flush();
        try {
            this.stream().close();
        }
        catch (Throwable throwable) {}
    }

    private void openLog() {
        File dir = new File(this.filename()).getParentFile();
        Object object = dir != null && !dir.exists() ? BoxesRunTime.boxToBoolean((boolean)dir.mkdirs()) : BoxedUnit.UNIT;
        this.stream_$eq(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename(), this.append()), "UTF-8"));
        this.openTime_$eq(System.currentTimeMillis());
        this.nextRollTime_$eq(this.computeNextRollTime());
    }

    public String timeSuffix(Date date) {
        String string2;
        Policy policy = this.policy();
        Never$ never$ = Never$.MODULE$;
        Policy policy2 = policy;
        if (!(never$ != null ? !never$.equals(policy2) : policy2 != null)) {
            string2 = "yyyy";
        } else {
            Hourly$ hourly$ = Hourly$.MODULE$;
            Policy policy3 = policy;
            string2 = !(hourly$ != null ? !hourly$.equals(policy3) : policy3 != null) ? "yyyyMMdd-HH" : "yyyyMMdd";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(string2);
        dateFormat.setCalendar(this.formatter.calendar());
        return dateFormat.format(date);
    }

    public long computeNextRollTime(long now) {
        Policy policy;
        block7: {
            Calendar next;
            block4: {
                block6: {
                    block5: {
                        block3: {
                            next = (Calendar)this.formatter.calendar().clone();
                            next.setTimeInMillis(now);
                            next.set(14, 0);
                            next.set(13, 0);
                            next.set(12, 0);
                            policy = this.policy();
                            Never$ never$ = Never$.MODULE$;
                            Policy policy2 = policy;
                            if (never$ != null ? !never$.equals(policy2) : policy2 != null) break block3;
                            next.add(1, 100);
                            break block4;
                        }
                        Hourly$ hourly$ = Hourly$.MODULE$;
                        Policy policy3 = policy;
                        if (hourly$ != null ? !hourly$.equals(policy3) : policy3 != null) break block5;
                        next.add(11, 1);
                        break block4;
                    }
                    Daily$ daily$ = Daily$.MODULE$;
                    Policy policy4 = policy;
                    if (daily$ != null ? !daily$.equals(policy4) : policy4 != null) break block6;
                    next.set(11, 0);
                    next.add(5, 1);
                    break block4;
                }
                if (!(policy instanceof Weekly)) break block7;
                next.set(11, 0);
                do {
                    next.add(5, 1);
                } while (next.get(7) != ((Weekly)policy).dayOfWeek());
            }
            return next.getTimeInMillis();
        }
        throw new MatchError((Object)policy);
    }

    public long computeNextRollTime() {
        return this.computeNextRollTime(System.currentTimeMillis());
    }

    private void roll() {
        this.stream().close();
        int n = this.filename().lastIndexOf(46);
        int n2 = n == -1 ? this.filename().length() : n;
        String newFilename = new StringBuilder().append((Object)((String)Predef$.MODULE$.augmentString(this.filename()).take(n2))).append((Object)"-").append((Object)this.timeSuffix(new Date(this.openTime()))).append(Predef$.MODULE$.augmentString(this.filename()).drop(n2)).toString();
        new File(this.filename()).renameTo(new File(newFilename));
        this.openLog();
    }

    public void publish(LogRecord record$1) {
        FileHandler fileHandler = this;
        synchronized (fileHandler) {
            this.liftedTree1$1(record$1);
            return;
        }
    }

    private final void liftedTree1$1(LogRecord logRecord) {
        try {
            if (System.currentTimeMillis() > this.nextRollTime()) {
                this.roll();
            }
            this.stream().write(this.getFormatter().format(logRecord));
            this.stream().flush();
        }
        catch (Throwable throwable) {
            System.err.println(Formatter$.MODULE$.formatStackTrace(throwable, 30).mkString("\n"));
        }
    }

    public FileHandler(String filename, Policy policy, Formatter formatter, boolean append) {
        this.filename = filename;
        this.policy = policy;
        this.formatter = formatter;
        this.append = append;
        super(formatter);
        this.stream = null;
        this.openTime = 0L;
        this.nextRollTime = 0L;
        this.openLog();
    }
}

