/*
 * Decompiled with CFR 0.152.
 */
package net.lag.logging;

import java.util.logging.LogManager;
import net.lag.configgy.ConfigMap;
import net.lag.logging.ConsoleHandler;
import net.lag.logging.FileFormatter;
import net.lag.logging.GenericFormatter;
import net.lag.logging.Level;
import net.lag.logging.Level$ALL$;
import net.lag.logging.Level$CRITICAL$;
import net.lag.logging.Level$DEBUG$;
import net.lag.logging.Level$ERROR$;
import net.lag.logging.Level$FATAL$;
import net.lag.logging.Level$INFO$;
import net.lag.logging.Level$OFF$;
import net.lag.logging.Level$TRACE$;
import net.lag.logging.Level$WARNING$;
import net.lag.logging.Logger;
import net.lag.logging.Logger$;
import net.lag.logging.LoggingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logger$
implements ScalaObject {
    public static final Logger$ MODULE$;
    private final HashMap<String, Level> levelNamesMap;
    private final HashMap<Integer, Level> levelsMap;
    private final HashMap<String, Logger> loggersCache;
    private final Logger net$lag$logging$Logger$$root;
    private final java.util.logging.Logger javaRoot;

    static {
        new Logger$();
    }

    public HashMap<String, Level> levelNamesMap() {
        return this.levelNamesMap;
    }

    public HashMap<Integer, Level> levelsMap() {
        return this.levelsMap;
    }

    private HashMap<String, Logger> loggersCache() {
        return this.loggersCache;
    }

    public final Logger net$lag$logging$Logger$$root() {
        return this.net$lag$logging$Logger$$root;
    }

    private java.util.logging.Logger javaRoot() {
        return this.javaRoot;
    }

    public Level$OFF$ OFF() {
        return Level$OFF$.MODULE$;
    }

    public Level$FATAL$ FATAL() {
        return Level$FATAL$.MODULE$;
    }

    public Level$CRITICAL$ CRITICAL() {
        return Level$CRITICAL$.MODULE$;
    }

    public Level$ERROR$ ERROR() {
        return Level$ERROR$.MODULE$;
    }

    public Level$WARNING$ WARNING() {
        return Level$WARNING$.MODULE$;
    }

    public Level$INFO$ INFO() {
        return Level$INFO$.MODULE$;
    }

    public Level$DEBUG$ DEBUG() {
        return Level$DEBUG$.MODULE$;
    }

    public Level$TRACE$ TRACE() {
        return Level$TRACE$.MODULE$;
    }

    public Level$ALL$ ALL() {
        return Level$ALL$.MODULE$;
    }

    public Map<Integer, Level> levels() {
        return this.levelsMap();
    }

    public Map<String, Level> levelNames() {
        return this.levelNamesMap();
    }

    public void reset() {
        this.clearHandlers();
        this.javaRoot().addHandler(new ConsoleHandler(new FileFormatter()));
    }

    public void clearHandlers() {
        this.elements().foreach((Function1)new anonfun.clearHandlers.1());
    }

    public Logger get(String name$1) {
        return (Logger)this.loggersCache().getOrElseUpdate((Object)name$1, (Function0)new anonfun.get.1(name$1));
    }

    public Logger apply(String name) {
        return this.get(name);
    }

    private Logger get(int depth) {
        return this.getForClassName(new Throwable().getStackTrace()[depth].getClassName());
    }

    public Logger get() {
        return this.get(2);
    }

    public Logger apply() {
        return this.get(2);
    }

    private Logger getForClassName(String className) {
        return this.get(Predef$.MODULE$.augmentString(className).stripSuffix("$"));
    }

    public Logger get(Class<?> cls) {
        return this.getForClassName(cls.getName());
    }

    public Logger apply(Class<?> cls) {
        return this.get(cls);
    }

    public Iterator<Logger> elements() {
        LogManager manager$2 = LogManager.getLogManager();
        return JavaConversions$.MODULE$.asIterator(manager$2.getLoggerNames()).map((Function1)new anonfun.elements.1(manager$2)).filterNot((Function1)new anonfun.elements.2()).map((Function1)new anonfun.elements.3());
    }

    public Logger configure(ConfigMap config$1, boolean validateOnly$1, boolean allowNestedBlocks) {
        Option<String> option;
        block9: {
            GenericFormatter genericFormatter;
            Logger logger$2;
            block8: {
                block7: {
                    List allowed$1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"node", "console", "filename", "roll", "utc", "truncate", "truncate_stack_traces", "level", "use_parents", "syslog_host", "syslog_server_name", "syslog_use_iso_date_format", "prefix_format", "use_full_package_names", "append", "scribe_server", "scribe_buffer_msec", "scribe_backoff_msec", "scribe_max_packet_size", "scribe_category", "scribe_max_buffer"}));
                    List forbidden = (List)config$1.keys().toList().filterNot((Function1)new anonfun.2(allowed$1));
                    if (allowNestedBlocks) {
                        forbidden = (List)forbidden.filter((Function1)new anonfun.configure.1(config$1));
                    }
                    if (forbidden.nonEmpty()) {
                        throw new LoggingException(new StringBuilder().append((Object)"Unknown logging config attribute(s): ").append((Object)forbidden.mkString(", ")).toString());
                    }
                    logger$2 = this.get(config$1.getString("node", ""));
                    if (!validateOnly$1 && allowNestedBlocks) {
                        Predef$.MODULE$.refArrayOps((Object[])logger$2.getHandlers()).foreach((Function1)new anonfun.configure.2(logger$2));
                    }
                    option = config$1.getString("prefix_format");
                    None$ none$ = None$.MODULE$;
                    Option<String> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    genericFormatter = new FileFormatter();
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                genericFormatter = new GenericFormatter((String)((Some)option).x());
            }
            FileFormatter formatter$1 = genericFormatter;
            ObjectRef handlers$1 = new ObjectRef(config$1.getBool("console", false) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsoleHandler[]{new ConsoleHandler(formatter$1)})) : Nil$.MODULE$);
            config$1.getString("syslog_host").foreach((Function1)new anonfun.configure.3(config$1, handlers$1));
            config$1.getString("filename").foreach((Function1)new anonfun.configure.4(config$1, formatter$1, handlers$1));
            config$1.getString("scribe_server").foreach((Function1)new anonfun.configure.5(config$1, formatter$1, handlers$1));
            Option level$1 = config$1.getString("level").map((Function1)new anonfun.3());
            ((List)handlers$1.elem).foreach((Function1)new anonfun.configure.6(config$1, validateOnly$1, logger$2, level$1));
            if (!validateOnly$1) {
                logger$2.setUseParentHandlers(config$1.getBool("use_parents", true));
                level$1.foreach((Function1)new anonfun.configure.7(logger$2));
            }
            return logger$2;
        }
        throw new MatchError(option);
    }

    private Logger$() {
        MODULE$ = this;
        this.levelNamesMap = new HashMap();
        this.levelsMap = new HashMap();
        this.loggersCache = new HashMap();
        this.net$lag$logging$Logger$$root = this.get("");
        this.javaRoot = java.util.logging.Logger.getLogger("");
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Level[]{this.OFF(), this.FATAL(), this.CRITICAL(), this.ERROR(), this.WARNING(), this.INFO(), this.DEBUG(), this.TRACE(), this.ALL()})).foreach((Function1)new anonfun.1());
        this.reset();
    }
}

