/*
 * Decompiled with CFR 0.152.
 */
package net.lag.logging;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.LogRecord;
import net.lag.logging.Formatter;
import net.lag.logging.Handler;
import net.lag.logging.Logger;
import net.lag.logging.Logger$;
import net.lag.logging.ScribeHandler$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t%q!B\u0001\u0003\u0011\u000bI\u0011!D*de&\u0014W\rS1oI2,'O\u0003\u0002\u0004\t\u00059An\\4hS:<'BA\u0003\u0007\u0003\ra\u0017m\u001a\u0006\u0002\u000f\u0005\u0019a.\u001a;\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019AAB\u0001C\u0001\u0002#\u0015QBA\u0007TGJL'-\u001a%b]\u0012dWM]\n\u0004\u001791\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006;-!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%Aq\u0001I\u0006C\u0002\u0013\u0005\u0011%\u0001\u0002P\u0017V\t!\u0005\u0005\u0002\u0018G%\u0011A\u0005\u0007\u0002\u0004\u0013:$\bB\u0002\u0014\fA\u0003%!%A\u0002P\u0017\u0002Bq\u0001K\u0006C\u0002\u0013\u0005\u0011%A\u0005U%f{F*\u0011+F%\"1!f\u0003Q\u0001\n\t\n!\u0002\u0016*Z?2\u000bE+\u0012*!\r!a!\u0001\"A\u0001\u0002\u0003a3cA\u0016.-A\u0011!BL\u0005\u0003_\t\u0011q\u0001S1oI2,'\u000f\u0003\u00052W\t\u0005\t\u0015!\u00033\u0003%1wN]7biR,'\u000f\u0005\u0002\u000bg%\u0011AG\u0001\u0002\n\r>\u0014X.\u0019;uKJDQ!H\u0016\u0005\u0002Y\"\"a\u000e\u001d\u0011\u0005)Y\u0003\"B\u00196\u0001\u0004\u0011\u0004b\u0002\u001e,\u0005\u0004%\taO\u0001\u0004Y><W#\u0001\u001f\u0011\u0005)i\u0014B\u0001 \u0003\u0005\u0019aunZ4fe\"1\u0001i\u000bQ\u0001\nq\nA\u0001\\8hA!9!i\u000ba\u0001\n\u0003\t\u0013A\u00062vM\u001a,'\u000fV5nK6KG\u000e\\5tK\u000e|g\u000eZ:\t\u000f\u0011[\u0003\u0019!C\u0001\u000b\u0006Q\"-\u001e4gKJ$\u0016.\\3NS2d\u0017n]3d_:$7o\u0018\u0013fcR\u0011a)\u0013\t\u0003/\u001dK!\u0001\u0013\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u000e\u000b\t\u00111\u0001#\u0003\rAH%\r\u0005\u0007\u0019.\u0002\u000b\u0015\u0002\u0012\u0002/\t,hMZ3s)&lW-T5mY&\u001cXmY8oIN\u0004\u0003b\u0002(,\u0001\u0004%\taT\u0001\u0011Y\u0006\u001cH\u000f\u0016:b]Nl\u0017n]:j_:,\u0012\u0001\u0015\t\u0003/EK!A\u0015\r\u0003\t1{gn\u001a\u0005\b).\u0002\r\u0011\"\u0001V\u0003Qa\u0017m\u001d;Ue\u0006t7/\\5tg&|gn\u0018\u0013fcR\u0011aI\u0016\u0005\b\u0015N\u000b\t\u00111\u0001Q\u0011\u0019A6\u0006)Q\u0005!\u0006\tB.Y:u)J\fgn]7jgNLwN\u001c\u0011\t\u000fi[\u0003\u0019!C\u0001C\u0005Q2m\u001c8oK\u000e$()Y2l_\u001a4W*\u001b7mSN,7m\u001c8eg\"9Al\u000ba\u0001\n\u0003i\u0016AH2p]:,7\r\u001e\"bG.|gMZ'jY2L7/Z2p]\u0012\u001cx\fJ3r)\t1e\fC\u0004K7\u0006\u0005\t\u0019\u0001\u0012\t\r\u0001\\\u0003\u0015)\u0003#\u0003m\u0019wN\u001c8fGR\u0014\u0015mY6pM\u001al\u0015\u000e\u001c7jg\u0016\u001cwN\u001c3tA!9!m\u000ba\u0001\n\u0003y\u0015A\u00057bgR\u001cuN\u001c8fGR\fE\u000f^3naRDq\u0001Z\u0016A\u0002\u0013\u0005Q-\u0001\fmCN$8i\u001c8oK\u000e$\u0018\t\u001e;f[B$x\fJ3r)\t1e\rC\u0004KG\u0006\u0005\t\u0019\u0001)\t\r!\\\u0003\u0015)\u0003Q\u0003Ma\u0017m\u001d;D_:tWm\u0019;BiR,W\u000e\u001d;!\u0011\u001dQ7\u00061A\u0005\u0002\u0005\n\u0011$\\1y\u001b\u0016\u001c8/Y4fgB+'\u000f\u0016:b]N\f7\r^5p]\"9An\u000ba\u0001\n\u0003i\u0017!H7bq6+7o]1hKN\u0004VM\u001d+sC:\u001c\u0018m\u0019;j_:|F%Z9\u0015\u0005\u0019s\u0007b\u0002&l\u0003\u0003\u0005\rA\t\u0005\u0007a.\u0002\u000b\u0015\u0002\u0012\u000255\f\u00070T3tg\u0006<Wm\u001d)feR\u0013\u0018M\\:bGRLwN\u001c\u0011\t\u000fI\\\u0003\u0019!C\u0001C\u0005\u0019R.\u0019=NKN\u001c\u0018mZ3t)>\u0014UO\u001a4fe\"9Ao\u000ba\u0001\n\u0003)\u0018aF7bq6+7o]1hKN$vNQ;gM\u0016\u0014x\fJ3r)\t1e\u000fC\u0004Kg\u0006\u0005\t\u0019\u0001\u0012\t\ra\\\u0003\u0015)\u0003#\u0003Qi\u0017\r_'fgN\fw-Z:U_\n+hMZ3sA!9!p\u000ba\u0001\n\u0003Y\u0018\u0001\u00035pgRt\u0017-\\3\u0016\u0003q\u0004\"aD?\n\u0005y\u0004\"AB*ue&tw\rC\u0005\u0002\u0002-\u0002\r\u0011\"\u0001\u0002\u0004\u0005a\u0001n\\:u]\u0006lWm\u0018\u0013fcR\u0019a)!\u0002\t\u000f){\u0018\u0011!a\u0001y\"9\u0011\u0011B\u0016!B\u0013a\u0018!\u00035pgRt\u0017-\\3!\u0011!\tia\u000ba\u0001\n\u0003\t\u0013\u0001\u00029peRD\u0011\"!\u0005,\u0001\u0004%\t!a\u0005\u0002\u0011A|'\u000f^0%KF$2ARA\u000b\u0011!Q\u0015qBA\u0001\u0002\u0004\u0011\u0003bBA\rW\u0001\u0006KAI\u0001\u0006a>\u0014H\u000f\t\u0005\t\u0003;Y\u0003\u0019!C\u0001w\u0006A1-\u0019;fO>\u0014\u0018\u0010C\u0005\u0002\"-\u0002\r\u0011\"\u0001\u0002$\u0005a1-\u0019;fO>\u0014\u0018p\u0018\u0013fcR\u0019a)!\n\t\u0011)\u000by\"!AA\u0002qDq!!\u000b,A\u0003&A0A\u0005dCR,wm\u001c:zA!I\u0011QF\u0016A\u0002\u0013\u0005\u0011qF\u0001\u0007g>\u001c7.\u001a;\u0016\u0005\u0005E\u0002#B\f\u00024\u0005]\u0012bAA\u001b1\t1q\n\u001d;j_:\u0004B!!\u000f\u0002>5\u0011\u00111\b\u0006\u0003\u000fIIA!a\u0010\u0002<\t11k\\2lKRD\u0011\"a\u0011,\u0001\u0004%\t!!\u0012\u0002\u0015M|7m[3u?\u0012*\u0017\u000fF\u0002G\u0003\u000fB\u0011BSA!\u0003\u0003\u0005\r!!\r\t\u0011\u0005-3\u0006)Q\u0005\u0003c\tqa]8dW\u0016$\b\u0005C\u0005\u0002P-\u0012\r\u0011\"\u0001\u0002R\u0005)\u0011/^3vKV\u0011\u00111\u000b\t\u0007\u0003+\ny&a\u0019\u000e\u0005\u0005]#\u0002BA-\u00037\nq!\\;uC\ndWMC\u0002\u0002^a\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0016\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005\u0003K\nYGD\u0002\u0018\u0003OJ1!!\u001b\u0019\u0003\u0019\u0001&/\u001a3fM&\u0019a0!\u001c\u000b\u0007\u0005%\u0004\u0004\u0003\u0005\u0002r-\u0002\u000b\u0011BA*\u0003\u0019\tX/Z;fA!I\u0011QO\u0016A\u0002\u0013\u0005\u0011qO\u0001\u000eCJ\u001c\u0007.Y5d'\u0016\u0014h/\u001a:\u0016\u0005\u0005e\u0004cA\f\u0002|%\u0019\u0011Q\u0010\r\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011Q\u0016A\u0002\u0013\u0005\u00111Q\u0001\u0012CJ\u001c\u0007.Y5d'\u0016\u0014h/\u001a:`I\u0015\fHc\u0001$\u0002\u0006\"I!*a \u0002\u0002\u0003\u0007\u0011\u0011\u0010\u0005\t\u0003\u0013[\u0003\u0015)\u0003\u0002z\u0005q\u0011M]2iC&\u001c7+\u001a:wKJ\u0004\u0003bBAGW\u0011\u0005\u0011qR\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHc\u0001$\u0002\u0012\"A\u00111SAF\u0001\u0004\t\u0019'\u0001\u0004tKJ4XM\u001d\u0005\b\u0003'[C\u0011AAL+\t\t\u0019\u0007C\u0004\u0002\u001c.\"I!!(\u0002\u000f\r|gN\\3diR\ta\tC\u0004\u0002\".\"\t!!(\u0002\u000b\u0019dWo\u001d5\t\u000f\u0005\u00156\u0006\"\u0001\u0002(\u0006QQ.Y6f\u0005V4g-\u001a:\u0015\t\u0005%\u0016Q\u0017\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011q\u0016\n\u0002\u00079Lw.\u0003\u0003\u00024\u00065&A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011qWAR\u0001\u0004\u0011\u0013!B2pk:$\bbBA^W\u0011\u0005\u0011QT\u0001\u0006G2|7/\u001a\u0005\b\u0003\u007f[C\u0011AAa\u0003\u001d\u0001XO\u00197jg\"$2ARAb\u0011!\t)-!0A\u0002\u0005\u001d\u0017A\u0002:fG>\u0014H\r\u0005\u0003\u0002J\u0006EWBAAf\u0015\r\u0019\u0011Q\u001a\u0006\u0004\u0003\u001f\u0014\u0012\u0001B;uS2LA!a5\u0002L\nIAj\\4SK\u000e|'\u000f\u001a\u0005\b\u0003/\\C\u0011IAm\u0003!!xn\u0015;sS:<GCAA2\u0011%\tin\u000bb\u0001\n\u0003\ty.A\u0007T\u0007JK%)R0Q%\u00163\u0015\nW\u000b\u0003\u0003C\u0004RaFAr\u0003OL1!!:\u0019\u0005\u0015\t%O]1z!\r9\u0012\u0011^\u0005\u0004\u0003WD\"\u0001\u0002\"zi\u0016D\u0001\"a<,A\u0003%\u0011\u0011]\u0001\u000f'\u000e\u0013\u0016JQ#`!J+e)\u0013-!\u0011%\t\u0019p\u000bb\u0001\n\u0003\ty.A\tP\u0019\u0012{6k\u0011*J\u0005\u0016{\u0006KU#G\u0013bC\u0001\"a>,A\u0003%\u0011\u0011]\u0001\u0013\u001f2#ulU\"S\u0013\n+u\f\u0015*F\r&C\u0006\u0005C\u0005\u0002|.\u0012\r\u0011\"\u0001\u0002`\u0006a1k\u0011*J\u0005\u0016{&+\u0012)M3\"A\u0011q`\u0016!\u0002\u0013\t\t/A\u0007T\u0007JK%)R0S\u000bBc\u0015\f\t\u0005\n\u0005\u0007Y#\u0019!C\u0001\u0003?\f\u0001c\u0014'E?N\u001b%+\u0013\"F?J+\u0005\u000bT-\t\u0011\t\u001d1\u0006)A\u0005\u0003C\f\u0011c\u0014'E?N\u001b%+\u0013\"F?J+\u0005\u000bT-!\u0001")
public class ScribeHandler
extends Handler
implements ScalaObject {
    private final Logger log = Logger$.MODULE$.get("scribe");
    private int bufferTimeMilliseconds = 100;
    private long lastTransmission = 0L;
    private int connectBackoffMilliseconds = 15000;
    private long lastConnectAttempt = 0L;
    private int maxMessagesPerTransaction = 1000;
    private int maxMessagesToBuffer = 10000;
    private String hostname = "localhost";
    private int port = 1463;
    private String category = "scala";
    private Option<Socket> socket = None$.MODULE$;
    private final ArrayBuffer<String> queue = new ArrayBuffer();
    private boolean archaicServer = false;
    private final byte[] SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 1, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 15, 0, 1, 12}), (ClassManifest)Manifest$.MODULE$.Byte());
    private final byte[] OLD_SCRIBE_PREFIX = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 1, 0, 0, 0, 0, 15, 0, 1, 12}), (ClassManifest)Manifest$.MODULE$.Byte());
    private final byte[] SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)128, 1, 0, 2, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), (ClassManifest)Manifest$.MODULE$.Byte());
    private final byte[] OLD_SCRIBE_REPLY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 20, 0, 0, 0, 3, (byte)76, (byte)111, (byte)103, 2, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0}), (ClassManifest)Manifest$.MODULE$.Byte());

    public static final int TRY_LATER() {
        return ScribeHandler$.MODULE$.TRY_LATER();
    }

    public static final int OK() {
        return ScribeHandler$.MODULE$.OK();
    }

    public Logger log() {
        return this.log;
    }

    public int bufferTimeMilliseconds() {
        return this.bufferTimeMilliseconds;
    }

    public void bufferTimeMilliseconds_$eq(int n) {
        this.bufferTimeMilliseconds = n;
    }

    public long lastTransmission() {
        return this.lastTransmission;
    }

    public void lastTransmission_$eq(long l) {
        this.lastTransmission = l;
    }

    public int connectBackoffMilliseconds() {
        return this.connectBackoffMilliseconds;
    }

    public void connectBackoffMilliseconds_$eq(int n) {
        this.connectBackoffMilliseconds = n;
    }

    public long lastConnectAttempt() {
        return this.lastConnectAttempt;
    }

    public void lastConnectAttempt_$eq(long l) {
        this.lastConnectAttempt = l;
    }

    public int maxMessagesPerTransaction() {
        return this.maxMessagesPerTransaction;
    }

    public void maxMessagesPerTransaction_$eq(int n) {
        this.maxMessagesPerTransaction = n;
    }

    public int maxMessagesToBuffer() {
        return this.maxMessagesToBuffer;
    }

    public void maxMessagesToBuffer_$eq(int n) {
        this.maxMessagesToBuffer = n;
    }

    public String hostname() {
        return this.hostname;
    }

    public void hostname_$eq(String string2) {
        this.hostname = string2;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public String category() {
        return this.category;
    }

    public void category_$eq(String string2) {
        this.category = string2;
    }

    public Option<Socket> socket() {
        return this.socket;
    }

    public void socket_$eq(Option<Socket> option) {
        this.socket = option;
    }

    public ArrayBuffer<String> queue() {
        return this.queue;
    }

    public boolean archaicServer() {
        return this.archaicServer;
    }

    public void archaicServer_$eq(boolean bl) {
        this.archaicServer = bl;
    }

    public void server_$eq(String server) {
        String[] stringArray;
        block6: {
            block5: {
                IndexedSeq indexedSeq;
                block4: {
                    stringArray = server.split(":", 2);
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)stringArray);
                    }
                    indexedSeq = (IndexedSeq)option.get();
                    if (!(indexedSeq == null ? false : indexedSeq.lengthCompare(1) == 0)) break block4;
                    this.hostname_$eq((String)indexedSeq.apply(0));
                    break block5;
                }
                if (!(indexedSeq == null ? false : indexedSeq.lengthCompare(2) == 0)) break block6;
                this.hostname_$eq((String)indexedSeq.apply(0));
                this.port_$eq(Predef$.MODULE$.augmentString((String)indexedSeq.apply(1)).toInt());
            }
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    public String server() {
        return Predef$.MODULE$.augmentString("%s:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname(), BoxesRunTime.boxToInteger((int)this.port())}));
    }

    private void connect() {
        if (!this.socket().isDefined() && System.currentTimeMillis() - this.lastConnectAttempt() > (long)this.connectBackoffMilliseconds()) {
            this.lastConnectAttempt_$eq(System.currentTimeMillis());
            try {
                this.socket_$eq((Option<Socket>)new Some((Object)new Socket(this.hostname(), this.port())));
            }
            catch (Exception exception) {
                this.log().error("Unable to open socket to scribe server at %s: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.server(), exception}));
            }
        }
    }

    @Override
    public void flush() {
        ScribeHandler scribeHandler = this;
        synchronized (scribeHandler) {
            this.connect();
            this.socket().foreach((Function1)new $anonfun$flush$1(this));
            return;
        }
    }

    public ByteBuffer makeBuffer(int count) {
        scala.collection.immutable.IndexedSeq texts = (scala.collection.immutable.IndexedSeq)((TraversableLike)Predef$.MODULE$.intWrapper(0).until(count)).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer recordHeader$1 = ByteBuffer.wrap(new byte[10 + this.category().length()]);
        recordHeader$1.order(ByteOrder.BIG_ENDIAN);
        recordHeader$1.put((byte)11);
        recordHeader$1.putShort((short)1);
        recordHeader$1.putInt(this.category().length());
        recordHeader$1.put(this.category().getBytes("ISO-8859-1"));
        recordHeader$1.put((byte)11);
        recordHeader$1.putShort((short)2);
        byte[] prefix = this.archaicServer() ? this.OLD_SCRIBE_PREFIX() : this.SCRIBE_PREFIX();
        int messageSize = count * (recordHeader$1.capacity() + 5) + BoxesRunTime.unboxToInt((Object)texts.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new $anonfun$2(this))) + prefix.length + 5;
        ByteBuffer buffer$1 = ByteBuffer.wrap(new byte[messageSize + 4]);
        buffer$1.order(ByteOrder.BIG_ENDIAN);
        buffer$1.putInt(messageSize);
        buffer$1.put(prefix);
        buffer$1.putInt(count);
        texts.foreach((Function1)new $anonfun$makeBuffer$1(this, recordHeader$1, buffer$1));
        buffer$1.put((byte)0);
        return buffer$1;
    }

    @Override
    public void close() {
        ScribeHandler scribeHandler = this;
        synchronized (scribeHandler) {
            this.liftedTree1$1();
            this.socket_$eq((Option<Socket>)None$.MODULE$);
            return;
        }
    }

    @Override
    public void publish(LogRecord record) {
        ScribeHandler scribeHandler = this;
        synchronized (scribeHandler) {
            BoxedUnit boxedUnit;
            String string2 = record.getLoggerName();
            String string3 = "scribe";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return;
            }
            this.queue().$plus$eq((Object)this.getFormatter().format(record));
            while (this.queue().size() > this.maxMessagesToBuffer()) {
                this.queue().trimStart(1);
            }
            if (System.currentTimeMillis() - this.lastTransmission() >= (long)this.bufferTimeMilliseconds()) {
                this.flush();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public String toString() {
        return Predef$.MODULE$.augmentString("<%s level=%s utc=%s truncate=%d truncate_stack=%d server=%s scribe_buffer_msec=%d scribe_backoff_msec=%d scribe_max_packet_size=%d>").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.getLevel(), BoxesRunTime.boxToBoolean((boolean)this.useUtc()), BoxesRunTime.boxToInteger((int)this.truncateAt()), BoxesRunTime.boxToInteger((int)this.truncateStackTracesAt()), this.server(), BoxesRunTime.boxToInteger((int)this.bufferTimeMilliseconds()), BoxesRunTime.boxToInteger((int)this.connectBackoffMilliseconds()), BoxesRunTime.boxToInteger((int)this.maxMessagesPerTransaction())}));
    }

    public byte[] SCRIBE_PREFIX() {
        return this.SCRIBE_PREFIX;
    }

    public byte[] OLD_SCRIBE_PREFIX() {
        return this.OLD_SCRIBE_PREFIX;
    }

    public byte[] SCRIBE_REPLY() {
        return this.SCRIBE_REPLY;
    }

    public byte[] OLD_SCRIBE_REPLY() {
        return this.OLD_SCRIBE_REPLY;
    }

    /*
     * WARNING - void declaration
     */
    private final Object liftedTree1$1() {
        void var1_1;
        BoxedUnit exceptionResult1 = null;
        try {
            exceptionResult1 = this.socket().map((Function1)new $anonfun$liftedTree1$1$1(this));
        }
        catch (Throwable throwable) {
            exceptionResult1 = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    public ScribeHandler(Formatter formatter) {
        super(formatter);
    }
}

