/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.multiverse.api.TransactionConfiguration;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.backoff.ExponentialBackoffPolicy;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.clock.StrictPrimitiveClock;

public class AbstractTransactionConfiguration
implements TransactionConfiguration {
    public final PrimitiveClock clock;
    public final BackoffPolicy backoffPolicy;
    public final String familyName;
    public final boolean readOnly;
    public final int maxRetries;
    public final boolean interruptible;
    public final boolean writeSkewAllowed;
    public final boolean readTrackingEnabled;
    public final long timeoutNs;
    public final boolean explicitRetryAllowed;
    public final int maxReadSpinCount;

    public AbstractTransactionConfiguration() {
        this(new StrictPrimitiveClock(), ExponentialBackoffPolicy.INSTANCE_100_MS_MAX, null, true, 1000, true, true, true, true, Long.MIN_VALUE, 10);
    }

    public AbstractTransactionConfiguration(PrimitiveClock clock, BackoffPolicy backoffPolicy, String familyName, boolean readOnly, int maxRetries, boolean interruptible, boolean writeSkewAllowed, boolean readTrackingEnabled, boolean explicitRetryAllowed, long timeoutNs, int maxReadSpinCount) {
        if (clock == null) {
            throw new NullPointerException();
        }
        if (backoffPolicy == null) {
            throw new NullPointerException();
        }
        this.clock = clock;
        this.familyName = familyName;
        this.readOnly = readOnly;
        this.backoffPolicy = backoffPolicy;
        this.maxRetries = maxRetries;
        this.interruptible = interruptible;
        this.readTrackingEnabled = readTrackingEnabled;
        this.writeSkewAllowed = writeSkewAllowed;
        this.explicitRetryAllowed = explicitRetryAllowed;
        this.timeoutNs = timeoutNs;
        this.maxReadSpinCount = maxReadSpinCount;
        if (!(readOnly || readTrackingEnabled || writeSkewAllowed)) {
            String msg = String.format("Update transaction '%s' isn't  allowed with writeSkew disabled and trackReads disabled. The last is needed to do the first.", familyName);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public int maxReadSpinCount() {
        return this.maxReadSpinCount;
    }

    @Override
    public boolean isExplicitRetryAllowed() {
        return this.explicitRetryAllowed;
    }

    @Override
    public final String getFamilyName() {
        return this.familyName;
    }

    @Override
    public final int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public final boolean isInterruptible() {
        return this.interruptible;
    }

    @Override
    public final boolean isReadonly() {
        return this.readOnly;
    }

    @Override
    public final boolean isWriteSkewAllowed() {
        return this.writeSkewAllowed;
    }

    @Override
    public final boolean isReadTrackingEnabled() {
        return this.readTrackingEnabled;
    }

    @Override
    public final BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    @Override
    public long getTimeoutNs() {
        return this.timeoutNs;
    }
}

