/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.TransactionalReference;

@TransactionalObject
public final class DefaultTransactionalReference<E>
implements TransactionalReference<E> {
    private E value;

    public DefaultTransactionalReference() {
        this(null);
    }

    public DefaultTransactionalReference(E value) {
        this.value = value;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true)
    public E getOrAwait() {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true, interruptible=true)
    public E getOrAwaitInterruptibly() throws InterruptedException {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E get() {
        return this.value;
    }

    @Override
    @TransactionalMethod(trackReads=true)
    public E set(E newValue) {
        E currentValue = this.value;
        if (currentValue == newValue) {
            return newValue;
        }
        E oldRef = currentValue;
        this.value = newValue;
        return oldRef;
    }

    @Override
    public E clear() {
        return this.set(null);
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        if (this.value == null) {
            return "DefaultTransactionalReference(ref=null)";
        }
        return String.format("DefaultTransactionalReference(ref=%s)", this.value);
    }
}

