/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.transactional.collections.TransactionalLinkedList;
import org.multiverse.transactional.collections.TransactionalQueue;

@TransactionalObject
public final class TransactionalThreadPoolExecutor
extends AbstractExecutorService {
    private final TransactionalQueue<Runnable> workQueue;
    private final TransactionalLinkedList<Thread> threads = new TransactionalLinkedList();
    private State state;
    private int corePoolSize;
    private ThreadFactory threadFactory;

    public TransactionalThreadPoolExecutor() {
        this(new TransactionalLinkedList<Runnable>(1000000, true), 1);
    }

    public TransactionalThreadPoolExecutor(int poolSize) {
        this(new TransactionalLinkedList<Runnable>(1000000, true), poolSize);
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue<Runnable> workQueue) {
        this(workQueue, 1);
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue<Runnable> workQueue, int corePoolSize) {
        if (workQueue == null) {
            throw new NullPointerException();
        }
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        this.corePoolSize = corePoolSize;
        this.workQueue = workQueue;
        this.state = State.unstarted;
        this.threadFactory = new ThreadFactory(){
            final AtomicLong idGenerator = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "worker-" + this.idGenerator.incrementAndGet());
            }
        };
    }

    @TransactionalMethod(readonly=true)
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @TransactionalMethod(trackReads=false)
    public void setCorePoolSize(int newCorePoolSize) {
        if (newCorePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        switch (this.state) {
            case unstarted: {
                this.corePoolSize = newCorePoolSize;
                break;
            }
            case started: {
                int extra = newCorePoolSize - this.corePoolSize;
                if (extra > 0) {
                    this.createAndRegisterWorkers(extra);
                }
                this.corePoolSize = newCorePoolSize;
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
        }
    }

    @TransactionalMethod(readonly=true)
    public int getCurrentPoolSize() {
        return this.threads.size();
    }

    @TransactionalMethod(readonly=true)
    public BlockingQueue<Runnable> getWorkQueue() {
        return this.workQueue;
    }

    @TransactionalMethod(readonly=true)
    public State getState() {
        return this.state;
    }

    @TransactionalMethod(trackReads=false)
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    @TransactionalMethod(readonly=true)
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void shutdown() {
        switch (this.state) {
            case unstarted: {
                this.state = State.terminated;
                break;
            }
            case started: {
                this.state = State.shutdown;
                break;
            }
            case shutdown: {
                break;
            }
            case terminated: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    @TransactionalMethod(trackReads=false)
    public List<Runnable> shutdownNow() {
        switch (this.state) {
            case unstarted: {
                this.state = State.terminated;
                return Collections.EMPTY_LIST;
            }
            case started: 
            case shutdown: {
                LinkedList<Runnable> sink = new LinkedList<Runnable>();
                this.workQueue.drainTo(sink);
                if (this.threads.isEmpty()) {
                    this.state = State.terminated;
                } else {
                    this.state = State.shutdown;
                    ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new InterruptWorkersListener());
                }
                return sink;
            }
            case terminated: {
                return Collections.EMPTY_LIST;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isShutdown() {
        return this.state == State.shutdown || this.state == State.terminated;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public boolean isTerminated() {
        return this.state == State.terminated;
    }

    @TransactionalMethod(readonly=true)
    public boolean isStarted() {
        return this.state == State.started;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true)
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        switch (this.state) {
            case unstarted: {
                throw new UnsupportedOperationException();
            }
            case started: {
                throw new UnsupportedOperationException();
            }
            case shutdown: {
                throw new UnsupportedOperationException();
            }
            case terminated: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @TransactionalMethod(readonly=true, trackReads=true, interruptible=true)
    public void awaitTermination() throws InterruptedException {
        if (this.state != State.terminated) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void awaitTerminationUninterruptibly() {
        if (this.state != State.terminated) {
            StmUtils.retry();
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        switch (this.state) {
            case unstarted: {
                this.start();
            }
            case started: {
                boolean workOffered = this.workQueue.offer(command);
                if (workOffered) break;
                throw new RejectedExecutionException();
            }
            case shutdown: {
                throw new RejectedExecutionException();
            }
            case terminated: {
                throw new RejectedExecutionException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void u() {
        this.v();
    }

    public void v() {
    }

    public void x(int a) {
        this.y(a);
    }

    public void y(int b) {
    }

    public void start() {
        switch (this.state) {
            case unstarted: {
                this.state = State.started;
                this.createAndRegisterWorkers(this.corePoolSize);
                break;
            }
            case started: {
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void createAndRegisterWorkers(int size) {
        Thread[] newThreads = new Thread[size];
        for (int k = 0; k < this.corePoolSize; ++k) {
            Worker worker = new Worker();
            Thread thread = this.threadFactory.newThread(worker);
            worker.thread = thread;
            this.threads.add(thread);
            newThreads[k] = thread;
        }
        ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new StartWorkersListener(newThreads));
    }

    private void signalTerminated() {
        this.state = State.terminated;
    }

    private class InterruptWorkersListener
    implements TransactionLifecycleListener {
        private InterruptWorkersListener() {
        }

        @Override
        @TransactionalMethod
        public void notify(Transaction tx, TransactionLifecycleEvent event) {
            if (event == TransactionLifecycleEvent.postCommit) {
                for (Thread thread : TransactionalThreadPoolExecutor.this.threads) {
                    thread.interrupt();
                }
            }
        }
    }

    private static class StartWorkersListener
    implements TransactionLifecycleListener {
        private final Thread[] threads;

        private StartWorkersListener(Thread ... threads) {
            this.threads = threads;
        }

        @Override
        public void notify(Transaction t, TransactionLifecycleEvent event) {
            if (event == TransactionLifecycleEvent.postCommit) {
                for (int k = 0; k < this.threads.length; ++k) {
                    this.threads[k].start();
                }
            }
        }
    }

    private class Worker
    implements Runnable {
        private Thread thread;

        private Worker() {
        }

        @Override
        public void run() {
            this.work();
            this.drainWorkQueue();
            this.die();
        }

        private void work() {
            boolean again = true;
            do {
                try {
                    Runnable command = this.takeWork();
                    if (command == null) {
                        again = false;
                        continue;
                    }
                    this.execute(command);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (again);
        }

        @TransactionalMethod
        private Runnable takeWork() throws InterruptedException {
            if (TransactionalThreadPoolExecutor.this.threads.size() > TransactionalThreadPoolExecutor.this.corePoolSize || TransactionalThreadPoolExecutor.this.isShutdown()) {
                TransactionalThreadPoolExecutor.this.threads.remove(this.thread);
                return null;
            }
            return (Runnable)TransactionalThreadPoolExecutor.this.workQueue.take();
        }

        private void drainWorkQueue() {
            boolean again = true;
            do {
                Runnable command;
                if ((command = (Runnable)TransactionalThreadPoolExecutor.this.workQueue.poll()) == null) {
                    again = false;
                    continue;
                }
                this.execute(command);
            } while (again);
        }

        @TransactionalMethod
        private void die() {
            if (TransactionalThreadPoolExecutor.this.isShutdown()) {
                TransactionalThreadPoolExecutor.this.signalTerminated();
            }
        }

        private void execute(Runnable command) {
            try {
                command.run();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    static enum State {
        unstarted,
        started,
        shutdown,
        terminated;

    }
}

