/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public final class TransactionalShort {
    private short value;

    public TransactionalShort() {
        this(0);
    }

    public TransactionalShort(short value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public short get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(short desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public short awaitLargerThan(short than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public short awaitLargerOrEqualThan(short than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public short awaitSmallerThan(short than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public short awaitSmallerOrEqualThan(short than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public short awaitNotEqualTo(short than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    public short set(short newValue) {
        short oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public short inc() {
        this.value = (short)(this.value + 1);
        return this.value;
    }

    public short inc(short amount) {
        this.value = (short)(this.value + amount);
        return this.value;
    }

    public short dec() {
        this.value = (short)(this.value - 1);
        return this.value;
    }

    public short dec(short amount) {
        this.value = (short)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalShort(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalShort)) {
            return false;
        }
        TransactionalShort that = (TransactionalShort)thatObj;
        return that.value == this.value;
    }
}

