/*
 * Decompiled with CFR 0.152.
 */
package com.karneim.util.collection.set;

import com.karneim.util.collection.automaton.Automaton;
import com.karneim.util.collection.set.AutomatonSet_String;
import com.karneim.util.collection.set.CharSet;
import com.karneim.util.collection.set.FSAData;
import com.karneim.util.collection.set.ISet_char;
import com.karneim.util.collection.set.IState;
import com.karneim.util.collection.set.IStatePro;
import com.karneim.util.collection.set.SAutomatonData;
import com.karneim.util.collection.set.StateProSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class SAutomaton {
    protected transient HashMap state2wrapper = null;
    protected transient HashMap transition2wrapper = null;
    protected transient Automaton.IChangedListener automatonChangedListener = null;
    protected transient LinkedList listeners = null;
    protected transient AutomatonSet_String automaton;
    static Class class$com$karneim$util$collection$set$FSAData;

    protected Automaton.IChangedListener getAutomatonChangedListener() {
        if (this.automatonChangedListener != null) {
            return this.automatonChangedListener;
        }
        this.automatonChangedListener = new Automaton.IChangedListener(){

            public void stateAdded(Automaton.State state) {
                StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(state);
                if (statePro == null) {
                    statePro = new StatePro((AutomatonSet_String.SState)state);
                }
                Iterator iterator = SAutomaton.this.listeners.iterator();
                for (int i = SAutomaton.this.listeners.size(); i > 0; --i) {
                    ((IChangeListener)iterator.next()).stateAdded(statePro);
                }
            }

            public void stateRemoved(Automaton.State state) {
                StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(state);
                if (statePro == null) {
                    statePro = new StatePro((AutomatonSet_String.SState)state);
                }
                Iterator iterator = SAutomaton.this.listeners.iterator();
                for (int i = SAutomaton.this.listeners.size(); i > 0; --i) {
                    ((IChangeListener)iterator.next()).stateRemoved(statePro);
                }
            }

            public void startStateChanged(Automaton.State state, Automaton.State state2) {
                StatePro statePro = null;
                if (state != null && (statePro = (StatePro)SAutomaton.this.state2wrapper.get(state)) == null) {
                    statePro = new StatePro((AutomatonSet_String.SState)state);
                }
                StatePro statePro2 = null;
                if (state2 != null && (statePro2 = (StatePro)SAutomaton.this.state2wrapper.get(state2)) == null) {
                    statePro2 = new StatePro((AutomatonSet_String.SState)state2);
                }
                Iterator iterator = SAutomaton.this.listeners.iterator();
                for (int i = SAutomaton.this.listeners.size(); i > 0; --i) {
                    ((IChangeListener)iterator.next()).startStateChanged(statePro, statePro2);
                }
            }
        };
        return this.automatonChangedListener;
    }

    public void addChangeListener(IChangeListener iChangeListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
            this.automaton.addChangedListener(this.getAutomatonChangedListener());
        }
        this.listeners.add(iChangeListener);
    }

    public boolean removeChangeListener(IChangeListener iChangeListener) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            for (int i = this.listeners.size(); i > 0; --i) {
                if (iChangeListener != iterator.next()) continue;
                if (this.listeners.size() > 1) {
                    iterator.remove();
                } else {
                    this.automaton.removeChangedListener(this.automatonChangedListener);
                    this.automatonChangedListener = null;
                    this.listeners = null;
                }
                return true;
            }
        }
        return false;
    }

    public SAutomaton() {
        this(new AutomatonSet_String());
    }

    public SAutomaton(FSAData fSAData) {
        this(new AutomatonSet_String());
        this.init(fSAData);
    }

    protected static FSAData toFSAData(Object object) {
        if (object.getClass() != (class$com$karneim$util$collection$set$FSAData == null ? (class$com$karneim$util$collection$set$FSAData = SAutomaton.class$("com.karneim.util.collection.set.FSAData")) : class$com$karneim$util$collection$set$FSAData)) {
            SAutomatonData sAutomatonData = (SAutomatonData)object;
            FSAData.State[] stateArray = new FSAData.State[sAutomatonData.states == null ? 0 : sAutomatonData.states.length];
            for (int i = 0; i < stateArray.length; ++i) {
                SAutomatonData.State state = sAutomatonData.states[i];
                if (state == null) continue;
                FSAData.State.Transition[] transitionArray = new FSAData.State.Transition[state.transitions == null ? 0 : state.transitions.length];
                for (int j = 0; j < transitionArray.length; ++j) {
                    SAutomatonData.State.Transition transition = state.transitions[j];
                    transitionArray[j] = new FSAData.State.Transition(transition.properties, transition.charSet, transition.toStateNumber);
                }
                stateArray[i] = new FSAData.State(state.number, state.isFinal, transitionArray, state.transitionsAreDeterministic);
            }
            return new FSAData(stateArray, sAutomatonData.startStateNumber, sAutomatonData.isDeterministic);
        }
        FSAData fSAData = (FSAData)object;
        switch (fSAData.objectVersion) {
            case 1: {
                return fSAData;
            }
        }
        return fSAData;
    }

    public SAutomaton(InputStream inputStream) throws ClassNotFoundException, IOException {
        this(new AutomatonSet_String());
        this.init(SAutomaton.toFSAData(new ObjectInputStream(inputStream).readObject()));
    }

    protected SAutomaton(AutomatonSet_String automatonSet_String) {
        this.automaton = automatonSet_String;
        this.state2wrapper = new HashMap();
        this.transition2wrapper = new HashMap();
    }

    public boolean isDeterministic() {
        return this.automaton.isDeterministic();
    }

    public IStatePro getStartState() {
        Automaton.State state = this.automaton.getStartState();
        if (state == null) {
            return null;
        }
        StatePro statePro = (StatePro)this.state2wrapper.get(state);
        if (statePro == null) {
            statePro = new StatePro((AutomatonSet_String.SState)state);
        }
        return statePro;
    }

    public void setStartState(IStatePro iStatePro) {
        if (!(iStatePro instanceof StatePro)) {
            throw new IllegalArgumentException("state is no state of mine");
        }
        StatePro statePro = (StatePro)iStatePro;
        if (statePro.parent() != this) {
            throw new IllegalArgumentException("state is no state of mine");
        }
        this.automaton.setStartState(statePro.state);
    }

    public IStatePro addState() {
        return this.addState(false);
    }

    public IStatePro addState(boolean bl) {
        AutomatonSet_String.SState sState = this.automaton.addState(bl);
        StatePro statePro = (StatePro)this.state2wrapper.get(sState);
        if (statePro == null) {
            statePro = new StatePro(sState);
        }
        return statePro;
    }

    public boolean removeState(IStatePro iStatePro) {
        if (!(iStatePro instanceof StatePro)) {
            throw new IllegalArgumentException("state is no state of mine");
        }
        StatePro statePro = (StatePro)iStatePro;
        if (statePro.parent() != this) {
            throw new IllegalArgumentException("state is no state of mine");
        }
        return this.automaton.removeState(statePro.state);
    }

    public void clear() {
        this.automaton.clear();
    }

    public void minimize() {
        this.automaton.minimize();
    }

    public StateProSet getStates() {
        StateProSet stateProSet = new StateProSet();
        Automaton.LinkedSet_State linkedSet_State = this.automaton.getStates();
        Automaton.Wrapper_State wrapper_State = linkedSet_State.elements;
        while (wrapper_State != null) {
            StatePro statePro = (StatePro)this.state2wrapper.get(wrapper_State.state);
            if (statePro == null) {
                statePro = new StatePro((AutomatonSet_String.SState)wrapper_State.state);
            }
            stateProSet.add(statePro);
            wrapper_State = wrapper_State.next;
        }
        return stateProSet;
    }

    public void complement() {
        this.automaton.complement();
    }

    public void addAll(SAutomaton sAutomaton) {
        this.automaton.addAll(sAutomaton.automaton);
    }

    public void retainAll(SAutomaton sAutomaton) {
        this.automaton.retainAll(sAutomaton.automaton);
    }

    public void removeAll(SAutomaton sAutomaton) {
        this.automaton.removeAll(sAutomaton.automaton);
    }

    public String toString() {
        return this.automaton.toString();
    }

    private String getCharSet(ISet_char iSet_char) {
        if (iSet_char == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(iSet_char.size());
        ISet_char.Iterator iterator = iSet_char.iterator();
        for (int i = iSet_char.size(); i > 0; --i) {
            stringBuffer.append(iterator.next());
        }
        CharSet charSet = new CharSet(stringBuffer.toString());
        if (!((Object)charSet).equals(iSet_char)) {
            throw new Error(String.valueOf(String.valueOf(new StringBuffer("").append(iSet_char).append("   ").append(charSet))));
        }
        return stringBuffer.toString();
    }

    public FSAData toData() {
        Serializable serializable;
        Automaton.LinkedSet_State linkedSet_State = this.automaton.getStates();
        AutomatonSet_String.SState[] sStateArray = new AutomatonSet_String.SState[linkedSet_State.size()];
        int n = 0;
        FSAData.State[] stateArray = linkedSet_State.elements;
        while (stateArray != null) {
            sStateArray[n] = (AutomatonSet_String.SState)stateArray.state;
            stateArray = stateArray.next;
            ++n;
        }
        stateArray = new FSAData.State[sStateArray.length];
        for (int i = 0; i < sStateArray.length; ++i) {
            serializable = new LinkedList<FSAData.State.Transition>();
            FSAData.State.Transition[] transitionArray = sStateArray[i].transitions;
            while (transitionArray != null) {
                ((LinkedList)serializable).addFirst(new FSAData.State.Transition(transitionArray.properties, this.getCharSet(transitionArray.charSet), transitionArray.toState.stateNr));
                transitionArray = transitionArray.next;
            }
            transitionArray = sStateArray[i].eTransitions;
            while (transitionArray != null) {
                ((LinkedList)serializable).addFirst(new FSAData.State.Transition(transitionArray.properties, null, transitionArray.toState.stateNr));
                transitionArray = transitionArray.next;
            }
            transitionArray = ((LinkedList)serializable).toArray(new FSAData.State.Transition[((LinkedList)serializable).size()]);
            stateArray[i] = new FSAData.State(sStateArray[i].stateNr, sStateArray[i].isFinal, transitionArray, sStateArray[i].isDeterministic());
        }
        Automaton.State state = this.automaton.getStartState();
        if (state == null) {
            return new FSAData(stateArray, null, this.automaton.isDeterministic());
        }
        serializable = new FSAData(stateArray, new Integer(state.stateNr), this.automaton.isDeterministic());
        return serializable;
    }

    protected void init(FSAData fSAData) {
        HashMap<Integer, AutomatonSet_String.SState> hashMap = new HashMap<Integer, AutomatonSet_String.SState>();
        if (fSAData.states != null) {
            AutomatonSet_String.SState sState;
            Serializable serializable;
            int n;
            for (n = 0; n < fSAData.states.length; ++n) {
                serializable = new Integer(fSAData.states[n].number);
                if (hashMap.containsKey(serializable)) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("bad automatonData: state with number ").append(serializable).append(" does already exists"))));
                }
                sState = this.automaton.addState(fSAData.states[n].isFinal, fSAData.states[n].number);
                hashMap.put((Integer)serializable, sState);
            }
            for (n = 0; n < fSAData.states.length; ++n) {
                serializable = fSAData.states[n];
                sState = (AutomatonSet_String.SState)hashMap.get(new Integer(((FSAData.State)serializable).number));
                if (((FSAData.State)serializable).transitions != null) {
                    for (int i = 0; i < ((FSAData.State)serializable).transitions.length; ++i) {
                        FSAData.State.Transition transition = ((FSAData.State)serializable).transitions[i];
                        CharSet charSet = transition.charSet == null ? null : new CharSet(transition.charSet);
                        AutomatonSet_String.SState sState2 = (AutomatonSet_String.SState)hashMap.get(new Integer(transition.toStateNumber));
                        sState.addTransition(transition.properties, charSet, sState2);
                    }
                }
                sState.setDeterministic(((FSAData.State)serializable).transitionsAreDeterministic);
            }
        }
        if (fSAData.startStateNumber != null) {
            AutomatonSet_String.SState sState = (AutomatonSet_String.SState)hashMap.get(fSAData.startStateNumber);
            if (sState == null) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("bad automatonData: startState ").append(fSAData.startStateNumber).append(" does not exists"))));
            }
            this.automaton.setStartState(sState);
        }
        this.automaton.setDeterministic(fSAData.isDeterministic);
    }

    public void toData(OutputStream outputStream) throws IOException {
        new ObjectOutputStream(outputStream).writeObject(this.toData());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class StatePro
    implements IStatePro {
        protected final Automaton.IStateVisitedListener stateVisitedListener = new Automaton.IStateVisitedListener(this){
            private final /* synthetic */ StatePro this$1;
            {
                this.this$1 = statePro;
            }

            public void stateVisited(Automaton.State state) {
                StatePro statePro = (StatePro)StatePro.access$0((StatePro)this.this$1).state2wrapper.get(state);
                if (statePro == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    statePro = sAutomaton.new StatePro((AutomatonSet_String.SState)state);
                }
                Iterator<E> iterator = this.this$1.visitListeners.iterator();
                for (int i = this.this$1.visitListeners.size(); i > 0; --i) {
                    ((IStatePro.IVisitListener)iterator.next()).stateVisited(statePro);
                }
            }

            public void stateVisited(Automaton.State state, char c) {
                StatePro statePro = (StatePro)StatePro.access$0((StatePro)this.this$1).state2wrapper.get(state);
                if (statePro == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    statePro = sAutomaton.new StatePro((AutomatonSet_String.SState)state);
                }
                Iterator<E> iterator = this.this$1.visitListeners.iterator();
                for (int i = this.this$1.visitListeners.size(); i > 0; --i) {
                    ((IStatePro.IVisitListener)iterator.next()).stateVisited(statePro, c);
                }
            }

            public void stateUnVisited(Automaton.State state) {
                StatePro statePro = (StatePro)StatePro.access$0((StatePro)this.this$1).state2wrapper.get(state);
                if (statePro == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    statePro = sAutomaton.new StatePro((AutomatonSet_String.SState)state);
                }
                Iterator<E> iterator = this.this$1.visitListeners.iterator();
                for (int i = this.this$1.visitListeners.size(); i > 0; --i) {
                    ((IStatePro.IVisitListener)iterator.next()).stateUnVisited(statePro);
                }
            }
        };
        protected final Automaton.IStateChangedListener stateChangedListener = new AutomatonSet_String.ISStateChangedListener(this){
            private final /* synthetic */ StatePro this$1;
            {
                this.this$1 = statePro;
            }

            public void transitionAdded(Automaton.State.Transition transition) {
                Transition transition2 = (Transition)StatePro.access$0((StatePro)this.this$1).transition2wrapper.get(transition);
                if (transition2 == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    transition2 = sAutomaton.new Transition(transition);
                }
                Iterator<E> iterator = this.this$1.changeListeners.iterator();
                for (int i = this.this$1.changeListeners.size(); i > 0; --i) {
                    ((IStatePro.IChangeListener)iterator.next()).transitionAdded(transition2);
                }
            }

            public void transitionRemoved(Automaton.State.Transition transition) {
                Transition transition2 = (Transition)StatePro.access$0((StatePro)this.this$1).transition2wrapper.get(transition);
                if (transition2 == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    transition2 = sAutomaton.new Transition(transition);
                }
                Iterator<E> iterator = this.this$1.changeListeners.iterator();
                for (int i = this.this$1.changeListeners.size(); i > 0; --i) {
                    ((IStatePro.IChangeListener)iterator.next()).transitionRemoved(transition2);
                }
            }

            public void isFinalChanged(AutomatonSet_String.SState sState, boolean bl) {
                StatePro statePro = (StatePro)StatePro.access$0((StatePro)this.this$1).state2wrapper.get(sState);
                if (statePro == null) {
                    SAutomaton sAutomaton = StatePro.access$0(this.this$1);
                    sAutomaton.getClass();
                    statePro = sAutomaton.new StatePro(sState);
                }
                Iterator<E> iterator = this.this$1.changeListeners.iterator();
                for (int i = this.this$1.changeListeners.size(); i > 0; --i) {
                    ((IStatePro.IChangeListener)iterator.next()).isFinalChanged(statePro, bl);
                }
            }
        };
        protected LinkedList visitListeners = null;
        protected LinkedList changeListeners = null;
        protected final AutomatonSet_String.SState state;

        public void addVisitListener(IStatePro.IVisitListener iVisitListener) {
            if (this.visitListeners == null) {
                this.visitListeners = new LinkedList();
                this.state.addVisitedListener(this.stateVisitedListener);
            }
            this.visitListeners.add(iVisitListener);
        }

        public boolean removeVisitListener(IStatePro.IVisitListener iVisitListener) {
            if (this.visitListeners != null) {
                Iterator iterator = this.visitListeners.iterator();
                for (int i = this.visitListeners.size(); i > 0; --i) {
                    if (iVisitListener != iterator.next()) continue;
                    if (this.visitListeners.size() > 1) {
                        iterator.remove();
                    } else {
                        this.state.removeVisitedListener(this.stateVisitedListener);
                        this.visitListeners = null;
                    }
                    return true;
                }
            }
            return false;
        }

        public void addChangeListener(IStatePro.IChangeListener iChangeListener) {
            if (this.changeListeners == null) {
                this.changeListeners = new LinkedList();
                this.state.addChangedListener(this.stateChangedListener);
            }
            this.changeListeners.add(iChangeListener);
        }

        public boolean removeChangeListener(IStatePro.IChangeListener iChangeListener) {
            if (this.changeListeners != null) {
                Iterator iterator = this.changeListeners.iterator();
                for (int i = this.changeListeners.size(); i > 0; --i) {
                    if (iChangeListener != iterator.next()) continue;
                    if (this.changeListeners.size() > 1) {
                        iterator.remove();
                    } else {
                        this.state.removeChangedListener(this.stateChangedListener);
                        this.changeListeners = null;
                    }
                    return true;
                }
            }
            return false;
        }

        protected StatePro(AutomatonSet_String.SState sState) {
            if (sState == null) {
                throw new Error("state==null");
            }
            this.state = sState;
            SAutomaton.this.state2wrapper.put(sState, this);
        }

        protected void finalize() {
            SAutomaton.this.state2wrapper.remove(this.state);
        }

        protected SAutomaton parent() {
            return SAutomaton.this;
        }

        public boolean isFinal() {
            return this.state.isFinal();
        }

        public void setFinal(boolean bl) {
            this.state.setFinal(bl);
        }

        public IState visit() {
            return new State((AutomatonSet_String.ISState)this.state.visit());
        }

        public IStatePro.ITransition addTransition(ISet_char iSet_char, IStatePro iStatePro) {
            Automaton.State.Transition transition = this.state.addTransition(null, iSet_char, ((StatePro)iStatePro).state);
            Transition transition2 = (Transition)SAutomaton.this.transition2wrapper.get(transition);
            if (transition2 == null) {
                transition2 = new Transition(transition);
            }
            return transition2;
        }

        public boolean removeTransition(IStatePro.ITransition iTransition) {
            return this.state.removeTransition(((Transition)iTransition).transition);
        }

        public void removeAllTransitions() {
            this.state.removeAllTransitions();
        }

        public StateProSet getAllReachableStates() {
            StateProSet stateProSet = new StateProSet();
            Automaton.LinkedSet_State linkedSet_State = this.state.getAllReachableStates();
            Automaton.Wrapper_State wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(wrapper_State.state);
                if (statePro == null) {
                    statePro = new StatePro((AutomatonSet_String.SState)wrapper_State.state);
                }
                stateProSet.add(statePro);
                wrapper_State = wrapper_State.next;
            }
            return stateProSet;
        }

        public IStatePro.ITransition[] getTransitions() {
            LinkedList<Transition> linkedList = new LinkedList<Transition>();
            Automaton.State.Transition transition = this.state.transitions;
            while (transition != null) {
                Transition transition2 = (Transition)SAutomaton.this.transition2wrapper.get(transition);
                if (transition2 == null) {
                    transition2 = new Transition(transition);
                }
                linkedList.addFirst(transition2);
                transition = transition.next;
            }
            return linkedList.toArray(new IStatePro.ITransition[linkedList.size()]);
        }

        public IStatePro.ITransition[] getETransitions() {
            LinkedList<Transition> linkedList = new LinkedList<Transition>();
            Automaton.State.Transition transition = this.state.eTransitions;
            while (transition != null) {
                Transition transition2 = (Transition)SAutomaton.this.transition2wrapper.get(transition);
                if (transition2 == null) {
                    transition2 = new Transition(transition);
                }
                linkedList.addFirst(transition2);
                transition = transition.next;
            }
            return linkedList.toArray(new IStatePro.ITransition[linkedList.size()]);
        }

        public IStatePro.ITransition[] getAllTransitions() {
            Transition transition;
            LinkedList<Transition> linkedList = new LinkedList<Transition>();
            Automaton.State.Transition transition2 = this.state.transitions;
            while (transition2 != null) {
                transition = (Transition)SAutomaton.this.transition2wrapper.get(transition2);
                if (transition == null) {
                    transition = new Transition(transition2);
                }
                linkedList.addFirst(transition);
                transition2 = transition2.next;
            }
            transition2 = this.state.eTransitions;
            while (transition2 != null) {
                transition = (Transition)SAutomaton.this.transition2wrapper.get(transition2);
                if (transition == null) {
                    transition = new Transition(transition2);
                }
                linkedList.addFirst(transition);
                transition2 = transition2.next;
            }
            return linkedList.toArray(new IStatePro.ITransition[linkedList.size()]);
        }

        public int getStateNumber() {
            return this.state.stateNr;
        }

        public String toString() {
            if (this.isFinal()) {
                return String.valueOf(String.valueOf(new StringBuffer("[").append(this.state.stateNr).append("]")));
            }
            return String.valueOf(String.valueOf(new StringBuffer("(").append(this.state.stateNr).append(")")));
        }

        static /* synthetic */ SAutomaton access$0(StatePro statePro) {
            return statePro.SAutomaton.this;
        }
    }

    protected class Transition
    implements IStatePro.ITransition {
        protected final Automaton.State.Transition transition;

        protected Transition(Automaton.State.Transition transition) {
            this.transition = transition;
            SAutomaton.this.transition2wrapper.put(transition, this);
        }

        public IStatePro getFromState() {
            StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(this.transition.getFromState());
            if (statePro == null) {
                statePro = new StatePro((AutomatonSet_String.SState)this.transition.getFromState());
            }
            return statePro;
        }

        public Set getLabels() {
            HashSet hashSet = (HashSet)((Object)this.transition.properties);
            if (hashSet != null) {
                return hashSet;
            }
            return Collections.EMPTY_SET;
        }

        public ISet_char getCharSet() {
            return this.transition.getCharSet();
        }

        public IStatePro getToState() {
            StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(this.transition.getToState());
            if (statePro == null) {
                statePro = new StatePro((AutomatonSet_String.SState)this.transition.getToState());
            }
            return statePro;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            AutomatonSet_String.SState sState = (AutomatonSet_String.SState)this.transition.getFromState();
            AutomatonSet_String.SState sState2 = (AutomatonSet_String.SState)this.transition.getToState();
            if (sState.isFinal()) {
                stringBuffer.append('[').append(sState.stateNr).append(']');
            } else {
                stringBuffer.append('(').append(sState.stateNr).append(')');
            }
            if (this.transition.getCharSet() == null) {
                if (this.transition.properties == null) {
                    stringBuffer.append(" --> ");
                } else {
                    stringBuffer.append(" - ").append(this.transition.properties).append(": -> ");
                }
            } else if (this.transition.properties == null) {
                stringBuffer.append(" - ").append(this.transition.getCharSet()).append(" -> ");
            } else {
                stringBuffer.append(" - ").append(this.transition.properties).append(':').append(this.transition.getCharSet()).append(" ->");
            }
            if (sState2.isFinal()) {
                stringBuffer.append('[').append(sState2.stateNr).append(']');
            } else {
                stringBuffer.append('(').append(sState2.stateNr).append(')');
            }
            return stringBuffer.toString();
        }
    }

    protected class State
    implements IState {
        protected final AutomatonSet_String.ISState state;

        protected State(AutomatonSet_String.ISState iSState) {
            this.state = iSState;
        }

        public boolean isFinal() {
            return this.state.isFinal();
        }

        public IState next(char c) {
            Automaton.IState iState = this.state.next(c);
            return iState == null ? null : new State((AutomatonSet_String.ISState)iState);
        }

        public StateProSet getAllReachableStates() {
            StateProSet stateProSet = new StateProSet();
            Automaton.LinkedSet_State linkedSet_State = this.state.getAllReachableStates();
            Automaton.Wrapper_State wrapper_State = linkedSet_State.elements;
            while (wrapper_State != null) {
                StatePro statePro = (StatePro)SAutomaton.this.state2wrapper.get(wrapper_State.state);
                if (statePro == null) {
                    statePro = new StatePro((AutomatonSet_String.SState)wrapper_State.state);
                }
                stateProSet.add(statePro);
                wrapper_State = wrapper_State.next;
            }
            return stateProSet;
        }

        public String toString() {
            return this.state.toString();
        }
    }

    public static interface IChangeListener {
        public void stateAdded(IStatePro var1);

        public void stateRemoved(IStatePro var1);

        public void startStateChanged(IStatePro var1, IStatePro var2);
    }
}

