/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

public class DeploymentModel {
    public static final DeploymentModel PER_JVM = new DeploymentModel("perJVM");
    public static final DeploymentModel PER_CLASS = new DeploymentModel("perClass");
    public static final DeploymentModel PER_INSTANCE = new DeploymentModel("perInstance");
    public static final DeploymentModel PER_TARGET = new DeploymentModel("perTarget");
    public static final DeploymentModel PER_THIS = new DeploymentModel("perThis");
    public static final DeploymentModel PER_CFLOW = new DeploymentModel("perCflow");
    public static final DeploymentModel PER_CFLOWBELOW = new DeploymentModel("perCflowbelow");
    private static final String THIS_POINTCUT = "this(aw_Instance)";
    private static final String TARGET_POINTCUT = "target(aw_Instance)";
    protected final String m_name;

    private DeploymentModel(String name) {
        this.m_name = name;
    }

    public String toString() {
        return this.m_name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentModel)) {
            return false;
        }
        DeploymentModel adviceType = (DeploymentModel)o;
        return !(this.m_name != null ? !this.m_name.equals(adviceType.m_name) : adviceType.m_name != null);
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    public static DeploymentModel getDeploymentModelFor(String deploymentModelAsString) {
        if (deploymentModelAsString == null || deploymentModelAsString.equals("")) {
            return PER_JVM;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_JVM.toString())) {
            return PER_JVM;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_CLASS.toString())) {
            return PER_CLASS;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_INSTANCE.toString())) {
            return PER_INSTANCE;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_CFLOW.toString())) {
            return PER_CFLOW;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_CFLOWBELOW.toString())) {
            return PER_CFLOWBELOW;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_THIS.toString())) {
            return PER_THIS;
        }
        if (deploymentModelAsString.equalsIgnoreCase(PER_TARGET.toString())) {
            return PER_TARGET;
        }
        if (deploymentModelAsString.toLowerCase().startsWith(DeploymentModel.PER_THIS.m_name.toLowerCase())) {
            return new PointcutControlledDeploymentModel(PER_THIS, DeploymentModel.getDeploymentExpression(deploymentModelAsString, THIS_POINTCUT));
        }
        if (deploymentModelAsString.toLowerCase().startsWith(DeploymentModel.PER_TARGET.m_name.toLowerCase())) {
            return new PointcutControlledDeploymentModel(PER_TARGET, DeploymentModel.getDeploymentExpression(deploymentModelAsString, TARGET_POINTCUT));
        }
        System.out.println("AW::WARNING - no such deployment model [" + deploymentModelAsString + "] using default (perJVM)");
        return PER_JVM;
    }

    private static String getDeploymentExpression(String deploymentModelAsString, String pointcut) {
        int startIndex = deploymentModelAsString.indexOf(40);
        int endIndex = deploymentModelAsString.lastIndexOf(41);
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            System.out.println("AW::ERROR - wrong deployment model definition [" + deploymentModelAsString + "]");
            return "";
        }
        return deploymentModelAsString.substring(startIndex + 1, endIndex).trim() + " && " + pointcut;
    }

    public static final class PointcutControlledDeploymentModel
    extends DeploymentModel {
        private String m_expression;

        private PointcutControlledDeploymentModel(DeploymentModel deploymentModel, String expression) {
            super(deploymentModel.m_name);
            this.m_expression = expression;
        }

        public String getDeploymentExpression() {
            return this.m_expression;
        }

        public String toString() {
            return this.m_name;
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

