/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.hook.impl.WeavingClassLoader;

public class WeavedTestCase
extends TestCase {
    private static WeaverTestRunner s_runner = new WeaverTestRunner();
    static /* synthetic */ Class class$java$lang$String;

    public WeavedTestCase() {
    }

    public WeavedTestCase(String name) {
        super(name);
    }

    public void runBare() throws Throwable {
        s_runner.runTest(((Object)((Object)this)).getClass().getName(), this.getName());
    }

    public void runBareAfterWeaving() throws Throwable {
        super.runBare();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WeaverTestRunner {
        private WeavingClassLoader cl;

        public WeaverTestRunner() {
            try {
                String path = System.getProperty("java.class.path");
                ArrayList<URL> paths = new ArrayList<URL>();
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    paths.add(new File(st.nextToken()).getCanonicalFile().toURL());
                }
                this.cl = new WeavingClassLoader(paths.toArray(new URL[0]), ClassLoader.getSystemClassLoader().getParent());
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(e);
            }
        }

        public void runTest(String testClassName, String testMethodName) throws Throwable {
            if (this.cl.getClass().getClassLoader() != null && this.cl.getClass().getClassLoader().getClass().getName().indexOf("hook.impl.Weaving") <= 0) {
                Thread.currentThread().setContextClassLoader(this.cl);
            }
            Class<?> testClass = Class.forName(testClassName, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> ctor = null;
            Object testInstance = null;
            try {
                ctor = testClass.getConstructor(new Class[0]);
                testInstance = ctor.newInstance(new Object[0]);
                Method setNameMethod = testClass.getMethod("setExpression", class$java$lang$String == null ? (class$java$lang$String = WeavedTestCase.class$("java.lang.String")) : class$java$lang$String);
                setNameMethod.invoke(testInstance, testMethodName);
            }
            catch (NoSuchMethodException e) {
                ctor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = WeavedTestCase.class$("java.lang.String")) : class$java$lang$String);
                testInstance = ctor.newInstance(testMethodName);
            }
            Method runAfterWeavingMethod = testClass.getMethod("runBareAfterWeaving", new Class[0]);
            runAfterWeavingMethod.invoke(testInstance, new Object[0]);
        }
    }
}

