/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AbstractMixinFactory;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class DefaultMixinFactory
extends AbstractMixinFactory {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Object m_perJVM = null;
    private Map m_perClassMixins = new WeakHashMap();
    private Map m_perInstanceMixins = new WeakHashMap();

    public DefaultMixinFactory(Class mixinClass, DeploymentModel deploymentModel) {
        super(mixinClass, deploymentModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mixinOf() {
        if (this.m_perJVM != null) {
            return this.m_perJVM;
        }
        DefaultMixinFactory defaultMixinFactory = this;
        synchronized (defaultMixinFactory) {
            Object mixin;
            if (this.m_deploymentModel == DeploymentModel.PER_JVM) {
                try {
                    mixin = this.m_defaultConstructor.newInstance(EMPTY_OBJECT_ARRAY);
                }
                catch (InvocationTargetException e) {
                    throw new WrappedRuntimeException(e.getTargetException());
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            } else {
                throw new DefinitionException("Mixins.mixinOf() is can not be invoked for mixin deployed using as " + this.m_deploymentModel);
            }
            this.m_perJVM = mixin;
        }
        return this.m_perJVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mixinOf(Class klass) {
        if (this.m_perClassMixins.containsKey(klass)) {
            return this.m_perClassMixins.get(klass);
        }
        Map map = this.m_perClassMixins;
        synchronized (map) {
            if (!this.m_perClassMixins.containsKey(klass)) {
                Object mixin;
                if (this.m_deploymentModel == DeploymentModel.PER_CLASS) {
                    try {
                        if (this.m_perClassConstructor != null) {
                            mixin = this.m_perClassConstructor.newInstance(klass);
                        }
                        if (this.m_defaultConstructor != null) {
                            mixin = this.m_defaultConstructor.newInstance(new Object[0]);
                        }
                        throw new DefinitionException("no valid constructor found for mixin [" + this.m_mixinClass.getName() + "]");
                    }
                    catch (InvocationTargetException e) {
                        throw new WrappedRuntimeException(e.getTargetException());
                    }
                    catch (Exception e) {
                        throw new WrappedRuntimeException(e);
                    }
                } else {
                    throw new DefinitionException("Mixins.mixinOf(Class) is can not be invoked for mixin deployed using as " + this.m_deploymentModel);
                }
                this.m_perClassMixins.put(klass, mixin);
            }
            return this.m_perClassMixins.get(klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mixinOf(Object instance) {
        if (this.m_perInstanceMixins.containsKey(instance)) {
            return this.m_perInstanceMixins.get(instance);
        }
        Map map = this.m_perInstanceMixins;
        synchronized (map) {
            if (!this.m_perInstanceMixins.containsKey(instance)) {
                Object mixin;
                if (this.m_deploymentModel == DeploymentModel.PER_INSTANCE) {
                    try {
                        if (this.m_perInstanceConstructor != null) {
                            mixin = this.m_perInstanceConstructor.newInstance(instance);
                        }
                        if (this.m_defaultConstructor != null) {
                            mixin = this.m_defaultConstructor.newInstance(new Object[0]);
                        }
                        throw new DefinitionException("no valid constructor found for mixin [" + this.m_mixinClass.getName() + "]");
                    }
                    catch (InvocationTargetException e) {
                        throw new WrappedRuntimeException(e.getTargetException());
                    }
                    catch (Exception e) {
                        throw new WrappedRuntimeException(e);
                    }
                } else {
                    throw new DefinitionException("Mixins.mixinOf(Object) is can not be invoked for mixin deployed using as " + this.m_deploymentModel);
                }
                this.m_perInstanceMixins.put(instance, mixin);
            }
            return this.m_perInstanceMixins.get(instance);
        }
    }
}

