/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.aspectwerkz.aspect.container.Artifact;
import org.codehaus.aspectwerkz.aspect.container.AspectFactoryManager;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Opcodes;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.util.Strings;

public abstract class AbstractAspectFactoryCompiler
implements Opcodes,
TransformationConstants {
    private static final boolean DUMP_JIT_FACTORIES = AspectWerkzPreProcessor.DUMP_AFTER;
    static final Artifact[] EMPTY_ARTIFACT_ARRAY = new Artifact[0];
    private final ClassLoader m_loader;
    private final String m_uuid;
    protected final String m_aspectQualifiedName;
    protected final String m_aspectClassName;
    protected final String m_aspectClassSignature;
    protected final String m_aspectFactoryClassName;
    protected final String m_aspectContainerClassName;
    protected final boolean m_hasAspectContainer;
    private boolean m_hasParameters;
    private String m_rawParameters;
    private Map m_parametersLazy;
    protected ClassWriter m_cw;
    protected MethodVisitor m_clinit;

    public AbstractAspectFactoryCompiler(String uuid, String aspectClassName, String aspectQualifiedName, String containerClassName, String rawParameters, ClassLoader loader) {
        this.m_uuid = uuid;
        this.m_aspectClassName = aspectClassName.replace('.', '/');
        this.m_aspectClassSignature = 'L' + this.m_aspectClassName + ';';
        this.m_aspectQualifiedName = aspectQualifiedName;
        this.m_aspectFactoryClassName = AspectFactoryManager.getAspectFactoryClassName(this.m_aspectClassName, this.m_aspectQualifiedName);
        if (containerClassName != null) {
            this.m_aspectContainerClassName = containerClassName.replace('.', '/');
            this.m_hasAspectContainer = true;
        } else {
            this.m_aspectContainerClassName = null;
            this.m_hasAspectContainer = false;
        }
        if (rawParameters != null) {
            this.m_rawParameters = rawParameters;
            this.m_hasParameters = true;
        } else {
            this.m_rawParameters = null;
            this.m_hasParameters = false;
        }
        this.m_loader = loader;
    }

    private Map getParameters() {
        if (this.m_parametersLazy == null) {
            HashMap<String, String> map;
            if (this.m_rawParameters != null) {
                map = new HashMap<String, String>();
                String[] raw = Strings.splitString(this.m_rawParameters, "$_AW_$");
                for (int i = 0; i < raw.length; ++i) {
                    if (i >= raw.length) continue;
                    map.put(raw[i], raw[++i]);
                }
            } else {
                map = new HashMap(0);
            }
            this.m_parametersLazy = map;
        }
        return this.m_parametersLazy;
    }

    public Artifact compile() {
        this.m_cw = AsmHelper.newClassWriter(true);
        this.m_cw.visit(AsmHelper.JAVA_VERSION, 1, this.m_aspectFactoryClassName, null, "java/lang/Object", null);
        this.m_cw.visitField(10, "FACTORY_CLASS", "Ljava/lang/Class;", null, null);
        this.m_clinit = this.m_cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.m_clinit.visitLdcInsn(this.m_aspectFactoryClassName.replace('/', '.'));
        this.m_clinit.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        this.m_clinit.visitFieldInsn(179, this.m_aspectFactoryClassName, "FACTORY_CLASS", "Ljava/lang/Class;");
        if (this.m_hasParameters) {
            this.createParametersFieldAndClinit();
        }
        if (this.m_hasAspectContainer) {
            this.createAspectContainerFieldAndClinit();
        }
        this.createAspectOf();
        this.createHasAspect();
        this.createOtherArtifacts();
        this.m_clinit.visitInsn(177);
        this.m_clinit.visitMaxs(0, 0);
        Artifact artifact = new Artifact(this.m_aspectFactoryClassName, this.m_cw.toByteArray());
        if (DUMP_JIT_FACTORIES && AspectWerkzPreProcessor.DUMP_PATTERN.matches(artifact.className.replace('/', '.'))) {
            try {
                AsmHelper.dumpClass(AspectWerkzPreProcessor.DUMP_DIR_AFTER, artifact.className, artifact.bytecode);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return artifact;
    }

    protected abstract void createAspectOf();

    protected abstract void createHasAspect();

    protected abstract void createOtherArtifacts();

    private void createParametersFieldAndClinit() {
        this.m_cw.visitField(26, "PARAMS", "Ljava/util/Map;", null, null);
        this.m_clinit.visitTypeInsn(187, "java/util/HashMap");
        this.m_clinit.visitInsn(89);
        this.m_clinit.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        Iterator iterator = this.getParameters().entrySet().iterator();
        while (iterator.hasNext()) {
            this.m_clinit.visitInsn(89);
            Map.Entry entry = iterator.next();
            this.m_clinit.visitLdcInsn(entry.getKey());
            this.m_clinit.visitLdcInsn(entry.getValue());
            this.m_clinit.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.m_clinit.visitInsn(87);
        }
        this.m_clinit.visitFieldInsn(179, this.m_aspectFactoryClassName, "PARAMS", "Ljava/util/Map;");
    }

    private void createAspectContainerFieldAndClinit() {
        this.m_cw.visitField(10, "CONTAINER", "Lorg/codehaus/aspectwerkz/aspect/AspectContainer;", null, null);
        ClassInfo containerClassInfo = AsmClassInfo.getClassInfo(this.m_aspectContainerClassName, this.m_loader);
        boolean hasConstructor = false;
        for (int i = 0; i < containerClassInfo.getConstructors().length; ++i) {
            ConstructorInfo constructorInfo = containerClassInfo.getConstructors()[i];
            if (!"(Ljava/lang/Class;Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V".equals(constructorInfo.getSignature())) continue;
            hasConstructor = true;
            break;
        }
        this.m_clinit.visitTypeInsn(187, this.m_aspectContainerClassName);
        this.m_clinit.visitInsn(89);
        if (hasConstructor) {
            this.m_clinit.visitLdcInsn(this.m_aspectClassName.replace('/', '.'));
            this.m_clinit.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.m_clinit.visitFieldInsn(178, this.m_aspectFactoryClassName, "FACTORY_CLASS", "Ljava/lang/Class;");
            this.m_clinit.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
            this.m_clinit.visitLdcInsn(this.m_uuid);
            this.m_clinit.visitLdcInsn(this.m_aspectQualifiedName);
            if (this.m_hasParameters) {
                this.m_clinit.visitFieldInsn(178, this.m_aspectFactoryClassName, "PARAMS", "Ljava/util/Map;");
            } else {
                this.m_clinit.visitInsn(1);
            }
            this.m_clinit.visitMethodInsn(183, this.m_aspectContainerClassName, "<init>", "(Ljava/lang/Class;Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V");
        } else {
            this.m_clinit.visitMethodInsn(183, this.m_aspectContainerClassName, "<init>", "()V");
        }
        this.m_clinit.visitFieldInsn(179, this.m_aspectFactoryClassName, "CONTAINER", "Lorg/codehaus/aspectwerkz/aspect/AspectContainer;");
    }
}

