/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect.management;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.container.AspectFactoryManager;
import org.codehaus.aspectwerkz.aspect.management.NoAspectBoundException;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class Aspects {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;

    private static String[] getAspectQNameAndAspectClassName(ClassLoader visibleFrom, String qName) {
        AspectDefinition aspectDefinition = Aspects.lookupAspectDefinition(visibleFrom, qName);
        return new String[]{aspectDefinition.getQualifiedName(), aspectDefinition.getClassName()};
    }

    public static Object aspectOf(String qName) {
        return Aspects.aspectOf(Thread.currentThread().getContextClassLoader(), qName);
    }

    public static Object aspectOf(Class aspectClass) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClass.getClassLoader(), aspectClassName);
    }

    public static Object aspectOf(ClassLoader visibleFrom, String qName) {
        String[] qNameAndAspectClassName = Aspects.getAspectQNameAndAspectClassName(visibleFrom, qName);
        return Aspects.aspect$Of(qNameAndAspectClassName[0], qNameAndAspectClassName[1], visibleFrom);
    }

    public static Object aspectOf(Class aspectClass, Class targetClass) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClassName, targetClass);
    }

    public static Object aspectOf(String qName, Class targetClass) {
        String[] qNameAndAspectClassName = Aspects.getAspectQNameAndAspectClassName(targetClass.getClassLoader(), qName);
        return Aspects.aspect$Of(qNameAndAspectClassName[0], qNameAndAspectClassName[1], targetClass);
    }

    public static Object aspectOf(Class aspectClass, Object targetInstance) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClassName, targetInstance);
    }

    public static Object aspectOf(String qName, Object targetInstance) {
        AspectDefinition aspectDef = Aspects.lookupAspectDefinition(targetInstance.getClass().getClassLoader(), qName);
        DeploymentModel deployModel = aspectDef.getDeploymentModel();
        String[] qNameAndAspectClassName = Aspects.getAspectQNameAndAspectClassName(targetInstance.getClass().getClassLoader(), qName);
        if (DeploymentModel.PER_INSTANCE.equals(deployModel) || DeploymentModel.PER_THIS.equals(deployModel) || DeploymentModel.PER_TARGET.equals(deployModel)) {
            return Aspects.aspect$Of(qNameAndAspectClassName[0], qNameAndAspectClassName[1], targetInstance);
        }
        throw new NoAspectBoundException("Cannot retrieve instance level aspect with deployment-scope " + deployModel.toString() + " named ", qName);
    }

    public static boolean hasAspect(String qName, Object targetInstance) {
        String[] qNameAndAspectClassName = Aspects.getAspectQNameAndAspectClassName(targetInstance.getClass().getClassLoader(), qName);
        try {
            Class factory = ContextClassLoader.forName(targetInstance.getClass().getClassLoader(), AspectFactoryManager.getAspectFactoryClassName(qNameAndAspectClassName[1], qName).replace('/', '.'));
            Method m = factory.getMethod("hasAspect", class$java$lang$Object == null ? (class$java$lang$Object = Aspects.class$("java.lang.Object")) : class$java$lang$Object);
            Boolean b = (Boolean)m.invoke(null, targetInstance);
            return b;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object aspect$Of(String qName, String aspectClassName, ClassLoader loader) {
        try {
            Class factory = ContextClassLoader.forName(loader, AspectFactoryManager.getAspectFactoryClassName(aspectClassName, qName).replace('/', '.'));
            Method m = factory.getMethod("aspectOf", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (NoAspectBoundException nabe) {
            throw nabe;
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    public static Object aspect$Of(String qName, String aspectClassName, Class perClass) {
        try {
            Class factory = ContextClassLoader.forName(perClass.getClassLoader(), AspectFactoryManager.getAspectFactoryClassName(aspectClassName, qName).replace('/', '.'));
            Method m = factory.getMethod("aspectOf", class$java$lang$Class == null ? (class$java$lang$Class = Aspects.class$("java.lang.Class")) : class$java$lang$Class);
            return m.invoke(null, perClass);
        }
        catch (NoAspectBoundException nabe) {
            throw nabe;
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    public static Object aspect$Of(String qName, String aspectClassName, Object perInstance) {
        try {
            ClassLoader loader = perInstance.getClass().getClassLoader();
            Class containerClass = ContextClassLoader.forName(loader, AspectFactoryManager.getAspectFactoryClassName(aspectClassName, qName).replace('/', '.'));
            Method m = containerClass.getMethod("aspectOf", class$java$lang$Object == null ? (class$java$lang$Object = Aspects.class$("java.lang.Object")) : class$java$lang$Object);
            return m.invoke(null, perInstance);
        }
        catch (NoAspectBoundException nabe) {
            throw nabe;
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    private static AspectDefinition lookupAspectDefinition(ClassLoader visibleFrom, String qName) {
        AspectDefinition aspectDefinition = null;
        Set definitions = SystemDefinitionContainer.getDefinitionsFor(visibleFrom);
        if (qName.indexOf(47) > 0) {
            Iterator iterator = definitions.iterator();
            block0: while (iterator.hasNext()) {
                SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
                if (!qName.startsWith(systemDefinition.getUuid())) continue;
                Iterator iterator1 = systemDefinition.getAspectDefinitions().iterator();
                while (iterator1.hasNext()) {
                    AspectDefinition aspectDef = (AspectDefinition)iterator1.next();
                    if (!qName.equals(aspectDef.getQualifiedName())) continue;
                    aspectDefinition = aspectDef;
                    continue block0;
                }
            }
        } else {
            int found = 0;
            Iterator iterator = definitions.iterator();
            while (iterator.hasNext()) {
                SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
                Iterator iterator1 = systemDefinition.getAspectDefinitions().iterator();
                while (iterator1.hasNext()) {
                    AspectDefinition aspectDef = (AspectDefinition)iterator1.next();
                    if (!qName.equals(aspectDef.getClassName())) continue;
                    aspectDefinition = aspectDef;
                    ++found;
                }
            }
            if (found > 1) {
                throw new NoAspectBoundException("More than one AspectDefinition found, consider using other API methods", qName);
            }
        }
        if (aspectDefinition == null) {
            throw new NoAspectBoundException("Could not find AspectDefinition", qName);
        }
        return aspectDefinition;
    }

    private Aspects() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

