/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.cflow;

import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Opcodes;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.compiler.AbstractJoinPointCompiler;

public class CflowCompiler
implements Opcodes,
TransformationConstants {
    public static final String JIT_CFLOW_CLASS = "org/codehaus/aspectwerkz/cflow/Cflow_";
    private static final String ABSTRACT_CFLOW_CLASS = "org/codehaus/aspectwerkz/cflow/AbstractCflowSystemAspect";
    private static final String INSTANCE_CFLOW_FIELD_NAME = "INSTANCE";
    public static final String IN_CFLOW_METOD_NAME = "inCflow";
    public static final String IN_CFLOW_METOD_SIGNATURE = "()Z";
    public static final String CFLOW_ASPECTOF_METHOD_NAME = "aspectOf";
    private final String m_className;
    private final String m_classSignature;
    private ClassWriter m_cw;

    public static boolean isCflowClass(String className) {
        return className.indexOf(JIT_CFLOW_CLASS) >= 0;
    }

    private CflowCompiler(int cflowId) {
        this.m_className = CflowCompiler.getCflowAspectClassName(cflowId);
        this.m_classSignature = "L" + this.m_className + ";";
    }

    private byte[] compile() {
        this.m_cw = AsmHelper.newClassWriter(true);
        this.m_cw.visit(AsmHelper.JAVA_VERSION, 4129, this.m_className, null, ABSTRACT_CFLOW_CLASS, EMPTY_STRING_ARRAY);
        this.m_cw.visitField(10, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature, null, null);
        MethodVisitor ctor = this.m_cw.visitMethod(2, "<init>", "()V", null, EMPTY_STRING_ARRAY);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, ABSTRACT_CFLOW_CLASS, "<init>", "()V");
        ctor.visitInsn(177);
        ctor.visitMaxs(0, 0);
        MethodVisitor isInCflow = this.m_cw.visitMethod(9, "isInCflow", IN_CFLOW_METOD_SIGNATURE, null, EMPTY_STRING_ARRAY);
        isInCflow.visitFieldInsn(178, this.m_className, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature);
        Label isNull = new Label();
        isInCflow.visitJumpInsn(198, isNull);
        isInCflow.visitFieldInsn(178, this.m_className, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature);
        isInCflow.visitMethodInsn(182, ABSTRACT_CFLOW_CLASS, IN_CFLOW_METOD_NAME, IN_CFLOW_METOD_SIGNATURE);
        isInCflow.visitInsn(172);
        isInCflow.visitLabel(isNull);
        isInCflow.visitInsn(3);
        isInCflow.visitInsn(172);
        isInCflow.visitMaxs(0, 0);
        MethodVisitor aspectOf = this.m_cw.visitMethod(9, CFLOW_ASPECTOF_METHOD_NAME, "()" + this.m_classSignature, null, EMPTY_STRING_ARRAY);
        aspectOf.visitFieldInsn(178, this.m_className, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature);
        Label isNotNull = new Label();
        aspectOf.visitJumpInsn(199, isNotNull);
        aspectOf.visitTypeInsn(187, this.m_className);
        aspectOf.visitInsn(89);
        aspectOf.visitMethodInsn(183, this.m_className, "<init>", "()V");
        aspectOf.visitFieldInsn(179, this.m_className, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature);
        aspectOf.visitLabel(isNotNull);
        aspectOf.visitFieldInsn(178, this.m_className, INSTANCE_CFLOW_FIELD_NAME, this.m_classSignature);
        aspectOf.visitInsn(176);
        aspectOf.visitMaxs(0, 0);
        this.m_cw.visitEnd();
        return this.m_cw.toByteArray();
    }

    public static String getCflowAspectClassName(int cflowID) {
        return JIT_CFLOW_CLASS + cflowID;
    }

    public static Class compileCflowAspectAndAttachToClassLoader(ClassLoader loader, int cflowID) {
        CompiledCflowAspect cflowAspect = CflowCompiler.compileCflowAspect(cflowID);
        if (AbstractJoinPointCompiler.DUMP_JIT_CLASSES) {
            try {
                AsmHelper.dumpClass("_dump", CflowCompiler.getCflowAspectClassName(cflowID), cflowAspect.bytecode);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Class cflowAspectClass = AsmHelper.defineClass(loader, cflowAspect.bytecode, CflowCompiler.getCflowAspectClassName(cflowID));
        return cflowAspectClass;
    }

    public static CompiledCflowAspect compileCflowAspect(int cflowID) {
        CompiledCflowAspect cflowAspect = new CompiledCflowAspect();
        CflowCompiler compiler = new CflowCompiler(cflowID);
        cflowAspect.bytecode = compiler.compile();
        cflowAspect.className = compiler.m_className;
        return cflowAspect;
    }

    public static class CompiledCflowAspect {
        public byte[] bytecode;
        public String className;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompiledCflowAspect)) {
                return false;
            }
            CompiledCflowAspect compiledCflowAspect = (CompiledCflowAspect)o;
            return this.className.equals(compiledCflowAspect.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }
    }
}

