/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.List;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.cflow.CflowBinding;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.util.Strings;

public class AdviceDefinition {
    private String m_name;
    private AdviceType m_type;
    private final String m_aspectClassName;
    private final String m_aspectName;
    private ExpressionInfo m_expressionInfo;
    private final MethodInfo m_method;
    private String m_attribute = "";
    private AspectDefinition m_aspectDefinition;
    private String m_specialArgumentType;
    private boolean m_hasCflowOrCflowBelow = false;

    public static AdviceDefinition newInstance(String adviceName, AdviceType adviceType, String expression, String specialArgumentType, String aspectName, String aspectClassName, MethodInfo method, AspectDefinition aspectDef) {
        ExpressionInfo expressionInfo = new ExpressionInfo(expression, aspectDef.getQualifiedName());
        String adviceCallSignature = null;
        String resolvedSpecialArgumentType = specialArgumentType;
        if (adviceName.indexOf(40) > 0) {
            adviceCallSignature = adviceName.substring(adviceName.indexOf(40) + 1, adviceName.lastIndexOf(41));
            String[] parameters = Strings.splitString(adviceCallSignature, ",");
            for (int i = 0; i < parameters.length; ++i) {
                String[] parameterInfo = Strings.splitString(Strings.replaceSubString(parameters[i].trim(), "  ", " "), " ");
                if (parameterInfo[1].equals(specialArgumentType)) {
                    resolvedSpecialArgumentType = parameterInfo[0];
                    expressionInfo.setSpecialArgumentName(parameterInfo[1]);
                    continue;
                }
                expressionInfo.addArgument(parameterInfo[1], parameterInfo[0], aspectDef.getClassInfo().getClassLoader());
            }
        }
        return new AdviceDefinition(adviceName, adviceType, resolvedSpecialArgumentType, aspectName, aspectClassName, expressionInfo, method, aspectDef);
    }

    public AdviceDefinition(String name, AdviceType type, String specialArgumentType, String aspectName, String aspectClassName, ExpressionInfo expressionInfo, MethodInfo methodInfo, AspectDefinition aspectDef) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("illegal advice type");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (aspectClassName == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (methodInfo == null) {
            throw new IllegalArgumentException("methodInfo can not be null");
        }
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        this.m_name = name;
        this.m_type = type;
        this.m_specialArgumentType = specialArgumentType;
        this.m_aspectName = aspectName;
        this.m_aspectClassName = aspectClassName;
        this.m_expressionInfo = expressionInfo;
        this.m_method = methodInfo;
        this.m_aspectDefinition = aspectDef;
        List cflowBindings = CflowBinding.getCflowBindingsForCflowOf(this.m_expressionInfo);
        this.m_hasCflowOrCflowBelow = cflowBindings.size() > 0;
    }

    public AdviceType getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQualifiedName() {
        return this.m_aspectDefinition.getQualifiedName() + '.' + this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.trim();
    }

    public ExpressionInfo getExpressionInfo() {
        return this.m_expressionInfo;
    }

    public void setExpressionInfo(ExpressionInfo newExpression) {
        this.m_expressionInfo = newExpression;
        List cflowBindings = CflowBinding.getCflowBindingsForCflowOf(this.m_expressionInfo);
        this.m_hasCflowOrCflowBelow = cflowBindings.size() > 0;
    }

    public String getAspectClassName() {
        return this.m_aspectClassName;
    }

    public String getAspectName() {
        return this.m_aspectName;
    }

    public String getSpecialArgumentType() {
        return this.m_specialArgumentType;
    }

    public MethodInfo getMethodInfo() {
        return this.m_method;
    }

    public DeploymentModel getDeploymentModel() {
        return this.m_aspectDefinition.getDeploymentModel();
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public AspectDefinition getAspectDefinition() {
        return this.m_aspectDefinition;
    }

    public boolean hasCflowOrCflowBelow() {
        return this.m_hasCflowOrCflowBelow;
    }

    public AdviceDefinition copyAt(ExpressionInfo expressionInfo) {
        return new AdviceDefinition(this.getName(), this.getType(), this.getSpecialArgumentType(), this.getAspectName(), this.getAspectClassName(), expressionInfo, this.getMethodInfo(), this.m_aspectDefinition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdviceDefinition)) {
            return false;
        }
        AdviceDefinition adviceDefinition = (AdviceDefinition)o;
        if (!this.m_aspectName.equals(adviceDefinition.m_aspectName)) {
            return false;
        }
        return this.m_name.equals(adviceDefinition.m_name);
    }

    public int hashCode() {
        int result = this.m_name.hashCode();
        result = 29 * result + this.m_aspectName.hashCode();
        return result;
    }
}

